/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.forms;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.AuthoringUIText;
import org.eclipse.epf.authoring.ui.editors.MethodElementEditor;
import org.eclipse.epf.authoring.ui.forms.ProcessFormPage;
import org.eclipse.epf.authoring.ui.preferences.AuthoringUIPreferences;
import org.eclipse.epf.authoring.ui.richtext.IMethodRichText;
import org.eclipse.epf.authoring.ui.util.EditorsContextHelper;
import org.eclipse.epf.authoring.ui.util.UIHelper;
import org.eclipse.epf.diagram.core.services.DiagramManager;
import org.eclipse.epf.library.edit.LibraryEditResources;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.edit.navigator.ConfigurationsItemProvider;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.edit.validation.IValidator;
import org.eclipse.epf.library.edit.validation.IValidatorFactory;
import org.eclipse.epf.library.ui.LibraryUIText;
import org.eclipse.epf.services.ILibraryPersister;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.NamedElement;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class ProcessDescription
extends ProcessFormPage {
    private static final String FORM_PAGE_ID = "processDescriptionPage";
    private static final int DEFAULT_VERTICAL_INDENT = 2;
    private IStructuredContentProvider contentProvider = new AdapterFactoryContentProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){};
    private ILabelProvider labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory());
    private IMethodRichText ctrl_scope;
    private IMethodRichText ctrl_usage_notes;
    private IMethodRichText ctrl_alternatives;
    private IMethodRichText ctrl_how_to_staff;
    private IMethodRichText ctrl_key_consideration;
    private Section configSection;
    protected Composite configComposite;
    protected boolean configSectionExpandFlag = false;
    private org.eclipse.swt.widgets.List list_configurations;
    private ListViewer configListViewer;
    protected Button buttonAdd;
    protected Button buttonRemove;
    protected Button buttonMakeDefault;
    private Text textConfigDescription;
    private ItemProviderAdapter configListAdapter;
    protected ModifyListener modifyListener;
    protected ModifyListener contentModifyListener;
    private String processType;
    private MethodElementEditor editor;
    private ModifyListener nameModifyListener;
    private boolean disposed;

    public ProcessDescription(FormEditor editor) {
        super(editor, FORM_PAGE_ID, AuthoringUIResources.descriptionPage_title);
    }

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        this.processType = LibraryUIText.getUITextLower((MethodElement)this.process);
        this.versionSectionOn = false;
        this.variabilitySectionOn = false;
        this.externalIdOn = true;
        this.purposeOn = true;
    }

    protected void createEditorContent(FormToolkit toolkit) {
        super.createEditorContent(toolkit);
        this.createConfigurationSection(toolkit);
        Display display = this.form.getBody().getDisplay();
        if (display != null && !display.isDisposed()) {
            display.asyncExec(new Runnable(){

                public void run() {
                    if (ProcessDescription.this.ctrl_name.isDisposed()) {
                        return;
                    }
                    ProcessDescription.this.ctrl_name.setFocus();
                    ProcessDescription.this.ctrl_name.setSelection(0, ProcessDescription.this.ctrl_name.getText().length());
                }
            });
        }
    }

    protected void createGeneralSection(FormToolkit toolkit) {
        this.generalSection = this.createSection(toolkit, this.sectionComposite, AuthoringUIText.GENERAL_INFO_SECTION_NAME, MessageFormat.format(AuthoringUIText.GENERAL_INFO_SECTION_DESC, this.processType));
        this.generalComposite = this.createComposite(toolkit, this.generalSection);
        this.ctrl_name = ProcessDescription.createTextEditWithLabel(toolkit, this.generalComposite, AuthoringUIText.NAME_TEXT);
        this.ctrl_presentation_name = ProcessDescription.createTextEditWithLabel(toolkit, this.generalComposite, AuthoringUIText.PRESENTATION_NAME_TEXT);
        if (this.longPresentationNameOn && AuthoringUIPreferences.getEnableUIFields()) {
            this.ctrl_long_presentation_name = ProcessDescription.createTextEditWithLabel(toolkit, this.generalComposite, AuthoringUIText.LONG_PRESENTATION_NAME_TEXT);
        }
        this.ctrl_brief_desc = ProcessDescription.createTextEditWithLabel2(toolkit, this.generalComposite, AuthoringUIText.BRIEF_DESCRIPTION_TEXT);
        if (AuthoringUIPreferences.getEnableUIFields()) {
            this.ctrl_external_id = ProcessDescription.createTextEditWithLabel(toolkit, this.generalComposite, AuthoringUIResources.Process_ExternalID);
        }
        this.ctrl_purpose = this.createRichTextEditWithLinkForSection(toolkit, this.generalComposite, AuthoringUIResources.Process_Purpose, 40, 400, 1);
        toolkit.paintBordersFor(this.generalComposite);
    }

    protected void createDetailSection(FormToolkit toolkit) {
        this.detailSection = this.createSection(toolkit, this.sectionComposite, AuthoringUIText.DETAIL_SECTION_NAME, MessageFormat.format(AuthoringUIText.DETAIL_SECTION_DESC, this.processType));
        this.detailComposite = this.createComposite(toolkit, this.detailSection);
        this.ctrl_full_desc = this.createRichTextEditWithLinkForSection(toolkit, this.detailComposite, AuthoringUIText.MAIN_DESCRIPTION_TEXT, 100, 400, 2);
        this.ctrl_scope = this.createRichTextEditWithLinkForSection(toolkit, this.detailComposite, AuthoringUIResources.Process_Scope, 40, 400, 2);
        this.ctrl_usage_notes = this.createRichTextEditWithLinkForSection(toolkit, this.detailComposite, AuthoringUIResources.Process_UsageNotes, 40, 400, 2);
        this.ctrl_alternatives = this.createRichTextEditWithLinkForSection(toolkit, this.detailComposite, AuthoringUIResources.Process_Alternatives, 40, 400, 2);
        this.ctrl_how_to_staff = this.createRichTextEditWithLinkForSection(toolkit, this.detailComposite, AuthoringUIResources.Process_HowToStaff, 40, 400, 2);
        this.ctrl_key_consideration = this.createRichTextEditWithLinkForSection(toolkit, this.detailComposite, AuthoringUIResources.Process_KeyConsideration, 40, 400, 2);
        toolkit.paintBordersFor(this.detailComposite);
    }

    protected void createConfigurationSection(FormToolkit toolkit) {
        this.configSection = this.createSection(toolkit, this.sectionComposite, AuthoringUIResources.processDescription_configurationSectionTitle, AuthoringUIResources.processDescription_configurationSectionMessage);
        this.configComposite = this.createComposite(toolkit, this.configSection);
        ((GridLayout)this.configComposite.getLayout()).numColumns = 2;
        Label l_element = toolkit.createLabel(this.configComposite, AuthoringUIResources.processDescription_configurations);
        GridData gridData = new GridData(1, 0x1000008, true, true, 2, 1);
        l_element.setLayoutData((Object)gridData);
        this.list_configurations = UIHelper.createList(toolkit, this.configComposite, 2052);
        gridData = new GridData(4, 4, true, true);
        gridData.verticalIndent = 2;
        gridData.heightHint = 80;
        gridData.widthHint = 200;
        this.list_configurations.setLayoutData((Object)gridData);
        this.configListViewer = new ListViewer(this.list_configurations);
        this.configListViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.configListViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                if (element == ProcessDescription.this.process.getDefaultContext()) {
                    return AuthoringUIPlugin.getDefault().getSharedImage("icons/checked.gif");
                }
                return null;
            }

            public String getText(Object element) {
                String txt = ProcessDescription.this.labelProvider.getText(element);
                if (element == ProcessDescription.this.process.getDefaultContext()) {
                    txt = String.valueOf(txt) + " " + AuthoringUIResources.processDescription_default;
                }
                return txt;
            }
        });
        Composite buttonPanel = toolkit.createComposite(this.configComposite);
        GridData gridData2 = new GridData(0x1000000, 0x1000000, false, false);
        gridData2.horizontalIndent = 4;
        buttonPanel.setLayoutData((Object)gridData2);
        buttonPanel.setLayout((Layout)new GridLayout());
        Button button = toolkit.createButton(buttonPanel, AuthoringUIResources.addButton_text, 0);
        GridData gridData3 = new GridData(768);
        button.setLayoutData((Object)gridData3);
        this.buttonAdd = button;
        button = toolkit.createButton(buttonPanel, AuthoringUIResources.removeButton_text, 0);
        gridData3 = new GridData(768);
        button.setLayoutData((Object)gridData3);
        this.buttonRemove = button;
        button = toolkit.createButton(buttonPanel, AuthoringUIResources.makeDefaultButton_text, 0);
        gridData3 = new GridData(768);
        button.setLayoutData((Object)gridData3);
        this.buttonMakeDefault = button;
        Label label = toolkit.createLabel(this.configComposite, AuthoringUIResources.processDescription_configurationDescription);
        GridData gridData4 = new GridData(1, 0x1000008, true, false, 2, 1);
        label.setLayoutData((Object)gridData4);
        this.textConfigDescription = toolkit.createText(this.configComposite, "");
        gridData4 = new GridData(4, 4, true, true);
        gridData4.verticalIndent = 2;
        gridData4.heightHint = 80;
        gridData4.widthHint = 400;
        this.textConfigDescription.setLayoutData((Object)gridData4);
        this.textConfigDescription.setEditable(false);
        toolkit.paintBordersFor(this.configComposite);
    }

    public void dispose() {
        if (this.configListAdapter != null) {
            this.configListAdapter.dispose();
        }
        super.dispose();
        if (this.contentProvider != null) {
            this.contentProvider.dispose();
        }
        if (this.labelProvider != null) {
            this.labelProvider.dispose();
        }
        this.disposed = true;
    }

    private void updateModelControls() {
        if (this.ctrl_name != null && !this.ctrl_name.isDisposed()) {
            this.updateControl(this.ctrl_name, this.process.getName());
        }
        if (this.ctrl_brief_desc != null && !this.ctrl_brief_desc.isDisposed()) {
            this.updateControl(this.ctrl_brief_desc, this.process.getBriefDescription());
        }
        if (this.ctrl_presentation_name != null && !this.ctrl_presentation_name.isDisposed()) {
            this.updateControl(this.ctrl_presentation_name, this.process.getPresentationName());
        }
        if (this.longPresentationNameOn && AuthoringUIPreferences.getEnableUIFields() && this.ctrl_long_presentation_name != null && !this.ctrl_long_presentation_name.isDisposed()) {
            this.updateControl(this.ctrl_long_presentation_name, this.process.getPresentation().getLongPresentationName());
        }
    }

    private boolean updateControl(Text text, String newText) {
        if (!text.getText().equals(TngUtil.checkNull((String)newText))) {
            text.setText(TngUtil.checkNull((String)newText));
        }
        return false;
    }

    private boolean updateControl(IMethodRichText text, String newText) {
        if (!text.getText().equals(TngUtil.checkNull((String)newText))) {
            text.setText(TngUtil.checkNull((String)newText));
        }
        return false;
    }

    public void loadData() {
        org.eclipse.epf.uma.ProcessDescription content = (org.eclipse.epf.uma.ProcessDescription)this.process.getPresentation();
        String externalID = content.getExternalId();
        String purpose = content.getPurpose();
        String fullDesc = content.getMainDescription();
        String scope = content.getScope();
        String usageNotes = content.getUsageNotes();
        String alternatives = content.getAlternatives();
        String howToStaff = content.getHowtoStaff();
        String keyConsideration = content.getKeyConsiderations();
        this.updateModelControls();
        if (AuthoringUIPreferences.getEnableUIFields() && this.ctrl_external_id != null && !this.ctrl_external_id.isDisposed()) {
            this.updateControl(this.ctrl_external_id, externalID);
        }
        this.updateControl(this.ctrl_purpose, purpose);
        this.updateControl(this.ctrl_full_desc, fullDesc);
        this.updateControl(this.ctrl_scope, scope);
        this.updateControl(this.ctrl_usage_notes, usageNotes);
        this.updateControl(this.ctrl_alternatives, alternatives);
        this.updateControl(this.ctrl_how_to_staff, howToStaff);
        this.updateControl(this.ctrl_key_consideration, keyConsideration);
        if (this.configListAdapter == null) {
            this.configListAdapter = new ConfigListItemProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory());
        }
        this.configListViewer.setInput((Object)this.configListAdapter);
    }

    protected void addListeners() {
        this.editor = (MethodElementEditor)this.getEditor();
        final IActionManager actionMgr = this.editor.getActionManager();
        final org.eclipse.epf.uma.ProcessDescription content = (org.eclipse.epf.uma.ProcessDescription)this.process.getPresentation();
        this.modifyListener = this.editor.createModifyListener((EObject)this.process);
        this.contentModifyListener = this.editor.createModifyListener((EObject)this.process.getPresentation());
        this.form.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                if (!ProcessDescription.this.descExpandFlag) {
                    return;
                }
                if (ProcessDescription.this.ctrl_expanded != null) {
                    ((GridData)ProcessDescription.this.ctrl_expanded.getLayoutData()).heightHint = ProcessDescription.this.getRichTextEditorHeight();
                    ((GridData)ProcessDescription.this.ctrl_expanded.getLayoutData()).widthHint = ProcessDescription.this.getRichTextEditorWidth();
                }
                ProcessDescription.this.formSection.layout(true, true);
            }

            public void controlMoved(ControlEvent e) {
            }
        });
        this.form.getParent().addListener(26, new Listener(){

            public void handleEvent(Event event) {
                if (TngUtil.isLocked((EObject)ProcessDescription.this.process)) {
                    ProcessDescription.this.refresh(false);
                } else {
                    ProcessDescription.this.refresh(true);
                }
            }
        });
        this.nameModifyListener = this.editor.createModifyListener(this.process.eContainer(), true);
        this.ctrl_name.addModifyListener(this.nameModifyListener);
        this.ctrl_name.addListener(27, new Listener(){

            /*
             * Enabled aggressive block sorting
             */
            public void handleEvent(Event e) {
                String oldContent = ProcessDescription.this.process.getName();
                if (((MethodElementEditor)ProcessDescription.this.getEditor()).mustRestoreValue(e.widget, oldContent)) {
                    return;
                }
                String newName = ProcessDescription.this.ctrl_name.getText().trim();
                if (newName.equals(ProcessDescription.this.process.getName())) {
                    return;
                }
                ProcessComponent procComp = (ProcessComponent)ProcessDescription.this.process.eContainer();
                String msg = null;
                if (newName.indexOf(38) > -1) {
                    msg = NLS.bind((String)LibraryEditResources.invalidElementNameError4_msg, (Object)newName);
                } else {
                    IValidator validator = IValidatorFactory.INSTANCE.createNameValidator((NamedElement)procComp, (AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory());
                    msg = validator.isValid(newName);
                }
                if (msg != null) {
                    AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.renameDialog_title, msg);
                    ProcessDescription.this.ctrl_name.setText(ProcessDescription.this.process.getName());
                    e.doit = false;
                    ProcessDescription.this.ctrl_name.getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            (this).ProcessDescription.this.ctrl_name.setFocus();
                            (this).ProcessDescription.this.ctrl_name.selectAll();
                        }
                    });
                    return;
                }
                String title = AuthoringUIResources.processDescriptionNameChangeConfirm_title;
                String message = AuthoringUIResources.processDescriptionNameChangeConfirm_message;
                if (!AuthoringUIPlugin.getDefault().getMsgDialog().displayConfirmation(title, message)) {
                    ProcessDescription.this.ctrl_name.setText(ProcessDescription.this.process.getName());
                    return;
                }
                e.doit = true;
                boolean status = actionMgr.doAction(1, (EObject)ProcessDescription.this.process, (EStructuralFeature)UmaPackage.eINSTANCE.getNamedElement_Name(), (Object)ProcessDescription.this.ctrl_name.getText(), -1);
                if (!status) {
                    ProcessDescription.this.ctrl_name.setText(ProcessDescription.this.process.getName());
                    return;
                }
                actionMgr.doAction(1, (EObject)procComp, (EStructuralFeature)UmaPackage.eINSTANCE.getNamedElement_Name(), (Object)ProcessDescription.this.ctrl_name.getText(), -1);
                ProcessDescription.this.setFormText();
                BusyIndicator.showWhile((Display)ProcessDescription.this.getSite().getShell().getDisplay(), (Runnable)new Runnable(){

                    public void run() {
                        MethodElementEditor editor = (MethodElementEditor)ProcessDescription.this.getEditor();
                        editor.doSave((IProgressMonitor)new NullProgressMonitor());
                        if (editor.isDirty()) {
                            return;
                        }
                        ILibraryPersister.FailSafeMethodLibraryPersister persister = editor.getPersister();
                        try {
                            persister.adjustLocation((this).ProcessDescription.this.process.eResource());
                            persister.commit();
                        }
                        catch (RuntimeException e) {
                            persister.rollback();
                            throw e;
                        }
                        DiagramManager mgr = DiagramManager.getInstance((Process)(this).ProcessDescription.this.process, (Object)this);
                        if (mgr != null) {
                            try {
                                try {
                                    mgr.updateResourceURI();
                                }
                                catch (Exception e) {
                                    AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)e);
                                    mgr.removeConsumer((Object)this);
                                }
                            }
                            finally {
                                mgr.removeConsumer((Object)this);
                            }
                        }
                    }
                });
            }
        });
        this.ctrl_name.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                ((MethodElementEditor)ProcessDescription.this.getEditor()).setCurrentFeatureEditor(e.widget, (EStructuralFeature)UmaPackage.eINSTANCE.getNamedElement_Name());
            }
        });
        this.ctrl_presentation_name.addModifyListener(this.modifyListener);
        this.ctrl_presentation_name.addListener(27, new Listener(){

            public void handleEvent(Event e) {
                String oldContent = ProcessDescription.this.process.getPresentationName();
                if (((MethodElementEditor)ProcessDescription.this.getEditor()).mustRestoreValue(e.widget, oldContent)) {
                    return;
                }
                if (ProcessDescription.this.ctrl_presentation_name.getText() != null && !ProcessDescription.this.ctrl_presentation_name.getText().equals("")) {
                    boolean status;
                    e.doit = true;
                    if (!ProcessDescription.this.ctrl_presentation_name.getText().equals(oldContent) && !(status = actionMgr.doAction(1, (EObject)ProcessDescription.this.process, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodElement_PresentationName(), (Object)ProcessDescription.this.ctrl_presentation_name.getText(), -1))) {
                        ProcessDescription.this.ctrl_presentation_name.setText(oldContent);
                        return;
                    }
                } else {
                    ProcessDescription.this.ctrl_presentation_name.setText(ProcessDescription.this.process.getPresentationName());
                    AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.editDialog_title, AuthoringUIResources.invalidPresentationNameError_msg);
                    e.doit = false;
                    ProcessDescription.this.ctrl_presentation_name.getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            (this).ProcessDescription.this.ctrl_presentation_name.setFocus();
                        }
                    });
                }
            }
        });
        this.ctrl_presentation_name.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                ((MethodElementEditor)ProcessDescription.this.getEditor()).setCurrentFeatureEditor(e.widget, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodElement_PresentationName());
                ProcessDescription.this.ctrl_presentation_name.selectAll();
            }

            public void focusLost(FocusEvent e) {
                if (ProcessDescription.this.ctrl_presentation_name.getSelectionCount() > 0) {
                    ProcessDescription.this.ctrl_presentation_name.clearSelection();
                }
            }
        });
        if (this.longPresentationNameOn && AuthoringUIPreferences.getEnableUIFields()) {
            this.ctrl_long_presentation_name.addModifyListener(this.modifyListener);
            this.ctrl_long_presentation_name.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusGained(FocusEvent e) {
                    ((MethodElementEditor)ProcessDescription.this.getEditor()).setCurrentFeatureEditor(e.widget, (EStructuralFeature)UmaPackage.eINSTANCE.getContentDescription_LongPresentationName());
                }

                public void focusLost(FocusEvent e) {
                    boolean success;
                    String oldContent = content.getLongPresentationName();
                    if (((MethodElementEditor)ProcessDescription.this.getEditor()).mustRestoreValue(ProcessDescription.this.ctrl_long_presentation_name, oldContent)) {
                        return;
                    }
                    String newContent = ProcessDescription.this.ctrl_long_presentation_name.getText();
                    if (!newContent.equals(oldContent) && (success = actionMgr.doAction(1, (EObject)ProcessDescription.this.process.getPresentation(), (EStructuralFeature)UmaPackage.eINSTANCE.getContentDescription_LongPresentationName(), (Object)newContent, -1))) {
                        ProcessDescription.this.ctrl_long_presentation_name.setText(newContent);
                    }
                }
            });
        }
        this.ctrl_brief_desc.addModifyListener(this.modifyListener);
        this.ctrl_brief_desc.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                ((MethodElementEditor)ProcessDescription.this.getEditor()).setCurrentFeatureEditor(e.widget, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodElement_BriefDescription());
            }

            public void focusLost(FocusEvent e) {
                boolean success;
                String oldContent = ProcessDescription.this.process.getBriefDescription();
                if (((MethodElementEditor)ProcessDescription.this.getEditor()).mustRestoreValue(e.widget, oldContent)) {
                    return;
                }
                String newContent = ProcessDescription.this.ctrl_brief_desc.getText();
                if (!newContent.equals(oldContent) && (success = actionMgr.doAction(1, (EObject)ProcessDescription.this.process, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodElement_BriefDescription(), (Object)newContent, -1))) {
                    ProcessDescription.this.ctrl_brief_desc.setText(newContent);
                }
            }
        });
        if (AuthoringUIPreferences.getEnableUIFields()) {
            this.ctrl_external_id.addModifyListener(this.contentModifyListener);
            this.ctrl_external_id.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusGained(FocusEvent e) {
                    ((MethodElementEditor)ProcessDescription.this.getEditor()).setCurrentFeatureEditor(e.widget, (EStructuralFeature)UmaPackage.eINSTANCE.getContentDescription_ExternalId());
                }

                public void focusLost(FocusEvent e) {
                    boolean success;
                    String oldContent = content.getExternalId();
                    if (((MethodElementEditor)ProcessDescription.this.getEditor()).mustRestoreValue(ProcessDescription.this.ctrl_external_id, oldContent)) {
                        return;
                    }
                    String newContent = ProcessDescription.this.ctrl_external_id.getText();
                    if (!newContent.equals(oldContent) && (success = actionMgr.doAction(1, (EObject)ProcessDescription.this.process.getPresentation(), (EStructuralFeature)UmaPackage.eINSTANCE.getContentDescription_ExternalId(), (Object)newContent, -1))) {
                        ProcessDescription.this.ctrl_external_id.setText(newContent);
                    }
                }
            });
        }
        this.ctrl_purpose.setModalObject((EObject)this.process.getPresentation());
        this.ctrl_purpose.setModalObjectFeature((EStructuralFeature)UmaPackage.eINSTANCE.getActivityDescription_Purpose());
        this.ctrl_purpose.addModifyListener(this.contentModifyListener);
        this.ctrl_purpose.addListener(27, new Listener(){

            public void handleEvent(Event e) {
                IMethodRichText control;
                IMethodRichText iMethodRichText = control = ProcessDescription.this.descExpandFlag ? ProcessDescription.this.ctrl_expanded : ProcessDescription.this.ctrl_purpose;
                if (!control.getModified()) {
                    return;
                }
                String oldContent = content.getPurpose();
                if (((MethodElementEditor)ProcessDescription.this.getEditor()).mustRestoreValue(ProcessDescription.this.ctrl_purpose, oldContent)) {
                    return;
                }
                String newContent = control.getText();
                if (!newContent.equals(oldContent)) {
                    actionMgr.doAction(1, (EObject)ProcessDescription.this.process.getPresentation(), (EStructuralFeature)UmaPackage.eINSTANCE.getActivityDescription_Purpose(), (Object)newContent, -1);
                }
            }
        });
        this.ctrl_full_desc.setModalObject((EObject)this.process.getPresentation());
        this.ctrl_full_desc.setModalObjectFeature((EStructuralFeature)UmaPackage.eINSTANCE.getContentDescription_MainDescription());
        this.ctrl_full_desc.addModifyListener(this.contentModifyListener);
        this.ctrl_full_desc.addListener(27, new Listener(){

            public void handleEvent(Event e) {
                IMethodRichText control;
                IMethodRichText iMethodRichText = control = ProcessDescription.this.descExpandFlag ? ProcessDescription.this.ctrl_expanded : ProcessDescription.this.ctrl_full_desc;
                if (!control.getModified()) {
                    return;
                }
                String oldContent = content.getMainDescription();
                if (((MethodElementEditor)ProcessDescription.this.getEditor()).mustRestoreValue(ProcessDescription.this.ctrl_full_desc, oldContent)) {
                    return;
                }
                String newContent = control.getText();
                if (!newContent.equals(oldContent)) {
                    actionMgr.doAction(1, (EObject)ProcessDescription.this.process.getPresentation(), (EStructuralFeature)UmaPackage.eINSTANCE.getContentDescription_MainDescription(), (Object)newContent, -1);
                }
            }
        });
        this.ctrl_scope.setModalObject((EObject)this.process.getPresentation());
        this.ctrl_scope.setModalObjectFeature((EStructuralFeature)UmaPackage.eINSTANCE.getProcessDescription_Scope());
        this.ctrl_scope.addModifyListener(this.contentModifyListener);
        this.ctrl_scope.addListener(27, new Listener(){

            public void handleEvent(Event e) {
                IMethodRichText control;
                IMethodRichText iMethodRichText = control = ProcessDescription.this.descExpandFlag ? ProcessDescription.this.ctrl_expanded : ProcessDescription.this.ctrl_scope;
                if (!control.getModified()) {
                    return;
                }
                String oldContent = content.getScope();
                if (((MethodElementEditor)ProcessDescription.this.getEditor()).mustRestoreValue(ProcessDescription.this.ctrl_scope, oldContent)) {
                    return;
                }
                String newContent = control.getText();
                if (!newContent.equals(oldContent)) {
                    actionMgr.doAction(1, (EObject)ProcessDescription.this.process.getPresentation(), (EStructuralFeature)UmaPackage.eINSTANCE.getProcessDescription_Scope(), (Object)newContent, -1);
                }
            }
        });
        this.ctrl_usage_notes.setModalObject((EObject)this.process.getPresentation());
        this.ctrl_usage_notes.setModalObjectFeature((EStructuralFeature)UmaPackage.eINSTANCE.getProcessDescription_UsageNotes());
        this.ctrl_usage_notes.addModifyListener(this.contentModifyListener);
        this.ctrl_usage_notes.addListener(27, new Listener(){

            public void handleEvent(Event e) {
                IMethodRichText control;
                IMethodRichText iMethodRichText = control = ProcessDescription.this.descExpandFlag ? ProcessDescription.this.ctrl_expanded : ProcessDescription.this.ctrl_usage_notes;
                if (!control.getModified()) {
                    return;
                }
                String oldContent = content.getUsageNotes();
                if (((MethodElementEditor)ProcessDescription.this.getEditor()).mustRestoreValue(ProcessDescription.this.ctrl_usage_notes, oldContent)) {
                    return;
                }
                String newContent = control.getText();
                if (!newContent.equals(oldContent)) {
                    actionMgr.doAction(1, (EObject)ProcessDescription.this.process.getPresentation(), (EStructuralFeature)UmaPackage.eINSTANCE.getProcessDescription_UsageNotes(), (Object)newContent, -1);
                }
            }
        });
        this.ctrl_alternatives.setModalObject((EObject)this.process.getPresentation());
        this.ctrl_alternatives.setModalObjectFeature((EStructuralFeature)UmaPackage.eINSTANCE.getActivityDescription_Alternatives());
        this.ctrl_alternatives.addModifyListener(this.contentModifyListener);
        this.ctrl_alternatives.addListener(27, new Listener(){

            public void handleEvent(Event e) {
                IMethodRichText control;
                IMethodRichText iMethodRichText = control = ProcessDescription.this.descExpandFlag ? ProcessDescription.this.ctrl_expanded : ProcessDescription.this.ctrl_alternatives;
                if (!control.getModified()) {
                    return;
                }
                String oldContent = content.getAlternatives();
                if (((MethodElementEditor)ProcessDescription.this.getEditor()).mustRestoreValue(ProcessDescription.this.ctrl_alternatives, oldContent)) {
                    return;
                }
                String newContent = control.getText();
                if (!newContent.equals(oldContent)) {
                    actionMgr.doAction(1, (EObject)ProcessDescription.this.process.getPresentation(), (EStructuralFeature)UmaPackage.eINSTANCE.getActivityDescription_Alternatives(), (Object)newContent, -1);
                }
            }
        });
        this.ctrl_how_to_staff.setModalObject((EObject)this.process.getPresentation());
        this.ctrl_how_to_staff.setModalObjectFeature((EStructuralFeature)UmaPackage.eINSTANCE.getActivityDescription_HowtoStaff());
        this.ctrl_how_to_staff.addModifyListener(this.contentModifyListener);
        this.ctrl_how_to_staff.addListener(27, new Listener(){

            public void handleEvent(Event e) {
                IMethodRichText control;
                IMethodRichText iMethodRichText = control = ProcessDescription.this.descExpandFlag ? ProcessDescription.this.ctrl_expanded : ProcessDescription.this.ctrl_how_to_staff;
                if (!control.getModified()) {
                    return;
                }
                String oldContent = content.getHowtoStaff();
                if (((MethodElementEditor)ProcessDescription.this.getEditor()).mustRestoreValue(ProcessDescription.this.ctrl_how_to_staff, oldContent)) {
                    return;
                }
                String newContent = control.getText();
                if (!newContent.equals(oldContent)) {
                    actionMgr.doAction(1, (EObject)ProcessDescription.this.process.getPresentation(), (EStructuralFeature)UmaPackage.eINSTANCE.getActivityDescription_HowtoStaff(), (Object)newContent, -1);
                }
            }
        });
        this.ctrl_key_consideration.setModalObject((EObject)this.process.getPresentation());
        this.ctrl_key_consideration.setModalObjectFeature((EStructuralFeature)UmaPackage.eINSTANCE.getContentDescription_KeyConsiderations());
        this.ctrl_key_consideration.addModifyListener(this.contentModifyListener);
        this.ctrl_key_consideration.addListener(27, new Listener(){

            public void handleEvent(Event e) {
                IMethodRichText control;
                IMethodRichText iMethodRichText = control = ProcessDescription.this.descExpandFlag ? ProcessDescription.this.ctrl_expanded : ProcessDescription.this.ctrl_key_consideration;
                if (!control.getModified()) {
                    return;
                }
                String oldContent = content.getKeyConsiderations();
                if (((MethodElementEditor)ProcessDescription.this.getEditor()).mustRestoreValue(ProcessDescription.this.ctrl_key_consideration, oldContent)) {
                    return;
                }
                String newContent = control.getText();
                if (!newContent.equals(oldContent)) {
                    actionMgr.doAction(1, (EObject)ProcessDescription.this.process.getPresentation(), (EStructuralFeature)UmaPackage.eINSTANCE.getContentDescription_KeyConsiderations(), (Object)newContent, -1);
                }
            }
        });
        this.configListViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)ProcessDescription.this.configListViewer.getSelection();
                if (selection.size() == 1) {
                    String desc;
                    MethodConfiguration config = (MethodConfiguration)selection.getFirstElement();
                    if (!TngUtil.isLocked((EObject)ProcessDescription.this.methodElement)) {
                        if (config == ProcessDescription.this.process.getDefaultContext()) {
                            ProcessDescription.this.buttonRemove.setEnabled(false);
                        } else {
                            ProcessDescription.this.buttonRemove.setEnabled(true);
                        }
                    }
                    if ((desc = config.getBriefDescription()) == null) {
                        desc = "";
                    }
                    ProcessDescription.this.textConfigDescription.setText(desc);
                }
            }
        });
        this.buttonAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MethodLibrary lib = UmaUtil.getMethodLibrary((EObject)ProcessDescription.this.process);
                final ConfigurationsItemProvider input = new ConfigurationsItemProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory(), lib, "");
                ListSelectionDialog dlg = new ListSelectionDialog(Display.getCurrent().getActiveShell(), input, ProcessDescription.this.contentProvider, ProcessDescription.this.labelProvider, AuthoringUIResources.ProcessDescription_selectConfiguration){

                    protected Control createDialogArea(Composite parent) {
                        Control control = super.createDialogArea(parent);
                        this.getViewer().addFilter(new ViewerFilter(){

                            public boolean select(Viewer viewer, Object parentElement, Object element) {
                                return !((this).this).ProcessDescription.this.process.getValidContext().contains(element);
                            }
                        });
                        return control;
                    }

                    public boolean close() {
                        input.dispose();
                        return super.close();
                    }
                };
                if (dlg.open() == 0) {
                    Object[] obs = dlg.getResult();
                    int i = 0;
                    while (i < obs.length) {
                        MethodConfiguration config = (MethodConfiguration)obs[i];
                        if (config != null) {
                            actionMgr.doAction(3, (EObject)ProcessDescription.this.process, (EStructuralFeature)UmaPackage.eINSTANCE.getProcess_ValidContext(), (Object)config, -1);
                        } else {
                            AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.addConfigErrorDialog_title, AuthoringUIResources.bind((String)AuthoringUIResources.invalidConfigError_msg, (Object)config.getName()));
                        }
                        ++i;
                    }
                }
            }
        });
        this.buttonRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)ProcessDescription.this.configListViewer.getSelection();
                actionMgr.doAction(6, (EObject)ProcessDescription.this.process, (EStructuralFeature)UmaPackage.eINSTANCE.getProcess_ValidContext(), (Object)selection.toList(), -1);
            }
        });
        this.buttonMakeDefault.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MethodConfiguration currentConfig;
                IStructuredSelection selection = (IStructuredSelection)ProcessDescription.this.configListViewer.getSelection();
                if (selection.size() == 1 && (currentConfig = ProcessDescription.this.process.getDefaultContext()) != selection.getFirstElement()) {
                    boolean status = actionMgr.doAction(1, (EObject)ProcessDescription.this.process, (EStructuralFeature)UmaPackage.eINSTANCE.getProcess_DefaultContext(), selection.getFirstElement(), -1);
                    if (!status) {
                        return;
                    }
                    ProcessDescription.this.buttonRemove.setEnabled(false);
                }
            }
        });
    }

    protected void refresh(boolean editable) {
        IStructuredSelection selection;
        if (!this.ctrl_name.isDisposed()) {
            this.ctrl_name.setEditable(editable);
        }
        if (!this.ctrl_presentation_name.isDisposed()) {
            this.ctrl_presentation_name.setEditable(editable);
        }
        if (this.longPresentationNameOn && AuthoringUIPreferences.getEnableUIFields() && !this.ctrl_long_presentation_name.isDisposed()) {
            this.ctrl_long_presentation_name.setEditable(editable);
        }
        if (!this.ctrl_brief_desc.isDisposed()) {
            this.ctrl_brief_desc.setEditable(editable);
        }
        if (!this.ctrl_purpose.isDisposed()) {
            this.ctrl_purpose.setEditable(editable);
        }
        if (!this.ctrl_full_desc.isDisposed()) {
            this.ctrl_full_desc.setEditable(editable);
        }
        if (!this.ctrl_alternatives.isDisposed()) {
            this.ctrl_alternatives.setEditable(editable);
        }
        if (AuthoringUIPreferences.getEnableUIFields() && !this.ctrl_external_id.isDisposed()) {
            this.ctrl_external_id.setEditable(editable);
        }
        if (!this.ctrl_key_consideration.isDisposed()) {
            this.ctrl_key_consideration.setEditable(editable);
        }
        if (!this.ctrl_how_to_staff.isDisposed()) {
            this.ctrl_how_to_staff.setEditable(editable);
        }
        if (!this.ctrl_scope.isDisposed()) {
            this.ctrl_scope.setEditable(editable);
        }
        if (!this.ctrl_usage_notes.isDisposed()) {
            this.ctrl_usage_notes.setEditable(editable);
        }
        if (this.ctrl_expanded != null && !this.ctrl_expanded.isDisposed()) {
            this.ctrl_expanded.setEditable(editable);
        }
        if ((selection = (IStructuredSelection)this.configListViewer.getSelection()).size() == 1) {
            String desc;
            MethodConfiguration config = (MethodConfiguration)selection.getFirstElement();
            if (config == this.process.getDefaultContext()) {
                if (!this.buttonRemove.isDisposed()) {
                    this.buttonRemove.setEnabled(false);
                }
            } else if (!this.buttonRemove.isDisposed()) {
                this.buttonRemove.setEnabled(editable);
            }
            if ((desc = config.getBriefDescription()) == null) {
                desc = "";
            }
            this.textConfigDescription.setText(desc);
        }
        if (!this.buttonAdd.isDisposed()) {
            this.buttonAdd.setEnabled(editable);
        }
        if (!this.buttonMakeDefault.isDisposed()) {
            this.buttonMakeDefault.setEnabled(editable);
        }
        if (!this.buttonRemove.isDisposed() && !editable) {
            this.buttonRemove.setEnabled(editable);
        }
    }

    private boolean checkValidityForSuperSet(MethodConfiguration defaultConfig, MethodConfiguration config) {
        List defaultPlugins = defaultConfig.getMethodPluginSelection();
        List defaultPackages = defaultConfig.getMethodPackageSelection();
        List packages = config.getMethodPackageSelection();
        List plugins = config.getMethodPluginSelection();
        boolean pluginContains = false;
        boolean packageContains = false;
        if (plugins != null) {
            pluginContains = defaultPlugins.containsAll(plugins);
        }
        if (packages != null) {
            packageContains = defaultPackages.containsAll(packages);
        }
        return pluginContains && packageContains;
    }

    protected void enableSections(boolean enable) {
        this.generalSection.setVisible(enable);
        if (enable) {
            this.generalSection.setExpanded(this.generalSectionExpandFlag);
        } else {
            this.generalSectionExpandFlag = this.generalSection.isExpanded();
            this.generalSection.setExpanded(enable);
        }
        this.detailSection.setVisible(enable);
        if (enable) {
            this.detailSection.setExpanded(this.detailSectionExpandFlag);
        } else {
            this.detailSectionExpandFlag = this.detailSection.isExpanded();
            this.detailSection.setExpanded(enable);
        }
        this.configSection.setVisible(enable);
        if (enable) {
            this.configSection.setExpanded(this.configSectionExpandFlag);
        } else {
            this.configSectionExpandFlag = this.configSection.isExpanded();
            this.configSection.setExpanded(enable);
        }
    }

    public void setFormText() {
        this.form.setText(String.valueOf(LibraryUIText.getUIText((MethodElement)this.process)) + ": " + this.methodElement.getName());
    }

    public void refreshElementName(final String newName) {
        if (newName != null && this.ctrl_name != null && !this.ctrl_name.isDisposed()) {
            Runnable runnable = new Runnable(){

                public void run() {
                    ProcessDescription.this.ctrl_name.removeModifyListener(ProcessDescription.this.nameModifyListener);
                    ProcessDescription.this.ctrl_name.setText(newName);
                    ProcessDescription.this.ctrl_name.addModifyListener(ProcessDescription.this.nameModifyListener);
                    ProcessDescription.this.setFormText();
                }
            };
            if (this.ctrl_name.getDisplay().getThread() == Thread.currentThread()) {
                runnable.run();
            } else {
                this.ctrl_name.getDisplay().syncExec(runnable);
            }
        }
    }

    protected void setContextHelp() {
        super.setContextHelp();
        EditorsContextHelper.setHelp(this.getPartControl(), this.processType);
    }

    class ConfigListItemProvider
    extends ItemProviderAdapter
    implements IStructuredItemContentProvider {
        public ConfigListItemProvider(AdapterFactory adapterFactory) {
            super(adapterFactory);
            ProcessDescription.this.process.eAdapters().add((Object)this);
        }

        public Collection getChildren(Object object) {
            MethodConfiguration defaultConfig = ProcessDescription.this.process.getDefaultContext();
            if (defaultConfig != null && !ProcessDescription.this.process.getValidContext().contains(defaultConfig)) {
                ProcessDescription.this.process.getValidContext().add(0, defaultConfig);
            }
            return ProcessDescription.this.process.getValidContext();
        }

        public void notifyChanged(Notification msg) {
            boolean refresh = false;
            switch (msg.getFeatureID(Process.class)) {
                case 44: {
                    switch (msg.getEventType()) {
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: {
                            refresh = true;
                        }
                    }
                    break;
                }
                case 43: {
                    refresh = true;
                }
            }
            if (refresh) {
                ProcessDescription.this.configListViewer.refresh();
            }
        }
    }
}

