/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.properties;

import java.util.Iterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.authoring.ui.AuthoringUIImages;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.editors.MethodElementEditor;
import org.eclipse.epf.authoring.ui.forms.BaseFormPage;
import org.eclipse.epf.authoring.ui.forms.MethodFormToolkit;
import org.eclipse.epf.authoring.ui.properties.AbstractSection;
import org.eclipse.epf.authoring.ui.properties.EPFPropertySheetPage;
import org.eclipse.epf.authoring.ui.properties.FormUI;
import org.eclipse.epf.authoring.ui.properties.PropertiesResources;
import org.eclipse.epf.authoring.ui.properties.PropertiesUtil;
import org.eclipse.epf.authoring.ui.richtext.IMethodRichText;
import org.eclipse.epf.authoring.ui.richtext.IMethodRichTextEditor;
import org.eclipse.epf.authoring.ui.util.RichTextImageLinkContainer;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.util.ResourceHelper;
import org.eclipse.epf.richtext.RichTextListener;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.BreakdownElementDescription;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class BreakdownElementDocumentSection
extends AbstractSection {
    protected Text prefixText;
    protected Label prefixLabel;
    protected Text briefDescText;
    protected Label briefDescLabel;
    protected Text externalIDText;
    protected Label externalIDLabel;
    protected FormToolkit toolkit;
    protected Section documentSection;
    protected Composite parent;
    protected Composite documentComposite;
    protected Composite expandDocumentComposite;
    protected IMethodRichTextEditor ctrl_document_expanded;
    protected IMethodRichText usageGuidance;
    protected RichTextImageLinkContainer usageGuidanceContainer;
    protected IMethodRichText keyConsiderations;
    protected RichTextImageLinkContainer keyConsiderationsContainer;
    protected Text ctrl_document_expanded_Text;
    protected ImageHyperlink expandDocumentLink;
    protected Label expandDocumentLabel;
    protected boolean expandFlag = false;
    protected boolean expandFlagText = false;
    protected IMethodRichText activeControl;
    protected Text activeControlText;
    protected BreakdownElement element;
    protected IActionManager actionMgr;
    protected ModifyListener modelModifyListener;
    protected ModifyListener contentModifyListener;
    protected String contentElementPath;
    protected String type = "";
    protected String contentElementName = "";
    protected int heightHint = 40;
    private Listener usageGuidanceListener = new Listener(){

        public void handleEvent(Event e) {
            IMethodRichText control;
            BreakdownElementDocumentSection.this.element = BreakdownElementDocumentSection.this.getElement();
            IMethodRichText iMethodRichText = control = BreakdownElementDocumentSection.this.expandFlag ? BreakdownElementDocumentSection.this.ctrl_document_expanded : BreakdownElementDocumentSection.this.usageGuidance;
            if (!control.getModified()) {
                return;
            }
            String oldContent = ((BreakdownElementDescription)BreakdownElementDocumentSection.this.element.getPresentation()).getUsageGuidance();
            if (BreakdownElementDocumentSection.this.getEditor().mustRestoreValue(BreakdownElementDocumentSection.this.usageGuidance, oldContent)) {
                return;
            }
            String newContent = control.getText();
            if (!newContent.equals(oldContent)) {
                BreakdownElementDocumentSection.this.actionMgr.doAction(1, (EObject)BreakdownElementDocumentSection.this.element.getPresentation(), (EStructuralFeature)UmaPackage.eINSTANCE.getBreakdownElementDescription_UsageGuidance(), (Object)newContent, -1);
            }
        }
    };
    private Listener keyConsiderationsListener = new Listener(){

        public void handleEvent(Event e) {
            IMethodRichText control;
            BreakdownElementDocumentSection.this.element = BreakdownElementDocumentSection.this.getElement();
            IMethodRichText iMethodRichText = control = BreakdownElementDocumentSection.this.expandFlag ? BreakdownElementDocumentSection.this.ctrl_document_expanded : BreakdownElementDocumentSection.this.keyConsiderations;
            if (!control.getModified()) {
                return;
            }
            String oldContent = BreakdownElementDocumentSection.this.element.getPresentation().getKeyConsiderations();
            if (BreakdownElementDocumentSection.this.getEditor().mustRestoreValue(BreakdownElementDocumentSection.this.keyConsiderations, oldContent)) {
                return;
            }
            String newContent = control.getText();
            if (!newContent.equals(oldContent)) {
                BreakdownElementDocumentSection.this.actionMgr.doAction(1, (EObject)BreakdownElementDocumentSection.this.element.getPresentation(), (EStructuralFeature)UmaPackage.eINSTANCE.getContentDescription_KeyConsiderations(), (Object)newContent, -1);
            }
        }
    };

    protected void init() {
        this.element = this.getElement();
        this.toolkit = this.getWidgetFactory();
        this.actionMgr = EPFPropertySheetPage.getActionManager();
        this.contentElementPath = ResourceHelper.getFolderAbsolutePath((MethodElement)this.element);
    }

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        this.parent = parent;
        super.createControls(parent, tabbedPropertySheetPage);
        this.init();
        parent.setLayout((Layout)new GridLayout());
        parent.setLayoutData((Object)new GridData(1808));
        this.createDocumentSection(parent);
        this.addListeners();
        this.updateControls();
    }

    protected void addListeners() {
        this.parent.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                if (BreakdownElementDocumentSection.this.ctrl_document_expanded != null) {
                    ((GridData)BreakdownElementDocumentSection.this.ctrl_document_expanded.getLayoutData()).heightHint = BreakdownElementDocumentSection.this.getRichTextEditorHeight();
                    ((GridData)BreakdownElementDocumentSection.this.ctrl_document_expanded.getLayoutData()).widthHint = BreakdownElementDocumentSection.this.getRichTextEditorWidth();
                }
                BreakdownElementDocumentSection.this.parent.layout(true, true);
            }

            public void controlMoved(ControlEvent e) {
            }
        });
        this.prefixText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                BreakdownElementDocumentSection.this.getEditor().setCurrentFeatureEditor(e.widget, (EStructuralFeature)UmaPackage.eINSTANCE.getBreakdownElement_Prefix());
            }

            public void focusLost(FocusEvent e) {
                boolean status;
                BreakdownElementDocumentSection.this.element = BreakdownElementDocumentSection.this.getElement();
                String oldContent = BreakdownElementDocumentSection.this.element.getPrefix();
                if (BreakdownElementDocumentSection.this.getEditor().mustRestoreValue(BreakdownElementDocumentSection.this.prefixText, oldContent)) {
                    return;
                }
                String newContent = StrUtil.getPlainText((String)BreakdownElementDocumentSection.this.prefixText.getText());
                if (!newContent.equals(oldContent) && (status = BreakdownElementDocumentSection.this.actionMgr.doAction(1, (EObject)BreakdownElementDocumentSection.this.element, (EStructuralFeature)UmaPackage.eINSTANCE.getBreakdownElement_Prefix(), (Object)newContent, -1))) {
                    BreakdownElementDocumentSection.this.prefixText.setText(newContent);
                }
            }
        });
        this.briefDescText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                BreakdownElementDocumentSection.this.getEditor().setCurrentFeatureEditor(e.widget, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodElement_BriefDescription());
            }

            public void focusLost(FocusEvent e) {
                boolean status;
                BreakdownElementDocumentSection.this.element = BreakdownElementDocumentSection.this.getElement();
                String oldContent = BreakdownElementDocumentSection.this.element.getBriefDescription();
                if (BreakdownElementDocumentSection.this.getEditor().mustRestoreValue(BreakdownElementDocumentSection.this.briefDescText, oldContent)) {
                    return;
                }
                String newContent = StrUtil.getPlainText((String)BreakdownElementDocumentSection.this.briefDescText.getText());
                if (!newContent.equals(oldContent) && (status = BreakdownElementDocumentSection.this.actionMgr.doAction(1, (EObject)BreakdownElementDocumentSection.this.element, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodElement_BriefDescription(), (Object)newContent, -1))) {
                    BreakdownElementDocumentSection.this.briefDescText.setText(newContent);
                }
            }
        });
        this.externalIDText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                BreakdownElementDocumentSection.this.getEditor().setCurrentFeatureEditor(e.widget, (EStructuralFeature)UmaPackage.eINSTANCE.getContentDescription_ExternalId());
            }

            public void focusLost(FocusEvent e) {
                boolean status;
                BreakdownElementDocumentSection.this.element = BreakdownElementDocumentSection.this.getElement();
                String oldContent = BreakdownElementDocumentSection.this.element.getPresentation().getExternalId();
                if (BreakdownElementDocumentSection.this.getEditor().mustRestoreValue(BreakdownElementDocumentSection.this.externalIDText, oldContent)) {
                    return;
                }
                String newContent = StrUtil.getPlainText((String)BreakdownElementDocumentSection.this.externalIDText.getText());
                if (!newContent.equals(oldContent) && (status = BreakdownElementDocumentSection.this.actionMgr.doAction(1, (EObject)BreakdownElementDocumentSection.this.element.getPresentation(), (EStructuralFeature)UmaPackage.eINSTANCE.getContentDescription_ExternalId(), (Object)newContent, -1))) {
                    BreakdownElementDocumentSection.this.externalIDText.setText(newContent);
                }
            }
        });
        BreakdownElement element = this.getElement();
        this.usageGuidance.setModalObject((EObject)element);
        this.usageGuidance.setModalObjectFeature((EStructuralFeature)UmaPackage.eINSTANCE.getBreakdownElementDescription_UsageGuidance());
        this.usageGuidance.addListener(27, this.usageGuidanceListener);
        this.keyConsiderations.setModalObject((EObject)element);
        this.keyConsiderations.setModalObjectFeature((EStructuralFeature)UmaPackage.eINSTANCE.getContentDescription_KeyConsiderations());
        this.keyConsiderations.addListener(27, this.keyConsiderationsListener);
    }

    protected void createDocumentSection(Composite composite) {
        int horizontalSpan = 2;
        this.documentSection = FormUI.createSection(this.toolkit, composite, PropertiesResources.Process_DocumentInformationTitle, PropertiesResources.bind(PropertiesResources.Process_documentInformationDescription, PropertiesUtil.getTypeLower(this.element)));
        this.documentComposite = FormUI.createComposite(this.toolkit, this.documentSection, 3, false);
        this.prefixLabel = FormUI.createLabel(this.toolkit, this.documentComposite, PropertiesResources.Process_prefix, horizontalSpan);
        this.prefixText = FormUI.createText(this.toolkit, this.documentComposite, this.heightHint);
        this.briefDescLabel = FormUI.createLabel(this.toolkit, this.documentComposite, PropertiesResources.Process_briefDescription, horizontalSpan);
        this.briefDescText = FormUI.createText(this.toolkit, this.documentComposite, this.heightHint);
        this.externalIDLabel = FormUI.createLabel(this.toolkit, this.documentComposite, AuthoringUIResources.Process_ExternalID, horizontalSpan);
        this.externalIDText = FormUI.createText(this.toolkit, this.documentComposite);
        this.usageGuidanceContainer = FormUI.createRichTextWithLink(this.toolkit, this.documentComposite, this.heightHint, this.contentElementPath, (MethodElement)this.element, PropertiesResources.Process_usageGuidance);
        this.addHyperLinkListener(this.usageGuidanceContainer.link);
        this.usageGuidance = this.usageGuidanceContainer.richText;
        this.keyConsiderationsContainer = FormUI.createRichTextWithLink(this.toolkit, this.documentComposite, this.heightHint, this.contentElementPath, (MethodElement)this.element, PropertiesResources.BreakdownElement_keyConsiderations);
        this.addHyperLinkListener(this.keyConsiderationsContainer.link);
        this.keyConsiderations = this.keyConsiderationsContainer.richText;
        this.expandDocumentComposite = FormUI.createComposite(this.toolkit, this.documentSection, 2, true);
        this.expandDocumentLink = FormUI.createImageHyperLink(this.toolkit, this.expandDocumentComposite, AuthoringUIImages.IMG_EXPANDED, AuthoringUIResources.closeRTE);
        this.addHyperLinkListener(this.expandDocumentLink);
        this.expandDocumentLabel = BaseFormPage.createDecoratedLabel(this.toolkit, this.expandDocumentComposite, "");
    }

    protected void addHyperLinkListener(ImageHyperlink link) {
        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                BreakdownElementDocumentSection.this.toggle(e);
            }
        });
    }

    protected IMethodRichTextEditor toggle(HyperlinkEvent e) {
        Iterator i;
        IMethodRichText ctrl = (IMethodRichText)e.getHref();
        if (this.ctrl_document_expanded == null) {
            this.ctrl_document_expanded = MethodFormToolkit.createRichTextEditor(this.toolkit, this.expandDocumentComposite, "", 66, this.contentElementPath, (MethodElement)this.element, this.expandDocumentLabel, this.getEditor().getEditorSite());
            GridData gridData = new GridData(1808);
            gridData.heightHint = this.getRichTextEditorHeight();
            gridData.widthHint = this.getRichTextEditorWidth();
            gridData.horizontalSpan = 2;
            this.ctrl_document_expanded.setLayoutData(gridData);
            this.ctrl_document_expanded.addModifyListener(this.contentModifyListener);
        }
        if (this.expandFlag) {
            this.ctrl_document_expanded.collapse();
            this.documentComposite.setVisible(true);
            this.documentSection.setClient((Control)this.documentComposite);
            this.expandDocumentComposite.setVisible(false);
            ctrl = this.getActiveRichTextControl();
            ctrl.setText(this.ctrl_document_expanded.getText());
            i = ctrl.getListeners();
            while (i.hasNext()) {
                RichTextListener listener = (RichTextListener)i.next();
                this.ctrl_document_expanded.removeListener(listener.getEventType(), listener.getListener());
            }
            if (this.ctrl_document_expanded.getModified()) {
                this.getEditor().saveModifiedRichText(this.ctrl_document_expanded);
            }
            ctrl.setFocus();
        } else {
            this.documentComposite.setVisible(false);
            this.documentSection.setClient((Control)this.expandDocumentComposite);
            this.expandDocumentComposite.setVisible(true);
            this.expandDocumentLabel.setText((String)((ImageHyperlink)e.getSource()).getData("Title"));
            this.setActiveRichTextControl(ctrl);
            this.ctrl_document_expanded.setInitialText(ctrl.getText());
            this.ctrl_document_expanded.setModalObject(ctrl.getModalObject());
            this.ctrl_document_expanded.setModalObjectFeature(ctrl.getModalObjectFeature());
            this.ctrl_document_expanded.setFindReplaceAction(ctrl.getFindReplaceAction());
            i = ctrl.getListeners();
            while (i.hasNext()) {
                RichTextListener listener = (RichTextListener)i.next();
                this.ctrl_document_expanded.addListener(listener.getEventType(), listener.getListener());
            }
        }
        this.documentSection.layout(true);
        if (this.ctrl_document_expanded != null) {
            this.ctrl_document_expanded.setEditable(this.editable);
        }
        this.expandFlag = !this.expandFlag;
        return this.ctrl_document_expanded;
    }

    public void refresh() {
        try {
            if (this.getElement() instanceof BreakdownElement) {
                this.getEditor().saveModifiedRichText();
                this.element = this.getElement();
                BreakdownElementDescription content = (BreakdownElementDescription)this.element.getPresentation();
                this.documentSection.setDescription(PropertiesResources.bind(PropertiesResources.Process_documentInformationDescription, PropertiesUtil.getTypeLower(this.element)));
                if (this.modelModifyListener != null) {
                    this.prefixText.removeModifyListener(this.modelModifyListener);
                    this.briefDescText.removeModifyListener(this.modelModifyListener);
                }
                if (this.contentModifyListener != null) {
                    this.externalIDText.removeModifyListener(this.contentModifyListener);
                    this.usageGuidance.removeModifyListener(this.contentModifyListener);
                    this.keyConsiderations.removeModifyListener(this.contentModifyListener);
                }
                this.modelModifyListener = this.getEditor().createModifyListener((EObject)this.element);
                this.contentModifyListener = this.getEditor().createModifyListener((EObject)this.element.getPresentation());
                if (this.modelModifyListener != null && this.modelModifyListener instanceof MethodElementEditor.ModifyListener) {
                    ((MethodElementEditor.ModifyListener)this.modelModifyListener).setElement((EObject)this.element);
                    ((MethodElementEditor.ModifyListener)this.modelModifyListener).setDisable(true);
                }
                if (this.contentModifyListener != null && this.contentModifyListener instanceof MethodElementEditor.ModifyListener) {
                    ((MethodElementEditor.ModifyListener)this.contentModifyListener).setElement((EObject)this.element.getPresentation());
                    ((MethodElementEditor.ModifyListener)this.contentModifyListener).setDisable(true);
                }
                this.prefixText.setText(this.element.getPrefix());
                this.briefDescText.setText(this.element.getBriefDescription());
                this.externalIDText.setText(content.getExternalId());
                this.usageGuidance.setText(content.getUsageGuidance());
                this.keyConsiderations.setText(content.getKeyConsiderations());
                if (this.expandFlag) {
                    if (this.expandDocumentLabel.getText().equals(PropertiesResources.Process_usageGuidance)) {
                        this.ctrl_document_expanded.setText(content.getUsageGuidance());
                        this.ctrl_document_expanded.setSelection(0);
                        this.ctrl_document_expanded.setModalObject((EObject)content);
                        this.ctrl_document_expanded.setModalObjectFeature((EStructuralFeature)UmaPackage.eINSTANCE.getBreakdownElementDescription_UsageGuidance());
                    } else if (this.expandDocumentLabel.getText().equals(PropertiesResources.BreakdownElement_keyConsiderations)) {
                        this.ctrl_document_expanded.setText(content.getKeyConsiderations());
                        this.ctrl_document_expanded.setModalObject((EObject)content);
                        this.ctrl_document_expanded.setModalObjectFeature((EStructuralFeature)UmaPackage.eINSTANCE.getContentDescription_KeyConsiderations());
                    }
                }
                this.updateControls();
                if (this.modelModifyListener instanceof MethodElementEditor.ModifyListener) {
                    ((MethodElementEditor.ModifyListener)this.modelModifyListener).setDisable(false);
                }
                if (this.contentModifyListener instanceof MethodElementEditor.ModifyListener) {
                    ((MethodElementEditor.ModifyListener)this.contentModifyListener).setDisable(false);
                }
                this.prefixText.addModifyListener(this.modelModifyListener);
                this.briefDescText.addModifyListener(this.modelModifyListener);
                this.externalIDText.addModifyListener(this.contentModifyListener);
                this.usageGuidance.setModalObject((EObject)content);
                this.usageGuidance.setModalObjectFeature((EStructuralFeature)UmaPackage.eINSTANCE.getBreakdownElementDescription_UsageGuidance());
                this.usageGuidance.addModifyListener(this.contentModifyListener);
                this.keyConsiderations.setModalObject((EObject)content);
                this.keyConsiderations.setModalObjectFeature((EStructuralFeature)UmaPackage.eINSTANCE.getContentDescription_KeyConsiderations());
                this.keyConsiderations.addModifyListener(this.contentModifyListener);
            }
        }
        catch (Exception ex) {
            this.logger.logError("Error refreshing breakdown element documentation section", (Throwable)ex);
        }
    }

    protected void updateControls() {
        this.prefixText.setEditable(this.editable);
        this.briefDescText.setEditable(this.editable);
        this.externalIDText.setEditable(this.editable);
        this.usageGuidance.setEditable(this.editable);
        this.keyConsiderations.setEditable(this.editable);
    }

    private void setActiveRichTextControl(IMethodRichText ctrl) {
        this.activeControl = ctrl;
    }

    private IMethodRichText getActiveRichTextControl() {
        return this.activeControl;
    }

    public int getRichTextEditorHeight() {
        return this.parent.getBounds().height - 96;
    }

    public int getRichTextEditorWidth() {
        return this.parent.getBounds().width - 64;
    }
}

