/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.properties;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.epf.authoring.ui.dialogs.ItemsFilterDialog;
import org.eclipse.epf.authoring.ui.filters.ProcessGuidanceFilter;
import org.eclipse.epf.authoring.ui.properties.AbstractSection;
import org.eclipse.epf.authoring.ui.properties.EPFPropertySheetPage;
import org.eclipse.epf.authoring.ui.properties.FormUI;
import org.eclipse.epf.authoring.ui.properties.PropertiesResources;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.library.edit.configuration.GuidanceItemProvider;
import org.eclipse.epf.library.edit.itemsfilter.FilterConstants;
import org.eclipse.epf.library.edit.itemsfilter.FilterInitializer;
import org.eclipse.epf.library.edit.process.IBSItemProvider;
import org.eclipse.epf.library.edit.process.command.AddGuidanceToBreakdownElementCommand;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.Checklist;
import org.eclipse.epf.uma.Concept;
import org.eclipse.epf.uma.Example;
import org.eclipse.epf.uma.Guidance;
import org.eclipse.epf.uma.Guideline;
import org.eclipse.epf.uma.ReusableAsset;
import org.eclipse.epf.uma.SupportingMaterial;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BreakdownElementGuidanceSection
extends AbstractSection {
    protected ILabelProvider labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory());
    private FormToolkit toolkit;
    private Button ctrl_add_1;
    private Button ctrl_remove_1;
    private Table ctrl_table_1;
    private TableViewer viewer_1;
    private BreakdownElement element;
    private IActionManager actionMgr;
    public final String tabName = FilterConstants.GUIDANCE;
    private IFilter generalGuidanceFilter = null;

    public IFilter getGeneralGuidanceFilter() {
        if (this.generalGuidanceFilter == null) {
            this.generalGuidanceFilter = new ProcessGuidanceFilter(this.getConfiguration(), null, this.tabName){

                public boolean childAccept(Object obj) {
                    if (super.childAccept(obj)) {
                        return true;
                    }
                    if (obj instanceof GuidanceItemProvider) {
                        return !((GuidanceItemProvider)obj).getChildren(obj).isEmpty();
                    }
                    Class cls = FilterInitializer.getInstance().getClassForType(this.helper.getFilterTypeStr());
                    if (cls != null) {
                        return cls.isInstance(obj);
                    }
                    return obj instanceof Checklist || obj instanceof Concept || obj instanceof Example || obj instanceof Guideline || obj instanceof ReusableAsset || obj instanceof SupportingMaterial;
                }
            };
        } else {
            ((ProcessGuidanceFilter)this.generalGuidanceFilter).setMethodConfiguration(this.getConfiguration());
        }
        return this.generalGuidanceFilter;
    }

    @Override
    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        this.init();
        parent.setLayout((Layout)new GridLayout());
        parent.setLayoutData((Object)new GridData(1808));
        this.createGuidanceSection(parent);
        this.addListeners();
        this.updateControls();
    }

    private void init() {
        this.element = this.getElement();
        this.toolkit = this.getWidgetFactory();
        this.actionMgr = EPFPropertySheetPage.getActionManager();
    }

    public void updateControls() {
        this.ctrl_add_1.setEnabled(this.editable);
        IStructuredSelection selection = (IStructuredSelection)this.viewer_1.getSelection();
        if (selection.size() > 0 && this.editable) {
            this.ctrl_remove_1.setEnabled(true);
        } else {
            this.ctrl_remove_1.setEnabled(false);
        }
    }

    public void refresh() {
        try {
            if (this.getElement() instanceof BreakdownElement) {
                this.element = this.getElement();
                this.viewer_1.refresh();
                this.updateControls();
            }
        }
        catch (Exception ex) {
            this.logger.logError("Error refreshing activity guidance section: ", (Throwable)ex);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.labelProvider != null) {
            this.labelProvider.dispose();
        }
    }

    private void createGuidanceSection(Composite composite) {
        int tableHeight = 50;
        String sectionTitle = null;
        String sectionDesc = null;
        String tableTitle = null;
        sectionTitle = PropertiesResources.Activity_GeneralGuidanceTitle;
        sectionDesc = PropertiesResources.Activity_GeneralGuidanceDescription;
        tableTitle = PropertiesResources.Activity_Selected_GeneralGuidance;
        Section section = FormUI.createSection(this.toolkit, composite, sectionTitle, sectionDesc);
        Composite sectionComposite = FormUI.createComposite(this.toolkit, section, 2, false);
        Composite pane1 = FormUI.createComposite(this.toolkit, sectionComposite, 1808);
        FormUI.createLabel(this.toolkit, pane1, tableTitle);
        this.ctrl_table_1 = FormUI.createTable(this.toolkit, pane1, tableHeight);
        this.viewer_1 = new TableViewer(this.ctrl_table_1);
        AdapterFactoryContentProvider contentProvider = new AdapterFactoryContentProvider(this.getAdapterFactory()){

            public Object[] getElements(Object object) {
                return BreakdownElementGuidanceSection.this.getFilteredList(BreakdownElementGuidanceSection.this.getSelectedGuidances()).toArray();
            }
        };
        this.viewer_1.setContentProvider((IContentProvider)contentProvider);
        this.viewer_1.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.viewer_1.setInput((Object)this.element);
        Composite pane2 = FormUI.createComposite(this.toolkit, sectionComposite, 68);
        this.ctrl_add_1 = FormUI.createButton(this.toolkit, pane2, PropertiesResources.Process_Add);
        this.ctrl_remove_1 = FormUI.createButton(this.toolkit, pane2, PropertiesResources.Process_Remove);
        this.toolkit.paintBordersFor(pane1);
    }

    private void addListeners() {
        ItemProviderAdapter adapter = this.getAdapter();
        if (!(adapter instanceof IBSItemProvider)) {
            this.logger.logError("ActivityGuidanceSection::addListeners - IBSItemProvider is null");
            return;
        }
        IBSItemProvider bsItemProvider = (IBSItemProvider)adapter;
        bsItemProvider.getTopItem();
        this.ctrl_table_1.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                IStructuredSelection selection = (IStructuredSelection)BreakdownElementGuidanceSection.this.viewer_1.getSelection();
                if (selection.size() > 0 && BreakdownElementGuidanceSection.this.editable) {
                    BreakdownElementGuidanceSection.this.ctrl_remove_1.setEnabled(true);
                }
            }
        });
        this.viewer_1.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)BreakdownElementGuidanceSection.this.viewer_1.getSelection();
                if (selection.size() > 0 && BreakdownElementGuidanceSection.this.editable) {
                    BreakdownElementGuidanceSection.this.ctrl_remove_1.setEnabled(true);
                }
            }
        });
        this.ctrl_add_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IFilter filter = BreakdownElementGuidanceSection.this.getGeneralGuidanceFilter();
                ItemsFilterDialog fd = new ItemsFilterDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), filter, BreakdownElementGuidanceSection.this.element, FilterConstants.GUIDANCE, BreakdownElementGuidanceSection.this.getSelectedGuidances());
                fd.setTitle(FilterConstants.GUIDANCE);
                fd.setInput(UmaUtil.getMethodLibrary((EObject)BreakdownElementGuidanceSection.this.element));
                fd.setBlockOnOpen(true);
                fd.setTypes(BreakdownElementGuidanceSection.this.getFilterTypes());
                fd.open();
                BreakdownElementGuidanceSection.this.addGuidances(fd.getSelectedItems());
                BreakdownElementGuidanceSection.this.viewer_1.refresh();
            }
        });
        this.ctrl_remove_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)BreakdownElementGuidanceSection.this.viewer_1.getSelection();
                if (selection.size() > 0) {
                    ArrayList rmItems = new ArrayList();
                    rmItems.addAll(selection.toList());
                    BreakdownElementGuidanceSection.this.removeGuidances(rmItems);
                    BreakdownElementGuidanceSection.this.viewer_1.refresh();
                    BreakdownElementGuidanceSection.this.viewer_1.setSelection(null, true);
                }
                BreakdownElementGuidanceSection.this.ctrl_remove_1.setEnabled(false);
            }
        });
    }

    private void addGuidances(List<Guidance> addItems) {
        AddGuidanceToBreakdownElementCommand command = new AddGuidanceToBreakdownElementCommand(this.element, addItems);
        this.actionMgr.execute((IResourceAwareCommand)command);
    }

    private void removeGuidances(List<Guidance> rmItems) {
        if (!rmItems.isEmpty()) {
            for (Guidance item : rmItems) {
                if (item instanceof Checklist) {
                    this.actionMgr.doAction(4, (EObject)this.element, (EStructuralFeature)UmaPackage.eINSTANCE.getBreakdownElement_Checklists(), (Object)item, -1);
                    continue;
                }
                if (item instanceof Concept) {
                    this.actionMgr.doAction(4, (EObject)this.element, (EStructuralFeature)UmaPackage.eINSTANCE.getBreakdownElement_Concepts(), (Object)item, -1);
                    continue;
                }
                if (item instanceof Example) {
                    this.actionMgr.doAction(4, (EObject)this.element, (EStructuralFeature)UmaPackage.eINSTANCE.getBreakdownElement_Examples(), (Object)item, -1);
                    continue;
                }
                if (item instanceof SupportingMaterial) {
                    this.actionMgr.doAction(4, (EObject)this.element, (EStructuralFeature)UmaPackage.eINSTANCE.getBreakdownElement_SupportingMaterials(), (Object)item, -1);
                    continue;
                }
                if (item instanceof Guideline) {
                    this.actionMgr.doAction(4, (EObject)this.element, (EStructuralFeature)UmaPackage.eINSTANCE.getBreakdownElement_Guidelines(), (Object)item, -1);
                    continue;
                }
                if (item instanceof ReusableAsset) {
                    this.actionMgr.doAction(4, (EObject)this.element, (EStructuralFeature)UmaPackage.eINSTANCE.getBreakdownElement_ReusableAssets(), (Object)item, -1);
                    continue;
                }
                this.logger.logError("Can't remove Guidance: " + item.getType().getName() + ":" + item.getName());
            }
        }
    }

    private List<Guidance> getSelectedGuidances() {
        ArrayList<Guidance> itemList = new ArrayList<Guidance>();
        itemList.addAll(this.element.getChecklists());
        itemList.addAll(this.element.getConcepts());
        itemList.addAll(this.element.getExamples());
        itemList.addAll(this.element.getGuidelines());
        itemList.addAll(this.element.getReusableAssets());
        itemList.addAll(this.element.getSupportingMaterials());
        return itemList;
    }

    protected String[] getFilterTypes() {
        String[] str = new String[14];
        int i = 0;
        str[i++] = FilterConstants.GUIDANCE;
        str[i++] = "-" + FilterConstants.CHECKLISTS;
        str[i++] = "-" + FilterConstants.CONCEPTS;
        str[i++] = "-" + FilterConstants.ESTIMATE_CONSIDERATIONS;
        str[i++] = "-" + FilterConstants.EXAMPLES;
        str[i++] = "-" + FilterConstants.GUIDELINES;
        str[i++] = "-" + FilterConstants.PRACTICES;
        str[i++] = "-" + FilterConstants.REPORTS;
        str[i++] = "-" + FilterConstants.REUSABLE_ASSETS;
        str[i++] = "-" + FilterConstants.SUPPORTING_MATERIALS;
        str[i++] = "-" + FilterConstants.TEMPLATES;
        str[i++] = "-" + FilterConstants.TOOL_MENTORS;
        str[i++] = "-" + FilterConstants.WHITE_PAPERS;
        str[i++] = "-" + FilterConstants.TERM_DEFINITIONS;
        return str;
    }
}

