/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.properties;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.epf.authoring.ui.properties.AbstractSection;
import org.eclipse.epf.authoring.ui.properties.EPFPropertySheetPage;
import org.eclipse.epf.authoring.ui.properties.FormUI;
import org.eclipse.epf.authoring.ui.properties.PropertiesResources;
import org.eclipse.epf.authoring.ui.providers.VariabilityElementLabelProvider;
import org.eclipse.epf.library.edit.IConfigurationApplicator;
import org.eclipse.epf.library.edit.Providers;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Section;
import org.eclipse.epf.uma.TaskDescriptor;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class TaskDescriptorStepSection
extends AbstractSection {
    protected ILabelProvider labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory());
    private TaskDescriptor element;
    private IActionManager actionMgr;
    private FormToolkit toolkit;
    private Button ctrl_add;
    private Button ctrl_remove;
    private Button ctrl_up;
    private Button ctrl_down;
    private Table ctrl_selected;
    private TableViewer viewer;
    private Image titleImage;

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        this.init();
        parent.setLayout((Layout)new GridLayout());
        parent.setLayoutData((Object)new GridData(1808));
        this.createStepSection(parent);
        this.addListeners();
    }

    private void init() {
        this.element = (TaskDescriptor)this.getElement();
        this.toolkit = this.getWidgetFactory();
        this.actionMgr = EPFPropertySheetPage.getActionManager();
    }

    public void refresh() {
        try {
            if (this.getElement() instanceof TaskDescriptor) {
                this.element = (TaskDescriptor)this.getElement();
                this.viewer.refresh();
                this.updateControls();
            }
        }
        catch (Exception ex) {
            this.logger.logError("Error refreshing TaskDescriptor step section" + this.element, (Throwable)ex);
        }
    }

    public void dispose() {
        super.dispose();
        if (this.labelProvider != null) {
            this.labelProvider.dispose();
        }
    }

    public void updateControls() {
        this.ctrl_add.setEnabled(this.editable);
        if (this.element.getTask() == null) {
            this.ctrl_add.setEnabled(false);
        } else {
            List steps = this.getSteps();
            if (steps != null && steps.size() > 0) {
                this.ctrl_add.setEnabled(true);
            } else {
                this.ctrl_add.setEnabled(false);
            }
        }
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() > 0 && this.editable) {
            this.ctrl_remove.setEnabled(this.editable);
            this.ctrl_up.setEnabled(this.editable);
            this.ctrl_down.setEnabled(this.editable);
        } else {
            this.ctrl_remove.setEnabled(false);
            this.ctrl_up.setEnabled(false);
            this.ctrl_down.setEnabled(false);
        }
    }

    private void createStepSection(Composite composite) {
        List steps;
        org.eclipse.ui.forms.widgets.Section stepSection = FormUI.createSection(this.toolkit, composite, PropertiesResources.TaskDescriptor_stepInformationTitle, PropertiesResources.TaskDescriptor_stepInformationDescription);
        Composite stepComposite = FormUI.createComposite(this.toolkit, stepSection, 2, false);
        Composite pane1 = FormUI.createComposite(this.toolkit, stepComposite, 1808);
        FormUI.createLabel(this.toolkit, pane1, PropertiesResources.TaskDescriptor_Selected_Steps);
        this.ctrl_selected = FormUI.createTable(this.toolkit, pane1);
        this.viewer = new TableViewer(this.ctrl_selected);
        AdapterFactoryContentProvider contentProvider = new AdapterFactoryContentProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

            public Object[] getElements(Object object) {
                return TaskDescriptorStepSection.this.element.getSelectedSteps().toArray();
            }
        };
        this.viewer.setContentProvider((IContentProvider)contentProvider);
        this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.viewer.setInput((Object)this.element);
        Composite pane2 = FormUI.createComposite(this.toolkit, stepComposite, 68);
        this.ctrl_add = FormUI.createButton(this.toolkit, pane2, PropertiesResources.Process_Add);
        this.ctrl_add.setEnabled(false);
        this.ctrl_remove = FormUI.createButton(this.toolkit, pane2, PropertiesResources.Process_Remove);
        this.ctrl_remove.setEnabled(false);
        this.ctrl_up = FormUI.createButton(this.toolkit, pane2, PropertiesResources.Process_Up);
        this.ctrl_down = FormUI.createButton(this.toolkit, pane2, PropertiesResources.Process_Down);
        if (this.element.getTask() != null && (steps = this.getSteps()) != null && steps.size() > 0) {
            this.ctrl_add.setEnabled(true);
        }
        this.toolkit.paintBordersFor(stepComposite);
        this.toolkit.paintBordersFor(pane1);
    }

    private void addListeners() {
        this.ctrl_selected.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                IStructuredSelection selection = (IStructuredSelection)TaskDescriptorStepSection.this.viewer.getSelection();
                if (selection.size() > 0 && TaskDescriptorStepSection.this.editable) {
                    TaskDescriptorStepSection.this.ctrl_remove.setEnabled(TaskDescriptorStepSection.this.editable);
                    TaskDescriptorStepSection.this.ctrl_up.setEnabled(TaskDescriptorStepSection.this.editable);
                    TaskDescriptorStepSection.this.ctrl_down.setEnabled(TaskDescriptorStepSection.this.editable);
                }
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)TaskDescriptorStepSection.this.viewer.getSelection();
                if (selection.size() > 0 && TaskDescriptorStepSection.this.editable) {
                    TaskDescriptorStepSection.this.ctrl_remove.setEnabled(true);
                    if (TaskDescriptorStepSection.this.viewer.getTable().getSelectionIndex() > 0 && selection.size() == 1) {
                        TaskDescriptorStepSection.this.ctrl_up.setEnabled(true);
                    } else {
                        TaskDescriptorStepSection.this.ctrl_up.setEnabled(false);
                    }
                    if (TaskDescriptorStepSection.this.viewer.getTable().getSelectionIndex() < TaskDescriptorStepSection.this.viewer.getTable().getItemCount() - 1 && selection.size() == 1) {
                        TaskDescriptorStepSection.this.ctrl_down.setEnabled(true);
                    } else {
                        TaskDescriptorStepSection.this.ctrl_down.setEnabled(false);
                    }
                }
                if (selection.size() == 1) {
                    String desc = ((MethodElement)selection.getFirstElement()).getBriefDescription();
                    if (desc == null) {
                        desc = "";
                    }
                } else {
                    selection.size();
                }
            }
        });
        this.ctrl_add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AdapterFactoryContentProvider stepContentProvider = new AdapterFactoryContentProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

                    public Object[] getElements(Object object) {
                        return TaskDescriptorStepSection.this.getSteps().toArray();
                    }
                };
                VariabilityElementLabelProvider stepLabelProvider = new VariabilityElementLabelProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

                    public boolean isExternal(Object obj) {
                        boolean flag = !TaskDescriptorStepSection.this.element.getTask().getPresentation().getSections().contains(obj);
                        return flag;
                    }
                };
                ListSelectionDialog dlg = new ListSelectionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (Object)TaskDescriptorStepSection.this.element.getTask(), (IStructuredContentProvider)stepContentProvider, (ILabelProvider)stepLabelProvider, PropertiesResources.TaskDescriptor_StepDialogMessage);
                TaskDescriptorStepSection.this.titleImage = Display.getCurrent().getActiveShell().getImage();
                ListSelectionDialog.setDefaultImage((Image)TaskDescriptorStepSection.this.titleImage);
                dlg.setTitle(PropertiesResources.TaskDescriptor_StepDialogTitle);
                dlg.setBlockOnOpen(true);
                dlg.open();
                TaskDescriptorStepSection.this.addSteps(dlg.getResult());
                List steps = TaskDescriptorStepSection.this.getSteps();
                if (steps != null && steps.size() > 0) {
                    TaskDescriptorStepSection.this.ctrl_add.setEnabled(true);
                } else {
                    TaskDescriptorStepSection.this.ctrl_add.setEnabled(false);
                }
                TaskDescriptorStepSection.this.viewer.refresh();
            }
        });
        this.ctrl_remove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List steps;
                IStructuredSelection selection = (IStructuredSelection)TaskDescriptorStepSection.this.viewer.getSelection();
                if (selection.size() > 0) {
                    ArrayList rmItems = new ArrayList();
                    rmItems.addAll(selection.toList());
                    TaskDescriptorStepSection.this.removeSteps(rmItems);
                    TaskDescriptorStepSection.this.viewer.refresh();
                    TaskDescriptorStepSection.this.viewer.setSelection(null, true);
                }
                if ((steps = TaskDescriptorStepSection.this.getSteps()) != null && steps.size() > 0) {
                    TaskDescriptorStepSection.this.ctrl_add.setEnabled(true);
                } else {
                    TaskDescriptorStepSection.this.ctrl_add.setEnabled(false);
                }
            }
        });
        this.ctrl_up.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ArrayList steps = new ArrayList();
                IStructuredSelection selection = (IStructuredSelection)TaskDescriptorStepSection.this.viewer.getSelection();
                if (selection.size() > 0) {
                    ArrayList items = new ArrayList();
                    items.addAll(selection.toList());
                    BasicEList stepList = (BasicEList)TaskDescriptorStepSection.this.element.getSelectedSteps();
                    for (Object object : items) {
                        int index = stepList.indexOf(object);
                        if (index <= 0) continue;
                        stepList.move(index - 1, object);
                    }
                    steps.addAll(stepList);
                    TaskDescriptorStepSection.this.actionMgr.doAction(6, (EObject)TaskDescriptorStepSection.this.element, (EStructuralFeature)UmaPackage.eINSTANCE.getTaskDescriptor_SelectedSteps(), (Object)stepList, -1);
                    TaskDescriptorStepSection.this.actionMgr.doAction(5, (EObject)TaskDescriptorStepSection.this.element, (EStructuralFeature)UmaPackage.eINSTANCE.getTaskDescriptor_SelectedSteps(), steps, -1);
                    TaskDescriptorStepSection.this.viewer.refresh();
                }
                if (TaskDescriptorStepSection.this.viewer.getTable().getSelectionIndex() > 0 && TaskDescriptorStepSection.this.editable) {
                    TaskDescriptorStepSection.this.ctrl_up.setEnabled(true);
                } else {
                    TaskDescriptorStepSection.this.ctrl_up.setEnabled(false);
                }
                if (TaskDescriptorStepSection.this.viewer.getTable().getSelectionIndex() < TaskDescriptorStepSection.this.viewer.getTable().getItemCount() - 1 && TaskDescriptorStepSection.this.editable) {
                    TaskDescriptorStepSection.this.ctrl_down.setEnabled(true);
                } else {
                    TaskDescriptorStepSection.this.ctrl_down.setEnabled(false);
                }
            }
        });
        this.ctrl_down.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ArrayList steps = new ArrayList();
                IStructuredSelection selection = (IStructuredSelection)TaskDescriptorStepSection.this.viewer.getSelection();
                if (selection.size() > 0) {
                    ArrayList items = new ArrayList();
                    items.addAll(selection.toList());
                    BasicEList stepList = (BasicEList)TaskDescriptorStepSection.this.element.getSelectedSteps();
                    for (Object object : items) {
                        int index = stepList.indexOf(object);
                        if (index >= stepList.size() - 1) continue;
                        stepList.move(index + items.size(), object);
                    }
                    steps.addAll(stepList);
                    TaskDescriptorStepSection.this.actionMgr.doAction(6, (EObject)TaskDescriptorStepSection.this.element, (EStructuralFeature)UmaPackage.eINSTANCE.getTaskDescriptor_SelectedSteps(), (Object)stepList, -1);
                    TaskDescriptorStepSection.this.actionMgr.doAction(5, (EObject)TaskDescriptorStepSection.this.element, (EStructuralFeature)UmaPackage.eINSTANCE.getTaskDescriptor_SelectedSteps(), steps, -1);
                    TaskDescriptorStepSection.this.viewer.refresh();
                }
                if (TaskDescriptorStepSection.this.viewer.getTable().getSelectionIndex() > 0 && TaskDescriptorStepSection.this.editable) {
                    TaskDescriptorStepSection.this.ctrl_up.setEnabled(true);
                } else {
                    TaskDescriptorStepSection.this.ctrl_up.setEnabled(false);
                }
                if (TaskDescriptorStepSection.this.viewer.getTable().getSelectionIndex() < TaskDescriptorStepSection.this.viewer.getTable().getItemCount() - 1 && TaskDescriptorStepSection.this.editable) {
                    TaskDescriptorStepSection.this.ctrl_down.setEnabled(true);
                } else {
                    TaskDescriptorStepSection.this.ctrl_down.setEnabled(false);
                }
            }
        });
    }

    private void addSteps(Object[] addItems) {
        if (addItems != null) {
            int i = 0;
            while (i < addItems.length) {
                Section item = (Section)addItems[i];
                this.actionMgr.doAction(3, (EObject)this.element, (EStructuralFeature)UmaPackage.eINSTANCE.getTaskDescriptor_SelectedSteps(), (Object)item, -1);
                ++i;
            }
        }
    }

    private void removeSteps(List rmItems) {
        if (!rmItems.isEmpty()) {
            for (Section item : rmItems) {
                this.actionMgr.doAction(4, (EObject)this.element, (EStructuralFeature)UmaPackage.eINSTANCE.getTaskDescriptor_SelectedSteps(), (Object)item, -1);
            }
        }
    }

    private List getSteps() {
        IConfigurationApplicator configApplicator = Providers.getConfigurationApplicator();
        MethodConfiguration config = TngUtil.getOwningProcess((BreakdownElement)this.element).getDefaultContext();
        List steps = (List)configApplicator.getReference((VariabilityElement)this.element.getTask(), UmaPackage.eINSTANCE.getTask_Steps(), config);
        steps.removeAll(this.element.getSelectedSteps());
        return steps;
    }
}

