/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.editors.EditorChooser;
import org.eclipse.epf.authoring.ui.views.LibraryView;
import org.eclipse.epf.authoring.ui.wizards.NewPluginMainPage;
import org.eclipse.epf.library.ILibraryManager;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.LibraryServiceUtil;
import org.eclipse.epf.library.ui.actions.LibraryLockingOperationRunner;
import org.eclipse.epf.ui.wizards.BaseWizard;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class NewPluginWizard
extends BaseWizard
implements INewWizard {
    public static final String WIZARD_ID = NewPluginWizard.class.getName();
    public static final String WIZARD_EXTENSION_POINT_ID = "org.eclipse.epf.authoring.ui.newPluginWizard";
    protected NewPluginMainPage mainPage;
    protected MethodPlugin newPlugin;

    public String getWizardExtenderExtensionPointId() {
        return WIZARD_EXTENSION_POINT_ID;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        super.init(workbench, selection);
        this.setWindowTitle(AuthoringUIResources.newPluginWizard_title);
    }

    public void addPages() {
        if (this.wizardExtender == null) {
            this.mainPage = this.createMainPage();
            super.addPage((IWizardPage)this.mainPage);
        } else {
            ArrayList<Object> wizardPages = new ArrayList<Object>();
            IWizardPage page = this.wizardExtender.getReplaceWizardPage(NewPluginMainPage.PAGE_NAME);
            if (page != null) {
                wizardPages.add(page);
            } else {
                this.mainPage = this.createMainPage();
                wizardPages.add((Object)this.mainPage);
            }
            super.getNewWizardPages(wizardPages);
            for (IWizardPage iWizardPage : wizardPages) {
                super.addPage(iWizardPage);
            }
            this.wizardExtender.initWizardPages(wizardPages);
        }
    }

    protected NewPluginMainPage createMainPage() {
        return new NewPluginMainPage();
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        pageContainer.getShell().setImage(AuthoringUIPlugin.getDefault().getSharedImage("full/obj16/MethodPlugin.gif"));
    }

    public boolean doFinish() {
        try {
            this.newPlugin = LibraryServiceUtil.createMethodPlugin((String)this.mainPage.getPluginName(), (String)this.mainPage.getBriefDescription(), (String)this.mainPage.getAuthors(), (Object[])this.mainPage.getReferencedPlugins());
            this.initMethodPlugin(this.newPlugin);
            return true;
        }
        catch (Exception e) {
            String reason = e.getMessage() != null ? e.getMessage() : AuthoringUIResources.newPluginError_reason;
            AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.newPluginWizard_title, AuthoringUIResources.newPluginError_msg, reason, (Throwable)e);
            return false;
        }
    }

    public boolean initMethodPlugin(final MethodPlugin plugin) {
        try {
            ILibraryManager manager = LibraryService.getInstance().getCurrentLibraryManager();
            if (manager != null) {
                manager.addMethodPlugin(plugin);
            }
            Display.getCurrent().asyncExec(new Runnable(){

                public void run() {
                    ArrayList<MethodPlugin> selection = new ArrayList<MethodPlugin>();
                    selection.add(plugin);
                    LibraryView.getView().setSelectionToViewer(selection);
                    EditorChooser.getInstance().openEditor(NewPluginWizard.this.newPlugin);
                }
            });
            return true;
        }
        catch (Exception e) {
            AuthoringUIPlugin.getDefault().getLogger().logError("Failed to initialize method plug-in '" + plugin.getName() + "'", (Throwable)e);
            return false;
        }
    }

    private boolean superPerformFinish() {
        return super.performFinish();
    }

    public boolean performFinish() {
        final boolean[] resultHolder = new boolean[1];
        LibraryLockingOperationRunner runner = new LibraryLockingOperationRunner();
        runner.run(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                resultHolder[0] = NewPluginWizard.this.superPerformFinish();
            }
        });
        return resultHolder[0];
    }
}

