/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.importing.xml.services;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.sdo.EDataObject;
import org.eclipse.epf.common.IActivator;
import org.eclipse.epf.common.service.versioning.VersionUtil;
import org.eclipse.epf.common.ui.util.MsgBox;
import org.eclipse.epf.common.ui.util.MsgDialog;
import org.eclipse.epf.dataexchange.util.ContentProcessor;
import org.eclipse.epf.dataexchange.util.ILogger;
import org.eclipse.epf.dataexchange.util.IResourceHandler;
import org.eclipse.epf.export.services.DiagramHandler;
import org.eclipse.epf.export.xml.ExportXMLResources;
import org.eclipse.epf.export.xml.services.FeatureManager;
import org.eclipse.epf.export.xml.services.XMLLibrary;
import org.eclipse.epf.importing.ImportPlugin;
import org.eclipse.epf.importing.ImportResources;
import org.eclipse.epf.importing.services.ConfigurationImportService;
import org.eclipse.epf.importing.services.FileModifyChecker;
import org.eclipse.epf.importing.services.LibraryImportManager;
import org.eclipse.epf.importing.wizards.PluginModifyInfo;
import org.eclipse.epf.importing.wizards.SelectImportConfigurationSource;
import org.eclipse.epf.importing.xml.ImportXMLPlugin;
import org.eclipse.epf.importing.xml.ImportXMLResources;
import org.eclipse.epf.importing.xml.services.ImportResourceHandler;
import org.eclipse.epf.importing.xml.services.ImportXMLogger;
import org.eclipse.epf.importing.xml.services.UmaLibrary;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.services.SafeUpdateController;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.persistence.MultiFileResourceSetImpl;
import org.eclipse.epf.persistence.migration.IMigrator;
import org.eclipse.epf.persistence.migration.MappingUtil;
import org.eclipse.epf.persistence.refresh.RefreshJob;
import org.eclipse.epf.services.IFileBasedLibraryPersister;
import org.eclipse.epf.services.ILibraryPersister;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.TaskDescriptor;
import org.eclipse.epf.uma.UmaFactory;
import org.eclipse.epf.xml.uma.Activity;
import org.eclipse.epf.xml.uma.CapabilityPattern;
import org.eclipse.epf.xml.uma.ContentCategory;
import org.eclipse.epf.xml.uma.ContentCategoryPackage;
import org.eclipse.epf.xml.uma.ContentPackage;
import org.eclipse.epf.xml.uma.DeliveryProcess;
import org.eclipse.epf.xml.uma.Discipline;
import org.eclipse.epf.xml.uma.Domain;
import org.eclipse.epf.xml.uma.Guidance;
import org.eclipse.epf.xml.uma.MethodElement;
import org.eclipse.epf.xml.uma.MethodElementProperty;
import org.eclipse.epf.xml.uma.MethodLibrary;
import org.eclipse.epf.xml.uma.MethodPackage;
import org.eclipse.epf.xml.uma.MethodPlugin;
import org.eclipse.epf.xml.uma.Process;
import org.eclipse.epf.xml.uma.ProcessComponent;
import org.eclipse.epf.xml.uma.ProcessPackage;
import org.eclipse.epf.xml.uma.UmaPackage;
import org.eclipse.epf.xml.uma.WorkOrder;
import org.eclipse.epf.xml.uma.WorkOrderType;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;

public class ImportXMLService {
    private List unlockedPlugins;
    private boolean error = false;
    private Map renameElementMap = new HashMap();
    private boolean overwrite = false;
    private int mergeLevel = 0;
    private IStatus fileCheckedOutStatus = null;
    private String xmlPath;
    private XMLLibrary xmlLib;
    private UmaLibrary umaLib;
    private ImportXMLogger logger = new ImportXMLogger();
    private List discardedElements = new ArrayList();
    private DiagramHandler diagramHandler;
    private Map<String, org.eclipse.epf.xml.uma.TaskDescriptor> tdMap;
    Map workOrderMap = new HashMap();
    private IMigrator migrator;
    private boolean checkBasePlugins = true;
    private List processedElements = new ArrayList();

    public boolean loadXml(final String xmlPath) {
        String versionError = this.versionCheck(xmlPath, ImportXMLResources.importXMLWizard_title);
        if (versionError != null) {
            return false;
        }
        this.xmlPath = xmlPath;
        this.logger.logMessage("Loading xml library ...");
        boolean ret = false;
        try {
            this.xmlLib = new XMLLibrary(null, (ILogger)this.logger, xmlPath);
            this.xmlLib.load();
            ret = this.checkOldPlugins();
        }
        catch (Exception e) {
            this.logger.logError(NLS.bind((String)ExportXMLResources.xmlLibrary_error_load_xml, (Object)xmlPath), e);
            final String errStr = e.toString();
            SafeUpdateController.syncExec((Runnable)new Runnable(){

                public void run() {
                    ImportXMLPlugin.getDefault().getMsgDialog().displayError(NLS.bind((String)ExportXMLResources.xmlLibrary_error_load_xml, (Object)xmlPath), errStr);
                }
            });
        }
        return ret;
    }

    private boolean checkOldPlugins() {
        this.unlockedPlugins = new ArrayList();
        ArrayList<String> fileNameToCheck = new ArrayList<String>();
        HashMap<String, org.eclipse.epf.uma.MethodPlugin> map = new HashMap<String, org.eclipse.epf.uma.MethodPlugin>();
        HashMap<String, org.eclipse.epf.uma.MethodPlugin> guidMap = new HashMap<String, org.eclipse.epf.uma.MethodPlugin>();
        List basePlugins = LibraryService.getInstance().getCurrentMethodLibrary().getMethodPlugins();
        int i = 0;
        while (i < basePlugins.size()) {
            org.eclipse.epf.uma.MethodPlugin plugin = (org.eclipse.epf.uma.MethodPlugin)basePlugins.get(i);
            map.put(plugin.getName(), plugin);
            guidMap.put(plugin.getGuid(), plugin);
            ++i;
        }
        EList plugins = ((MethodLibrary)this.xmlLib.getRoot()).getMethodPlugin();
        ArrayList<String> guids = new ArrayList<String>();
        int i2 = 0;
        while (i2 < plugins.size()) {
            MethodElement elem = (MethodElement)plugins.get(i2);
            guids.add(elem.getId());
            org.eclipse.epf.uma.MethodPlugin basePlugin = (org.eclipse.epf.uma.MethodPlugin)map.get(elem.getName());
            boolean toAdd = false;
            if (basePlugin != null && !basePlugin.getGuid().equals(elem.getId()) && !basePlugin.getUserChangeable().booleanValue()) {
                toAdd = true;
            } else {
                basePlugin = (org.eclipse.epf.uma.MethodPlugin)guidMap.get(elem.getId());
                if (basePlugin != null && !basePlugin.getUserChangeable().booleanValue()) {
                    toAdd = true;
                }
            }
            if (toAdd) {
                this.unlockedPlugins.add(basePlugin.getGuid());
                basePlugin.setUserChangeable(new Boolean(true));
                Resource res = basePlugin.eResource();
                if (res != null && res.getURI() != null) {
                    String fileName = res.getURI().toFileString();
                    fileNameToCheck.add(fileName);
                }
            }
            ++i2;
        }
        if (fileNameToCheck.size() > 0) {
            final ArrayList<String> modifiedFiles = fileNameToCheck;
            SafeUpdateController.syncExec((Runnable)new Runnable(){

                public void run() {
                    ImportXMLService.this.fileCheckedOutStatus = FileModifyChecker.checkModify((List)modifiedFiles);
                }
            });
        }
        if (!this.unlockedPlugins.isEmpty() && this.fileCheckedOutStatus != null && !this.fileCheckedOutStatus.isOK()) {
            SafeUpdateController.syncExec((Runnable)new Runnable(){

                public void run() {
                    String title = ImportXMLResources.importXMLWizard_title;
                    String msg = ImportXMLResources.importXMLService_import_failed;
                    new MsgDialog((IActivator)ImportPlugin.getDefault()).displayError(title, msg, ImportXMLService.this.fileCheckedOutStatus);
                }
            });
            return false;
        }
        final PluginModifyInfo modifyInfo = SelectImportConfigurationSource.checkModify(guids, (Shell)MsgBox.getDefaultShell(), (boolean)false);
        if (modifyInfo.lockedPlugins.size() > 0) {
            final boolean[] ret = new boolean[1];
            SafeUpdateController.syncExec((Runnable)new Runnable(){

                public void run() {
                    String WIZARD_TITLE = ImportXMLResources.importXMLWizard_title;
                    String message = String.valueOf(modifyInfo.getLockedMessage().toString()) + ImportResources.ImportPluginWizard_confirm_continue;
                    ret[0] = ImportXMLPlugin.getDefault().getMsgDialog().displayConfirmation(WIZARD_TITLE, message);
                }
            });
            return ret[0];
        }
        return true;
    }

    public File getLogPath() {
        return this.logger.getLogPath();
    }

    public void dispose() {
        this.discardedElements.clear();
        this.workOrderMap.clear();
        this.logger.dispose();
    }

    public void doImport(IProgressMonitor monitor) throws Exception {
        boolean refresh = RefreshJob.getInstance().isEnabled();
        try {
            try {
                String id;
                org.eclipse.epf.uma.MethodLibrary library;
                if (refresh) {
                    RefreshJob.getInstance().setEnabled(false);
                }
                this.handleTypeChanges();
                ImportResourceHandler handler = new ImportResourceHandler(new File(this.xmlPath).getParentFile(), new File(LibraryService.getInstance().getCurrentMethodLibraryLocation()));
                ContentProcessor contentProc = new ContentProcessor((IResourceHandler)handler, (ILogger)this.logger);
                this.diagramHandler = new DiagramHandler(new File(this.xmlPath).getParentFile(), new File(LibraryService.getInstance().getCurrentMethodLibraryLocation())){

                    protected File[] getFiles(org.eclipse.epf.uma.MethodElement elem) {
                        File file;
                        Process proc;
                        String uri;
                        File[] files = super.getFiles(elem, false);
                        EDataObject xmlObj = ImportXMLService.this.xmlLib.getElement(elem.getGuid());
                        if (xmlObj instanceof Process && (uri = (proc = (Process)xmlObj).getDiagramURI()) != null && uri.length() > 0 && (file = new File(this.getSourceLibRoot(), uri)).exists()) {
                            files[0] = file;
                            files[1] = new File(this.getTargetLibRoot(), uri);
                        }
                        return files;
                    }
                };
                this.xmlLib.fixLibraryForImport();
                List referencedPlugins = this.xmlLib.getReferencedPlugins();
                if (referencedPlugins.size() > 0 && (library = LibraryService.getInstance().getCurrentMethodLibrary()) != null) {
                    List plugins = library.getMethodPlugins();
                    Iterator it = plugins.iterator();
                    while (it.hasNext()) {
                        id = ((org.eclipse.epf.uma.MethodPlugin)it.next()).getGuid();
                        referencedPlugins.remove(id);
                    }
                }
                if (this.isCheckBasePlugins() && referencedPlugins.size() > 0) {
                    Map map = this.xmlLib.getGuidToPlugNameMap();
                    Iterator it = referencedPlugins.iterator();
                    while (it.hasNext()) {
                        String name;
                        String nameAndId = "";
                        id = (String)it.next();
                        if (map != null && (name = (String)map.get(id)) != null) {
                            nameAndId = String.valueOf(nameAndId) + name + ", ";
                        }
                        nameAndId = String.valueOf(nameAndId) + id;
                        this.logger.logError(NLS.bind((String)ImportXMLResources.importXMLService_missing_plugin, (Object)nameAndId), null);
                    }
                    throw new Exception(ImportXMLResources.importXMLService_error_missing_plugins);
                }
                this.umaLib = new UmaLibrary(this.renameElementMap, contentProc, (ILogger)this.logger, this.overwrite);
                this.umaLib.setMergeLevel(this.mergeLevel);
                EDataObject xmlRoot = this.xmlLib.getRoot();
                org.eclipse.epf.uma.MethodLibrary umaRoot = this.umaLib.getRoot();
                this.logger.logMessage("create target library elements ...");
                this.creatEDataObjectTree(xmlRoot, (EDataObject)umaRoot);
                this.logger.logMessage("copying all feature values for target library elements ...");
                this.iteratEDataObject((MethodElement)xmlRoot);
                this.logger.logMessage("fix the target library ...");
                this.umaLib.fixLibrary();
                this.umaLib.fixTaskDescriptors(this.tdMap);
                LibraryImportManager.handleNameReplace((Map)this.renameElementMap);
                this.diagramHandler.postRegisterElements();
                this.logger.logMessage("delete unneeded elements ...");
                this.umaLib.deleteElements();
                List modifiedFiles = FileModifyChecker.getModifiedFiles((ResourceSet)LibraryService.getInstance().getCurrentMethodLibrary().eResource().getResourceSet());
                modifiedFiles.addAll(this.diagramHandler.getModifiedFiles());
                final IStatus fileCheckedOutStatus = FileModifyChecker.syncExecCheckModify((List)modifiedFiles);
                if (fileCheckedOutStatus.isOK()) {
                    org.eclipse.epf.uma.MethodLibrary currLib;
                    ILibraryPersister persister;
                    this.logger.logMessage("saving target library ...");
                    List configs = LibraryService.getInstance().getCurrentMethodLibrary().getPredefinedConfigurations();
                    int configSz = configs == null ? 0 : configs.size();
                    int i = 0;
                    while (i < configSz) {
                        MethodConfiguration config = (MethodConfiguration)configs.get(i);
                        LibraryUtil.validateMethodConfiguration(null, (MethodConfiguration)config);
                        ++i;
                    }
                    if (configSz != 0 && (persister = ((MultiFileResourceSetImpl)(currLib = LibraryService.getInstance().getCurrentMethodLibrary()).eResource().getResourceSet()).getPersister()) instanceof IFileBasedLibraryPersister) {
                        IFileBasedLibraryPersister ip = (IFileBasedLibraryPersister)persister;
                        File configFolder = ip.getDefaultMethodConfigurationFolder(currLib);
                        if (configFolder != null) {
                            ip.setDefaultMethodConfigurationFolder(currLib, configFolder);
                        } else {
                            throw new Exception(ImportXMLResources.importXMLService_import_failed);
                        }
                    }
                    if (this.unlockedPlugins != null && !this.unlockedPlugins.isEmpty()) {
                        LibraryImportManager.lockUnlockedPlugins((List)this.unlockedPlugins);
                    }
                    LibraryUtil.saveLibrary((org.eclipse.epf.uma.MethodLibrary)LibraryService.getInstance().getCurrentMethodLibrary(), (boolean)false, (boolean)false);
                    this.diagramHandler.execute();
                    this.logger.logMessage("re-open target library ...");
                    LibraryService.getInstance().reopenCurrentMethodLibrary();
                    if (this.migrator != null) {
                        org.eclipse.epf.uma.MethodLibrary lib = LibraryService.getInstance().getCurrentMethodLibrary();
                        this.migrator.migrateXmlImportedLib(lib, monitor);
                        LibraryService.getInstance().reopenCurrentMethodLibrary();
                    }
                    this.logger.logMessage("import completed successfully ...");
                } else {
                    SafeUpdateController.syncExec((Runnable)new Runnable(){

                        public void run() {
                            String title = ImportXMLResources.importXMLWizard_title;
                            String msg = ImportXMLResources.importXMLService_import_failed;
                            new MsgDialog((IActivator)ImportXMLPlugin.getDefault()).displayError(title, msg, fileCheckedOutStatus);
                        }
                    });
                }
            }
            catch (Exception e) {
                this.logger.logError(NLS.bind((String)ImportXMLResources.importXMLService_import_failed, (Object)e.getMessage()), e);
                throw e;
            }
        }
        finally {
            if (refresh) {
                RefreshJob.getInstance().setEnabled(true);
            }
        }
    }

    private void creatEDataObjectTree(EDataObject xmlObj, EDataObject umaObj) {
        for (EDataObject child : xmlObj.eContents()) {
            this.createRmcObject(child, umaObj);
        }
    }

    private void createRmcObject(EDataObject xmlElement, EDataObject targetContainer) {
        if (xmlElement instanceof MethodElementProperty) {
            return;
        }
        EReference feature = xmlElement.eContainmentFeature();
        this.createRmcObject(xmlElement, targetContainer, feature.getName());
    }

    private void createRmcObject(EDataObject xmlElement, EDataObject targetContainer, String containmentXmlFeature) {
        try {
            if (xmlElement == null) {
                return;
            }
            EDataObject umaElement = null;
            if (xmlElement instanceof MethodPlugin) {
                MethodPlugin plugin = (MethodPlugin)xmlElement;
                umaElement = this.umaLib.createMethodPlugin(plugin.getId(), plugin.getName());
            } else if (xmlElement instanceof ContentCategoryPackage) {
                this.setDiscarded(((ContentCategoryPackage)xmlElement).getId());
            } else if (xmlElement instanceof ContentCategory && !(xmlElement.eContainer() instanceof Domain) && !(xmlElement.eContainer() instanceof Discipline) || xmlElement.eContainer() instanceof ContentCategoryPackage) {
                String pluginId = this.getPlugin((EObject)xmlElement).getId();
                umaElement = this.umaLib.createContentCategory(pluginId, xmlElement.eClass().getName(), xmlElement.getType().getName(), this.xmlLib.getElementId(xmlElement));
            } else {
                EList steps;
                org.eclipse.epf.xml.uma.TaskDescriptor td;
                if (xmlElement instanceof MethodPackage && xmlElement.eContainer() instanceof MethodPlugin) {
                    List procs;
                    if (xmlElement instanceof ContentPackage) {
                        targetContainer = this.umaLib.getContentRootPackage(targetContainer);
                    } else if (xmlElement instanceof ProcessComponent) {
                        Process proc = ((ProcessComponent)xmlElement).getProcess();
                        if (proc instanceof CapabilityPattern) {
                            targetContainer = this.umaLib.getCapabilityPatternRootPackage(targetContainer);
                        } else if (proc instanceof DeliveryProcess) {
                            targetContainer = this.umaLib.getDeliveryProcessRootPackage(targetContainer);
                        }
                    } else if (xmlElement instanceof ProcessPackage && (procs = this.xmlLib.getAllProcesses((MethodPackage)xmlElement)) != null && procs.size() > 0) {
                        Object proc = procs.get(0);
                        if (proc instanceof CapabilityPattern) {
                            targetContainer = this.umaLib.getCapabilityPatternRootPackage(targetContainer);
                        } else if (proc instanceof DeliveryProcess) {
                            targetContainer = this.umaLib.getDeliveryProcessRootPackage(targetContainer);
                        }
                    }
                }
                if (targetContainer instanceof TaskDescriptor && containmentXmlFeature.equals("step")) {
                    return;
                }
                umaElement = this.umaLib.createElement(targetContainer, containmentXmlFeature, xmlElement.eClass().getName(), xmlElement.getType().getName(), this.xmlLib.getElementId(xmlElement));
                if (xmlElement instanceof org.eclipse.epf.xml.uma.TaskDescriptor && (td = (org.eclipse.epf.xml.uma.TaskDescriptor)xmlElement).getTask() != null && (steps = td.getStep()) != null && !steps.isEmpty()) {
                    if (this.tdMap == null) {
                        this.tdMap = new HashMap<String, org.eclipse.epf.xml.uma.TaskDescriptor>();
                    }
                    this.tdMap.put(td.getId(), td);
                }
                if (xmlElement instanceof WorkOrder) {
                    this.workOrderMap.put(xmlElement, umaElement);
                }
            }
            this.creatEDataObjectTree(xmlElement, umaElement);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private MethodPlugin getPlugin(EObject element) {
        while (element != null && !(element instanceof MethodPlugin)) {
            element = element.eContainer();
        }
        return (MethodPlugin)element;
    }

    private EDataObject getRmcObject(MethodElement xmlObj) {
        if (xmlObj instanceof MethodLibrary) {
            return this.umaLib.getRoot();
        }
        String id = xmlObj.getId();
        return this.umaLib.getElement(id);
    }

    private void iteratEDataObject(MethodElement srcObj) {
        this.iteratEDataObject_(srcObj);
        EDataObject targetObj = this.getRmcObject(srcObj);
        if (targetObj instanceof org.eclipse.epf.uma.MethodElement) {
            this.diagramHandler.registerElement((org.eclipse.epf.uma.MethodElement)targetObj);
        }
    }

    private void iteratEDataObject_(MethodElement srcObj) {
        this.logger.logMessage(" === processing element " + srcObj.getType().getName() + ": " + srcObj.getName());
        if (this.isProcessed(srcObj.getId())) {
            return;
        }
        this.setProcessed(srcObj.getId());
        if (srcObj instanceof ContentCategoryPackage) {
            Iterator it = ((ContentCategoryPackage)srcObj).getContentCategory().iterator();
            while (it.hasNext()) {
                this.iteratEDataObject((MethodElement)it.next());
            }
            return;
        }
        EDataObject targetObj = this.getRmcObject(srcObj);
        EClass eClass = srcObj.eClass();
        EList features = eClass.getEAllStructuralFeatures();
        boolean isNewElement = this.umaLib.isNewElement(srcObj.getId()) || srcObj instanceof MethodLibrary;
        boolean isOldPlugin = !isNewElement && srcObj instanceof MethodPlugin;
        HashSet<EStructuralFeature> seenRmcFeatures = new HashSet<EStructuralFeature>();
        for (EStructuralFeature feature : features) {
            if (FeatureManager.INSTANCE.isUnneededXmlFeature(feature.getName()) || isOldPlugin && UmaPackage.eINSTANCE.getMethodPlugin_UserChangeable() == feature) continue;
            Object value = srcObj.eGet(feature);
            try {
                org.eclipse.epf.uma.MethodElement elem;
                EObject ceobj;
                if (value == null) {
                    this.umaLib.handleNullXmlValue((EDataObject)srcObj, targetObj, feature.getName());
                    continue;
                }
                boolean isMep = feature.getName().equals("methodElementProperty");
                if (value instanceof List && !isMep) {
                    this.umaLib.initListValueMerge((EDataObject)srcObj, targetObj, feature.getName(), (List)value, seenRmcFeatures);
                    for (Object src_value : (List)value) {
                        if (src_value instanceof String) {
                            this.umaLib.setReferenceValue(targetObj, feature.getName(), (String)src_value);
                            continue;
                        }
                        if (src_value instanceof MethodElement) {
                            MethodElement e = (MethodElement)src_value;
                            String guid = e.getId();
                            if (!this.isDiscarded(guid) && e.eContainer() != srcObj) {
                                this.umaLib.setReferenceValue(targetObj, feature.getName(), guid);
                            }
                            this.iteratEDataObject((MethodElement)src_value);
                            continue;
                        }
                        if (src_value instanceof WorkOrder) {
                            WorkOrder wr = (WorkOrder)src_value;
                            Object umaWr = this.workOrderMap.get(wr);
                            this.umaLib.setWorkOrder(umaWr, wr.getValue());
                            continue;
                        }
                        this.logger.logMessage(NLS.bind((String)ImportXMLResources.importXMLService_element_not_handled, src_value));
                    }
                    continue;
                }
                if (feature instanceof EReference && !isMep) {
                    Object src_value = value;
                    if (src_value instanceof WorkOrder) {
                        this.logger.logMessage("workorder value");
                        continue;
                    }
                    if (src_value instanceof String && !this.isDiscarded((String)src_value)) {
                        this.umaLib.setReferenceValue(targetObj, feature.getName(), (String)src_value);
                        continue;
                    }
                    if (src_value instanceof MethodElement) {
                        String guid = ((MethodElement)src_value).getId();
                        if (guid == null) {
                            this.logger.logWarning(NLS.bind((String)ImportXMLResources.importXMLService_element_without_id, (Object)((MethodElement)src_value).getName()));
                        }
                        if (!this.isDiscarded(guid)) {
                            this.umaLib.setReferenceValue(targetObj, feature.getName(), guid);
                        }
                        this.iteratEDataObject((MethodElement)src_value);
                        continue;
                    }
                    this.logger.logWarning(NLS.bind((String)ImportXMLResources.importXMLService_element_not_handled, (Object)src_value));
                    continue;
                }
                if (targetObj instanceof ContentCategoryPackage) {
                    this.logger.logMessage("hrre");
                }
                if (value instanceof WorkOrderType) {
                    value = ((WorkOrderType)value).getName();
                }
                boolean rename = false;
                if (!isNewElement && feature == UmaPackage.eINSTANCE.getNamedElement_Name()) {
                    String oldName = (String)targetObj.eGet((EStructuralFeature)org.eclipse.epf.uma.UmaPackage.eINSTANCE.getNamedElement_Name());
                    String newName = (String)srcObj.eGet(feature);
                    if (!newName.equals(oldName)) {
                        LibraryImportManager.ensureUniqueNameForExistingElement((org.eclipse.epf.uma.MethodElement)((org.eclipse.epf.uma.MethodElement)targetObj), (String)oldName, (String)newName, (Map)this.renameElementMap);
                        rename = true;
                    }
                }
                if (!rename) {
                    this.umaLib.setAtributeFeatureValue(targetObj, feature.getName(), value);
                }
                if (!isNewElement || feature != UmaPackage.eINSTANCE.getNamedElement_Name() || !((ceobj = (elem = (org.eclipse.epf.uma.MethodElement)targetObj).eContainer()) instanceof org.eclipse.epf.uma.MethodElement) || this.umaLib.isNewElement(((org.eclipse.epf.uma.MethodElement)ceobj).getGuid())) continue;
                LibraryImportManager.ensureUniqueName((EObject)ceobj, (org.eclipse.epf.uma.MethodElement)elem, (Map)this.renameElementMap);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private boolean isProcessed(String guid) {
        return this.processedElements.contains(guid);
    }

    private void setProcessed(String guid) {
        if (!this.processedElements.contains(guid)) {
            this.processedElements.add(guid);
        }
    }

    private boolean isDiscarded(String id) {
        return this.discardedElements.contains(id);
    }

    private void setDiscarded(String id) {
        this.discardedElements.add(id);
    }

    public void setOverwrite(boolean b) {
        this.overwrite = b;
    }

    private String versionCheck(final String xmlPath, final String title) {
        final String[] ret = new String[]{null};
        SafeUpdateController.syncExec((Runnable)new Runnable(){

            public void run() {
                VersionUtil.VersionCheckInfo info = VersionUtil.checkXMLVersion((File)new File(xmlPath));
                if (info == null) {
                    ret[0] = NLS.bind((String)ImportXMLResources.versionMismatch_oldData_unknown, (Object[])new Object[]{Platform.getProduct().getName()});
                } else if (info.result < 0) {
                    try {
                        ImportXMLService.this.migrator = MappingUtil.getMigratorByLibPath((String)xmlPath);
                    }
                    catch (Exception e) {
                        ret[0] = e.toString();
                    }
                    if (ImportXMLService.this.migrator == null && ret[0] == null) {
                        ret[0] = info.toolID.equals(VersionUtil.getPrimaryToolID()) ? NLS.bind((String)ImportXMLResources.versionMismatch_oldData, (Object[])new Object[]{info.toolVersion, Platform.getProduct().getName()}) : NLS.bind((String)ImportXMLResources.versionMismatch_oldData_unknown, (Object[])new Object[]{Platform.getProduct().getName()});
                    }
                } else if (info.result > 0) {
                    ret[0] = info.toolID.equals(VersionUtil.getPrimaryToolID()) ? NLS.bind((String)ImportXMLResources.versionMismatch_oldTool, (Object[])new Object[]{info.toolVersion, Platform.getProduct().getName()}) : NLS.bind((String)ImportXMLResources.versionMismatch_oldTool_unknown, (Object[])new Object[]{Platform.getProduct().getName()});
                }
                if (ret[0] != null) {
                    ImportXMLPlugin.getDefault().getMsgDialog().displayError(title, ret[0]);
                }
            }
        });
        return ret[0];
    }

    public void handleTypeChanges() {
        org.eclipse.epf.uma.MethodLibrary baseLib = LibraryService.getInstance().getCurrentMethodLibrary();
        HashMap baseMap = new HashMap();
        ConfigurationImportService.collectPotentialTypeChanged((org.eclipse.epf.uma.MethodLibrary)baseLib, baseMap);
        HashMap eClassObjMap = new HashMap();
        HashMap importMap = new HashMap();
        TreeIterator it = this.xmlLib.getRoot().eAllContents();
        while (it.hasNext()) {
            EClass objEClass;
            Object obj = it.next();
            if (!(obj instanceof Guidance) && !(obj instanceof Activity)) continue;
            MethodElement xmlElement = (MethodElement)obj;
            String eClassName = xmlElement.eClass().getName();
            Object eClassObj = eClassObjMap.get(eClassName);
            if (eClassObj == null && (objEClass = FeatureManager.INSTANCE.getRmcEClass(eClassName)) != null) {
                eClassObj = UmaFactory.eINSTANCE.create(objEClass);
                eClassObjMap.put(eClassName, eClassObj);
            }
            if (eClassObj == null) continue;
            importMap.put(xmlElement.getId(), eClassObj);
        }
        ConfigurationImportService.handleTypeChanges(baseMap, importMap);
    }

    private boolean isCheckBasePlugins() {
        return this.checkBasePlugins;
    }

    public void setCheckBasePlugins(boolean checkBasePlugins) {
        this.checkBasePlugins = checkBasePlugins;
    }

    public void setMergeLevel(int mergeLevel) {
        this.mergeLevel = mergeLevel;
    }
}

