/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.navigator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.CreateChildCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.epf.library.edit.IStatefulItemProvider;
import org.eclipse.epf.library.edit.LibraryEditPlugin;
import org.eclipse.epf.library.edit.PresentationContext;
import org.eclipse.epf.library.edit.command.MethodElementAddCommand;
import org.eclipse.epf.library.edit.command.MethodElementCreateChildCommand;
import org.eclipse.epf.library.edit.navigator.ProcessesItemProvider;
import org.eclipse.epf.library.edit.process.IProcessItemProvider;
import org.eclipse.epf.library.edit.process.command.CreateProcessComponentCommand;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.UmaFactory;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.provider.UmaEditPlugin;

public class ProcessPackageItemProvider
extends org.eclipse.epf.uma.provider.ProcessPackageItemProvider
implements IProcessItemProvider,
IStatefulItemProvider {
    protected EClass processType;
    private String label;
    private Object parent;

    public ProcessPackageItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public EClass getProcessType() {
        return this.processType;
    }

    protected void collectNewChildDescriptors(Collection newChildDescriptors, Object object) {
        newChildDescriptors.add(this.createChildParameter(UmaPackage.eINSTANCE.getMethodPackage_ChildPackages(), UmaFactory.eINSTANCE.createProcessPackage()));
        newChildDescriptors.add(this.createChildParameter(UmaPackage.eINSTANCE.getMethodPackage_ChildPackages(), UmaFactory.eINSTANCE.createProcessComponent()));
    }

    public Collection getChildrenFeatures(Object object) {
        if (this.childrenFeatures == null) {
            this.childrenFeatures = new ArrayList();
            this.childrenFeatures.add(UmaPackage.eINSTANCE.getMethodPackage_ChildPackages());
        }
        return this.childrenFeatures;
    }

    public Collection getChildren(Object object) {
        Collection children = super.getChildren(object);
        for (Object child : children) {
            if (child instanceof ProcessComponent || !(child instanceof ProcessPackage)) continue;
            ProcessPackageItemProvider itemProvider = (ProcessPackageItemProvider)this.getRootAdapterFactory().adapt(child, ITreeItemContentProvider.class);
            if (this.processType == null) continue;
            itemProvider.setProcessType(this.processType);
        }
        Collections.sort((List)children, PresentationContext.INSTANCE.getProcessPackageComparator());
        return children;
    }

    public String getText(Object object) {
        if (this.label != null) {
            return this.label;
        }
        return TngUtil.getLabel(object);
    }

    public Object getImage(Object object) {
        Object parent;
        EClass procType = this.getProcessType();
        if (procType != null && (parent = this.getParent(object)) != null && parent instanceof ProcessesItemProvider) {
            if (procType.equals(UmaPackage.eINSTANCE.getCapabilityPattern())) {
                return LibraryEditPlugin.INSTANCE.getImage("full/obj16/CapabilityPatterns");
            }
            if (procType.equals(UmaPackage.eINSTANCE.getDeliveryProcess())) {
                return LibraryEditPlugin.INSTANCE.getImage("full/obj16/DeliveryProcesses");
            }
        }
        return UmaEditPlugin.INSTANCE.getImage("full/obj16/ProcessPackage");
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setProcessType(EClass processType) {
        this.processType = processType;
    }

    protected Command createCreateChildCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Object value, int index, Collection collection) {
        if (value instanceof ProcessComponent) {
            return new CreateProcessComponentCommand(domain, owner, feature, value, index, collection, (CreateChildCommand.Helper)this);
        }
        return new MethodElementCreateChildCommand(domain, owner, feature, value, index, collection, (CreateChildCommand.Helper)this);
    }

    public String getCreateChildText(Object owner, Object feature, Object child, Collection selection) {
        EClass processType;
        if (child instanceof ProcessComponent && (processType = this.getProcessType()) != null) {
            if (processType.equals(UmaPackage.eINSTANCE.getCapabilityPattern())) {
                return LibraryEditPlugin.INSTANCE.getString("_UI_CapabilityPattern_text");
            }
            if (processType.equals(UmaPackage.eINSTANCE.getDeliveryProcess())) {
                return LibraryEditPlugin.INSTANCE.getString("_UI_DeliveryProcess_text");
            }
            if (processType == UmaPackage.eINSTANCE.getProcessPlanningTemplate()) {
                return this.getString("_UI_ProcessPlanningTemplate_type");
            }
        }
        return super.getCreateChildText(owner, feature, child, selection);
    }

    public Object getCreateChildImage(Object owner, Object feature, Object child, Collection selection) {
        EClass processType;
        if (child instanceof ProcessComponent && (processType = this.getProcessType()) != null) {
            if (processType.equals(UmaPackage.eINSTANCE.getCapabilityPattern())) {
                return UmaEditPlugin.INSTANCE.getImage("full/obj16/CapabilityPattern");
            }
            if (processType.equals(UmaPackage.eINSTANCE.getDeliveryProcess())) {
                return UmaEditPlugin.INSTANCE.getImage("full/obj16/DeliveryProcess");
            }
            if (processType == UmaPackage.eINSTANCE.getProcessPlanningTemplate()) {
                return UmaEditPlugin.INSTANCE.getImage("full/obj16/ProcessPlanningTemplate");
            }
        }
        return super.getCreateChildImage(owner, feature, child, selection);
    }

    protected Command createAddCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Collection collection, int index) {
        ArrayList selection = new ArrayList();
        for (Object element : collection) {
            if (!(element instanceof ProcessPackage) || ProcessUtil.hasProcessNotOfType((ProcessPackage)element, this.processType)) continue;
            selection.add(element);
        }
        if (selection.isEmpty()) {
            return UnexecutableCommand.INSTANCE;
        }
        return new MethodElementAddCommand((Command)((AddCommand)super.createAddCommand(domain, owner, feature, selection, index))){

            protected void featureChanged(EObject object, EStructuralFeature feature, Object newValue) {
                Process proc;
                if (object instanceof ProcessComponent && feature == UmaPackage.eINSTANCE.getNamedElement_Name() && (proc = ((ProcessComponent)object).getProcess()) != null) {
                    proc.setName((String)newValue);
                }
            }
        };
    }

    public void setParent(Object parent) {
        this.parent = parent;
    }

    public Object getParent(Object object) {
        if (this.parent != null) {
            return this.parent;
        }
        return super.getParent(object);
    }

    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        TngUtil.refreshParentIfNameChanged(notification, (ItemProviderAdapter)this);
        super.notifyChanged(notification);
    }
}

