/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.process;

import java.text.MessageFormat;
import java.util.Iterator;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.epf.library.edit.LibraryEditResources;
import org.eclipse.epf.library.edit.process.BreakdownElementItemProvider;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.Descriptor;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.VariabilityType;
import org.eclipse.epf.uma.WorkProductDescriptor;

public class DescriptorItemProvider
extends BreakdownElementItemProvider {
    public DescriptorItemProvider(AdapterFactory adapterFactory, ItemProviderAdapter delegateItemProvider) {
        super(adapterFactory, delegateItemProvider);
    }

    public String getAttribute(Object object, String property) {
        if (property == "model_info") {
            StringBuffer modelInfo = new StringBuffer();
            MethodElement e = ProcessUtil.getAssociatedElement((Descriptor)object);
            if (e instanceof VariabilityElement) {
                VariabilityElement ve = (VariabilityElement)e;
                VariabilityElement base = ve.getVariabilityBasedOnElement();
                if (base != null) {
                    ITreeItemContentProvider adapter;
                    Object parent = null;
                    parent = this.getParent(object);
                    while (parent != null && !(parent instanceof Activity)) {
                        adapter = (ITreeItemContentProvider)this.getRootAdapterFactory().adapt(parent, ITreeItemContentProvider.class);
                        parent = adapter.getParent(parent);
                    }
                    if (parent != null) {
                        adapter = (ITreeItemContentProvider)this.getRootAdapterFactory().adapt(parent, ITreeItemContentProvider.class);
                        Object desc = null;
                        Iterator iter = adapter.getChildren(parent).iterator();
                        while (iter.hasNext()) {
                            Object child = TngUtil.unwrap(iter.next());
                            if (!(child instanceof Descriptor) || ProcessUtil.getAssociatedElement((Descriptor)child) != base) continue;
                            desc = child;
                            break;
                        }
                        if (desc != null) {
                            String str = null;
                            if (ve.getVariabilityType() == VariabilityType.EXTENDS) {
                                str = LibraryEditResources.process_extends;
                            } else if (ve.getVariabilityType() == VariabilityType.REPLACES) {
                                str = LibraryEditResources.process_replaces;
                            }
                            String name = ((DescribableElement)desc).getPresentationName();
                            if (str != null) {
                                modelInfo.append(MessageFormat.format(str, name));
                            } else {
                                modelInfo.append("");
                            }
                        }
                    }
                }
                if (object instanceof WorkProductDescriptor) {
                    ProcessUtil.getWPDModelInfo(modelInfo, object, this);
                }
            }
            return modelInfo.toString();
        }
        return super.getAttribute(object, property);
    }
}

