/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.process;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.AdapterFactoryTreeIterator;
import org.eclipse.emf.edit.provider.Disposable;
import org.eclipse.emf.edit.provider.IWrapperItemProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.epf.library.edit.ICachedChildrenItemProvider;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.library.edit.process.BSActivityItemProvider;
import org.eclipse.epf.library.edit.process.ComposedWPDescriptorWrapperItemProvider;
import org.eclipse.epf.library.edit.process.command.PBSDragAndDropCommand;
import org.eclipse.epf.library.edit.process.command.PBSDropCommand;
import org.eclipse.epf.library.edit.util.Comparators;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.Artifact;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.Descriptor;
import org.eclipse.epf.uma.Milestone;
import org.eclipse.epf.uma.UmaFactory;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.WorkProductDescriptor;
import org.eclipse.epf.uma.util.AssociationHelper;

public class PBSActivityItemProvider
extends BSActivityItemProvider
implements ICachedChildrenItemProvider {
    private Disposable rolledUpWrappers;

    public PBSActivityItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    protected void collectNewChildDescriptors(Collection newChildDescriptors, Object object) {
        newChildDescriptors.add(this.createChildParameter(UmaPackage.eINSTANCE.getActivity_BreakdownElements(), UmaFactory.eINSTANCE.createPhase()));
        newChildDescriptors.add(this.createChildParameter(UmaPackage.eINSTANCE.getActivity_BreakdownElements(), UmaFactory.eINSTANCE.createIteration()));
        newChildDescriptors.add(this.createChildParameter(UmaPackage.eINSTANCE.getActivity_BreakdownElements(), UmaFactory.eINSTANCE.createActivity()));
        newChildDescriptors.add(this.createChildParameter(UmaPackage.eINSTANCE.getActivity_BreakdownElements(), UmaFactory.eINSTANCE.createWorkProductDescriptor()));
        newChildDescriptors.add(this.createChildParameter(UmaPackage.eINSTANCE.getActivity_BreakdownElements(), UmaFactory.eINSTANCE.createMilestone()));
    }

    protected boolean acceptAsChild(Object child) {
        if ((child = TngUtil.unwrap(child)) instanceof Activity || child instanceof WorkProductDescriptor || child instanceof Milestone) {
            return super.acceptAsChild(child);
        }
        return false;
    }

    public Collection getChildren(Object object) {
        if (this.rolledUpWrappers != null) {
            this.rolledUpWrappers.dispose();
        }
        if (this.isRolledUp()) {
            HashMap workProductToWrappersMap = new HashMap();
            Collection children = super.getChildren(object);
            Iterator iter = children.iterator();
            while (iter.hasNext()) {
                Object child = iter.next();
                Object e = TngUtil.unwrap(child);
                if (!(e instanceof WorkProductDescriptor)) continue;
                WorkProductDescriptor desc = (WorkProductDescriptor)e;
                List list = AssociationHelper.getDeliverableDescriptors((WorkProductDescriptor)desc);
                WorkProductDescriptor wrapperKey = desc.getWorkProduct() == null ? desc : desc.getWorkProduct();
                ArrayList<ComposedWPDescriptorWrapperItemProvider> wrappers = (ArrayList<ComposedWPDescriptorWrapperItemProvider>)workProductToWrappersMap.get(wrapperKey);
                if (list.size() < 1) {
                    if (wrappers == null) {
                        wrappers = new ArrayList<ComposedWPDescriptorWrapperItemProvider>();
                        workProductToWrappersMap.put(wrapperKey, wrappers);
                        wrappers.add(new ComposedWPDescriptorWrapperItemProvider(child, object, this.adapterFactory));
                        continue;
                    }
                    int i = wrappers.size() - 1;
                    while (i > -1) {
                        ((ComposedWPDescriptorWrapperItemProvider)wrappers.get(i)).addWorkProductDescriptor(child);
                        --i;
                    }
                    continue;
                }
                boolean checkExist = true;
                if (wrappers == null) {
                    wrappers = new ArrayList();
                    workProductToWrappersMap.put(wrapperKey, wrappers);
                    checkExist = false;
                }
                if (checkExist) {
                    for (Object e2 : wrappers) {
                        if (e2 instanceof DeliverableWorkProductDescriptorItemProvider) continue;
                        iter.remove();
                    }
                    checkExist = wrappers.size() > 0;
                }
                block3: for (Object e3 : list) {
                    if (checkExist) {
                        int i = wrappers.size() - 1;
                        while (i > -1) {
                            DeliverableWorkProductDescriptorItemProvider wrapper = (DeliverableWorkProductDescriptorItemProvider)wrappers.get(i);
                            if (wrapper.deliverableDescriptor == e3) {
                                wrapper.addWorkProductDescriptor(child);
                                continue block3;
                            }
                            --i;
                        }
                    }
                    DeliverableWorkProductDescriptorItemProvider itemProvider = new DeliverableWorkProductDescriptorItemProvider(desc, object, this.adapterFactory);
                    itemProvider.deliverableDescriptor = e3;
                    wrappers.add(itemProvider);
                }
            }
            ArrayList rolledUpChildren = new ArrayList();
            Iterator iter2 = workProductToWrappersMap.values().iterator();
            while (iter2.hasNext()) {
                rolledUpChildren.addAll((Collection)iter2.next());
            }
            List result = this.removeSubartifactsFromChildren(rolledUpChildren, true);
            if (this.rolledUpWrappers == null) {
                this.rolledUpWrappers = new Disposable();
            }
            this.rolledUpWrappers.addAll((Collection)result);
            int i = rolledUpChildren.size() - 1;
            while (i > -1) {
                IWrapperItemProvider wrapper = (IWrapperItemProvider)rolledUpChildren.get(i);
                if (!this.rolledUpWrappers.contains((Object)wrapper)) {
                    wrapper.dispose();
                }
                --i;
            }
            Collections.sort(result, Comparators.PRESENTATION_NAME_COMPARATOR);
            this.updateCachedChildren(result);
            return result;
        }
        List children = this.removeSubartifactsFromChildren(super.getChildren(object), false);
        this.updateCachedChildren(children);
        return children;
    }

    public void dispose() {
        if (this.rolledUpWrappers != null) {
            this.rolledUpWrappers.dispose();
        }
        super.dispose();
    }

    protected boolean isNewDescriptor(List children, Object child) {
        return true;
    }

    protected void createOrMovePackageFor(List newChildren) {
        super.createOrMovePackageFor(newChildren);
        for (Object e : newChildren) {
            if (!(e instanceof WorkProductDescriptor)) continue;
            WorkProductDescriptor wpd = (WorkProductDescriptor)e;
            for (WorkProductDescriptor part : wpd.getDeliverableParts()) {
                ProcessUtil.addToContainer((BreakdownElement)part, (ItemProviderAdapter)this, false);
            }
        }
    }

    protected Object getObject(Descriptor descriptor) {
        return ((WorkProductDescriptor)descriptor).getWorkProduct();
    }

    protected Command createDragAndDropCommand(EditingDomain domain, Object owner, float location, int operations, int operation, Collection collection) {
        return new PBSDragAndDropCommand(domain, owner, location, operations, operation, collection);
    }

    public IResourceAwareCommand createDropCommand(Object owner, List dropElements) {
        return new PBSDropCommand((Activity)owner, dropElements);
    }

    protected boolean acceptAsRolledUpChild(Object child) {
        Object obj = TngUtil.unwrap(child);
        if (obj instanceof WorkProductDescriptor && ((WorkProductDescriptor)obj).getSuperActivities() != null) {
            return super.acceptAsRolledUpChild(obj);
        }
        return false;
    }

    public Collection getEClasses() {
        return ProcessUtil.getPBSEclasses();
    }

    protected List removeSubartifactsFromChildren(Collection children, boolean unwrap) {
        List list = ProcessUtil.removeSubartifactsFromChildren(children, unwrap);
        if (list.size() != children.size()) {
            for (Object child : children) {
                if (!(child instanceof WorkProductDescriptor) || !(((WorkProductDescriptor)child).getWorkProduct() instanceof Artifact)) continue;
                AdapterFactoryTreeIterator iter = new AdapterFactoryTreeIterator(this.adapterFactory, child);
                while (iter.hasNext()) {
                    iter.next();
                }
            }
        }
        return list;
    }

    protected boolean isWrappingRollupNeeded(Object object) {
        if (TngUtil.unwrap(object) instanceof WorkProductDescriptor) {
            return true;
        }
        return super.isWrappingRollupNeeded(object);
    }

    private static class DeliverableWorkProductDescriptorItemProvider
    extends ComposedWPDescriptorWrapperItemProvider {
        private Object deliverableDescriptor;

        public DeliverableWorkProductDescriptorItemProvider(WorkProductDescriptor value, Object owner, AdapterFactory adapterFactory) {
            super((Object)value, owner, adapterFactory);
            this.readOnly = false;
        }

        public String getAttribute(Object object, String property) {
            if (property == "deliverable") {
                return TngUtil.getPresentationName(this.deliverableDescriptor);
            }
            return super.getAttribute(object, property);
        }
    }
}

