/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.util;

import com.ibm.icu.util.StringTokenizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.AdapterFactoryTreeIterator;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.provider.WrapperItemProvider;
import org.eclipse.epf.library.edit.IConfigurator;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.LibraryEditResources;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.library.edit.process.BSActivityItemProvider;
import org.eclipse.epf.library.edit.process.BreakdownElementWrapperItemProvider;
import org.eclipse.epf.library.edit.process.ComposedBreakdownElementWrapperItemProvider;
import org.eclipse.epf.library.edit.process.IBSItemProvider;
import org.eclipse.epf.library.edit.process.command.RemoveUnusedDescriptorsCommand;
import org.eclipse.epf.library.edit.util.ConfigurableComposedAdapterFactory;
import org.eclipse.epf.library.edit.util.ConstraintManager;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.Artifact;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.Constraint;
import org.eclipse.epf.uma.Descriptor;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessElement;
import org.eclipse.epf.uma.RoleDescriptor;
import org.eclipse.epf.uma.TaskDescriptor;
import org.eclipse.epf.uma.TeamProfile;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.VariabilityType;
import org.eclipse.epf.uma.WorkBreakdownElement;
import org.eclipse.epf.uma.WorkProduct;
import org.eclipse.epf.uma.WorkProductDescriptor;
import org.eclipse.epf.uma.ecore.impl.MultiResourceEObject;
import org.eclipse.epf.uma.ecore.util.OppositeFeature;
import org.eclipse.epf.uma.util.AssociationHelper;
import org.eclipse.epf.uma.util.UmaUtil;

public class Suppression {
    public static final String WBS = "wbs";
    public static final String TBS = "tbs";
    public static final String WPBS = "wpbs";
    public static final String CBS = "cbs";
    private static final Map procToSuppressionMap = new HashMap();
    private static boolean autoInheritIntermediateSuppressionState = true;
    protected Process process;
    private Set suppressedExternalElementPaths;
    private boolean modified;
    private Set internalUnsuppressedElements = new HashSet();

    public static final void clearCachedSuppressions() {
        procToSuppressionMap.clear();
    }

    public static final void cleanUp() {
        ArrayList<Process> listToRemove = new ArrayList<Process>();
        for (Process proc : new ArrayList(procToSuppressionMap.keySet())) {
            if (!proc.eIsProxy()) continue;
            listToRemove.add(proc);
        }
        int size = listToRemove.size();
        int i = 0;
        while (i < size) {
            procToSuppressionMap.remove(listToRemove.get(i));
            ++i;
        }
    }

    public static final void setAutoInheritSuppressionStates(boolean b) {
        autoInheritIntermediateSuppressionState = b;
    }

    public Suppression(Process process) {
        this.process = process;
        this.suppressedExternalElementPaths = this.loadSuppressedElementPaths();
    }

    public Process getProcess() {
        return this.process;
    }

    private Set loadSuppressedElementPaths() {
        Constraint rule = ConstraintManager.getConstraint((MethodElement)this.process, "", false);
        if (rule != null && rule.getBody().length() > 0) {
            HashSet<String> paths = new HashSet<String>();
            StringTokenizer tokens = new StringTokenizer(rule.getBody());
            while (tokens.hasMoreTokens()) {
                paths.add(tokens.nextToken());
            }
            return paths;
        }
        return null;
    }

    private Set getSuppressedExternalElementPaths() {
        if (this.suppressedExternalElementPaths == null) {
            this.suppressedExternalElementPaths = this.loadSuppressedElementPaths();
            if (this.suppressedExternalElementPaths == null) {
                this.suppressedExternalElementPaths = new HashSet();
            }
        }
        return this.suppressedExternalElementPaths;
    }

    public boolean hasSuppressed(Collection selection) {
        for (Object element : selection) {
            if (!(element instanceof BreakdownElementWrapperItemProvider ? this.isSuppressed((BreakdownElementWrapperItemProvider)element) : element instanceof BreakdownElement && this.isSuppressed((BreakdownElement)element))) continue;
            return true;
        }
        return false;
    }

    public boolean canSuppress(Collection selection) {
        return this.canDo(selection, true);
    }

    public boolean canReveal(Collection selection) {
        return this.canDo(selection, false);
    }

    private Collection getApplicableItems(Collection selection, boolean suppressed) {
        ArrayList applicableItems = new ArrayList();
        for (Object element : selection) {
            if (element instanceof BreakdownElementWrapperItemProvider) {
                BreakdownElementWrapperItemProvider wrapper = (BreakdownElementWrapperItemProvider)element;
                if (wrapper.isReadOnly()) {
                    if (this.isInSuppressedList(wrapper) == suppressed) continue;
                    applicableItems.add(element);
                    continue;
                }
                Object e = TngUtil.unwrap(wrapper);
                if (!(e instanceof MethodElement) || ((MethodElement)e).getSuppressed() == suppressed) continue;
                applicableItems.add(element);
                continue;
            }
            if (!(element instanceof MethodElement) || ((MethodElement)element).getSuppressed() == suppressed) continue;
            applicableItems.add(element);
        }
        return applicableItems;
    }

    public static boolean isValid(Object element) {
        BreakdownElement obj = null;
        if (element instanceof BreakdownElementWrapperItemProvider) {
            BreakdownElementWrapperItemProvider wrapper = (BreakdownElementWrapperItemProvider)element;
            if (wrapper.isRollupChild()) {
                return false;
            }
            obj = (BreakdownElement)TngUtil.unwrap(wrapper);
        } else if (element instanceof BreakdownElement) {
            obj = (BreakdownElement)element;
        }
        return !(obj instanceof RoleDescriptor) && !(obj instanceof WorkProductDescriptor) || obj.getSuperActivities() != null && obj.getSuperActivities() != null;
    }

    private boolean canDo(Collection selection, boolean suppressed) {
        for (Object element : selection) {
            Object e;
            BreakdownElementWrapperItemProvider wrapper;
            if (!Suppression.isValid(element) || !(element instanceof BreakdownElementWrapperItemProvider ? ((wrapper = (BreakdownElementWrapperItemProvider)element).isReadOnly() ? this.isInSuppressedList(wrapper) != suppressed : (e = TngUtil.unwrap(wrapper)) instanceof MethodElement && ((MethodElement)e).getSuppressed() != suppressed) : element instanceof MethodElement && ((MethodElement)element).getSuppressed() != suppressed)) continue;
            return true;
        }
        return false;
    }

    private boolean __isSuppressed(BreakdownElement e) {
        return Suppression.getSuppressed(e, true, null) != null;
    }

    private static boolean isDirectlySuppressed(MethodElement e) {
        VariabilityElement ve;
        VariabilityType variabilityType;
        Boolean b = e.getSuppressed();
        if (b != null && b.booleanValue()) {
            return true;
        }
        if (e instanceof VariabilityElement && ((variabilityType = (ve = (VariabilityElement)e).getVariabilityType()) == VariabilityType.EXTENDS || variabilityType == VariabilityType.CONTRIBUTES) && ve.getVariabilityBasedOnElement() != null) {
            return Suppression.isDirectlySuppressed((MethodElement)ve.getVariabilityBasedOnElement());
        }
        return false;
    }

    private static BreakdownElement getSuppressed(BreakdownElement e, boolean checkParent, Object top) {
        if (e.getSuppressed().booleanValue()) {
            return e;
        }
        if (checkParent) {
            TeamProfile superTeam;
            BreakdownElement be = e;
            while (be != top && be.getSuperActivities() != null) {
                if (!(be = be.getSuperActivities()).getSuppressed().booleanValue()) continue;
                return be;
            }
            if (e instanceof WorkProductDescriptor) {
                List list;
                Activity act;
                WorkProductDescriptor wpDesc = (WorkProductDescriptor)e;
                WorkProduct wp = wpDesc.getWorkProduct();
                if (wp instanceof Artifact && (act = UmaUtil.getParentActivity((BreakdownElement)e)) != null) {
                    for (Object element : act.getBreakdownElements()) {
                        WorkProductDescriptor wpd;
                        WorkProduct otherWp;
                        if (element == e || !(element instanceof WorkProductDescriptor) || !((otherWp = (wpd = (WorkProductDescriptor)element).getWorkProduct()) instanceof Artifact) || !UmaUtil.isContainedBy((EObject)wp, (Object)otherWp) || !wpd.getSuppressed().booleanValue()) continue;
                        return wpd;
                    }
                }
                if (wpDesc != top && wpDesc.getSuperActivities() == null && (list = AssociationHelper.getDeliverableDescriptors((WorkProductDescriptor)wpDesc)).size() == 1) {
                    return Suppression.getSuppressed((BreakdownElement)list.get(0), checkParent, top);
                }
            } else if (e instanceof RoleDescriptor) {
                TeamProfile team;
                List list;
                if (e.getSuperActivities() == null && (list = AssociationHelper.getTeamProfiles((RoleDescriptor)((RoleDescriptor)e))).size() == 1 && (team = (TeamProfile)list.get(0)) != top && team != null) {
                    return Suppression.getSuppressed((BreakdownElement)team, checkParent, top);
                }
            } else if (e instanceof TeamProfile && e.getSuperActivities() == null && (superTeam = ((TeamProfile)e).getSuperTeam()) != top && superTeam != null) {
                return Suppression.getSuppressed((BreakdownElement)superTeam, checkParent, top);
            }
        }
        return null;
    }

    public boolean isInSuppressedList(BreakdownElementWrapperItemProvider wrapper) {
        if (this.suppressedExternalElementPaths == null) {
            return false;
        }
        String path = Suppression.getPath(wrapper);
        return this.suppressedExternalElementPaths.contains(path);
    }

    private BreakdownElement getSuppressed(BreakdownElementWrapperItemProvider wrapper) {
        return this.getSuppressed(wrapper, true);
    }

    private BreakdownElement getSuppressed(BreakdownElementWrapperItemProvider wrapper, boolean checkBase) {
        return this.getSuppressed(wrapper, checkBase, true, autoInheritIntermediateSuppressionState);
    }

    private BreakdownElement getSuppressed(BreakdownElementWrapperItemProvider wrapper, boolean checkBase, boolean checkLocal, boolean inheritSuppressionState) {
        return this.getSuppressed(wrapper, checkBase, checkLocal, inheritSuppressionState, true, null);
    }

    private BreakdownElement getSuppressed(BreakdownElementWrapperItemProvider wrapper, boolean checkBase, boolean checkLocal, boolean inheritSuppressionState, boolean checkParent, Object top) {
        BreakdownElement suppressed;
        BreakdownElement e = (BreakdownElement)TngUtil.unwrap(wrapper);
        if (!wrapper.isReadOnly()) {
            return Suppression.getSuppressed(e, checkParent, top);
        }
        if (checkBase && (suppressed = Suppression.getSuppressed(e, checkParent, top)) != null) {
            return suppressed;
        }
        Object parent = null;
        if (checkLocal) {
            BreakdownElement suppressed2;
            if (this.isInSuppressedList(wrapper)) {
                return e;
            }
            if (checkParent && (parent = wrapper.getParent(wrapper)) instanceof BreakdownElement && parent != top && (suppressed2 = Suppression.getSuppressed((BreakdownElement)parent, checkParent, top)) != null) {
                return suppressed2;
            }
        }
        if (inheritSuppressionState) {
            Process immediateBaseProc;
            Process proc = TngUtil.getOwningProcess(e);
            Activity inheritor = ProcessUtil.getInheritor(wrapper);
            BreakdownElement base = (BreakdownElement)inheritor.getVariabilityBasedOnElement();
            if (base != null && proc != (immediateBaseProc = TngUtil.getOwningProcess(base))) {
                Suppression suppression;
                BreakdownElement breakdownElement;
                Object object = inheritor.getVariabilityBasedOnElement();
                ArrayList<BreakdownElement> objects = new ArrayList<BreakdownElement>(ProcessUtil.getParentList(inheritor, wrapper));
                objects.add(e);
                block0: for (Object e2 : objects) {
                    ITreeItemContentProvider adapter = (ITreeItemContentProvider)wrapper.getAdapterFactory().adapt(object, ITreeItemContentProvider.class);
                    for (Object child : adapter.getChildren(object)) {
                        if (e2 != TngUtil.unwrap(child)) continue;
                        object = child;
                        continue block0;
                    }
                }
                if (object instanceof BreakdownElementWrapperItemProvider && (breakdownElement = (suppression = Suppression.getSuppression(immediateBaseProc)).getSuppressed((BreakdownElementWrapperItemProvider)object, false, true, inheritSuppressionState, checkParent, TngUtil.unwrap(object))) != null) {
                    return breakdownElement;
                }
            }
        }
        if (checkParent) {
            if (parent == null) {
                parent = wrapper.getParent(wrapper);
            }
            if (parent instanceof BreakdownElementWrapperItemProvider && TngUtil.unwrap(parent) != top) {
                return this.getSuppressed((BreakdownElementWrapperItemProvider)parent, checkBase, true, inheritSuppressionState, checkParent, top);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Suppression getSuppression(Process proc) {
        Suppression suppression = (Suppression)procToSuppressionMap.get(proc);
        if (suppression == null) {
            Map map = procToSuppressionMap;
            synchronized (map) {
                suppression = (Suppression)procToSuppressionMap.get(proc);
                if (suppression == null) {
                    suppression = new Suppression(proc);
                    procToSuppressionMap.put(proc, suppression);
                }
            }
        }
        return suppression;
    }

    public static synchronized void setSuppression(Suppression sup) {
        procToSuppressionMap.put(sup.getProcess(), sup);
    }

    private boolean __isSuppressed(BreakdownElementWrapperItemProvider wrapper) {
        return this.getSuppressed(wrapper) != null;
    }

    public void saveToModel() {
        if (this.suppressedExternalElementPaths == null) {
            return;
        }
        StringBuffer paths = new StringBuffer();
        for (String path : this.suppressedExternalElementPaths) {
            if (!this.isValid(path)) continue;
            paths.append(path).append(' ');
        }
        Constraint rule = ConstraintManager.getConstraint((MethodElement)this.process, "", true);
        rule.setBody(paths.toString());
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isValid(String path) {
        URI uri = URI.createURI((String)path);
        String type = uri.scheme();
        ConfigurableComposedAdapterFactory adapterFactory = null;
        if (WBS.equals(type)) {
            adapterFactory = (ConfigurableComposedAdapterFactory)TngAdapterFactory.INSTANCE.getWBS_ComposedAdapterFactory();
        } else if (TBS.equals(type)) {
            adapterFactory = (ConfigurableComposedAdapterFactory)TngAdapterFactory.INSTANCE.getOBS_ComposedAdapterFactory();
        } else if (WPBS.equals(type)) {
            adapterFactory = (ConfigurableComposedAdapterFactory)TngAdapterFactory.INSTANCE.getPBS_ComposedAdapterFactory();
        } else {
            if (!CBS.equals(type)) return false;
            adapterFactory = (ConfigurableComposedAdapterFactory)TngAdapterFactory.INSTANCE.getProcessComposedAdapterFactory();
        }
        MethodConfiguration currentConfig = null;
        IConfigurator configurator = null;
        IFilter filter = adapterFactory.getFilter();
        if (filter instanceof IConfigurator) {
            configurator = (IConfigurator)adapterFactory.getFilter();
            currentConfig = configurator.getMethodConfiguration();
            configurator.setMethodConfiguration(this.process.getDefaultContext());
        }
        try {
            String guid = uri.authority();
            if (!this.process.getGuid().equals(guid)) {
                return false;
            }
            Process process = this.process;
            ITreeItemContentProvider adapter = (ITreeItemContentProvider)adapterFactory.adapt(process, ITreeItemContentProvider.class);
            int i = 0;
            while (i < uri.segmentCount()) {
                void var9_10;
                guid = uri.segment(i);
                Iterator iter = adapter.getChildren((Object)var9_10).iterator();
                adapter = null;
                while (iter.hasNext()) {
                    Object child = iter.next();
                    Object object = TngUtil.unwrap(child);
                    if (object instanceof MethodElement) {
                        if (!guid.equals(((MethodElement)object).getGuid())) continue;
                        if (child instanceof ITreeItemContentProvider) {
                            adapter = (ITreeItemContentProvider)child;
                            break;
                        }
                        adapter = (ITreeItemContentProvider)adapterFactory.adapt(child, ITreeItemContentProvider.class);
                        break;
                    }
                    ItemProviderAdapter itemProvider = (ItemProviderAdapter)object;
                    MethodElement e = (MethodElement)itemProvider.getTarget();
                    if (!guid.equals(e.getGuid())) continue;
                    adapter = (ITreeItemContentProvider)itemProvider;
                    break;
                }
                if (adapter == null) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        finally {
            if (configurator != null) {
                configurator.setMethodConfiguration(currentConfig);
            }
        }
    }

    public void reveal(List selection) {
        this.doSetSuppressed(selection, false);
    }

    private static String getViewType(BreakdownElementWrapperItemProvider wrapper) {
        Object e = TngUtil.unwrap(wrapper);
        if (e instanceof WorkBreakdownElement) {
            return WBS;
        }
        if (e instanceof TeamProfile || e instanceof RoleDescriptor) {
            return TBS;
        }
        if (e instanceof WorkProductDescriptor) {
            return WPBS;
        }
        return "";
    }

    public static String getProcessGUID(String guidPath) {
        int endIndex;
        int beginIndex;
        int id = guidPath.indexOf("://");
        if (id != -1 && (beginIndex = id + 3) < guidPath.length() && (endIndex = guidPath.indexOf(47, beginIndex)) != -1) {
            return guidPath.substring(beginIndex, endIndex);
        }
        return null;
    }

    public static String getPath(BreakdownElementWrapperItemProvider wrapper) {
        StringBuffer path = Suppression.getPathWithoutViewType(wrapper);
        String viewType = Suppression.getViewType(wrapper);
        path.insert(0, ":/").insert(0, viewType);
        return path.toString();
    }

    public static StringBuffer getPathWithoutViewType(BreakdownElementWrapperItemProvider wrapper) {
        StringBuffer path = new StringBuffer();
        List parentList = ProcessUtil.getParentList(null, wrapper);
        if (!parentList.isEmpty()) {
            for (MethodElement e : parentList) {
                if (e instanceof TaskDescriptor || e instanceof RoleDescriptor) continue;
                path.append('/').append(e.getGuid());
            }
        }
        MethodElement e = (MethodElement)TngUtil.unwrap(wrapper);
        path.append('/').append(e.getGuid());
        return path;
    }

    private static List getOwnRelatedElements(Collection changedDescriptors, boolean suppressed) {
        if (!changedDescriptors.isEmpty()) {
            ArrayList<Descriptor> descriptorsToChange = new ArrayList<Descriptor>();
            for (Descriptor desc : new ArrayList(changedDescriptors)) {
                Object[] relationships = null;
                if (desc instanceof TaskDescriptor) {
                    relationships = RemoveUnusedDescriptorsCommand.TASK_DESCRIPTOR__RELATIONSHIPS;
                } else if (desc instanceof RoleDescriptor) {
                    relationships = RemoveUnusedDescriptorsCommand.ROLE_DESCRIPTOR__RELATIONSHIPS;
                } else if (desc instanceof WorkProductDescriptor) {
                    relationships = RemoveUnusedDescriptorsCommand.WORK_PRODUCT_DESCRIPTOR__RELATIONSHIPS;
                }
                if (relationships == null) continue;
                int i = 0;
                while (i < relationships.length) {
                    Object value;
                    boolean isMany;
                    OppositeFeature f;
                    Object feature = relationships[i];
                    if (feature instanceof OppositeFeature) {
                        f = (OppositeFeature)feature;
                        isMany = f.isMany();
                        value = ((MultiResourceEObject)desc).getOppositeFeatureValue(f);
                    } else {
                        f = (EStructuralFeature)feature;
                        isMany = f.isMany();
                        value = desc.eGet((EStructuralFeature)f);
                    }
                    if (isMany) {
                        for (Descriptor ref : (Collection)value) {
                            if (ref.getSuppressed() == suppressed || ProcessUtil.checkDescriptorReferences(changedDescriptors, ref)) continue;
                            descriptorsToChange.add(ref);
                            changedDescriptors.add(ref);
                        }
                    } else {
                        Descriptor ref = (Descriptor)value;
                        if (ref != null && ref.getSuppressed() != suppressed && !ProcessUtil.checkDescriptorReferences(changedDescriptors, ref)) {
                            descriptorsToChange.add(ref);
                            changedDescriptors.add(ref);
                        }
                    }
                    ++i;
                }
            }
            return descriptorsToChange;
        }
        return null;
    }

    private Result setSuppressed(List selection, boolean suppressed) {
        List descriptorsToSuppress;
        Result result = this.doSetSuppressed(selection, suppressed);
        if (!result.descriptors.isEmpty() && (descriptorsToSuppress = Suppression.getOwnRelatedElements(result.descriptors, suppressed)) != null) {
            Result result2 = this.doSetSuppressed(descriptorsToSuppress, suppressed);
            result.elements.addAll(result2.elements);
            result.descriptors.addAll(result2.descriptors);
            result.paths.addAll(result2.paths);
        }
        return result;
    }

    public void suppress(List selection) {
        this.doSetSuppressed(selection, true);
    }

    private Result doSetSuppressed(List selection, boolean suppressed) {
        Result result = new Result();
        for (Object element : selection) {
            MethodElement e;
            if (element instanceof BreakdownElementWrapperItemProvider) {
                BreakdownElementWrapperItemProvider wrapper = (BreakdownElementWrapperItemProvider)element;
                BreakdownElement e2 = (BreakdownElement)TngUtil.unwrap(wrapper);
                if (!wrapper.isReadOnly()) {
                    if (e2.getSuppressed() == suppressed) continue;
                    e2.setSuppressed(Boolean.valueOf(suppressed));
                    result.elements.add(e2);
                    if (!(e2 instanceof Descriptor)) continue;
                    result.descriptors.add(e2);
                    continue;
                }
                String path = Suppression.getPath(wrapper);
                boolean b = suppressed ? this.getSuppressedExternalElementPaths().add(path) : this.getSuppressedExternalElementPaths().remove(path);
                if (!b) continue;
                result.paths.add(path);
                continue;
            }
            if (!(element instanceof MethodElement) || (e = (MethodElement)element).getSuppressed() == suppressed) continue;
            e.setSuppressed(Boolean.valueOf(suppressed));
            result.elements.add(e);
            if (!(e instanceof Descriptor)) continue;
            result.descriptors.add(e);
        }
        this.modified = !result.isEmpty();
        return result;
    }

    public boolean hasUnsuppressed(List selection) {
        for (Object element : selection) {
            if (!(element instanceof BreakdownElementWrapperItemProvider ? !this.isSuppressed((BreakdownElementWrapperItemProvider)element) : element instanceof BreakdownElement && !this.isSuppressed((BreakdownElement)element))) continue;
            return true;
        }
        return false;
    }

    public boolean isSaveNeeded() {
        return this.modified;
    }

    public void saveIsDone() {
        this.modified = false;
    }

    protected boolean __isSuppressed(ComposedBreakdownElementWrapperItemProvider composedWrapper) {
        for (Object element : composedWrapper.getValues()) {
            if (this.isSuppressed(element)) continue;
            return false;
        }
        return true;
    }

    public boolean isSuppressed(Object e) {
        if (e == null) {
            return true;
        }
        ComposedBreakdownElementWrapperItemProvider composedWrapper = ProcessUtil.getComposedWrapper(e);
        if (composedWrapper != null) {
            return this.__isSuppressed(composedWrapper);
        }
        if (this.internalUnsuppressedElements.contains(e)) {
            return false;
        }
        if (e instanceof BreakdownElementWrapperItemProvider) {
            return this.__isSuppressed((BreakdownElementWrapperItemProvider)e);
        }
        if (e instanceof BreakdownElement) {
            return this.__isSuppressed((BreakdownElement)e);
        }
        Object targetObj = null;
        if (e instanceof WrapperItemProvider) {
            targetObj = ((WrapperItemProvider)e).getValue();
        } else if (e instanceof ItemProviderAdapter) {
            targetObj = ((ItemProviderAdapter)e).getTarget();
        }
        if (targetObj != null && targetObj != e) {
            return this.isSuppressed(targetObj);
        }
        return false;
    }

    public boolean updateSuppressionFromBase(BreakdownElementWrapperItemProvider wrapper) {
        String path = Suppression.getPath(wrapper);
        BreakdownElement e = this.getSuppressed(wrapper, true, false, true, false, null);
        boolean ret = e != null ? this.getSuppressedExternalElementPaths().add(path) : this.getSuppressedExternalElementPaths().remove(path);
        if (ret) {
            this.modified = true;
        }
        return ret;
    }

    public String checkDuplicateNameAfterReveal(Collection selectionToRevealOrSuppress, AdapterFactory adapterFactory) {
        Collection elementsToReveal = this.getApplicableItems(selectionToRevealOrSuppress, false);
        for (Object element : elementsToReveal) {
            ITreeItemContentProvider itemProvider;
            Object parent;
            if (element instanceof BreakdownElement) {
                BreakdownElement be = (BreakdownElement)element;
                String msg = ProcessUtil.checkBreakdownElementName(adapterFactory, be, be.getName(), this);
                if (msg != null) {
                    return LibraryEditResources.Suppression_nameDuplication;
                }
                msg = ProcessUtil.checkBreakdownElementPresentationName(adapterFactory, be, be.getPresentationName(), this);
                if (msg == null) continue;
                return LibraryEditResources.Suppression_presentationNameDuplication;
            }
            Object unwrapped = TngUtil.unwrap(element);
            if (!(unwrapped instanceof BreakdownElement) || !((parent = (itemProvider = (ITreeItemContentProvider)adapterFactory.adapt(element, ITreeItemContentProvider.class)).getParent(element)) instanceof BreakdownElement)) continue;
            itemProvider = (ITreeItemContentProvider)adapterFactory.adapt(parent, ITreeItemContentProvider.class);
            Collection siblings = itemProvider.getChildren(parent);
            MethodElement linkedElement = null;
            if (element instanceof Descriptor) {
                linkedElement = ProcessUtil.getAssociatedElement((Descriptor)element);
            }
            try {
                this.internalUnsuppressedElements.add(element);
                for (Object sibling : siblings) {
                    MethodElement otherLinkedElement;
                    BreakdownElement be;
                    if (!(sibling instanceof BreakdownElement) || (be = (BreakdownElement)sibling).getSuppressed().booleanValue() || linkedElement != null && sibling instanceof Descriptor && (otherLinkedElement = ProcessUtil.getAssociatedElement((Descriptor)element)) == linkedElement) continue;
                    String msg = ProcessUtil.checkBreakdownElementName(adapterFactory, be, be.getName(), this);
                    if (msg != null) {
                        String string = LibraryEditResources.Suppression_nameDuplication;
                        return string;
                    }
                    msg = ProcessUtil.checkBreakdownElementPresentationName(adapterFactory, be, be.getPresentationName(), this);
                    if (msg == null) continue;
                    String string = LibraryEditResources.Suppression_presentationNameDuplication;
                    return string;
                }
            }
            finally {
                this.internalUnsuppressedElements.remove(element);
            }
        }
        return null;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public Object getObjectByPath(String[] guidPath, AdapterFactory adapterFactory) {
        if (guidPath.length == 0 || adapterFactory == null || !guidPath[0].equals(this.process.getGuid())) {
            return null;
        }
        object /* !! */  = this.process;
        len = guidPath.length;
        i = 1;
        while (i < len) {
            adapter = (ITreeItemContentProvider)adapterFactory.adapt((Object)object /* !! */ , ITreeItemContentProvider.class);
            found = false;
            rolledUpAdapter = null;
            iter = null;
            try {
                if (TngUtil.unwrap(object /* !! */ ) instanceof Activity) {
                    if (adapter instanceof BSActivityItemProvider) {
                        activityItemProvider = (BSActivityItemProvider)adapter;
                        if (activityItemProvider.isRolledUp()) {
                            activityItemProvider.basicSetRolledUp(false);
                            rolledUpAdapter = activityItemProvider;
                        }
                    } else if (adapter instanceof IBSItemProvider && (itemProvider = (IBSItemProvider)adapter).isRolledUp()) {
                        itemProvider.setRolledUp(false);
                        rolledUpAdapter = itemProvider;
                    }
                }
                iter = adapter.getChildren((Object)object /* !! */ ).iterator();
                if (true) ** GOTO lbl33
            }
            finally {
                if (rolledUpAdapter != null) {
                    rolledUpAdapter.setRolledUp(true);
                }
            }
            do {
                if (!((e = TngUtil.unwrap(child = iter.next())) instanceof MethodElement) || !((MethodElement)e).getGuid().equals(guidPath[i])) continue;
                found = true;
                object /* !! */  = child;
                break;
lbl33:
                // 2 sources

            } while (iter.hasNext());
            if (!found) {
                return null;
            }
            ++i;
        }
        return object /* !! */ ;
    }

    public boolean isSuppressed(String[] guidPath, AdapterFactory adapterFactory) throws IllegalArgumentException {
        Object object = this.getObjectByPath(guidPath, adapterFactory);
        if (object == null) {
            throw new IllegalArgumentException("Could not find object with path '" + guidPath + "'");
        }
        return this.isSuppressed(object);
    }

    public static Set getSuppressedItems(Process proc, AdapterFactory[] adapterFactories) {
        HashSet suppressedItems = new HashSet();
        Suppression suppression = new Suppression(proc);
        int i = 0;
        while (i < adapterFactories.length) {
            AdapterFactoryTreeIterator iter = new AdapterFactoryTreeIterator(adapterFactories[i], (Object)proc);
            while (iter.hasNext()) {
                Object item = iter.next();
                if (!suppression.isSuppressed(item)) continue;
                suppressedItems.add(item);
            }
            ++i;
        }
        return suppressedItems;
    }

    public boolean isItselfSuppressed(Object obj) {
        if (obj instanceof ProcessElement) {
            return ((ProcessElement)obj).getSuppressed();
        }
        if (obj instanceof BreakdownElementWrapperItemProvider && ProcessUtil.isInherited(obj)) {
            return this.isInSuppressedList((BreakdownElementWrapperItemProvider)obj);
        }
        if (obj instanceof BreakdownElementWrapperItemProvider && !ProcessUtil.isInherited(obj)) {
            Object object = TngUtil.unwrap(obj);
            return ((MethodElement)object).getSuppressed();
        }
        return false;
    }

    public boolean isSuppressed(Object obj, EStructuralFeature feature) {
        return this.isSuppressed(obj);
    }

    private static class Result {
        Collection elements = new ArrayList();
        Collection descriptors = new ArrayList();
        Collection paths = new ArrayList();

        Result() {
        }

        boolean isEmpty() {
            return this.elements.isEmpty() && this.paths.isEmpty();
        }

        void clear() {
            this.elements.clear();
            this.descriptors.clear();
            this.paths.clear();
        }
    }

    public static class SuppressionCommand
    extends AbstractCommand
    implements IResourceAwareCommand {
        protected Collection modifiedResources;
        protected List collection;
        protected Result result;
        protected boolean suppressed;
        protected Suppression suppression;

        public SuppressionCommand(Suppression suppression, List selection, boolean suppressed) {
            this.suppression = suppression;
            this.collection = selection;
            this.suppressed = suppressed;
        }

        public Collection getModifiedResources() {
            if (this.modifiedResources == null) {
                this.modifiedResources = Collections.singletonList(this.suppression.getProcess().eResource());
            }
            return this.modifiedResources;
        }

        public void execute() {
            this.result = this.suppression.setSuppressed(this.collection, this.suppressed);
            this.didExecute();
        }

        protected void didExecute() {
        }

        public void redo() {
            this.execute();
        }

        public void undo() {
            if (this.result != null && !this.result.isEmpty()) {
                if (!this.result.elements.isEmpty()) {
                    for (MethodElement e : this.result.elements) {
                        e.setSuppressed(Boolean.valueOf(!this.suppressed));
                    }
                }
                if (!this.result.paths.isEmpty()) {
                    for (Object path : this.result.paths) {
                        if (this.suppressed) {
                            this.suppression.getSuppressedExternalElementPaths().remove(path);
                            continue;
                        }
                        this.suppression.getSuppressedExternalElementPaths().add(path);
                    }
                }
                this.didUndo();
                this.result.clear();
            }
        }

        protected void didUndo() {
        }

        protected boolean prepare() {
            return true;
        }

        public Collection getResult() {
            if (!this.result.isEmpty()) {
                return this.collection;
            }
            return Collections.EMPTY_LIST;
        }

        public Collection getAffectedObjects() {
            return this.collection;
        }

        public boolean isReadOnlyElementAffected() {
            return !this.result.paths.isEmpty();
        }

        public void dispose() {
            if (this.result != null) {
                this.result.clear();
            }
            super.dispose();
        }
    }
}

