/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.common.utils;

import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.util.StringTokenizer;
import java.net.URI;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.epf.common.CommonPlugin;

public class StrUtil {
    public static final String EMPTY_STRING = "";
    public static final String TAB = "\t";
    private static final String REGEXP_ANY_SPECIAL_CHARS = "(`|~|!|@|#|\\$|%|\\^|&|\\*|\\(|\\)|\\+|=|\\[|\\]|\\||\\:|\"|<|>|\\?|/|'|\\s|\\\\)+";
    private static final String REGEXP_INVALID_PUBLISHED_PATH_CHARS = "(\\[|#|\\*|\\?|\"|<|>|\\||!|%|/|\\])+";
    private static final String REGEXP_INVALID_PUBLISHED_PATH_CHARS_LINUX = "(\\[|#|\\*|\\?|\"|<|>|\\||!|%|\\])+";
    private static final String REGEXP_INVALID_FILENAME_CHARS = "(\\[|#|/|\\\\|\\:|\\*|\\?|\"|<|>|\\||\\]|\\s)+";
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    public static final String LINE_FEED = System.getProperty("line.separator");
    public static final String ESCAPED_LF = "&#xA;";
    public static final String ESCAPED_CR = "&#xD;";
    public static final String ESCAPED_LINE_FEED = LINE_FEED.replace("\n", "&#xA;").replace("\r", "&#xD;");
    public static final String LINE_FEED_REGEX = LINE_FEED.replaceAll("\\\\", "\\\\");
    public static final String ESCAPED_LINE_FEED_REGEX = ESCAPED_LINE_FEED;
    public static final String HTML_BREAK = "<br/>";
    public static final String HTML_COPY = "&copy;";
    public static final String HTML_EURO = "&euro;";
    public static final String HTML_REG = "&reg;";
    public static final String HTML_TRADEMARK = "&trade;";
    public static boolean during_migration = false;

    private StrUtil() {
    }

    public static boolean isNull(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isBlank(String str) {
        return str == null || str.trim().length() == 0;
    }

    public static String trim(String str) {
        return str == null ? null : str.trim();
    }

    public static String removeWhiteSpaceChars(String str) {
        int len = str == null ? 0 : str.length();
        int i = 0;
        while (i < len) {
            switch (str.charAt(i)) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    break;
                }
                default: {
                    return str;
                }
            }
            ++i;
        }
        return EMPTY_STRING;
    }

    public static String removeNewlines(String str) {
        StringBuffer sb = new StringBuffer();
        int len = str == null ? 0 : str.length();
        int i = 0;
        while (i < len) {
            char c = str.charAt(i);
            switch (c) {
                case '\n': 
                case '\r': {
                    break;
                }
                default: {
                    sb.append(c);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public static String[] split(String str, String sep, int count) {
        if (str == null || count == 0 || count < -1) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(str, sep, count != -1);
        if (count == -1) {
            count = tokenizer.countTokens();
        }
        String[] result = new String[count];
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            String t = tokenizer.nextToken();
            if (i < count) {
                if (t.length() == 1 && sep.indexOf(t) != -1) continue;
                result[i++] = t;
                continue;
            }
            int n = count - 1;
            result[n] = String.valueOf(result[n]) + t;
        }
        return result;
    }

    public static String[] split(String str, String sep) {
        return StrUtil.split(str, sep, -1);
    }

    public static String replace(String str, String src, String tgt) {
        int index;
        if (str == null || str.length() == 0 || src == null || src.length() == 0) {
            return str;
        }
        String tmpStr = str;
        while ((index = tmpStr.indexOf(src)) != -1) {
            tmpStr = String.valueOf(tmpStr.substring(0, index)) + tgt + tmpStr.substring(index + src.length());
        }
        return tmpStr;
    }

    public static int getIntValue(String str, int defaultValue) {
        if (StrUtil.isBlank(str)) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    public static byte[] getUTF8Bytes(String str) {
        char[] c = str.toCharArray();
        int len = c.length;
        int count = 0;
        int i = 0;
        while (i < len) {
            char ch = c[i];
            count = ch <= '\u007f' ? ++count : (ch <= '\u07ff' ? (count += 2) : (count += 3));
            ++i;
        }
        byte[] b = new byte[count];
        int off = 0;
        int i2 = 0;
        while (i2 < len) {
            char ch = c[i2];
            if (ch <= '\u007f') {
                b[off++] = (byte)ch;
            } else if (ch <= '\u07ff') {
                b[off++] = (byte)(ch >> 6 | 0xC0);
                b[off++] = (byte)(ch & 0x3F | 0x80);
            } else {
                b[off++] = (byte)(ch >> 12 | 0xE0);
                b[off++] = (byte)(ch >> 6 & 0x3F | 0x80);
                b[off++] = (byte)(ch & 0x3F | 0x80);
            }
            ++i2;
        }
        return b;
    }

    private static char toHex(int value) {
        return HEX_DIGITS[value & 0xF];
    }

    public static String toEscapedUnicode(String str, boolean skipASCII) {
        int len = str.length();
        StringBuffer result = new StringBuffer(len * 2);
        int i = 0;
        while (i < len) {
            char ch = str.charAt(i);
            if (skipASCII && ch < '~') {
                result.append(ch);
            } else {
                result.append("\\u");
                result.append(StrUtil.toHex(ch >> 12 & 0xF));
                result.append(StrUtil.toHex(ch >> 8 & 0xF));
                result.append(StrUtil.toHex(ch >> 4 & 0xF));
                result.append(StrUtil.toHex(ch & 0xF));
            }
            ++i;
        }
        return result.toString();
    }

    public static String getEscapedHTML(String html) {
        if (html == null || html.length() == 0) {
            return EMPTY_STRING;
        }
        StringBuffer result = new StringBuffer();
        int length = html.length();
        int i = 0;
        while (i < length) {
            char ch = html.charAt(i);
            switch (ch) {
                case '%': {
                    if (i + 4 < length) {
                        String hexStr = html.substring(i + 1, i + 5);
                        boolean validHextStr = true;
                        int j = 0;
                        while (j < hexStr.length()) {
                            char c = hexStr.charAt(j);
                            if (!(c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F')) {
                                validHextStr = false;
                                break;
                            }
                            ++j;
                        }
                        if (validHextStr && hexStr.startsWith("20")) {
                            result.append("%20");
                            i += 2;
                            break;
                        }
                        if (validHextStr) {
                            try {
                                int codePoint = Integer.parseInt(hexStr, 16);
                                char[] c = UCharacter.toChars((int)codePoint);
                                result.append(c);
                                i += 4;
                                break;
                            }
                            catch (NumberFormatException numberFormatException) {
                            }
                            catch (Exception e) {
                                CommonPlugin.getDefault().getLogger().logError(e);
                            }
                        }
                    }
                    result.append(ch);
                    break;
                }
                case '\u00a9': {
                    result.append(HTML_COPY);
                    break;
                }
                case '\u00ae': {
                    result.append(HTML_REG);
                    break;
                }
                case '\u20ac': {
                    result.append(HTML_EURO);
                    break;
                }
                case '\u2122': {
                    result.append(HTML_TRADEMARK);
                    break;
                }
                default: {
                    result.append(ch);
                }
            }
            ++i;
        }
        return result.toString();
    }

    public static String getPlainText(String html) {
        if (html == null) {
            return EMPTY_STRING;
        }
        Pattern p_plaintext_filter = Pattern.compile("<[^>]*?>", 34);
        Pattern p_plaintext_filter2 = Pattern.compile("&.{1,5}[^;];", 34);
        Pattern p_plaintext_filter3 = Pattern.compile("\\s+", 34);
        String result = html.replaceAll(p_plaintext_filter.pattern(), " ").replaceAll(p_plaintext_filter2.pattern(), " ").replaceAll(p_plaintext_filter3.pattern(), " ");
        return result;
    }

    public static String makeValidFileName(String str) {
        if (str == null) {
            return EMPTY_STRING;
        }
        return StrUtil.getPlainText(str).replaceAll(REGEXP_INVALID_FILENAME_CHARS, " ").trim();
    }

    public static String removeSpecialCharacters(String str) {
        if (str == null) {
            return EMPTY_STRING;
        }
        return StrUtil.getPlainText(str).replaceAll(REGEXP_ANY_SPECIAL_CHARS, " ").trim();
    }

    public static boolean isValidPublishPath(String path) {
        if (Platform.getOS().equals("win32")) {
            return path.replaceAll(REGEXP_INVALID_PUBLISHED_PATH_CHARS, EMPTY_STRING).equals(path);
        }
        return path.replaceAll(REGEXP_INVALID_PUBLISHED_PATH_CHARS_LINUX, EMPTY_STRING).equals(path);
    }

    public static String toLower(String str) {
        if (Platform.getNL().startsWith("de")) {
            return str;
        }
        return str.toLowerCase();
    }

    public static String escape(String str) {
        return str.replaceAll("'", "\\\\'").replaceAll("\"", "\\\\\"");
    }

    public static String[] convertListToStrArray(List list) {
        if (list != null) {
            int cnt = list.size();
            String[] strArray = new String[cnt];
            int i = 0;
            while (i < cnt) {
                String str = (String)list.get(i);
                strArray[i] = new String(str);
                ++i;
            }
            return strArray;
        }
        return null;
    }

    public static boolean isValidName(String name) {
        return name.replaceAll(REGEXP_ANY_SPECIAL_CHARS, EMPTY_STRING).equals(name);
    }

    public static void main(String[] args) {
        String text = "A&%      `&#           $~!@#$%^&*()_-+={}[\"]:|\\:;\"'<,>.?/ \t\r\nZ";
        System.out.println("[" + text + "] <== text");
        System.out.println("[" + text.replaceAll(REGEXP_ANY_SPECIAL_CHARS, " ") + "] <== All");
        System.out.println("[" + text.replaceAll(REGEXP_INVALID_FILENAME_CHARS, " ") + "] <== File Name");
        System.out.println("[" + text.replaceAll(REGEXP_INVALID_PUBLISHED_PATH_CHARS, " ") + "] <== path");
        System.out.println("[" + text.replaceAll(REGEXP_INVALID_PUBLISHED_PATH_CHARS_LINUX, " ") + "] <== path, Linux");
        System.out.println(EMPTY_STRING);
    }

    public static String convertNewlinesToHTML(String text) {
        if (text != null) {
            text = text.replaceAll(LINE_FEED_REGEX, HTML_BREAK + LINE_FEED);
            text = text.replaceAll(ESCAPED_LINE_FEED_REGEX, HTML_BREAK + ESCAPED_LINE_FEED);
        }
        return text;
    }

    public static URI toURI(String pathStr) {
        if (pathStr != null && pathStr.length() > 0) {
            IPath path = Path.fromOSString((String)pathStr);
            try {
                return path.toFile().toURI();
            }
            catch (Exception e) {
                CommonPlugin.getDefault().getLogger().logError(e);
            }
        }
        return null;
    }

    public static String escapeChar(String text, char c) {
        int i = text.indexOf(c);
        if (i < 0) {
            return text;
        }
        int start = 0;
        StringBuffer buffer = new StringBuffer();
        while (i > start) {
            buffer.append(text.substring(start, i)).append("\\");
            start = i;
            i = text.indexOf(c, start + 1);
        }
        buffer.append(text.substring(start));
        return buffer.toString();
    }
}

