/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.common.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.runtime.IProgressMonitor;

public class ZipUtil {
    public static void createZipFile(String zipFilePath, String contentPath, IProgressMonitor monitor) throws IOException {
        ZipOutputStream out = null;
        try {
            try {
                out = new ZipOutputStream(new FileOutputStream(zipFilePath));
                File contentDir = new File(contentPath);
                ZipUtil.populateZipFile(out, contentDir.getAbsolutePath(), contentDir, monitor);
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception exception) {}
            }
            throw throwable;
        }
        if (out != null) {
            try {
                out.close();
            }
            catch (Exception exception) {}
        }
    }

    public static void populateZipFile(ZipOutputStream out, String rootPath, File file, IProgressMonitor monitor) throws IOException {
        File[] files = file.listFiles();
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                if (files[i].isDirectory()) {
                    ZipUtil.populateZipFile(out, rootPath, files[i], monitor);
                } else {
                    int len;
                    String filePath = files[i].getAbsolutePath();
                    FileInputStream in = new FileInputStream(filePath);
                    String relativePath = filePath.substring(rootPath.length() + 1);
                    out.putNextEntry(new ZipEntry(relativePath));
                    byte[] buffer = new byte[1024];
                    while ((len = in.read(buffer)) > 0) {
                        out.write(buffer, 0, len);
                    }
                    out.closeEntry();
                    in.close();
                }
                ++i;
            }
        }
    }
}

