/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.parts;

import java.util.List;
import org.eclipse.draw2d.DeferredUpdateManager;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.UpdateManager;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.internal.parts.ElementToEditPartsMap;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramEditDomain;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramGraphicalViewer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.util.TransferDragSourceListener;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class DiagramGraphicalViewer
extends ScrollingGraphicalViewer
implements IDiagramGraphicalViewer {
    private ResourceManager resourceManager;
    private boolean selectionEventPending = false;
    private ElementToEditPartsMap elementToEditPartsMap = new ElementToEditPartsMap();
    private IPreferenceStore workspacePreferenceStore;
    private boolean initializing;

    public void enableUpdates(boolean enable) {
        if (enable) {
            this.getLightweightSystemWithUpdateToggle().enableUpdates();
        } else {
            this.getLightweightSystemWithUpdateToggle().disableUpdates();
        }
    }

    public boolean areUpdatesDisabled() {
        return this.getLightweightSystemWithUpdateToggle().getToggleUpdateManager().shouldDisableUpdates();
    }

    private LightweightSystemWithUpdateToggle getLightweightSystemWithUpdateToggle() {
        return (LightweightSystemWithUpdateToggle)this.getLightweightSystem();
    }

    protected LightweightSystem createLightweightSystem() {
        LightweightSystemWithUpdateToggle lws = new LightweightSystemWithUpdateToggle();
        lws.setUpdateManager((UpdateManager)new ToggleUpdateManager());
        return lws;
    }

    protected void hookControl() {
        super.hookControl();
        if (this.resourceManager == null) {
            this.resourceManager = new LocalResourceManager(JFaceResources.getResources());
        }
    }

    public void removeDragSourceListener(TransferDragSourceListener listener) {
        this.getDelegatingDragAdapter().removeDragSourceListener(listener);
        this.refreshDragSourceAdapter();
    }

    public void removeDropTargetListener(TransferDropTargetListener listener) {
        this.getDelegatingDropAdapter().removeDropTargetListener(listener);
        this.refreshDropTargetAdapter();
    }

    public void flush() {
        super.flush();
        if (this.selectionEventPending) {
            this.flushSelectionEvents(this.getSelection());
        }
    }

    protected void fireSelectionChanged() {
        if (this.selectionEventPending) {
            return;
        }
        this.selectionEventPending = true;
        Display display = PlatformUI.getWorkbench().getDisplay();
        if (display != null) {
            display.asyncExec(new Runnable(){

                public void run() {
                    DiagramGraphicalViewer.this.flushSelectionEvents(DiagramGraphicalViewer.this.getSelection());
                }
            });
        }
    }

    protected void flushSelectionEvents(ISelection sel) {
        this.selectionEventPending = false;
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, sel);
        Object[] array = this.selectionListeners.toArray();
        int i = 0;
        while (i < array.length) {
            ISelectionChangedListener l = (ISelectionChangedListener)array[i];
            if (this.selectionListeners.contains(l)) {
                l.selectionChanged(event);
            }
            ++i;
        }
    }

    private void fireEmptySelection() {
        if (this.selectionEventPending) {
            return;
        }
        this.selectionEventPending = true;
        Display display = PlatformUI.getWorkbench().getDisplay();
        if (display != null) {
            display.asyncExec(new Runnable(){

                public void run() {
                    DiagramGraphicalViewer.this.flushSelectionEvents(DiagramGraphicalViewer.this.getSelection());
                    DiagramGraphicalViewer.this.flushSelectionEvents((ISelection)StructuredSelection.EMPTY);
                }
            });
        }
    }

    public IDiagramEditDomain getDiagramEditDomain() {
        return (IDiagramEditDomain)this.getEditDomain();
    }

    public List findEditPartsForElement(String elementIdStr, Class editPartClass) {
        return this.elementToEditPartsMap.findEditPartsForElement(elementIdStr, editPartClass);
    }

    public void registerEditPartForElement(String elementIdStr, EditPart ep) {
        this.elementToEditPartsMap.registerEditPartForElement(elementIdStr, ep);
    }

    public void unregisterEditPartForElement(String elementIdStr, EditPart ep) {
        this.elementToEditPartsMap.unregisterEditPartForElement(elementIdStr, ep);
    }

    public void hookWorkspacePreferenceStore(IPreferenceStore store) {
        this.workspacePreferenceStore = store;
    }

    public IPreferenceStore getWorkspaceViewerPreferenceStore() {
        return this.workspacePreferenceStore;
    }

    public final ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    protected void unhookControl() {
        this.fireEmptySelection();
        super.unhookControl();
        if (this.resourceManager != null) {
            this.resourceManager.dispose();
        }
    }

    public void setContents(EditPart editpart) {
        this.initializing = true;
        try {
            super.setContents(editpart);
        }
        finally {
            this.initializing = false;
        }
    }

    public boolean isInitializing() {
        return this.initializing;
    }

    private class LightweightSystemWithUpdateToggle
    extends LightweightSystem {
        private LightweightSystemWithUpdateToggle() {
        }

        public ToggleUpdateManager getToggleUpdateManager() {
            return (ToggleUpdateManager)this.getUpdateManager();
        }

        public void disableUpdates() {
            this.getToggleUpdateManager().setDisableUpdates(true);
        }

        public void enableUpdates() {
            this.getToggleUpdateManager().setDisableUpdates(false);
        }
    }

    private class ToggleUpdateManager
    extends DeferredUpdateManager {
        private boolean disableUpdates = false;

        private ToggleUpdateManager() {
        }

        public boolean shouldDisableUpdates() {
            return this.disableUpdates;
        }

        protected void sendUpdateRequest() {
            PlatformUI.getWorkbench().getDisplay().asyncExec((Runnable)new DeferredUpdateManager.UpdateRequest((DeferredUpdateManager)this));
        }

        public synchronized void setDisableUpdates(boolean disableUpdates) {
            boolean prevDisableUpdates = this.disableUpdates;
            this.disableUpdates = disableUpdates;
            if (!disableUpdates && prevDisableUpdates != disableUpdates) {
                this.sendUpdateRequest();
            }
        }

        public synchronized void performUpdate() {
            if (!this.shouldDisableUpdates()) {
                super.performUpdate();
            }
        }

        public void performValidation() {
            if (!this.shouldDisableUpdates()) {
                super.performValidation();
            }
        }

        public void queueWork() {
            if (!this.shouldDisableUpdates()) {
                super.queueWork();
            }
        }
    }
}

