/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.dtd.schema;

import org.eclipse.ant.internal.ui.dtd.IAtom;
import org.eclipse.ant.internal.ui.dtd.IDfm;
import org.eclipse.ant.internal.ui.dtd.util.Factory;
import org.eclipse.ant.internal.ui.dtd.util.FactoryObject;
import org.eclipse.ant.internal.ui.dtd.util.MapHolder;
import org.eclipse.ant.internal.ui.dtd.util.SortedMap;

public class Dfm
extends MapHolder
implements IDfm,
FactoryObject {
    public boolean accepting;
    public boolean empty;
    public boolean any;
    public int id;
    private static int unique = 0;
    private static Factory factory = new Factory();
    private Dfm fNext;

    public static Dfm dfm(boolean accepting) {
        Dfm dfm = Dfm.free();
        dfm.accepting = accepting;
        return dfm;
    }

    protected Dfm() {
    }

    private static Dfm free() {
        Dfm dfm = (Dfm)factory.getFree();
        if (dfm == null) {
            dfm = new Dfm();
        }
        dfm.any = false;
        dfm.empty = false;
        dfm.accepting = false;
        dfm.id = unique++;
        return dfm;
    }

    public static Dfm dfm(IAtom accept, Dfm follow) {
        Dfm dfm = Dfm.free();
        dfm.keys = new Object[1];
        dfm.keys[0] = accept;
        dfm.values = new Object[1];
        dfm.values[0] = follow;
        return dfm;
    }

    public static void free(Dfm dfm) {
        dfm.setKeys(null);
        dfm.setValues(null);
        factory.setFree(dfm);
    }

    public boolean isAccepting() {
        return this.accepting;
    }

    public IDfm advance(String name) {
        if (this.any) {
            return this;
        }
        if (this.empty) {
            return null;
        }
        if (this.keys == null) {
            return null;
        }
        SortedMap map = Dfm.getIndirectStringMap(this);
        Dfm dfm = (Dfm)map.get(name);
        Dfm.freeMap(map);
        return dfm;
    }

    public String[] getAccepts() {
        if (this.keys == null) {
            return new String[0];
        }
        String[] s = new String[this.keys.length];
        int i = 0;
        while (i < s.length) {
            s[i] = this.keys[i].toString();
            ++i;
        }
        return s;
    }

    public Dfm[] getFollows() {
        if (this.values == null) {
            return new Dfm[0];
        }
        Dfm[] s = new Dfm[this.values.length];
        System.arraycopy(this.values, 0, s, 0, this.values.length);
        return s;
    }

    public void merge(Dfm other) {
        this.accepting |= other.accepting;
        SortedMap map = Dfm.getIndirectStringMap(this);
        SortedMap othermap = Dfm.getIndirectStringMap(other);
        map.merge(othermap);
        Dfm.freeMap(map);
        Dfm.freeMap(othermap);
    }

    public SortedMap getMap() {
        return Dfm.getIndirectStringMap(this);
    }

    public FactoryObject next() {
        return this.fNext;
    }

    public void next(FactoryObject obj) {
        this.fNext = (Dfm)obj;
    }

    public boolean isAny() {
        return this.any;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public IAtom getAtom(String name) {
        Object[] allKeys = this.getKeys();
        if (this.empty || allKeys == null) {
            return null;
        }
        SortedMap map = Dfm.getIndirectStringMap(this);
        int index = map.keyIndex(name);
        if (index < 0) {
            return null;
        }
        return (IAtom)allKeys[index];
    }

    public IDfm advance(String namespace, String localname) {
        return this.advance(localname);
    }
}

