/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.model.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.epf.diagram.model.ActivityDetailDiagram;
import org.eclipse.epf.diagram.model.Diagram;
import org.eclipse.epf.diagram.model.ModelFactory;
import org.eclipse.epf.diagram.model.ModelPackage;
import org.eclipse.epf.diagram.model.Node;
import org.eclipse.epf.diagram.model.NodeContainer;
import org.eclipse.epf.diagram.model.RoleNode;
import org.eclipse.epf.diagram.model.RoleTaskComposite;
import org.eclipse.epf.diagram.model.TaskNode;
import org.eclipse.epf.diagram.model.WorkProductComposite;
import org.eclipse.epf.diagram.model.impl.ActivityDetailDiagramImpl;
import org.eclipse.epf.diagram.model.impl.NamedNodeImpl;
import org.eclipse.epf.diagram.model.impl.NodeContainerImpl;
import org.eclipse.epf.diagram.model.impl.NodeImpl;
import org.eclipse.epf.diagram.model.impl.TaskNodeImpl;
import org.eclipse.epf.diagram.model.util.GraphicalDataHelper;
import org.eclipse.epf.diagram.model.util.GraphicalDataManager;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.GraphNode;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Property;
import org.eclipse.epf.uma.RoleDescriptor;
import org.eclipse.epf.uma.SemanticModelBridge;
import org.eclipse.epf.uma.TaskDescriptor;
import org.eclipse.epf.uma.UMASemanticModelBridge;
import org.eclipse.epf.uma.ecore.util.OppositeFeature;
import org.eclipse.epf.uma.ecore.util.OppositeFeatureNotification;
import org.eclipse.epf.uma.util.AssociationHelper;

public class RoleTaskCompositeImpl
extends NodeContainerImpl
implements RoleTaskComposite {
    protected static final int ROW_INDEX_EDEFAULT = 0;
    protected int rowIndex = 0;
    private static final Comparator comparator = new Comparator(){

        public int compare(Object obj1, Object obj2) {
            if (obj1 == obj2) {
                return 0;
            }
            if (obj1 instanceof TaskNodeImpl && obj2 instanceof TaskNodeImpl) {
                TaskNodeImpl node1 = (TaskNodeImpl)obj1;
                TaskNodeImpl node2 = (TaskNodeImpl)obj2;
                if (node1.doGetIndex() > node2.doGetIndex()) {
                    return 1;
                }
            }
            return 0;
        }
    };

    protected RoleTaskCompositeImpl() {
        this.methodElementAdapter = new RoleDescriptorAdapter();
    }

    protected EClass eStaticClass() {
        return ModelPackage.Literals.ROLE_TASK_COMPOSITE;
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public void setRowIndex(int newRowIndex) {
        int oldRowIndex = this.rowIndex;
        this.rowIndex = newRowIndex;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 8, oldRowIndex, this.rowIndex));
        }
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 8: {
                return new Integer(this.getRowIndex());
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 8: {
                this.setRowIndex((Integer)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 8: {
                this.setRowIndex(0);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 8: {
                return this.rowIndex != 0;
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (rowIndex: ");
        result.append(this.rowIndex);
        result.append(')');
        return result.toString();
    }

    private static boolean contains(Collection mixedCollection, Object element) {
        Iterator iter = mixedCollection.iterator();
        while (iter.hasNext()) {
            if (element != TngUtil.unwrap(iter.next())) continue;
            return true;
        }
        return false;
    }

    public void setObject(Object newObject) {
        super.setObject(newObject);
        this.populateNodes(newObject);
    }

    public GraphNode getGraphNode(MethodElement methodElement) {
        if (this.isGraphicalDataRequired()) {
            String autolayout;
            if (this.getUMADiagram() == null) {
                return GraphicalDataManager.getInstance().createGraphNode(methodElement);
            }
            GraphNode node = this.findGraphNode(this.getUMADiagram(), methodElement);
            if (node == null) {
                node = GraphicalDataManager.getInstance().createGraphNode(methodElement);
                this.getUMADiagram().getContained().add(node);
            }
            if ((autolayout = GraphicalDataHelper.getAutoLayoutFlag((ActivityDetailDiagram)this.getDiagram())) != null) {
                GraphicalDataHelper.createProperty(node, "index", new Integer(this.rowIndex).toString());
            }
            return node;
        }
        return null;
    }

    public GraphNode findGraphNode(org.eclipse.epf.uma.Diagram diagram, Object methodElement) {
        for (GraphNode element : diagram.getContained()) {
            if (!(element.getSemanticModel() instanceof UMASemanticModelBridge) || methodElement != ((UMASemanticModelBridge)element.getSemanticModel()).getElement()) continue;
            Property property = GraphicalDataHelper.findProperty(element, "index");
            if (property != null) {
                String index = property.getValue();
                if (index == null || this.getRowIndex() != new Integer(index).intValue()) continue;
                return element;
            }
            return element;
        }
        return null;
    }

    private void removeNode(Object oldValue) {
        Diagram diagram = this.getDiagram();
        if (diagram == null) {
            System.err.println("RoleTaskCompositeImpl.removeNode(): [ERROR] no diagram");
        }
        HashSet<Node> removedNodes = new HashSet<Node>();
        Iterator iter = this.nodes.iterator();
        while (iter.hasNext()) {
            ActivityDetailDiagramImpl d;
            List list;
            Node node = (Node)iter.next();
            if (oldValue instanceof TaskDescriptor && node instanceof RoleNode && ((list = (d = (ActivityDetailDiagramImpl)this.getDiagram()).getRealizedPrimaryTaskDescriptors((RoleDescriptor)node.getObject())) == null || list.size() < 1)) {
                iter.remove();
                removedNodes.add(node);
            }
            if (node.getObject() != oldValue) continue;
            iter.remove();
            removedNodes.add(node);
            if (!(oldValue instanceof TaskDescriptor)) continue;
            Node wpnode = GraphicalDataHelper.findNode((ActivityDetailDiagram)this.getDiagram(), oldValue);
            this.getDiagram().getNodes().remove((Object)wpnode);
            wpnode = GraphicalDataHelper.findNode((ActivityDetailDiagram)this.getDiagram(), oldValue);
            this.getDiagram().getNodes().remove((Object)wpnode);
        }
        if (this.nodes.isEmpty()) {
            this.getDiagram().getNodes().remove((Object)this);
        }
    }

    private void addNode(TaskDescriptor descriptor) {
        this.addNode((Collection)this.getNodes(), descriptor);
    }

    private void addNode(Collection nodes, TaskDescriptor descriptor) {
        if (descriptor.getSuperActivities() == null) {
            return;
        }
        ActivityDetailDiagramImpl diagram = (ActivityDetailDiagramImpl)this.getDiagram();
        Node node = GraphicalDataHelper.findNode((NodeContainer)this, (Object)descriptor, TaskNode.class);
        if (node == null && (node = diagram.createNode(descriptor)) != null) {
            int i = this.getNextIndex((List)this.getNodes());
            if (node instanceof TaskNodeImpl) {
                ((TaskNodeImpl)node).doSetIndex(i + 1);
            }
            nodes.add(node);
            ArrayList inputOutputNodes = new ArrayList();
            diagram.createTaskInputOutputNodes(descriptor, inputOutputNodes);
            if (!inputOutputNodes.isEmpty()) {
                diagram.getNodes().addAll(inputOutputNodes);
                diagram.populateLinks(inputOutputNodes, false);
            }
        }
    }

    private void removeNode(Collection elements) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (Node node : nodes) {
            if (!elements.contains(node.getObject())) continue;
            nodes.add(node);
        }
        this.getNodes().removeAll(nodes);
    }

    private void addNode(Collection elements) {
        ArrayList nodes = new ArrayList();
        for (TaskDescriptor descriptor : elements) {
            this.addNode(nodes, descriptor);
        }
        this.getNodes().addAll(nodes);
    }

    public Class getMethodElementAdapterType() {
        return RoleDescriptorAdapter.class;
    }

    private int getNextIndex(List nodes) {
        int index = 0;
        for (Object obj : nodes) {
            int id;
            if (!(obj instanceof TaskNodeImpl) || (id = ((TaskNodeImpl)obj).doGetIndex()) <= index) continue;
            index = id;
        }
        return index;
    }

    public void createTaskInputOutputNodes(TaskDescriptor descriptor, Collection nodes) {
        WorkProductComposite newNode = null;
        if (!descriptor.getMandatoryInput().isEmpty()) {
            newNode = this.createWorkProductComposite(descriptor, 1);
            nodes.add(newNode);
        }
        if (!descriptor.getOutput().isEmpty()) {
            newNode = this.createWorkProductComposite(descriptor, 2);
            nodes.add(newNode);
        }
    }

    public WorkProductComposite createWorkProductComposite(TaskDescriptor taskDescriptor, int type) {
        WorkProductComposite workproductComposite = ModelFactory.eINSTANCE.createWorkProductComposite();
        workproductComposite.setUMAContainer(this.getGraphNode());
        workproductComposite.setDiagram(this.getDiagram());
        workproductComposite.setType(type);
        workproductComposite.setObject(taskDescriptor);
        return workproductComposite;
    }

    private TaskNode createTaskNode(TaskDescriptor td) {
        TaskNode taskNode = null;
        for (Node node : this.getNodes()) {
            TaskNode tn;
            if (!(node instanceof TaskNode) || (tn = (TaskNode)node).getLinkedElement() != td) continue;
            taskNode = tn;
            break;
        }
        if (taskNode == null) {
            taskNode = ModelFactory.eINSTANCE.createTaskNode();
            taskNode.setDiagram(this.getDiagram());
        }
        taskNode.setObject(td);
        return taskNode;
    }

    private RoleNode createRoleNode(RoleDescriptor rd) {
        RoleNode roleNode = null;
        for (Node node : this.getNodes()) {
            RoleNode rn;
            if (!(node instanceof RoleNode) || (rn = (RoleNode)node).getLinkedElement() != rd) continue;
            roleNode = rn;
            break;
        }
        if (roleNode == null) {
            roleNode = ModelFactory.eINSTANCE.createRoleNode();
            roleNode.setDiagram(this.getDiagram());
            roleNode.setObject(rd);
        }
        return roleNode;
    }

    public void populateNodes(Object newObject) {
        if (newObject instanceof RoleDescriptor) {
            RoleDescriptor roleDescriptor = (RoleDescriptor)newObject;
            ActivityDetailDiagramImpl diagram = (ActivityDetailDiagramImpl)this.getDiagram();
            Collection allElements = diagram.getAllBreakdownElements(true);
            ArrayList<Node> taskNodes = new ArrayList<Node>();
            List primaryTaskDescriptors = AssociationHelper.getPrimaryTaskDescriptors((RoleDescriptor)roleDescriptor);
            if (!primaryTaskDescriptors.isEmpty()) {
                ArrayList taskDescriptors = new ArrayList();
                taskDescriptors.addAll(primaryTaskDescriptors);
                HashSet<TaskDescriptor> selectedDescriptors = new HashSet<TaskDescriptor>();
                boolean autoLayout = ((ActivityDetailDiagramImpl)this.getDiagram()).isAutoLayout();
                if (autoLayout) {
                    int index = 0;
                    int rowTasksCount = 0;
                    int startCount = 0;
                    for (Object obj : allElements) {
                        if (!((obj = TngUtil.unwrap(obj)) instanceof TaskDescriptor) || !TngUtil.contains(taskDescriptors, obj)) continue;
                        TaskDescriptor taskDescriptor = (TaskDescriptor)obj;
                        if (startCount < this.rowIndex * GraphicalDataHelper.getTasksPerRow()) {
                            ++startCount;
                            continue;
                        }
                        if (selectedDescriptors.contains(taskDescriptor)) continue;
                        selectedDescriptors.add(taskDescriptor);
                        Node node = GraphicalDataHelper.findNode((NodeContainer)this, (Object)taskDescriptor, TaskNode.class);
                        if (node == null) {
                            node = this.createTaskNode(taskDescriptor);
                            TaskNodeImpl tn = (TaskNodeImpl)node;
                            if (autoLayout || tn.doGetIndex() == -1) {
                                tn.doSetIndex(index);
                            }
                        } else {
                            node.setObject(taskDescriptor);
                        }
                        ((NamedNodeImpl)node).setItemProvider(allElements);
                        if (rowTasksCount >= GraphicalDataHelper.getTasksPerRow()) break;
                        taskNodes.add(node);
                        if (node instanceof TaskNode) {
                            ((TaskNode)node).setIndex(index);
                            ++index;
                        }
                        ++rowTasksCount;
                    }
                    if (!autoLayout) {
                        Collections.sort(taskNodes, comparator);
                    }
                } else {
                    ArrayList<MethodElement> oldTaskDescriptors = new ArrayList<MethodElement>();
                    org.eclipse.epf.uma.Diagram umaDiagram = this.getUMADiagram();
                    if (umaDiagram != null) {
                        List graphNodes = umaDiagram.getContained();
                        for (GraphNode element : graphNodes) {
                            SemanticModelBridge bridge = element.getSemanticModel();
                            if (!(bridge instanceof UMASemanticModelBridge)) continue;
                            MethodElement taskObject = ((UMASemanticModelBridge)bridge).getElement();
                            List list = element.getList(12);
                            Property property = GraphicalDataHelper.getPropertyByKey(list, "wpCompositeType");
                            if (!taskDescriptors.contains(taskObject) || property != null) continue;
                            oldTaskDescriptors.add(taskObject);
                        }
                    } else {
                        for (Node node : this.getNodes()) {
                            if (!(node.getLinkedElement() instanceof TaskDescriptor)) continue;
                            oldTaskDescriptors.add(node.getLinkedElement());
                        }
                    }
                    for (TaskDescriptor taskDescriptor : oldTaskDescriptors) {
                        if (selectedDescriptors.contains(taskDescriptor) || !RoleTaskCompositeImpl.contains(allElements, taskDescriptor)) continue;
                        selectedDescriptors.add(taskDescriptor);
                        Node node = GraphicalDataHelper.findNode((NodeContainer)this.getDiagram(), (Object)taskDescriptor, TaskNode.class);
                        if (node == null) {
                            node = this.createTaskNode(taskDescriptor);
                            ((NamedNodeImpl)node).setItemProvider(allElements);
                        }
                        taskNodes.add(node);
                    }
                }
            }
            if (!taskNodes.isEmpty()) {
                NamedNodeImpl namedNode = (NamedNodeImpl)((Object)this.createRoleNode(roleDescriptor));
                namedNode.visible = true;
                namedNode.setItemProvider(allElements);
                this.getNodes().add((Object)namedNode);
                taskNodes.add(namedNode);
            }
            this.selectNodes(taskNodes);
        }
    }

    private class RoleDescriptorAdapter
    extends NodeImpl.TransactionalNodeLink {
        private RoleDescriptorAdapter() {
        }

        protected void handleNotification(Notification msg) {
            OppositeFeature feature;
            if (msg instanceof OppositeFeatureNotification && (feature = ((OppositeFeatureNotification)msg).getOppsiteFeature()) == AssociationHelper.RoleDescriptor_PrimaryTaskDescriptors) {
                switch (msg.getEventType()) {
                    case 3: {
                        RoleTaskCompositeImpl.this.addNode((TaskDescriptor)msg.getNewValue());
                        break;
                    }
                    case 4: {
                        RoleTaskCompositeImpl.this.removeNode(msg.getOldValue());
                        break;
                    }
                    case 5: {
                        RoleTaskCompositeImpl.this.addNode((Collection)msg.getNewValue());
                        break;
                    }
                    case 6: {
                        RoleTaskCompositeImpl.this.removeNode((Collection)msg.getOldValue());
                    }
                }
                return;
            }
            switch (msg.getFeatureID(Activity.class)) {
                case 40: {
                    switch (msg.getEventType()) {
                        default: 
                    }
                }
            }
        }
    }
}

