/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.model.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.epf.diagram.model.Link;
import org.eclipse.epf.diagram.model.ModelFactory;
import org.eclipse.epf.diagram.model.ModelPackage;
import org.eclipse.epf.diagram.model.Node;
import org.eclipse.epf.diagram.model.WorkProductDependencyDiagram;
import org.eclipse.epf.diagram.model.WorkProductNode;
import org.eclipse.epf.diagram.model.impl.DiagramImpl;
import org.eclipse.epf.diagram.model.impl.NamedNodeImpl;
import org.eclipse.epf.diagram.model.util.GraphicalDataHelper;
import org.eclipse.epf.diagram.model.util.IAdapterFactoryFilter;
import org.eclipse.epf.diagram.model.util.IWPDDiagramChangeListener;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.process.BreakdownElementWrapperItemProvider;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.Artifact;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.Deliverable;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Outcome;
import org.eclipse.epf.uma.UmaFactory;
import org.eclipse.epf.uma.WorkProductDescriptor;

public class WorkProductDependencyDiagramImpl
extends DiagramImpl
implements WorkProductDependencyDiagram {
    private static final AdapterFactory[] DEFAULT_ADAPTER_FACTORIES = new AdapterFactory[]{TngAdapterFactory.INSTANCE.getPBS_ComposedAdapterFactory()};

    protected WorkProductDependencyDiagramImpl() {
        this.diagramChangeListener = new WPDDiagramChangeListener();
    }

    protected Class getDiagramChangeListenerType() {
        return IWPDDiagramChangeListener.class;
    }

    protected EClass eStaticClass() {
        return ModelPackage.Literals.WORK_PRODUCT_DEPENDENCY_DIAGRAM;
    }

    public Collection getChildren() {
        ITreeItemContentProvider adapter = null;
        AdapterFactory adapterFactory = null;
        if (this.wrapper != null) {
            List wrappers = ProcessUtil.getWrappers((BreakdownElementWrapperItemProvider)this.wrapper, (AdapterFactory[])DEFAULT_ADAPTER_FACTORIES);
            if (wrappers != null && wrappers.size() > 0) {
                adapter = (ITreeItemContentProvider)wrappers.get(0);
            }
        } else if (this.filter == null) {
            adapter = (ITreeItemContentProvider)TngAdapterFactory.INSTANCE.getPBS_ComposedAdapterFactory().adapt(this.getObject(), ITreeItemContentProvider.class);
        } else if (this.filter instanceof IAdapterFactoryFilter) {
            adapterFactory = ((IAdapterFactoryFilter)this.filter).getWPBSAdapterFactory();
            adapter = (ITreeItemContentProvider)adapterFactory.adapt(this.getObject(), ITreeItemContentProvider.class);
        }
        if (adapter != null) {
            ArrayList children = new ArrayList();
            this.extractChildren(adapter, this.getObject(), children, true);
            return children;
        }
        return Collections.EMPTY_LIST;
    }

    protected void populateNodes() {
        super.populateNodes();
        ArrayList<WorkProductNode> nodes = new ArrayList<WorkProductNode>();
        for (Object e : this.getChildren()) {
            BreakdownElementWrapperItemProvider wrapper;
            Object element = TngUtil.unwrap(e);
            if (!(element instanceof WorkProductDescriptor)) continue;
            WorkProductNode node = (WorkProductNode)GraphicalDataHelper.findNode(this, element);
            if (node == null) {
                node = (WorkProductNode)this.toNode((MethodElement)element);
            }
            if (e instanceof BreakdownElementWrapperItemProvider && (wrapper = (BreakdownElementWrapperItemProvider)e).isReadOnly()) {
                ((NamedNodeImpl)((Object)node)).itemProvider = wrapper;
                node.setReadOnly(true);
            }
            if (((WorkProductDescriptor)element).getWorkProduct() instanceof Artifact) {
                node.setType(1);
            }
            if (((WorkProductDescriptor)element).getWorkProduct() instanceof Deliverable) {
                node.setType(2);
            }
            if (((WorkProductDescriptor)element).getWorkProduct() instanceof Outcome) {
                node.setType(3);
            }
            nodes.add(node);
        }
        this.selectNodes(nodes);
    }

    protected Node toNode(MethodElement e) {
        if (e instanceof WorkProductDescriptor) {
            return super.toNode(e);
        }
        return null;
    }

    protected Node newNode() {
        return ModelFactory.eINSTANCE.createWorkProductNode();
    }

    protected int getType() {
        return 1;
    }

    protected Class getBreakdownElementType() {
        return WorkProductDescriptor.class;
    }

    protected void addToUmaModel(int position, Node addedNode) {
        if (addedNode.getObject() instanceof BreakdownElement) {
            ((Activity)this.getObject()).getBreakdownElements().add((BreakdownElement)addedNode.getObject());
        }
        super.addToUmaModel(position, addedNode);
    }

    protected void nodeAdded(int index, Node node) {
        if (node.getObject() == null && node instanceof WorkProductNode) {
            node.setObject(UmaFactory.eINSTANCE.createWorkProductDescriptor());
        }
        super.nodeAdded(index, node);
    }

    protected void populateLinks() {
        super.populateLinks();
        for (Node node : this.getNodes()) {
            ArrayList<Link> linksToRemove = new ArrayList<Link>();
            for (Link link : node.getIncomingConnections()) {
                if (this.isValid(link)) continue;
                linksToRemove.add(link);
            }
            for (Link link : linksToRemove) {
                GraphicalDataHelper.removeLink(link);
            }
            linksToRemove.clear();
            linksToRemove = null;
        }
        for (Node node : this.getNodes()) {
            List impactedBy;
            Object wbe = null;
            wbe = node.getObject();
            if (!(wbe instanceof WorkProductDescriptor) || (impactedBy = ((WorkProductDescriptor)wbe).getImpactedBy()).isEmpty()) continue;
            for (WorkProductDescriptor source : impactedBy) {
                Link link = this.findLink(node, source);
                if (link != null) continue;
                NamedNodeImpl nodeImpl = (NamedNodeImpl)node;
                boolean oldNotify = nodeImpl.notificationEnabled;
                try {
                    nodeImpl.notificationEnabled = false;
                    nodeImpl.addIncomingConnection((MethodElement)source);
                }
                finally {
                    nodeImpl.notificationEnabled = oldNotify;
                }
            }
        }
    }

    private boolean isValid(Link link) {
        return link.getSource() != null && link.getTarget() != null && this.getNodes().contains((Object)link.getSource()) && this.getNodes().contains((Object)link.getTarget());
    }

    public Link findLink(Node target, Object sourceLinkedElement) {
        for (Link link : target.getIncomingConnections()) {
            Node source = link.getSource();
            if (source.getLinkedElement() != sourceLinkedElement) continue;
            return link;
        }
        return null;
    }

    private class WPDDiagramChangeListener
    extends DiagramImpl.ActivityAdapter
    implements IWPDDiagramChangeListener {
        private WPDDiagramChangeListener() {
        }
    }
}

