/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.services;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.epf.services.IAccessController;
import org.eclipse.epf.services.IFileManager;
import org.eclipse.epf.services.ILibraryPersister;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Services {
    public static final String XMI_PERSISTENCE_TYPE = "xmi";
    private static final String namespace = "org.eclipse.epf.services";
    private static final String extensionPointName = "serviceProviders";
    private static IAccessController accessController;
    private static IFileManager fileManager;
    private static List<PersisterDescriptor> persisterDescriptors;
    private static Map<String, PersisterDescriptor> typeToLibraryPersisterDescriptorMap;
    private static String defaultPersistenceType;

    static {
        persisterDescriptors = new ArrayList<PersisterDescriptor>();
    }

    private static Object getService(String serviceName) {
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint(namespace, extensionPointName);
        if (extensionPoint != null) {
            IExtension[] extensions = extensionPoint.getExtensions();
            Bundle bundle = null;
            String className = null;
            int version = -1;
            int i = 0;
            while (i < extensions.length) {
                IExtension extension = extensions[i];
                String pluginId = extension.getNamespaceIdentifier();
                IConfigurationElement[] configElements = extension.getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    int otherVersion;
                    IConfigurationElement configElement = configElements[j];
                    if (serviceName.equals(configElement.getName()) && (otherVersion = Services.parseVersion(configElement.getAttribute("version"))) > version) {
                        className = configElement.getAttribute("class");
                        bundle = Platform.getBundle((String)pluginId);
                        version = otherVersion;
                    }
                    ++j;
                }
                ++i;
            }
            if (className != null) {
                try {
                    return bundle.loadClass(className).newInstance();
                }
                catch (Exception e) {
                    CommonPlugin.INSTANCE.log((Object)e);
                }
            }
        }
        return null;
    }

    public static int parseVersion(String str) {
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    private static Map<String, PersisterDescriptor> getTypeToLibraryPersisterDescriptorMap() {
        HashMap<String, PersisterDescriptor> typeToPersisterDescriptorMap = new HashMap<String, PersisterDescriptor>();
        String serviceName = "libraryPersister";
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint(namespace, extensionPointName);
        if (extensionPoint != null) {
            IExtension[] extensions = extensionPoint.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IExtension extension = extensions[i];
                String pluginId = extension.getNamespaceIdentifier();
                IConfigurationElement[] configElements = extension.getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    IConfigurationElement configElement = configElements[j];
                    if (serviceName.equals(configElement.getName())) {
                        try {
                            PersisterDescriptor descriptor = new PersisterDescriptor();
                            descriptor.pluginId = pluginId;
                            descriptor.type = configElement.getAttribute("type");
                            descriptor.className = configElement.getAttribute("class");
                            descriptor.isDefault = Boolean.parseBoolean(configElement.getAttribute("default"));
                            descriptor.version = Services.parseVersion(configElement.getAttribute("version"));
                            persisterDescriptors.add(descriptor);
                            if (descriptor.type != null) {
                                PersisterDescriptor desc = (PersisterDescriptor)typeToPersisterDescriptorMap.get(descriptor.type);
                                if (desc != null) {
                                    if (desc.version < descriptor.version) {
                                        typeToPersisterDescriptorMap.put(descriptor.type, descriptor);
                                        if (descriptor.isDefault) {
                                            defaultPersistenceType = descriptor.type;
                                        } else if (desc.isDefault) {
                                            defaultPersistenceType = null;
                                        }
                                    }
                                } else {
                                    typeToPersisterDescriptorMap.put(descriptor.type, descriptor);
                                    if (descriptor.isDefault) {
                                        defaultPersistenceType = descriptor.type;
                                    }
                                }
                            }
                        }
                        catch (Exception e) {
                            CommonPlugin.INSTANCE.log((Object)e);
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
        return typeToPersisterDescriptorMap;
    }

    public static final IAccessController getAccessController() {
        if (accessController == null) {
            accessController = (IAccessController)Services.getService("accessController");
        }
        return accessController;
    }

    public static final ILibraryPersister getLibraryPersister(String type) {
        PersisterDescriptor descriptor;
        if (typeToLibraryPersisterDescriptorMap == null) {
            typeToLibraryPersisterDescriptorMap = Services.getTypeToLibraryPersisterDescriptorMap();
        }
        if ((descriptor = typeToLibraryPersisterDescriptorMap.get(type)) != null) {
            if (descriptor.persister == null) {
                Bundle bundle = Platform.getBundle((String)descriptor.pluginId);
                try {
                    descriptor.persister = (ILibraryPersister)bundle.loadClass(descriptor.className).newInstance();
                }
                catch (Exception e) {
                    CommonPlugin.INSTANCE.log((Object)e);
                }
            }
            return descriptor.persister;
        }
        return null;
    }

    public static final ILibraryPersister getDefaultLibraryPersister() {
        return Services.getLibraryPersister(Services.getDefaultLibraryPersistenceType());
    }

    public static final String getDefaultLibraryPersistenceType() {
        if (defaultPersistenceType == null) {
            Services.getTypeToLibraryPersisterDescriptorMap();
            if (defaultPersistenceType == null && Services.getLibraryPersister(XMI_PERSISTENCE_TYPE) != null) {
                defaultPersistenceType = XMI_PERSISTENCE_TYPE;
            }
        }
        return defaultPersistenceType;
    }

    public static final IFileManager getFileManager() {
        if (fileManager == null) {
            fileManager = (IFileManager)Services.getService("fileManager");
        }
        return fileManager;
    }

    private static class PersisterDescriptor {
        String pluginId;
        String type;
        String className;
        boolean isDefault;
        int version;
        ILibraryPersister persister;

        private PersisterDescriptor() {
        }
    }
}

