/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.search.ui;

import org.eclipse.epf.authoring.ui.AuthoringPerspective;
import org.eclipse.epf.authoring.ui.BrowsingPerspective;
import org.eclipse.epf.authoring.ui.editors.EditorChooser;
import org.eclipse.epf.authoring.ui.views.ContentView;
import org.eclipse.epf.common.ui.util.PerspectiveUtil;
import org.eclipse.epf.library.ILibraryServiceListener;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.LibraryServiceListener;
import org.eclipse.epf.library.edit.util.ExtensionManager;
import org.eclipse.epf.library.ui.providers.ElementTreeLabelProvider;
import org.eclipse.epf.search.ui.SearchUIPlugin;
import org.eclipse.epf.search.ui.internal.ISearchResultProviderFactory;
import org.eclipse.epf.search.ui.internal.MethodElementViewSorter;
import org.eclipse.epf.search.ui.internal.SearchResultTableContentProvider;
import org.eclipse.epf.search.ui.internal.SearchResultTreeContentProvider;
import org.eclipse.epf.uma.ContentPackage;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.ProcessElement;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.search.ui.text.AbstractTextSearchViewPage;
import org.eclipse.search.ui.text.Match;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class MethodSearchResultPage
extends AbstractTextSearchViewPage
implements ISelectionChangedListener {
    private IStructuredContentProvider contentProvider;
    private ILabelProvider labelProvider = this.createLabelProvider();

    public MethodSearchResultPage() {
        LibraryService.getInstance().addListener((ILibraryServiceListener)new LibraryServiceListener(){

            public void libraryClosed(MethodLibrary library) {
                MethodSearchResultPage.this.getInput().removeAll();
            }
        });
    }

    public boolean isLayoutSupported(int layout) {
        return (layout & 1) != 0 || (layout & 2) != 0;
    }

    private static final ISearchResultProviderFactory getSearchResultProviderFactory() {
        return (ISearchResultProviderFactory)ExtensionManager.getExtension((String)SearchUIPlugin.getDefault().getId(), (String)"searchResultProviderFactory");
    }

    protected IStructuredContentProvider createContentProvider(Viewer viewer) {
        ISearchResultProviderFactory factory = MethodSearchResultPage.getSearchResultProviderFactory();
        if (viewer instanceof TreeViewer) {
            ITreeContentProvider cp = null;
            if (factory != null) {
                cp = factory.createTreeContentProvider();
            }
            return cp != null ? cp : new SearchResultTreeContentProvider();
        }
        if (viewer instanceof TableViewer) {
            IStructuredContentProvider cp = null;
            if (factory != null) {
                cp = factory.createTableContentProvider();
            }
            return cp != null ? cp : new SearchResultTableContentProvider();
        }
        return null;
    }

    protected ILabelProvider createLabelProvider() {
        ILabelProvider lp = null;
        ISearchResultProviderFactory factory = MethodSearchResultPage.getSearchResultProviderFactory();
        if (factory != null) {
            lp = factory.createLabelProvider();
        }
        return lp != null ? lp : new ElementTreeLabelProvider();
    }

    protected void configureTreeViewer(TreeViewer viewer) {
        this.contentProvider = this.createContentProvider((Viewer)viewer);
        viewer.setContentProvider((IContentProvider)this.contentProvider);
        viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        viewer.setSorter((ViewerSorter)new MethodElementViewSorter());
        viewer.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    protected void configureTableViewer(TableViewer viewer) {
        this.contentProvider = this.createContentProvider((Viewer)viewer);
        viewer.setContentProvider((IContentProvider)this.contentProvider);
        viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        viewer.setSorter((ViewerSorter)new MethodElementViewSorter());
    }

    protected void elementsChanged(Object[] objects) {
        if (this.contentProvider != null) {
            if (this.contentProvider instanceof SearchResultTreeContentProvider) {
                ((SearchResultTreeContentProvider)this.contentProvider).elementsChanged(objects);
            } else if (this.contentProvider instanceof SearchResultTableContentProvider) {
                ((SearchResultTableContentProvider)this.contentProvider).elementsChanged(objects);
            }
        }
    }

    protected void clear() {
        if (this.contentProvider != null) {
            if (this.contentProvider instanceof SearchResultTreeContentProvider) {
                ((SearchResultTreeContentProvider)this.contentProvider).clear();
            } else if (this.contentProvider instanceof SearchResultTableContentProvider) {
                ((SearchResultTableContentProvider)this.contentProvider).clear();
            }
        }
    }

    protected void showMatch(Match match, int currentOffset, int currentLength, boolean activate) throws PartInitException {
        if (match.getElement() instanceof MethodElement && activate) {
            MethodElement element = (MethodElement)match.getElement();
            if (PerspectiveUtil.isActivePerspective((String)BrowsingPerspective.PERSPECTIVE_ID)) {
                IViewPart view;
                PerspectiveUtil.openPerspective((String)AuthoringPerspective.PERSPECTIVE_ID);
                IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                if (activePage != null && (view = activePage.findView("org.eclipse.search.ui.views.SearchView")) != null) {
                    activePage.showView("org.eclipse.search.ui.views.SearchView");
                }
            }
            this.displayEditor(element);
        }
    }

    protected void displayEditor(MethodElement element) {
        if (element instanceof ProcessElement) {
            EditorChooser.getInstance().openEditor((Object)UmaUtil.getProcessComponent((MethodElement)element));
        } else {
            EditorChooser.getInstance().openEditor((Object)element);
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IStructuredSelection sel;
        Object[] selectedElements;
        ISelection selection;
        if (PerspectiveUtil.isActivePerspective((String)BrowsingPerspective.PERSPECTIVE_ID) && (selection = event.getSelection()) instanceof IStructuredSelection && (selectedElements = (sel = (IStructuredSelection)selection).toArray()) != null && selectedElements.length > 0 && selectedElements[0] instanceof MethodElement) {
            try {
                this.displayHTMLPage((MethodElement)selectedElements[0]);
            }
            catch (PartInitException partInitException) {}
        }
    }

    protected void displayHTMLPage(MethodElement element) throws PartInitException {
        if (element instanceof MethodPlugin || element instanceof ContentPackage) {
            return;
        }
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (activePage != null) {
            IViewPart view = activePage.findView(ContentView.VIEW_ID);
            if (view == null) {
                view = activePage.showView(ContentView.VIEW_ID);
            }
            if (view != null) {
                ((ContentView)view).displayHTMLContentPage((Object)element);
            }
        }
    }
}

