/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jsch.internal.core;

import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Proxy;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SocketFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jsch.core.IJSchService;
import org.eclipse.jsch.internal.core.JSchCorePlugin;
import org.eclipse.jsch.internal.core.ResponsiveSocketFactory;
import org.eclipse.jsch.internal.core.Utils;

public class JSchProvider
implements IJSchService {
    private static JSchProvider instance;

    public Session createSession(String host, int port, String username) throws JSchException {
        if (port == -1) {
            port = 22;
        }
        if (JSchCorePlugin.getPlugin().isNeedToLoadKnownHosts()) {
            JSchCorePlugin.getPlugin().loadKnownHosts();
        }
        if (JSchCorePlugin.getPlugin().isNeedToLoadKeys()) {
            JSchCorePlugin.getPlugin().loadPrivateKeys();
        }
        return Utils.createSession(JSchCorePlugin.getPlugin().getJSch(), username, host, port);
    }

    public void connect(Session session, int timeout, IProgressMonitor monitor) throws JSchException {
        session.setSocketFactory((SocketFactory)new ResponsiveSocketFactory(monitor, timeout));
        try {
            session.connect();
        }
        catch (JSchException e) {
            if (session.isConnected()) {
                session.disconnect();
            }
            throw e;
        }
    }

    public Proxy getProxyForHost(String host, String proxyType) {
        return Utils.getProxyForHost(host, proxyType);
    }

    public static IJSchService getInstance() {
        if (instance == null) {
            instance = new JSchProvider();
        }
        return instance;
    }

    public void connect(Proxy proxy, String host, int port, int timeout, IProgressMonitor monitor) throws JSchException {
        try {
            proxy.connect((SocketFactory)new ResponsiveSocketFactory(monitor, timeout), host, port, timeout);
        }
        catch (JSchException e) {
            throw e;
        }
        catch (Exception e) {
            new JSchException(e.getMessage());
        }
    }
}

