/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.add.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.InternalTransaction;
import org.eclipse.emf.transaction.impl.InternalTransactionalEditingDomain;
import org.eclipse.epf.diagram.add.edit.parts.ActivityDetailDiagramEditPart;
import org.eclipse.epf.diagram.add.edit.parts.RoleNodeEditPart;
import org.eclipse.epf.diagram.add.edit.parts.RoleTaskCompositeEditPart;
import org.eclipse.epf.diagram.add.edit.parts.TaskNodeEditPart;
import org.eclipse.epf.diagram.add.edit.parts.WorkProductCompositeEditPart;
import org.eclipse.epf.diagram.core.commands.ChangeBoundsCommand;
import org.eclipse.epf.diagram.core.util.DiagramConstants;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrapLabel;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Font;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiagramResetService {
    private DefaultEditDomain editDomain;
    private GraphicalViewer graphicalViewer;
    private ActionRegistry actionRegistry;
    private InternalTransactionalEditingDomain transactionDomain;
    int delta = 0;
    private static final int IMG_HEIGHT = 32;
    protected static final int HORIZ_PIX_PADDING = 30;
    protected static final int VERT_PIX_PADDING = 20;

    public DiagramResetService(InternalTransactionalEditingDomain transactionDomain, GraphicalViewer graphicalViewer, DefaultEditDomain editDomain, ActionRegistry actionRegistry) {
        this.transactionDomain = transactionDomain;
        this.graphicalViewer = graphicalViewer;
        this.editDomain = editDomain;
        this.actionRegistry = actionRegistry;
    }

    private GraphicalViewer getGraphicalViewer() {
        return this.graphicalViewer;
    }

    protected CommandStack getCommandStack() {
        return this.getEditDomain().getCommandStack();
    }

    protected DefaultEditDomain getEditDomain() {
        return this.editDomain;
    }

    protected ActionRegistry getActionRegistry() {
        return this.actionRegistry;
    }

    public void cleanUpDiagram() {
        ActivityDetailDiagramEditPart dep;
        List<EditPart> children;
        if (this.getGraphicalViewer().getContents() instanceof ActivityDetailDiagramEditPart && !(children = (dep = (ActivityDetailDiagramEditPart)this.getGraphicalViewer().getContents()).getRecentlyAddedParts()).isEmpty()) {
            AbstractGraphicalEditPart ep;
            Comparator<Object> comparator = new Comparator<Object>(){

                @Override
                public int compare(Object arg0, Object arg1) {
                    int rc = 0;
                    if (arg0 instanceof RoleTaskCompositeEditPart) {
                        if (!(arg1 instanceof RoleTaskCompositeEditPart)) {
                            rc = -1;
                        }
                    } else if (arg1 instanceof RoleTaskCompositeEditPart) {
                        rc = 1;
                    }
                    return rc;
                }
            };
            Object[] array = children.toArray();
            Arrays.sort(array, comparator);
            int a = 0;
            while (a < array.length) {
                ep = (AbstractGraphicalEditPart)array[a];
                this.adjustSize(ep);
                ++a;
            }
            dep.getViewport().validate();
            int b = 0;
            while (b < array.length) {
                ep = (AbstractGraphicalEditPart)array[b];
                this.cleanUp(ep);
                ++b;
            }
            int c = 0;
            while (c < array.length) {
                ep = (AbstractGraphicalEditPart)array[c];
                this.reduceLinkLength(ep);
                ++c;
            }
            this.packDiagram();
            dep.refresh();
            dep.clearRecentlyAddedParts();
            this.getGraphicalViewer().setSelection((ISelection)new StructuredSelection());
        }
    }

    private void cleanUp(AbstractGraphicalEditPart ep) {
        if (!(ep instanceof WorkProductCompositeEditPart)) {
            List targetLinks;
            List sourceLinks = ep.getSourceConnections();
            if (sourceLinks.size() > 0) {
                int b = 0;
                while (b < sourceLinks.size()) {
                    ConnectionNodeEditPart link = (ConnectionNodeEditPart)sourceLinks.get(b);
                    AbstractGraphicalEditPart target = (AbstractGraphicalEditPart)link.getTarget();
                    int w = target.getFigure().getBounds().width;
                    int ew = ep.getFigure().getPreferredSize().width;
                    if (w < ew) {
                        ChangeBoundsCommand c = new ChangeBoundsCommand((TransactionalEditingDomain)this.transactionDomain, (View)((Node)ep.getModel()), target.getFigure().getBounds().getLocation(), w, target.getFigure().getPreferredSize().height);
                        this.getCommandStack().execute((Command)c);
                        int h = target.getFigure().getPreferredSize().height;
                        target.getFigure().setPreferredSize(new Dimension(w, h));
                        target.getFigure().setSize(new Dimension(w, h));
                    }
                    ArrayList<AbstractGraphicalEditPart> list = new ArrayList<AbstractGraphicalEditPart>();
                    list.add(ep);
                    list.add(target);
                    this.verticalAlignToFirstSelected(list);
                    ++b;
                }
            }
            if ((targetLinks = ep.getTargetConnections()).size() > 0) {
                int b = 0;
                while (b < targetLinks.size()) {
                    ConnectionNodeEditPart link = (ConnectionNodeEditPart)targetLinks.get(b);
                    AbstractGraphicalEditPart source = (AbstractGraphicalEditPart)link.getSource();
                    int w = source.getFigure().getBounds().width;
                    int ew = ep.getFigure().getPreferredSize().width;
                    if (w < ew) {
                        ChangeBoundsCommand c = new ChangeBoundsCommand((TransactionalEditingDomain)this.transactionDomain, (View)((Node)ep.getModel()), source.getFigure().getBounds().getLocation(), w, -1);
                        this.getCommandStack().execute((Command)c);
                        int h = source.getFigure().getPreferredSize().height;
                        source.getFigure().setPreferredSize(new Dimension(w, h));
                        source.getFigure().setSize(new Dimension(w, h));
                    }
                    ArrayList<AbstractGraphicalEditPart> list = new ArrayList<AbstractGraphicalEditPart>();
                    list.add(ep);
                    list.add(source);
                    this.verticalAlignToFirstSelected(list);
                    ++b;
                }
            }
            if (ep instanceof WorkProductCompositeEditPart || ep instanceof RoleTaskCompositeEditPart) {
                List children = ep.getChildren();
                int d = 0;
                while (d < children.size()) {
                    AbstractGraphicalEditPart p = (AbstractGraphicalEditPart)children.get(d);
                    this.cleanUp(p);
                    ++d;
                }
            }
        }
    }

    private boolean reduceLinkLength(AbstractGraphicalEditPart part) {
        boolean moved = false;
        if (part instanceof WorkProductCompositeEditPart) {
            AbstractGraphicalEditPart linkedPart = null;
            int position = 2;
            if (part.getTargetConnections().size() > 0) {
                linkedPart = (AbstractGraphicalEditPart)((ConnectionNodeEditPart)part.getTargetConnections().get(0)).getSource();
                position = 1;
            } else if (part.getSourceConnections().size() > 0) {
                linkedPart = (AbstractGraphicalEditPart)((ConnectionNodeEditPart)part.getSourceConnections().get(0)).getTarget();
                position = 4;
            }
            if (linkedPart != null) {
                if (!(linkedPart.getParent() instanceof DiagramEditPart)) {
                    linkedPart = (AbstractGraphicalEditPart)linkedPart.getParent();
                }
                Rectangle partBounds = part.getFigure().getBounds();
                Rectangle linkedPartBounds = linkedPart.getFigure().getBounds();
                int direction = -1;
                if ((position & 1) == 1 || (position & 2) == 2) {
                    direction = 1;
                }
                Rectangle testBounds = partBounds.getCopy();
                testBounds.y = direction == 1 ? linkedPartBounds.y + linkedPartBounds.height + 20 : linkedPartBounds.y - 20 - partBounds.height;
                Point np = new Point(testBounds.x, testBounds.y);
                part.getFigure().setLocation(np);
                ChangeBoundsCommand c = new ChangeBoundsCommand((TransactionalEditingDomain)this.transactionDomain, (View)((Node)part.getModel()), np, partBounds.width, -1);
                this.getCommandStack().execute((Command)c);
            }
        }
        return moved;
    }

    private void adjustSize(AbstractGraphicalEditPart ep) {
        if (ep instanceof WorkProductCompositeEditPart) {
            this.adjustSize((WorkProductCompositeEditPart)ep, 1);
        } else if (ep instanceof RoleTaskCompositeEditPart) {
            this.adjustSize((RoleTaskCompositeEditPart)ep, 50);
        }
    }

    private void adjustSize(ShapeNodeEditPart ep, int horizCount) {
        int requiredWidth = 0;
        int rowMaxHeight = 0;
        int rows = 0;
        int widthSum = 0;
        int heightSum = 0;
        int column = 0;
        this.delta = 0;
        List children = ep.getChildren();
        IFigure parentFigure = ep.getFigure();
        try {
            InternalTransaction tx = this.transactionDomain.startTransaction(false, Collections.EMPTY_MAP);
            int p = 0;
            while (p < children.size()) {
                if (column == 0) {
                    ++rows;
                }
                if (column < horizCount) {
                    AbstractGraphicalEditPart child = (AbstractGraphicalEditPart)children.get(p);
                    if (child instanceof RoleNodeEditPart || child instanceof TaskNodeEditPart) {
                        this.resetSize((ShapeNodeEditPart)child, parentFigure);
                    }
                    Dimension d = child.getFigure().getPreferredSize();
                    widthSum += d.width;
                    if (d.height > rowMaxHeight) {
                        rowMaxHeight = d.height;
                    }
                    ++p;
                    ++column;
                    continue;
                }
                if (widthSum > requiredWidth) {
                    requiredWidth = widthSum;
                }
                heightSum += rowMaxHeight;
                rowMaxHeight = 0;
                widthSum = 0;
                column = 0;
            }
            tx.commit();
        }
        catch (Exception exception) {}
        if (widthSum > requiredWidth) {
            requiredWidth = widthSum;
        }
        int requiredHeight = (heightSum += rowMaxHeight) + 20 * rows;
        ChangeBoundsCommand cmd = new ChangeBoundsCommand((TransactionalEditingDomain)this.transactionDomain, (View)((Node)ep.getModel()), ep.getFigure().getBounds().getLocation(), requiredWidth += 30 * Math.min(horizCount, children.size()), requiredHeight);
        this.getCommandStack().execute((Command)cmd);
        ep.getFigure().setPreferredSize(new Dimension(requiredWidth, requiredHeight));
        ep.getFigure().setSize(new Dimension(requiredWidth, requiredHeight));
        ep.getFigure().getLayoutManager().layout(ep.getFigure());
        if (ep instanceof WorkProductCompositeEditPart && children.size() > 0) {
            int totalCalculatedHeight = 0;
            int i = 0;
            while (i < children.size()) {
                GraphicalEditPart part = (GraphicalEditPart)children.get(i);
                Node nodeObj = (Node)part.getModel();
                nodeObj.getElement();
                totalCalculatedHeight += part.getFigure().getPreferredSize().height;
                ++i;
            }
            int height = totalCalculatedHeight + 20 + 5 * (children.size() - 1);
            GraphicalEditPart last = (GraphicalEditPart)children.get(children.size() - 1);
            Point childBottom = last.getFigure().getBounds().getBottom();
            Point parentBottom = ep.getFigure().getBounds().getBottom();
            int cfr_ignored_0 = parentBottom.y;
            int cfr_ignored_1 = childBottom.y;
            ep.getFigure().setPreferredSize(new Dimension(requiredWidth, height));
            cmd = new ChangeBoundsCommand((TransactionalEditingDomain)this.transactionDomain, (View)((Node)ep.getModel()), ep.getFigure().getBounds().getLocation(), -1, height);
            this.getCommandStack().execute((Command)cmd);
            ep.getFigure().setSize(new Dimension(requiredWidth, height));
        }
    }

    private void resetSize(ShapeNodeEditPart ep, IFigure parentFigure) {
        IFigure labelFigure;
        Node model = (Node)ep.getModel();
        IGraphicalEditPart child = (IGraphicalEditPart)ep.getChildren().get(0);
        NodeFigure nodeFigure = (NodeFigure)ep.getFigure();
        List nodeFigureChildren = nodeFigure.getChildren();
        IFigure childFigure = (IFigure)nodeFigureChildren.get(0);
        if (childFigure instanceof RectangleFigure && (labelFigure = (IFigure)((RectangleFigure)childFigure).getChildren().get(0)) instanceof WrapLabel) {
            Dimension figDimension = labelFigure.getSize();
            Dimension d = labelFigure.getPreferredSize();
            Point p = nodeFigure.getLocation().getCopy();
            p.x += this.delta;
            nodeFigure.setLocation(p);
            if (d.width > nodeFigure.getSize().width) {
                this.delta += d.width - nodeFigure.getSize().width;
            }
            if (d.width > figDimension.width) {
                int width = d.width;
                View view = (View)child.getModel();
                ViewUtil.setStructuralFeatureValue((View)view, (EStructuralFeature)NotationPackage.eINSTANCE.getSize_Width(), (Object)new Integer(width));
                ViewUtil.setStructuralFeatureValue((View)model, (EStructuralFeature)NotationPackage.eINSTANCE.getSize_Width(), (Object)new Integer(width));
                nodeFigure.setPreferredSize(new Dimension(width, nodeFigure.getPreferredSize().height));
                childFigure.setPreferredSize(new Dimension(width, childFigure.getPreferredSize().height));
                labelFigure.setPreferredSize(new Dimension(width, labelFigure.getPreferredSize().height));
                nodeFigure.setSize(new Dimension(width, nodeFigure.getPreferredSize().height));
                childFigure.setSize(new Dimension(width, childFigure.getPreferredSize().height));
                labelFigure.setSize(new Dimension(width, labelFigure.getPreferredSize().height));
            }
        }
    }

    protected void enumerateConnectedParts(AbstractGraphicalEditPart part, List<EditPart> connected) {
        if (!connected.contains(part)) {
            if (!(part.getParent() instanceof DiagramEditPart)) {
                if (!connected.contains(part.getParent())) {
                    connected.add(part.getParent());
                }
            } else {
                connected.add((EditPart)part);
            }
            AbstractGraphicalEditPart linkedPart = null;
            List children = part.getChildren();
            int x = 0;
            while (x < children.size()) {
                AbstractGraphicalEditPart p = (AbstractGraphicalEditPart)children.get(x);
                this.enumerateConnectedParts(p, connected);
                ++x;
            }
            x = 0;
            while (x < part.getTargetConnections().size()) {
                linkedPart = (AbstractGraphicalEditPart)((ConnectionNodeEditPart)part.getTargetConnections().get(x)).getSource();
                this.enumerateConnectedParts(linkedPart, connected);
                ++x;
            }
            x = 0;
            while (x < part.getSourceConnections().size()) {
                linkedPart = (AbstractGraphicalEditPart)((ConnectionNodeEditPart)part.getSourceConnections().get(x)).getTarget();
                this.enumerateConnectedParts(linkedPart, connected);
                ++x;
            }
        }
    }

    private void packDiagram() {
        int limit;
        ActivityDetailDiagramEditPart diagram = (ActivityDetailDiagramEditPart)this.getGraphicalViewer().getContents();
        int reserved = 0;
        ArrayList<AbstractGraphicalEditPart> stragglers = new ArrayList<AbstractGraphicalEditPart>();
        ArrayList<ArrayList<EditPart>> groups = new ArrayList<ArrayList<EditPart>>();
        List<EditPart> diagramParts = diagram.getRecentlyAddedParts();
        int x = 0;
        while (x < diagramParts.size()) {
            AbstractGraphicalEditPart p = (AbstractGraphicalEditPart)diagramParts.get(x);
            boolean found = false;
            int g = 0;
            while (g < groups.size() && !found) {
                List group = (List)groups.get(g);
                if (group.contains(p)) {
                    found = true;
                    break;
                }
                ++g;
            }
            if (!found) {
                ArrayList<EditPart> connected = new ArrayList<EditPart>();
                this.enumerateConnectedParts(p, connected);
                if (connected.size() == 1) {
                    stragglers.add(p);
                } else {
                    groups.add(connected);
                }
            }
            ++x;
        }
        while (groups.size() > 0) {
            List top = (List)groups.get(0);
            int topY = this.getVerticalMinPart((List)top).getFigure().getBounds().y;
            int x2 = 0;
            while (x2 < groups.size()) {
                List g = (List)groups.get(x2);
                int y = this.getVerticalMinPart((List)g).getFigure().getBounds().y;
                if (y < topY) {
                    top = g;
                    topY = y;
                }
                ++x2;
            }
            limit = reserved + 1;
            int verticalDelta = limit - topY;
            int leftX = this.getHorizontalMinPart((List)top).getFigure().getBounds().x;
            int horizontalDelta = 30 - leftX;
            int x3 = 0;
            while (x3 < top.size()) {
                AbstractGraphicalEditPart p = (AbstractGraphicalEditPart)top.get(x3);
                Rectangle bounds = p.getFigure().getBounds();
                ChangeBoundsCommand cbc = new ChangeBoundsCommand((TransactionalEditingDomain)this.transactionDomain, (View)((Node)p.getModel()), new Point(bounds.x + horizontalDelta, bounds.y + verticalDelta), bounds.width, -1);
                this.getCommandStack().execute((Command)cbc);
                p.getFigure().setLocation(new Point(bounds.x + horizontalDelta, bounds.y + verticalDelta));
                p.refresh();
                ++x3;
            }
            int bottomY = this.getVerticalMaxPart(top).getFigure().getBounds().bottom();
            reserved = bottomY + 40;
            groups.remove(top);
        }
        int next = 30;
        int x4 = 0;
        while (x4 < stragglers.size()) {
            limit = reserved + 1;
            AbstractGraphicalEditPart p = (AbstractGraphicalEditPart)stragglers.get(x4);
            Rectangle bounds = p.getFigure().getBounds();
            ChangeBoundsCommand cbc = new ChangeBoundsCommand((TransactionalEditingDomain)this.transactionDomain, (View)((Node)p.getModel()), new Point(next, limit), bounds.width, -1);
            this.getCommandStack().execute((Command)cbc);
            p.getFigure().setLocation(new Point(next, limit));
            p.refresh();
            next += bounds.width + 30;
            ++x4;
        }
    }

    private AbstractGraphicalEditPart getVerticalMinPart(List parts) {
        AbstractGraphicalEditPart rc = parts.size() > 0 ? (AbstractGraphicalEditPart)parts.get(0) : null;
        int x = 0;
        while (x < parts.size()) {
            AbstractGraphicalEditPart p = (AbstractGraphicalEditPart)parts.get(x);
            if (p.getFigure().getBounds().y < rc.getFigure().getBounds().y) {
                rc = p;
            }
            ++x;
        }
        return rc;
    }

    private AbstractGraphicalEditPart getHorizontalMinPart(List parts) {
        AbstractGraphicalEditPart rc = parts.size() > 0 ? (AbstractGraphicalEditPart)parts.get(0) : null;
        int x = 0;
        while (x < parts.size()) {
            AbstractGraphicalEditPart p = (AbstractGraphicalEditPart)parts.get(x);
            if (p.getFigure().getBounds().x < rc.getFigure().getBounds().x) {
                rc = p;
            }
            ++x;
        }
        return rc;
    }

    private AbstractGraphicalEditPart getVerticalMaxPart(List parts) {
        AbstractGraphicalEditPart rc = parts.size() > 0 ? (AbstractGraphicalEditPart)parts.get(0) : null;
        int x = 0;
        while (x < parts.size()) {
            AbstractGraphicalEditPart p = (AbstractGraphicalEditPart)parts.get(x);
            if (p.getFigure().getBounds().bottom() > rc.getFigure().getBounds().bottom()) {
                rc = p;
            }
            ++x;
        }
        return rc;
    }

    public void verticalAlignToFirstSelected(List editParts) {
        AbstractGraphicalEditPart ep;
        AbstractGraphicalEditPart alignToPart = null;
        int a = 0;
        while (a < editParts.size()) {
            if (editParts.get(a) instanceof ShapeNodeEditPart) {
                ep = (AbstractGraphicalEditPart)editParts.get(a);
                if (alignToPart == null) {
                    alignToPart = ep;
                    break;
                }
            }
            ++a;
        }
        a = 0;
        while (a < editParts.size()) {
            if (editParts.get(a) instanceof ShapeNodeEditPart && (ep = (AbstractGraphicalEditPart)editParts.get(a)) != alignToPart) {
                Rectangle bounds = ep.getFigure().getBounds();
                Rectangle alignToPartBounds = alignToPart.getFigure().getBounds();
                alignToPart.getFigure().getPreferredSize();
                int offset = bounds.getCenter().x - alignToPartBounds.getCenter().x;
                if (!(ep.getParent() instanceof DiagramEditPart)) {
                    ep = (AbstractGraphicalEditPart)ep.getParent();
                    Rectangle parentBounds = ep.getFigure().getBounds();
                    offset += bounds.x - parentBounds.x;
                    bounds = parentBounds;
                }
                ChangeBoundsCommand c = new ChangeBoundsCommand((TransactionalEditingDomain)this.transactionDomain, (View)((Node)ep.getModel()), new Point(alignToPart.getFigure().getBounds().x - offset, bounds.y), bounds.width, -1);
                this.getCommandStack().execute((Command)c);
                ep.getFigure().setLocation(new Point(alignToPart.getFigure().getBounds().x - offset, bounds.y));
                Point sp = alignToPart.getFigure().getBounds().getCenter();
                boolean connected = false;
                List list = ((ShapeNodeEditPart)alignToPart).getSourceConnections();
                for (ConnectionNodeEditPart lp : list) {
                    if (!lp.getTarget().equals(ep)) continue;
                    connected = true;
                    break;
                }
                if (!connected) {
                    list = ((ShapeNodeEditPart)alignToPart).getTargetConnections();
                    for (ConnectionNodeEditPart lp : list) {
                        if (!lp.getSource().equals(ep)) continue;
                        connected = true;
                        break;
                    }
                }
                Point p = new Point();
                p.x = (Integer)ViewUtil.getStructuralFeatureValue((View)((View)ep.getModel()), (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_X());
                p.y = (Integer)ViewUtil.getStructuralFeatureValue((View)((View)ep.getModel()), (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_Y());
                Point tp = p.getCopy();
                Point centerPoint = ep.getFigure().getBounds().getCenter();
                int delta = sp.x - centerPoint.x;
                tp.x += delta;
                c = new ChangeBoundsCommand((TransactionalEditingDomain)this.transactionDomain, (View)((Node)ep.getModel()), tp, ep.getFigure().getBounds().width, -1);
                this.getCommandStack().execute((Command)c);
                ep.getFigure().setLocation(new Point(tp.x, tp.y));
            }
            ++a;
        }
    }

    public static Dimension getTextDimension(String text) {
        Font f;
        Dimension d;
        if (text != null && (d = FigureUtilities.getTextExtents((String)text, (Font)(f = DiagramConstants.DEFAULT_FONT))) != null) {
            return d;
        }
        return null;
    }

    private void anyObliqueLinks(ActivityDetailDiagramEditPart dep, List recentlyAddedChildren) {
        List children = dep.getChildren();
        for (IGraphicalEditPart part : children) {
            if (!(part instanceof RoleTaskCompositeEditPart)) continue;
            List grandChildren = ((RoleTaskCompositeEditPart)part).getChildren();
            for (ShapeNodeEditPart child : grandChildren) {
                AbstractGraphicalEditPart linkedPart;
                if (!(child instanceof TaskNodeEditPart)) continue;
                Point p = child.getFigure().getBounds().getCenter();
                List connected = child.getTargetConnections();
                if (!connected.isEmpty()) {
                    linkedPart = (AbstractGraphicalEditPart)((ConnectionNodeEditPart)connected.get(0)).getSource();
                    Point pt = linkedPart.getFigure().getBounds().getCenter();
                    if (p.x != pt.x && !recentlyAddedChildren.contains(part)) {
                        recentlyAddedChildren.add(part);
                    }
                }
                if ((connected = child.getSourceConnections()).isEmpty()) continue;
                linkedPart = (AbstractGraphicalEditPart)((ConnectionNodeEditPart)connected.get(0)).getSource();
                Point ps = linkedPart.getFigure().getBounds().getCenter();
                if (p.x == ps.x || recentlyAddedChildren.contains(part)) continue;
                recentlyAddedChildren.add(part);
            }
        }
    }
}

