/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.core.actions;

import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.draw2d.AbsoluteBendpoint;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.epf.diagram.core.DiagramCoreResources;
import org.eclipse.epf.diagram.core.bridge.BridgeHelper;
import org.eclipse.epf.diagram.core.bridge.DiagramAdapter;
import org.eclipse.epf.diagram.core.commands.ChangeBoundsCommand;
import org.eclipse.epf.diagram.core.part.AbstractDiagramEditor;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.Process;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.actions.DiagramAction;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.RelativeBendpoints;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

public class AccessibilityMoveAction
extends DiagramAction {
    public static final String MOVE_LEFT_ACTION = "move_left_action";
    public static final String MOVE_RIGHT_ACTION = "move_right_action";
    public static final String MOVE_DOWN_ACTION = "move_down_action";
    public static final String MOVE_UP_ACTION = "move_up_action";
    private int direction;

    public AccessibilityMoveAction(IWorkbenchPage workbenchPage) {
        super(workbenchPage);
    }

    public AccessibilityMoveAction(IWorkbenchPart workbenchpart, int direction) {
        super(workbenchpart);
        this.direction = direction;
    }

    protected Request createTargetRequest() {
        return null;
    }

    protected boolean isSelectionListener() {
        return true;
    }

    public void init() {
        super.init();
        this.setId("move_action_id");
    }

    public void setDirection(int direction) {
        this.direction = direction;
    }

    protected Command getCommand() {
        List list = this.getSelectedObjects();
        CompositeCommand cc = new CompositeCommand(DiagramCoreResources.AbstractDiagramEditor_MoveNode_label);
        for (Object part : list) {
            Command c;
            if (!(part instanceof GraphicalEditPart) || (c = this.move(this.direction, (GraphicalEditPart)part)) == null) continue;
            cc.compose((IUndoableOperation)new CommandProxy(c));
        }
        return cc.isEmpty() ? null : new ICommandProxy(cc.reduce());
    }

    public Command move(int direction, GraphicalEditPart part) {
        if (part.getModel() instanceof Node) {
            View view = (View)part.getModel();
            Object x = ViewUtil.getStructuralFeatureValue((View)view, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_X());
            Object y = ViewUtil.getStructuralFeatureValue((View)view, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_Y());
            Point point = new Point(((Integer)x).intValue(), ((Integer)y).intValue());
            int newx = point.x;
            int newy = point.y;
            int presslength = 1;
            switch (direction) {
                case 16: {
                    newx = point.x + presslength;
                    break;
                }
                case 4: {
                    newy += presslength;
                    break;
                }
                case 1: {
                    newy -= presslength;
                    break;
                }
                case 8: {
                    newx -= presslength;
                    break;
                }
            }
            ChangeBoundsCommand c = new ChangeBoundsCommand(this.getEditingDomain(), view, new Point(newx, newy), -1, -1);
            return c;
        }
        return null;
    }

    public Command moveBendPoint(int direction, ConnectionEditPart part) {
        if (part.getModel() instanceof Edge) {
            Edge edge = (Edge)part.getModel();
            RelativeBendpoints bPoints = (RelativeBendpoints)edge.getBendpoints();
            List blist = bPoints.getPoints();
            int index = 0;
            if (blist != null && blist.size() > 0) {
                AbsoluteBendpoint point = (AbsoluteBendpoint)blist.get(index);
                int newx = point.x;
                int newy = point.y;
                int presslength = 5;
                switch (direction) {
                    case 1: {
                        newx = point.x + presslength;
                        break;
                    }
                    case 2: {
                        newy += presslength;
                        break;
                    }
                    case 3: {
                        newy -= presslength;
                        break;
                    }
                    case 4: {
                        newx -= presslength;
                        break;
                    }
                }
            }
        }
        return null;
    }

    public TransactionalEditingDomain getEditingDomain() {
        return ((AbstractDiagramEditor)this.getDiagramWorkbenchPart()).getEditingDomain();
    }

    public String getId() {
        switch (this.direction) {
            case 16: {
                return MOVE_RIGHT_ACTION;
            }
            case 4: {
                return MOVE_DOWN_ACTION;
            }
            case 1: {
                return MOVE_UP_ACTION;
            }
            case 8: {
                return MOVE_LEFT_ACTION;
            }
        }
        return "move_action_id";
    }

    public boolean isEnabled() {
        if (TngUtil.isLocked((EObject)this.getOwningProcess())) {
            return false;
        }
        if (BridgeHelper.isReadOnly((View)((AbstractDiagramEditor)this.getDiagramWorkbenchPart()).getDiagram())) {
            return false;
        }
        if (this.getSelectedObjects().isEmpty()) {
            return false;
        }
        return super.isEnabled();
    }

    private Process getOwningProcess() {
        Diagram d;
        DiagramAdapter adapter;
        IDiagramWorkbenchPart targetPart = this.getDiagramWorkbenchPart();
        if (targetPart != null && (adapter = BridgeHelper.getDiagramAdapter((d = ((AbstractDiagramEditor)targetPart).getDiagram()).getElement())) != null) {
            return TngUtil.getOwningProcess((BreakdownElement)adapter.getActivity());
        }
        return null;
    }
}

