/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.core.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.command.CopyCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.epf.diagram.core.DiagramCorePlugin;
import org.eclipse.epf.diagram.core.DiagramCoreResources;
import org.eclipse.epf.diagram.core.bridge.BridgeHelper;
import org.eclipse.epf.diagram.core.bridge.DiagramAdapter;
import org.eclipse.epf.diagram.core.part.AbstractDiagramEditor;
import org.eclipse.epf.diagram.core.part.util.DiagramEditorUtil;
import org.eclipse.epf.diagram.core.services.DiagramHelper;
import org.eclipse.epf.diagram.core.services.DiagramService;
import org.eclipse.epf.diagram.model.impl.NodeImpl;
import org.eclipse.epf.diagram.model.util.TxUtil;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.VariabilityType;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.services.editpart.EditPartService;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.ActivityNode;
import org.eclipse.uml2.uml.ObjectNode;
import org.eclipse.uml2.uml.StructuredActivityNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RefreshFromBaseAction
implements IObjectActionDelegate {
    private EditPart editPart;
    private IWorkbenchPart targetPart;
    private org.eclipse.gef.commands.Command refreshFromBaseCommand = new org.eclipse.gef.commands.Command(DiagramCoreResources.AbstractDiagramEditorrefreshfrombase){
        private ArrayList oldContent;
        {
            this.oldContent = new ArrayList();
        }

        public void execute() {
            Diagram diagram = (Diagram)RefreshFromBaseAction.this.editPart.getModel();
            EditPart parent = RefreshFromBaseAction.this.editPart.getParent();
            this.oldContent.clear();
            this.oldContent.addAll(diagram.getPersistedChildren());
            boolean refreshed = RefreshFromBaseAction.this.refreshFromBase(diagram);
            if (!refreshed) {
                return;
            }
            if (RefreshFromBaseAction.this.editPart.isActive()) {
                RefreshFromBaseAction.this.editPart.deactivate();
            }
            RefreshFromBaseAction.this.editPart = (EditPart)EditPartService.getInstance().createGraphicEditPart((View)diagram);
            RefreshFromBaseAction.this.editPart.setParent(parent);
            parent.getViewer().setContents(RefreshFromBaseAction.this.editPart);
        }

        public void undo() {
            Diagram diagram = (Diagram)RefreshFromBaseAction.this.editPart.getModel();
            diagram.getChildren().clear();
            diagram.getChildren().addAll((Collection)this.oldContent);
            if (RefreshFromBaseAction.this.editPart.isActive()) {
                RefreshFromBaseAction.this.editPart.deactivate();
            }
            RefreshFromBaseAction.this.editPart = (EditPart)EditPartService.getInstance().createGraphicEditPart((View)diagram);
            RefreshFromBaseAction.this.getGraphicalViewer().setContents(RefreshFromBaseAction.this.editPart);
            RefreshFromBaseAction.this.editPart.activate();
        }
    };
    private static final IDiagramAssociationHelper ADAssociationHelper = new IDiagramAssociationHelper(){

        @Override
        public Node findNode(Diagram diagram, MethodElement e) {
            return DiagramHelper.findNode(diagram, e);
        }

        @Override
        public MethodElement getMethodElement(Node node, ResourceSet resourceSet) {
            EObject umlObject = node.getElement();
            if (umlObject instanceof StructuredActivityNode || umlObject instanceof ObjectNode) {
                MethodElement e = BridgeHelper.getMethodElement((EModelElement)((ActivityNode)umlObject));
                if (e == null && resourceSet != null) {
                    e = BridgeHelper.getMethodElementFromAnnotation((EModelElement)umlObject, resourceSet);
                }
                return e;
            }
            return null;
        }

        @Override
        public void reassociate(org.eclipse.epf.uma.Activity activity, Diagram copyOfBaseDiagram) {
            DiagramHelper.reassociate(activity, copyOfBaseDiagram);
        }

        @Override
        public void addEdgeModels(EObject diagramModel, Collection<?> edgeModels) {
            if (!(diagramModel instanceof Activity)) {
                return;
            }
            DiagramAdapter diagramAdapter = BridgeHelper.getDiagramAdapter(diagramModel);
            boolean oldNotify = false;
            if (diagramAdapter != null) {
                oldNotify = diagramAdapter.isNotificationEnabled();
                diagramAdapter.setNotificationEnabled(false);
            }
            try {
                ((Activity)diagramModel).getEdges().addAll(edgeModels);
            }
            finally {
                if (diagramAdapter != null) {
                    diagramAdapter.setNotificationEnabled(oldNotify);
                }
            }
        }

        @Override
        public void addNodeModels(EObject diagramModel, Collection<?> nodeModels) {
            if (!(diagramModel instanceof Activity)) {
                return;
            }
            DiagramAdapter diagramAdapter = BridgeHelper.getDiagramAdapter(diagramModel);
            boolean oldNotify = false;
            if (diagramAdapter != null) {
                oldNotify = diagramAdapter.isNotificationEnabled();
                diagramAdapter.setNotificationEnabled(false);
            }
            try {
                ((Activity)diagramModel).getNodes().addAll(nodeModels);
            }
            finally {
                if (diagramAdapter != null) {
                    diagramAdapter.setNotificationEnabled(oldNotify);
                }
            }
        }

        @Override
        public void removeEdgeModel(EObject diagramModel, EObject edgeModel) {
            if (!(diagramModel instanceof Activity)) {
                return;
            }
            DiagramAdapter diagramAdapter = BridgeHelper.getDiagramAdapter(diagramModel);
            boolean oldNotify = false;
            if (diagramAdapter != null) {
                oldNotify = diagramAdapter.isNotificationEnabled();
                diagramAdapter.setNotificationEnabled(false);
            }
            try {
                ((Activity)diagramModel).getEdges().remove((Object)edgeModel);
            }
            finally {
                if (diagramAdapter != null) {
                    diagramAdapter.setNotificationEnabled(oldNotify);
                }
            }
        }

        @Override
        public void removeNodeModel(EObject diagramModel, EObject nodeModel) {
            if (!(diagramModel instanceof Activity)) {
                return;
            }
            DiagramAdapter diagramAdapter = BridgeHelper.getDiagramAdapter(diagramModel);
            boolean oldNotify = false;
            if (diagramAdapter != null) {
                oldNotify = diagramAdapter.isNotificationEnabled();
                diagramAdapter.setNotificationEnabled(false);
            }
            try {
                ((Activity)diagramModel).getNodes().remove((Object)nodeModel);
            }
            finally {
                if (diagramAdapter != null) {
                    diagramAdapter.setNotificationEnabled(oldNotify);
                }
            }
        }

        @Override
        public Collection<?> getEdgeModels(EObject element) {
            if (element instanceof Activity) {
                return ((Activity)element).getEdges();
            }
            return Collections.EMPTY_LIST;
        }

        @Override
        public Collection<?> getNodeModels(EObject element) {
            if (element instanceof Activity) {
                return ((Activity)element).getNodes();
            }
            return Collections.EMPTY_LIST;
        }
    };
    private static final IDiagramAssociationHelper diagramAssociationHelper = new IDiagramAssociationHelper(){

        @Override
        public Node findNode(Diagram diagram, MethodElement e) {
            return DiagramHelper.findNodeInModelDiagram(diagram, e);
        }

        @Override
        public MethodElement getMethodElement(Node node, ResourceSet resourceSet) {
            EObject element = node.getElement();
            return element instanceof org.eclipse.epf.diagram.model.Node ? ((org.eclipse.epf.diagram.model.Node)element).getLinkedElement() : null;
        }

        @Override
        public void reassociate(org.eclipse.epf.uma.Activity activity, Diagram copyOfBaseDiagram) {
        }

        @Override
        public void addNodeModels(EObject diagramModel, Collection<?> nodeModels) {
            if (!(diagramModel instanceof org.eclipse.epf.diagram.model.Diagram)) {
                return;
            }
            org.eclipse.epf.diagram.model.Diagram diagram = (org.eclipse.epf.diagram.model.Diagram)diagramModel;
            boolean oldNotify = ((NodeImpl)diagram).isNotificationEnabled();
            try {
                ((NodeImpl)diagram).setNotificationEnabled(false);
                diagram.getNodes().addAll(nodeModels);
            }
            finally {
                ((NodeImpl)diagram).setNotificationEnabled(oldNotify);
            }
        }

        @Override
        public void addEdgeModels(EObject diagramModel, Collection<?> edgeModels) {
        }

        @Override
        public void removeEdgeModel(EObject diagramModel, EObject edgeModel) {
        }

        @Override
        public void removeNodeModel(EObject diagramModel, EObject nodeModel) {
            if (!(diagramModel instanceof org.eclipse.epf.diagram.model.Diagram)) {
                return;
            }
            org.eclipse.epf.diagram.model.Diagram diagram = (org.eclipse.epf.diagram.model.Diagram)diagramModel;
            boolean oldNotify = ((NodeImpl)diagram).isNotificationEnabled();
            try {
                ((NodeImpl)diagram).setNotificationEnabled(false);
                diagram.getNodes().remove((Object)nodeModel);
            }
            finally {
                ((NodeImpl)diagram).setNotificationEnabled(oldNotify);
            }
        }

        @Override
        public Collection<?> getEdgeModels(EObject element) {
            return Collections.EMPTY_LIST;
        }

        @Override
        public Collection<?> getNodeModels(EObject element) {
            if (element instanceof org.eclipse.epf.diagram.model.Diagram) {
                return ((org.eclipse.epf.diagram.model.Diagram)element).getNodes();
            }
            return Collections.EMPTY_LIST;
        }
    };

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.targetPart = targetPart;
    }

    public void run(IAction action) {
        this.refreshFromBaseCommand.execute();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        IStructuredSelection structuredSelection;
        this.editPart = null;
        if (selection instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)selection).size() == 1 && structuredSelection.getFirstElement() instanceof EditPart) {
            this.editPart = (EditPart)structuredSelection.getFirstElement();
        }
        if (this.editPart != null) {
            action.setChecked(false);
            if (this.editPart instanceof DiagramEditPart && !((DiagramEditPart)this.editPart).isEditModeEnabled()) {
                action.setEnabled(false);
                return;
            }
            Diagram diagram = (Diagram)this.editPart.getModel();
            EObject model = diagram.getElement();
            org.eclipse.epf.uma.Activity e = null;
            if (model instanceof Activity) {
                e = (org.eclipse.epf.uma.Activity)BridgeHelper.getMethodElement((EModelElement)model);
            } else if (model instanceof org.eclipse.epf.diagram.model.Diagram) {
                e = (org.eclipse.epf.uma.Activity)((org.eclipse.epf.diagram.model.Diagram)model).getLinkedElement();
            }
            if (e != null && e instanceof org.eclipse.epf.uma.Activity && (e.getVariabilityBasedOnElement() == null || e.getVariabilityBasedOnElement() != null && e.getVariabilityType() != VariabilityType.EXTENDS)) {
                action.setEnabled(false);
                return;
            }
        } else {
            action.setEnabled(false);
        }
    }

    private GraphicalViewer getGraphicalViewer() {
        return (GraphicalViewer)this.editPart.getRoot().getViewer();
    }

    public boolean refreshFromBase(final Diagram diagram) {
        final boolean[] resultHolder = new boolean[1];
        try {
            TxUtil.runInTransaction((EObject)diagram, (Runnable)new Runnable(){

                public void run() {
                    resultHolder[0] = RefreshFromBaseAction.this.doRefreshFromBase(diagram);
                }
            });
        }
        catch (Exception e) {
            DiagramCorePlugin.getDefault().getLogger().logError((Throwable)e);
        }
        return resultHolder[0];
    }

    public boolean refreshFromBase(final Diagram diagram, final org.eclipse.epf.uma.Activity activity) {
        final boolean[] resultHolder = new boolean[1];
        try {
            TxUtil.runInTransaction((EObject)diagram, (Runnable)new Runnable(){

                public void run() {
                    resultHolder[0] = RefreshFromBaseAction.this.doRefreshFromBase(diagram, activity);
                }
            });
        }
        catch (Exception e) {
            DiagramCorePlugin.getDefault().getLogger().logError((Throwable)e);
        }
        return resultHolder[0];
    }

    private static boolean contains(Collection<?> nodes, View node) {
        if (nodes.contains(node)) {
            return true;
        }
        for (Object child : nodes) {
            if (!(child instanceof Node) || !RefreshFromBaseAction.contains(((Node)child).getChildren(), node)) continue;
            return true;
        }
        return false;
    }

    private boolean doRefreshFromBase(Diagram diagram) {
        org.eclipse.epf.uma.Activity act = null;
        EObject model = diagram.getElement();
        if (model instanceof Activity) {
            act = (org.eclipse.epf.uma.Activity)BridgeHelper.getMethodElement((EModelElement)model);
        } else if (model instanceof org.eclipse.epf.diagram.model.Diagram) {
            act = (org.eclipse.epf.uma.Activity)((org.eclipse.epf.diagram.model.Diagram)model).getLinkedElement();
        }
        if (act == null) {
            return false;
        }
        return this.doRefreshFromBase(diagram, act);
    }

    private boolean doRefreshFromBase(Diagram diagram, org.eclipse.epf.uma.Activity act) {
        EObject model = diagram.getElement();
        org.eclipse.epf.uma.Activity base = (org.eclipse.epf.uma.Activity)act.getVariabilityBasedOnElement();
        if (base == null || act.getVariabilityType() == VariabilityType.LOCAL_REPLACEMENT) {
            return false;
        }
        int type = DiagramHelper.getDiagramType(diagram);
        DiagramService diagramSvc = new DiagramService();
        try {
            Diagram baseDiagram = diagramSvc.getBaseDiagram(act, type);
            if (baseDiagram == null) {
                return false;
            }
            HashSet<Node> oldNodes = new HashSet<Node>();
            HashSet<Object> oldEdges = new HashSet<Object>();
            Diagram baseCopy = DiagramHelper.copyDiagram((EditingDomain)TransactionUtil.getEditingDomain((EObject)diagram), baseDiagram);
            IDiagramAssociationHelper helper = type == 0 ? ADAssociationHelper : diagramAssociationHelper;
            boolean notification = model.eDeliver();
            try {
                Collection<?> baseEdgeModels;
                ResourceSet resourceSet = base.eResource().getResourceSet();
                for (Node node : baseDiagram.getChildren()) {
                    Node node2;
                    MethodElement e = helper.getMethodElement(node, resourceSet);
                    if (e == null || (node2 = helper.findNode(diagram, e)) == null) continue;
                    oldNodes.add(node2);
                }
                EList children = diagram.getChildren();
                for (Node node : children) {
                    if (BridgeHelper.isInherited((EModelElement)node)) {
                        oldNodes.add(node);
                        continue;
                    }
                    MethodElement e = helper.getMethodElement(node, resourceSet);
                    if (!(e instanceof org.eclipse.epf.uma.Activity) || ((org.eclipse.epf.uma.Activity)e).getVariabilityBasedOnElement() == null) continue;
                    oldNodes.add(node);
                }
                for (Object edge : diagram.getEdges()) {
                    if (!RefreshFromBaseAction.contains(oldNodes, edge.getSource()) || !RefreshFromBaseAction.contains(oldNodes, edge.getTarget())) continue;
                    oldEdges.add(edge);
                }
                for (Node node : oldNodes) {
                    diagram.removeChild((View)node);
                    helper.removeNodeModel(model, node.getElement());
                }
                for (Edge edge : oldEdges) {
                    diagram.removeEdge(edge);
                    helper.removeEdgeModel(model, edge.getElement());
                }
                helper.reassociate(act, baseCopy);
                for (Object e : baseCopy.getChildren()) {
                    BridgeHelper.markInherited((EModelElement)((View)e));
                }
                for (Object e : baseCopy.getEdges()) {
                    BridgeHelper.markInherited((EModelElement)((View)e));
                }
                diagram.getPersistedChildren().addAll((Collection)baseCopy.getChildren());
                diagram.getPersistedEdges().addAll((Collection)baseCopy.getEdges());
                Collection<?> collection = helper.getNodeModels(baseCopy.getElement());
                if (collection != null && !collection.isEmpty()) {
                    helper.addNodeModels(model, collection);
                }
                if ((baseEdgeModels = helper.getEdgeModels(baseCopy.getElement())) != null && !baseEdgeModels.isEmpty()) {
                    helper.addEdgeModels(model, baseEdgeModels);
                }
            }
            finally {
                model.eSetDeliver(notification);
            }
            try {
                if (this.targetPart instanceof AbstractDiagramEditor) {
                    DiagramEditorUtil.resetEditor((AbstractDiagramEditor)this.targetPart);
                }
            }
            catch (Exception exception) {}
        }
        finally {
            diagramSvc.dispose();
        }
        return true;
    }

    public static Command copyDiagram(EditingDomain domain, Diagram diagram) {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(diagram.getElement());
        list.add(diagram);
        Command cmd = CopyCommand.create((EditingDomain)domain, list);
        cmd.execute();
        return cmd;
    }

    public void initialize() {
        if (this.targetPart instanceof AbstractDiagramEditor) {
            AbstractDiagramEditor editor = (AbstractDiagramEditor)this.targetPart;
            editor.getDiagramEditPart();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface IDiagramAssociationHelper {
        public MethodElement getMethodElement(Node var1, ResourceSet var2);

        public Node findNode(Diagram var1, MethodElement var2);

        public void reassociate(org.eclipse.epf.uma.Activity var1, Diagram var2);

        public void addNodeModels(EObject var1, Collection<?> var2);

        public void addEdgeModels(EObject var1, Collection<?> var2);

        public void removeNodeModel(EObject var1, EObject var2);

        public void removeEdgeModel(EObject var1, EObject var2);

        public Collection<?> getNodeModels(EObject var1);

        public Collection<?> getEdgeModels(EObject var1);
    }
}

