/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.core.bridge;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.epf.diagram.core.bridge.BridgeHelper;
import org.eclipse.epf.diagram.core.bridge.ControlNodeAdapter;
import org.eclipse.epf.diagram.core.bridge.DiagramAdapter;
import org.eclipse.epf.diagram.core.bridge.NodeAdapter;
import org.eclipse.epf.diagram.core.bridge.WorkBreakdownElementNodeAdapter;
import org.eclipse.epf.diagram.model.util.IAdapterFactoryFilter;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.process.ActivityWrapperItemProvider;
import org.eclipse.epf.library.edit.process.BSActivityItemProvider;
import org.eclipse.epf.library.edit.process.BreakdownElementWrapperItemProvider;
import org.eclipse.epf.library.edit.process.IBSItemProvider;
import org.eclipse.epf.library.edit.process.WBSActivityItemProvider;
import org.eclipse.epf.library.edit.util.ConfigurableComposedAdapterFactory;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Milestone;
import org.eclipse.epf.uma.TaskDescriptor;
import org.eclipse.epf.uma.UmaFactory;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.WorkBreakdownElement;
import org.eclipse.epf.uma.WorkOrder;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.ActivityEdge;
import org.eclipse.uml2.uml.ActivityNode;
import org.eclipse.uml2.uml.ActivityParameterNode;
import org.eclipse.uml2.uml.ControlNode;
import org.eclipse.uml2.uml.StructuredActivityNode;
import org.eclipse.uml2.uml.UMLFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActivityDiagramAdapter
extends DiagramAdapter {
    public ActivityDiagramAdapter(BreakdownElementWrapperItemProvider wrapper) {
        super(wrapper);
    }

    public ActivityDiagramAdapter(org.eclipse.epf.uma.Activity e) {
        super(e);
    }

    @Override
    protected ActivityNode addNode(Collection nodes, Object obj) {
        org.eclipse.epf.uma.Activity act;
        VariabilityElement base;
        if (obj instanceof org.eclipse.epf.uma.Activity && (base = (act = (org.eclipse.epf.uma.Activity)obj).getVariabilityBasedOnElement()) != null) {
            Activity diagram = this.getDiagram();
            ActivityNode baseNode = BridgeHelper.findNode(diagram, base);
            if (baseNode == null) {
                baseNode = BridgeHelper.findNode(diagram, act);
            }
            if (baseNode != null) {
                NodeAdapter nodeAdapter = BridgeHelper.getNodeAdapter((EObject)baseNode);
                if (nodeAdapter != null) {
                    nodeAdapter.dispose();
                }
                if ((nodeAdapter = this.createNodeAdapter((MethodElement)act)) != null) {
                    this.initializeNodeAdapter(nodeAdapter);
                    baseNode.eAdapters().add((Object)nodeAdapter);
                    nodeAdapter.updateView();
                    BridgeHelper.associate((EModelElement)baseNode, (MethodElement)act);
                    if (BridgeHelper.isInherited((EModelElement)nodeAdapter.getView())) {
                        BridgeHelper.unmarkInHerited((EModelElement)nodeAdapter.getView());
                    }
                    nodeAdapter.setTargetReadOnly(false);
                }
                return null;
            }
        }
        return super.addNode(nodes, obj);
    }

    @Override
    protected NodeAdapter createNodeAdapter(MethodElement e) {
        if (e instanceof WorkBreakdownElement) {
            return new WorkBreakdownElementNodeAdapter(e);
        }
        return null;
    }

    @Override
    protected void addToUmaModel(int position, ActivityNode addedNode) {
        MethodElement e = BridgeHelper.getMethodElement((EModelElement)addedNode);
        if (e == null) {
            return;
        }
        org.eclipse.epf.uma.Activity act = (org.eclipse.epf.uma.Activity)this.getElement();
        int i = this.toActivityIndex(position);
        NodeAdapter nodeAdapter = BridgeHelper.getNodeAdapter((EObject)addedNode);
        boolean notify = nodeAdapter.notificationEnabled;
        try {
            nodeAdapter.notificationEnabled = false;
            this.getActionManager().doAction(3, (EObject)act, (EStructuralFeature)UmaPackage.Literals.ACTIVITY__BREAKDOWN_ELEMENTS, (Object)e, i);
            BridgeHelper.addEAnnotation((EModelElement)addedNode, e);
        }
        finally {
            nodeAdapter.notificationEnabled = notify;
        }
        super.addToUmaModel(position, addedNode);
    }

    /*
     * Unable to fully structure code
     */
    private int toActivityIndex(int index) {
        if (index == -1) {
            return index;
        }
        i = index + 1;
        size = this.getNodes().size();
        if (i == size) {
            return -1;
        }
        node = (ActivityNode)this.getNodes().get(i);
        if (node != null) ** GOTO lbl12
        return -1;
lbl-1000:
        // 1 sources

        {
            node = (ActivityNode)this.getNodes().get(i);
            ++i;
lbl12:
            // 2 sources

            ** while (!(BridgeHelper.getMethodElement((EModelElement)node) instanceof BreakdownElement) && i < size)
        }
lbl13:
        // 1 sources

        if (i == size) {
            return -1;
        }
        act = (org.eclipse.epf.uma.Activity)this.getElement();
        return act.getBreakdownElements().indexOf(BridgeHelper.getMethodElement((EModelElement)node));
    }

    @Override
    protected List getBreakdownElementTypes() {
        return Collections.singletonList(WorkBreakdownElement.class);
    }

    @Override
    protected ActivityNode newNode(MethodElement e) {
        StructuredActivityNode node = null;
        if (e instanceof org.eclipse.epf.uma.Activity) {
            node = UMLFactory.eINSTANCE.createStructuredActivityNode();
        } else if (e instanceof TaskDescriptor || e instanceof Milestone) {
            node = UMLFactory.eINSTANCE.createActivityParameterNode();
        } else if (e instanceof WorkBreakdownElement) {
            node = UMLFactory.eINSTANCE.createStructuredActivityNode();
        }
        if (node != null) {
            BridgeHelper.associate((EModelElement)node, e);
        }
        return node;
    }

    private boolean isValid(ActivityEdge link) {
        return link.getSource() != null && link.getTarget() != null && this.getNodes().contains(link.getSource()) && this.getNodes().contains(link.getTarget());
    }

    private static boolean isValidWorkOrder(WorkOrder wo, Object pred) {
        if (wo.getPred() == pred) {
            return true;
        }
        if (pred instanceof org.eclipse.epf.uma.Activity) {
            org.eclipse.epf.uma.Activity act = (org.eclipse.epf.uma.Activity)pred;
            VariabilityElement ve = act.getVariabilityBasedOnElement();
            while (ve != null) {
                if (ve == wo.getPred()) {
                    return true;
                }
                ve = ve.getVariabilityBasedOnElement();
            }
        }
        return false;
    }

    private static boolean canReachAsFirstActivityNode(ActivityNode predNode, ActivityNode node) {
        for (ActivityEdge link : predNode.getOutgoings()) {
            if (link.getTarget() == node) {
                return true;
            }
            if (!(link.getTarget() instanceof ControlNode) || !ActivityDiagramAdapter.canReachAsFirstActivityNode(link.getTarget(), node)) continue;
            return true;
        }
        return false;
    }

    AdapterFactory getAdapterFactory() {
        ComposedAdapterFactory adapterFactory = null;
        if (this.filter == null) {
            adapterFactory = TngAdapterFactory.INSTANCE.getWBS_ComposedAdapterFactory();
        } else if (this.filter instanceof IAdapterFactoryFilter) {
            adapterFactory = (ConfigurableComposedAdapterFactory)((IAdapterFactoryFilter)this.filter).getWBSAdapterFactory();
        }
        return adapterFactory;
    }

    @Override
    protected void populateLinks(List<ActivityNode> selectedNodes) {
        if (selectedNodes.isEmpty()) {
            return;
        }
        super.populateLinks(selectedNodes);
        for (ActivityNode node : selectedNodes) {
            ActivityEdge link2;
            WorkBreakdownElement wbe = null;
            MethodElement me = BridgeHelper.getMethodElement((EModelElement)node);
            if (me instanceof WorkBreakdownElement) {
                wbe = (WorkBreakdownElement)me;
            }
            ArrayList<ActivityEdge> linksToRemove = new ArrayList<ActivityEdge>();
            for (ActivityEdge link2 : node.getIncomings()) {
                if (!this.isValid(link2)) {
                    linksToRemove.add(link2);
                }
                if (wbe == null || link2.getSource() != null && link2.getSource() instanceof ControlNode) continue;
                MethodElement pred = BridgeHelper.getMethodElement((EModelElement)link2.getSource());
                boolean workOrderFound = false;
                for (WorkOrder wo : wbe.getLinkToPredecessor()) {
                    if (!ActivityDiagramAdapter.isValidWorkOrder(wo, pred)) continue;
                    workOrderFound = true;
                    break;
                }
                if (workOrderFound) continue;
                linksToRemove.add(link2);
            }
            link2 = linksToRemove.iterator();
            while (link2.hasNext()) {
                ActivityEdge link3 = (ActivityEdge)link2.next();
                BridgeHelper.removeLink(link3);
            }
            linksToRemove.clear();
            for (ActivityEdge link2 : node.getOutgoings()) {
                if (this.isValid(link2)) continue;
                linksToRemove.add(link2);
            }
            for (ActivityEdge link2 : linksToRemove) {
                BridgeHelper.removeLink(link2);
            }
            linksToRemove.clear();
            linksToRemove = null;
        }
        AdapterFactory adapterFactory = this.getAdapterFactory();
        for (ActivityNode node : selectedNodes) {
            MethodElement e = BridgeHelper.getMethodElement((EModelElement)node);
            if (!(e instanceof WorkBreakdownElement)) continue;
            ArrayList list = new ArrayList();
            WorkBreakdownElement local = (WorkBreakdownElement)e;
            list.addAll(local.getLinkToPredecessor());
            ITreeItemContentProvider adapter = null;
            adapter = (ITreeItemContentProvider)adapterFactory.adapt((Notifier)local, ITreeItemContentProvider.class);
            if (adapter instanceof IBSItemProvider) {
                list.addAll(((IBSItemProvider)adapter).getPredecessors());
            }
            for (Object next : list) {
                ActivityNode predNode;
                WorkOrder workOrder = null;
                WorkBreakdownElement pred = null;
                if (next instanceof WorkOrder) {
                    workOrder = (WorkOrder)next;
                    pred = workOrder.getPred();
                }
                if (next instanceof WBSActivityItemProvider) {
                    pred = (BreakdownElement)((WBSActivityItemProvider)next).getTarget();
                }
                if (pred == null || !(pred instanceof WorkBreakdownElement) || (predNode = BridgeHelper.findNode(this.getDiagram(), pred, true)) == null) continue;
                boolean linkFound = false;
                for (ActivityEdge link : node.getIncomings()) {
                    if (link.getSource() != predNode) continue;
                    linkFound = true;
                    if (link != null) break;
                    BridgeHelper.setSemanticModel(link, workOrder);
                    break;
                }
                if (linkFound || ActivityDiagramAdapter.canReachAsFirstActivityNode(predNode, node)) continue;
                NodeAdapter nodeAdapter = BridgeHelper.getNodeAdapter((EObject)node);
                NodeAdapter predNodeAdapter = BridgeHelper.getNodeAdapter((EObject)predNode);
                if (nodeAdapter == null || predNodeAdapter == null) continue;
                boolean oldNotify = nodeAdapter.notificationEnabled;
                boolean predNodeNotify = predNodeAdapter.notificationEnabled;
                try {
                    nodeAdapter.notificationEnabled = false;
                    predNodeAdapter.notificationEnabled = false;
                    nodeAdapter.addIncomingConnection((MethodElement)pred);
                }
                finally {
                    nodeAdapter.notificationEnabled = oldNotify;
                    predNodeAdapter.notificationEnabled = predNodeNotify;
                }
            }
        }
        this.cleanDuplicateLinks(selectedNodes);
    }

    private void cleanDuplicateLinks(List<ActivityNode> selectedNodes) {
        ArrayList duplicateLinks = new ArrayList();
        for (ActivityNode wbNode : selectedNodes) {
            if (wbNode.getIncomings() != null) {
                this.findDuplicateLinks(duplicateLinks, (List)wbNode.getIncomings());
            }
            if (wbNode.getOutgoings() == null) continue;
            this.findDuplicateLinks(duplicateLinks, (List)wbNode.getOutgoings());
        }
        for (ActivityEdge link : duplicateLinks) {
            BridgeHelper.removeLink(link);
        }
        duplicateLinks.clear();
        duplicateLinks = null;
    }

    private void findDuplicateLinks(List duplicateLinks, List links) {
        int i = 0;
        while (i < links.size()) {
            ActivityEdge link = (ActivityEdge)links.get(i);
            if (!duplicateLinks.contains(link)) {
                int j = i + 1;
                while (j < links.size()) {
                    ActivityEdge link1 = (ActivityEdge)links.get(j);
                    if (link1.getSource() == link.getSource() && link1.getTarget() == link.getTarget()) {
                        duplicateLinks.add(link1);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    @Override
    protected Collection populateNodes() {
        HashSet selectedNodes = new HashSet();
        Collection children = this.getChildren();
        selectedNodes.addAll(this.associateControlNodes(children));
        selectedNodes.addAll(this.addElementNodes(children));
        return selectedNodes;
    }

    private List associateControlNodes(Collection methodElements) {
        ArrayList<ActivityNode> ctrlNodes = new ArrayList<ActivityNode>();
        for (ActivityNode node : this.getDiagram().getNodes()) {
            if (!(node instanceof ControlNode) || this.addNodeAdapterTo(node) == null) continue;
            ctrlNodes.add(node);
        }
        return ctrlNodes;
    }

    private List addElementNodes(Collection methodElements) {
        ArrayList<ActivityNode> nodes = new ArrayList<ActivityNode>();
        ArrayList<ActivityNode> newNodes = new ArrayList<ActivityNode>();
        for (Object e : methodElements) {
            BreakdownElementWrapperItemProvider wrapper;
            Object child = TngUtil.unwrap(e);
            if (!(child instanceof WorkBreakdownElement)) continue;
            ActivityNode node = BridgeHelper.findNode(this.getDiagram(), child);
            if (node == null) {
                node = this.toNode((MethodElement)child);
                newNodes.add(node);
            } else {
                String name = BridgeHelper.getNodeName((MethodElement)child);
                if (!name.equals(node.getName())) {
                    node.setName(name);
                }
                this.addNodeAdapterTo(node);
            }
            nodes.add(node);
            if (!(e instanceof BreakdownElementWrapperItemProvider) || this.isTargetReadOnly() || !(wrapper = (BreakdownElementWrapperItemProvider)e).isReadOnly()) continue;
            NodeAdapter nodeAdapter = BridgeHelper.getNodeAdapter((EObject)node);
            nodeAdapter.wrapper = wrapper;
            nodeAdapter.basicSetTargetReadOnly(true);
        }
        this.getNodes().addAll(newNodes);
        return nodes;
    }

    private ITreeItemContentProvider getAdapter() {
        Object adapter = null;
        adapter = this.wrapper != null ? this.wrapper : (ITreeItemContentProvider)this.getAdapterFactory().adapt((Notifier)this.getElement(), ITreeItemContentProvider.class);
        return adapter;
    }

    public Collection getChildren() {
        ITreeItemContentProvider adapter = this.getAdapter();
        if (adapter != null) {
            Object obj = null;
            boolean enableVariabilityInfo = false;
            if (adapter instanceof ActivityWrapperItemProvider) {
                obj = ((ActivityWrapperItemProvider)adapter).getDelegatingItemProvider();
            }
            if (adapter instanceof BSActivityItemProvider) {
                obj = adapter;
            }
            if (obj instanceof BSActivityItemProvider) {
                enableVariabilityInfo = ((BSActivityItemProvider)obj).isEnableVariabilityInfo();
                ((BSActivityItemProvider)obj).setEnableVariabilityInfo(false);
            }
            ArrayList children = new ArrayList();
            this.extractChildren(adapter, this.getElement(), children);
            if (obj instanceof BSActivityItemProvider) {
                ((BSActivityItemProvider)obj).setEnableVariabilityInfo(enableVariabilityInfo);
            }
            return children;
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    protected boolean removeNode(Object obj) {
        org.eclipse.epf.uma.Activity act;
        VariabilityElement base;
        if (obj instanceof org.eclipse.epf.uma.Activity && (base = (act = (org.eclipse.epf.uma.Activity)obj).getVariabilityBasedOnElement()) != null) {
            Activity diagram = this.getDiagram();
            ActivityNode node = BridgeHelper.findNode(diagram, act);
            if (node == null) {
                node = BridgeHelper.findNode(diagram, base);
            }
            if (node != null) {
                NodeAdapter nodeAdapter = BridgeHelper.getNodeAdapter((EObject)node);
                if (nodeAdapter != null) {
                    nodeAdapter.dispose();
                }
                if ((nodeAdapter = this.createNodeAdapter((MethodElement)base)) != null) {
                    this.initializeNodeAdapter(nodeAdapter);
                    nodeAdapter.basicSetTargetReadOnly(true);
                    node.eAdapters().add((Object)nodeAdapter);
                    nodeAdapter.updateView();
                    if (!BridgeHelper.isInherited((EModelElement)nodeAdapter.getView())) {
                        BridgeHelper.markInherited((EModelElement)nodeAdapter.getView());
                    }
                }
                return false;
            }
        }
        return super.removeNode(obj);
    }

    @Override
    protected NodeAdapter addNodeAdapterTo(ActivityNode node) {
        NodeAdapter adapter = BridgeHelper.getNodeAdapter((EObject)node);
        if (adapter != null) {
            return adapter;
        }
        if (node instanceof ControlNode) {
            adapter = new ControlNodeAdapter();
        } else {
            Object e = BridgeHelper.getMethodElement((EModelElement)node);
            if (e == null) {
                if (node instanceof StructuredActivityNode) {
                    String type = BridgeHelper.getType((ActivityNode)((StructuredActivityNode)node));
                    e = "Phase".equals(type) ? UmaFactory.eINSTANCE.createPhase() : ("Iteration".equals(type) ? UmaFactory.eINSTANCE.createIteration() : UmaFactory.eINSTANCE.createActivity());
                } else if (node instanceof ActivityParameterNode) {
                    String type = BridgeHelper.getType((ActivityNode)((ActivityParameterNode)node));
                    e = "Milestone".equals(type) ? UmaFactory.eINSTANCE.createMilestone() : UmaFactory.eINSTANCE.createTaskDescriptor();
                }
            }
            if (e != null) {
                adapter = new WorkBreakdownElementNodeAdapter((MethodElement)e);
            }
        }
        if (adapter != null) {
            this.initializeNodeAdapter(adapter);
            node.eAdapters().add((Object)adapter);
            return adapter;
        }
        return null;
    }

    private ActivityNode reassociateBaseNode(org.eclipse.epf.uma.Activity act) {
        VariabilityElement base = act.getVariabilityBasedOnElement();
        if (base != null) {
            Activity diagram = this.getDiagram();
            ActivityNode baseNode = BridgeHelper.findNode(diagram, base);
            if (baseNode == null) {
                baseNode = BridgeHelper.findNode(diagram, act);
            }
            if (baseNode != null) {
                NodeAdapter nodeAdapter = BridgeHelper.getNodeAdapter((EObject)baseNode);
                if (nodeAdapter != null) {
                    nodeAdapter.dispose();
                }
                if ((nodeAdapter = this.createNodeAdapter((MethodElement)act)) != null) {
                    this.initializeNodeAdapter(nodeAdapter);
                    baseNode.eAdapters().add((Object)nodeAdapter);
                    nodeAdapter.updateView();
                    BridgeHelper.associate((EModelElement)baseNode, (MethodElement)act);
                    if (BridgeHelper.isInherited((EModelElement)nodeAdapter.getView())) {
                        BridgeHelper.unmarkInHerited((EModelElement)nodeAdapter.getView());
                    }
                    nodeAdapter.setTargetReadOnly(false);
                }
                return baseNode;
            }
        }
        return null;
    }

    @Override
    protected void replaceNode(Object oldElement, Object newElement) {
        Activity diagram;
        ActivityNode oldNode;
        if (newElement instanceof MethodElement && (oldNode = BridgeHelper.findNode(diagram = this.getDiagram(), oldElement)) != null) {
            MethodElement e;
            NodeAdapter nodeAdapter = BridgeHelper.getNodeAdapter((EObject)oldNode);
            if (nodeAdapter != null) {
                nodeAdapter.dispose();
            }
            if ((nodeAdapter = this.createNodeAdapter(e = (MethodElement)newElement)) != null) {
                this.initializeNodeAdapter(nodeAdapter);
                oldNode.eAdapters().add((Object)nodeAdapter);
                nodeAdapter.updateView();
                BridgeHelper.associate((EModelElement)oldNode, e);
            }
        }
    }
}

