/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.core.part;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.epf.diagram.core.part.DiagramEditorInput;
import org.eclipse.epf.diagram.core.part.IDiagramFileEditorInputProxy;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInputFactory;

public class DiagramFileEditorInputProxy
implements IDiagramFileEditorInputProxy {
    private DiagramEditorInput diagramEditorInput;
    private IFile file;
    private TransactionalEditingDomain domain;

    protected DiagramFileEditorInputProxy(DiagramEditorInput input) {
        this.diagramEditorInput = input;
    }

    public DiagramEditorInput getDiagramEditorInput() {
        return this.diagramEditorInput;
    }

    public TransactionalEditingDomain getEditingDomain() {
        return this.domain;
    }

    public boolean exists() {
        return this.file.exists();
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IFile.class) {
            return this.file;
        }
        return this.file.getAdapter(adapter);
    }

    public String getFactoryId() {
        return FileEditorInputFactory.getFactoryId();
    }

    public IFile getFile() {
        return this.file;
    }

    public ImageDescriptor getImageDescriptor() {
        IContentType contentType = IDE.getContentType((IFile)this.file);
        return PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(this.file.getName(), contentType);
    }

    public String getName() {
        return this.file.getName();
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public IStorage getStorage() throws CoreException {
        return this.file;
    }

    public String getToolTipText() {
        return this.diagramEditorInput.getMethodElement().getName();
    }

    public void saveState(IMemento memento) {
    }

    public void setTransactionalEditingDomain(TransactionalEditingDomain domain) {
        this.domain = domain;
    }

    public IPath getPath() {
        return this.file.getLocation();
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "(" + this.getFile().getFullPath() + ")";
    }
}

