/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.core.services;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.command.CopyCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.impl.InternalTransactionalEditingDomain;
import org.eclipse.epf.common.CommonPlugin;
import org.eclipse.epf.diagram.core.DiagramCorePlugin;
import org.eclipse.epf.diagram.core.DiagramCoreResources;
import org.eclipse.epf.diagram.core.bridge.BridgeHelper;
import org.eclipse.epf.diagram.core.bridge.DiagramAdapter;
import org.eclipse.epf.diagram.core.services.DiagramManager;
import org.eclipse.epf.diagram.model.Node;
import org.eclipse.epf.diagram.model.util.TxUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.persistence.FileManager;
import org.eclipse.epf.services.ILibraryPersister;
import org.eclipse.epf.services.Services;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.gmf.runtime.diagram.core.DiagramEditingDomainFactory;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.uml2.uml.Activity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiagramHelper {
    public static final int[] DIAGRAM_TYPES;

    static {
        int[] nArray = new int[3];
        nArray[1] = 2;
        nArray[2] = 1;
        DIAGRAM_TYPES = nArray;
    }

    public static int getDiagramType(Diagram diagram) {
        String typeStr = diagram.getType();
        if (typeStr.equals("AD")) {
            return 0;
        }
        if (typeStr.equals("ADD")) {
            return 2;
        }
        if (typeStr.equals("WPDD")) {
            return 1;
        }
        return -1;
    }

    public static org.eclipse.gmf.runtime.notation.Node findNode(Diagram diagram, Object object) {
        if (object == null) {
            return null;
        }
        for (View view : diagram.getChildren()) {
            if (!(view instanceof org.eclipse.gmf.runtime.notation.Node) || view.getElement() == null) continue;
            EObject e = null;
            if (object instanceof MethodElement && view.getElement() instanceof EModelElement) {
                Resource resource;
                EModelElement modelElement = (EModelElement)view.getElement();
                e = BridgeHelper.getMethodElement(modelElement);
                if (e == null && (resource = ((MethodElement)object).eResource()).getResourceSet() != null) {
                    e = BridgeHelper.getMethodElementFromAnnotation(modelElement, resource.getResourceSet());
                }
            } else {
                e = view.getElement();
            }
            if (!object.equals(e)) continue;
            return (org.eclipse.gmf.runtime.notation.Node)view;
        }
        return null;
    }

    public static org.eclipse.gmf.runtime.notation.Node findNodeInModelDiagram(Diagram diagram, MethodElement e) {
        for (View view : diagram.getChildren()) {
            if (!(view instanceof org.eclipse.gmf.runtime.notation.Node)) continue;
            MethodElement ex = null;
            EObject model = view.getElement();
            if (!(model instanceof Node) || (ex = ((Node)model).getLinkedElement()) == null || ex != e) continue;
            return (org.eclipse.gmf.runtime.notation.Node)view;
        }
        return null;
    }

    public static void deleteDiagram(final Diagram diagram, boolean save) throws Exception {
        String filePath;
        if (diagram == null) {
            return;
        }
        boolean fileExist = true;
        File file = null;
        MethodElement linkedObject = null;
        Process process = null;
        if (diagram.getElement() instanceof Activity) {
            DiagramAdapter adapter = BridgeHelper.getDiagramAdapter(diagram.getElement());
            if (adapter != null && (linkedObject = adapter.getWrapper()) == null) {
                linkedObject = adapter.getElement();
            }
        } else {
            org.eclipse.epf.diagram.model.Diagram diagramModel = (org.eclipse.epf.diagram.model.Diagram)diagram.getElement();
            linkedObject = diagramModel.getLinkedElement();
        }
        if (linkedObject != null && !(file = new File(filePath = DiagramManager.getDiagramFilePath(process = TngUtil.getOwningProcess((Object)linkedObject)))).exists()) {
            fileExist = false;
        }
        final Resource resource = diagram.eResource();
        if (file == null && resource != null && !(file = new File(FileManager.toFileString((URI)resource.getURI()))).exists()) {
            fileExist = false;
        }
        if (resource != null) {
            TxUtil.runInTransaction((EObject)diagram, (Runnable)new Runnable(){

                public void run() {
                    resource.getContents().remove((Object)diagram.getElement());
                    resource.getContents().remove((Object)diagram);
                    UmaUtil.removeAllAdapters((EObject)diagram.getElement());
                    UmaUtil.removeAllAdapters((EObject)diagram);
                }
            });
            if (!fileExist) {
                return;
            }
            if (save) {
                ILibraryPersister.FailSafeMethodLibraryPersister persister = Services.getLibraryPersister((String)"xmi").getFailSafePersister();
                try {
                    persister.save(resource);
                    persister.commit();
                }
                catch (Exception e) {
                    CommonPlugin.getDefault().getLogger().logError((Throwable)e);
                    persister.rollback();
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.epf.diagram.core", 1, e.getLocalizedMessage(), null));
                }
            }
        }
    }

    public static InternalTransactionalEditingDomain getEditingDomain() {
        return (InternalTransactionalEditingDomain)DiagramEditingDomainFactory.getInstance().createEditingDomain();
    }

    public static InternalTransactionalEditingDomain getEditingDomain(Diagram diagram) {
        if (diagram == null) {
            return DiagramHelper.getEditingDomain();
        }
        Resource resource = diagram.eResource();
        if (resource == null) {
            return DiagramHelper.getEditingDomain();
        }
        return (InternalTransactionalEditingDomain)DiagramEditingDomainFactory.getInstance().getEditingDomain(resource.getResourceSet());
    }

    public static Collection<Diagram> getDiagrams(org.eclipse.epf.uma.Activity act, DiagramManager mgr) {
        try {
            ArrayList<Diagram> diagrams = new ArrayList<Diagram>();
            int i = 0;
            while (i < DIAGRAM_TYPES.length) {
                List<Diagram> list = mgr.getDiagrams(act, DIAGRAM_TYPES[i]);
                if (!list.isEmpty()) {
                    diagrams.addAll(list);
                }
                ++i;
            }
            return diagrams;
        }
        catch (Exception e) {
            DiagramCorePlugin.getDefault().getLogger().logError((Throwable)e);
            return Collections.emptyList();
        }
    }

    public static String getDiagramTypeString(Diagram diagram) {
        String typeStr = diagram.getType();
        if (typeStr.equals("AD")) {
            return DiagramCoreResources.ActivityDiagram_kind;
        }
        if (typeStr.equals("ADD")) {
            return DiagramCoreResources.ActivityDetail_Diagram_kind;
        }
        if (typeStr.equals("WPDD")) {
            return DiagramCoreResources.WorkProductDependency_Diagram_kind;
        }
        return "";
    }

    public static Diagram copyDiagram(EditingDomain domain, Diagram diagram) {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(diagram.getElement());
        list.add(diagram);
        Command cmd = CopyCommand.create((EditingDomain)domain, list);
        cmd.execute();
        for (Object element : cmd.getResult()) {
            if (!(element instanceof Diagram)) continue;
            Diagram copy = (Diagram)element;
            return copy;
        }
        return null;
    }

    public static void reassociate(org.eclipse.epf.uma.Activity activity, Diagram copyOfBaseDiagram) {
        for (Object element : activity.getBreakdownElements()) {
            org.eclipse.gmf.runtime.notation.Node node;
            VariabilityElement baseElement;
            if (!(element instanceof org.eclipse.epf.uma.Activity) || (baseElement = ((org.eclipse.epf.uma.Activity)element).getVariabilityBasedOnElement()) == null || (node = DiagramHelper.findNode(copyOfBaseDiagram, baseElement)) == null) continue;
            EObject umlObj = node.getElement();
            BridgeHelper.addEAnnotation((EModelElement)umlObj, (MethodElement)element);
        }
    }
}

