/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.core.services;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.epf.diagram.core.DiagramCorePlugin;
import org.eclipse.epf.diagram.core.services.DiagramHelper;
import org.eclipse.epf.diagram.core.services.DiagramManager;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.Process;
import org.eclipse.gmf.runtime.notation.Diagram;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiagramService {
    private Set<DiagramManager> diagramManagers = new HashSet<DiagramManager>();

    public void dispose() {
        for (DiagramManager mgr : this.diagramManagers) {
            mgr.removeConsumer(this);
        }
    }

    public DiagramManager getDiagramManager(Activity act) {
        Process proc = TngUtil.getOwningProcess((BreakdownElement)act);
        if (proc != null) {
            DiagramManager mgr = DiagramManager.getInstance(TngUtil.getOwningProcess((BreakdownElement)act), this);
            this.diagramManagers.add(mgr);
            return mgr;
        }
        return null;
    }

    public Collection<Diagram> getDiagrams(Activity act) {
        DiagramManager mgr = this.getDiagramManager(act);
        return mgr != null ? DiagramHelper.getDiagrams(act, mgr) : Collections.EMPTY_LIST;
    }

    public Diagram getBaseDiagram(Activity act, int type) {
        if (ProcessUtil.isExtendingOrLocallyContributing((BreakdownElement)act)) {
            try {
                Activity baseAct = (Activity)act.getVariabilityBasedOnElement();
                DiagramManager mgr = this.getDiagramManager(baseAct);
                List<Diagram> baseDiagrams = mgr.getDiagrams(baseAct, type);
                if (!baseDiagrams.isEmpty()) {
                    return baseDiagrams.get(0);
                }
            }
            catch (Exception e) {
                DiagramCorePlugin.getDefault().getLogger().logError("Error in getting base diagram: ", (Throwable)e);
            }
        }
        return null;
    }

    public Diagram getDiagram(Activity act, int type) {
        try {
            DiagramManager mgr = this.getDiagramManager(act);
            List<Diagram> diagrams = mgr.getDiagrams(act, type);
            return diagrams.isEmpty() ? null : diagrams.get(0);
        }
        catch (Exception e) {
            DiagramCorePlugin.getDefault().getLogger().logError((Throwable)e);
            return null;
        }
    }
}

