/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.ui;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.epf.common.service.utils.CommandLineRunUtil;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.common.utils.I18nUtil;
import org.eclipse.epf.common.utils.NetUtil;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.LibraryServiceUtil;
import org.eclipse.epf.library.edit.ui.UserInteractionHelper;
import org.eclipse.epf.library.layout.LayoutResources;
import org.eclipse.epf.library.persistence.ILibraryResourceSet;
import org.eclipse.epf.library.preferences.LibraryPreferences;
import org.eclipse.epf.library.prefs.PreferenceUtil;
import org.eclipse.epf.library.services.SafeUpdateController;
import org.eclipse.epf.library.ui.LibraryUIPlugin;
import org.eclipse.epf.library.ui.LibraryUIResources;
import org.eclipse.epf.library.ui.actions.ConfigurationContributionItem;
import org.eclipse.epf.library.ui.dialogs.CopyLibraryDialog;
import org.eclipse.epf.library.ui.preferences.LibraryUIPreferences;
import org.eclipse.epf.library.ui.wizards.LibraryBackupUtil;
import org.eclipse.epf.library.xmi.XMILibraryUtil;
import org.eclipse.epf.persistence.migration.MappingUtil;
import org.eclipse.epf.persistence.migration.UpgradeCallerInfo;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.util.MessageException;
import org.eclipse.jface.action.CoolBarManager;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.ToolBarContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LibraryUIManager {
    public static boolean DEBUG = LibraryUIPlugin.getDefault().isDebugging();
    private static final String TOOLBAR_CONFIG_CONTRIBUTION_ID = "toolbar.config.contribution";
    private static final String CONFIG_VIEW_ID = "org.eclipse.epf.authoring.ui.views.ConfigurationView";
    private static final String PROCESS_EDITOR_ID = "org.eclipse.epf.authoring.ui.editors.ProcessEditor";
    private static final String REPORT_PERS_ID = "org.eclipse.birt.report.designer.ui.ReportPerspective";
    private static LibraryUIManager instance = null;
    protected static URI libraryURI;
    protected static URI defaultLibraryURI;
    protected static URI defaultLibraryURI_NL;
    private boolean libraryInitialized = false;
    protected ConfigurationContributionItem configCombo = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LibraryUIManager getInstance() {
        if (instance != null) return instance;
        Class<LibraryUIManager> clazz = LibraryUIManager.class;
        synchronized (LibraryUIManager.class) {
            if (instance != null) return instance;
            instance = new LibraryUIManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private LibraryUIManager() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            window.addPerspectiveListener(new IPerspectiveListener(){

                public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor desc) {
                    LibraryUIManager.this.checkConfigurationContribution();
                }

                public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor desc, String id) {
                    LibraryUIManager.this.checkConfigurationContribution();
                }
            });
        }
    }

    public boolean createLibrary(String path) {
        try {
            File libraryPath = new File(path);
            if (!libraryPath.exists()) {
                libraryPath.mkdirs();
            }
            XMILibraryUtil.createMethodLibrary((String)libraryPath.getName(), (String)path);
            LibraryUIPreferences.setSavedLibraryPath(path);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean openDefaultLibrary(final URI uri) {
        block3: {
            try {
                File defaultLibraryPathFile = new File(uri);
                File libraryXMIFile = new File(defaultLibraryPathFile, "library.xmi");
                if (libraryXMIFile.exists()) break block3;
                return false;
            }
            catch (Exception exception) {
                return false;
            }
        }
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) {
                try {
                    try {
                        URI libUri = uri;
                        String newPath = LibraryUIManager.this.handleLibraryOnReadOnlyInstallPath(libUri);
                        if (newPath != null) {
                            libUri = StrUtil.toURI((String)newPath);
                        }
                        String taskName = LibraryUIResources.openingLibraryTask_name;
                        monitor.beginTask(taskName, 2);
                        monitor.setTaskName(taskName);
                        monitor.worked(1);
                        LibraryService.getInstance().closeCurrentMethodLibrary();
                        LibraryService.getInstance().openMethodLibrary("xmi", libUri);
                    }
                    catch (Exception e) {
                        LibraryUIPlugin.getDefault().getLogger().logError((Throwable)e);
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        Shell shell = Display.getCurrent().getActiveShell();
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(shell){

            protected void configureShell(Shell shell) {
                super.configureShell(shell);
                shell.setText(LibraryUIResources.openLibraryWizard_title);
            }
        };
        dialog.run(true, false, (IRunnableWithProgress)operation);
        return LibraryService.getInstance().getCurrentMethodLibrary() != null;
    }

    public boolean openLastOpenedLibrary() {
        block3: {
            try {
                String savedMethodLibraryURI = LibraryPreferences.getSavedMethodLibraryURI();
                URI uri = new URI(savedMethodLibraryURI);
                if (uri.getPath().length() != 0) break block3;
                return false;
            }
            catch (Exception exception) {
                return false;
            }
        }
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) {
                try {
                    try {
                        String taskName = LibraryUIResources.openingLibraryTask_name;
                        monitor.beginTask(taskName, 2);
                        monitor.setTaskName(taskName);
                        monitor.worked(1);
                        LibraryService.getInstance().closeCurrentMethodLibrary();
                        LibraryService.getInstance().openLastOpenedMethodLibrary();
                    }
                    catch (Exception e) {
                        LibraryUIPlugin.getDefault().getLogger().logError((Throwable)e);
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        Shell shell = Display.getCurrent().getActiveShell();
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(shell){

            protected void configureShell(Shell shell) {
                super.configureShell(shell);
                shell.setText(LibraryUIResources.openLibraryWizard_title);
            }
        };
        dialog.run(true, false, (IRunnableWithProgress)operation);
        return LibraryService.getInstance().getCurrentMethodLibrary() != null;
    }

    public boolean openLibrary(URI uri) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("library.path", new File(uri).getAbsolutePath());
        return this.openLibrary("xmi", args);
    }

    public boolean openLibrary(String path) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("library.path", path);
        return this.openLibrary("xmi", args);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean openLibrary(final String type, final Map<String, Object> args) {
        final String path = (String)args.get("library.path");
        Shell shell = Display.getCurrent().getActiveShell();
        final ArrayList errors = new ArrayList();
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) {
                String taskName = LibraryUIResources.openingLibraryTask_name;
                monitor.beginTask(taskName, 2);
                try {
                    try {
                        monitor.setTaskName(taskName);
                        monitor.worked(1);
                        LibraryService.getInstance().closeCurrentMethodLibrary();
                        URI libURI = Path.fromOSString((String)path).toFile().toURI();
                        String newPath = LibraryUIManager.this.handleLibraryOnReadOnlyInstallPath(libURI);
                        if (newPath != null) {
                            args.put("library.path", newPath);
                        }
                        MethodLibrary library = LibraryService.getInstance().openMethodLibrary(type, args);
                        LibraryService.getInstance().setCurrentMethodLibrary(library);
                        LibraryUIPreferences.setSavedLibraryPath(path);
                        ILibraryResourceSet resourceSet = (ILibraryResourceSet)LibraryService.getInstance().getCurrentLibraryManager().getEditingDomain().getResourceSet();
                        if (resourceSet.hasUnresolvedProxy()) {
                            SafeUpdateController.asyncExec((Runnable)new Runnable(){

                                public void run() {
                                    try {
                                        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.ui.views.ProblemView", null, 2);
                                    }
                                    catch (Exception e) {
                                        LibraryUIPlugin.getDefault().getLogger().logError((Throwable)e);
                                    }
                                }
                            });
                        }
                    }
                    catch (Exception e) {
                        if (!(e instanceof IOException) || !e.getMessage().startsWith("###")) {
                            LibraryUIPlugin.getDefault().getLogger().logError((Throwable)e);
                        }
                        errors.add(e);
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(shell){

                protected void configureShell(Shell shell) {
                    super.configureShell(shell);
                    shell.setText(LibraryUIResources.openLibraryWizard_title);
                }
            };
            dialog.run(true, false, (IRunnableWithProgress)operation);
            if (errors.isEmpty()) {
                IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (workbenchWindow == null) return true;
                IWorkbenchPage activePage = workbenchWindow.getActivePage();
                if (activePage == null) return true;
                activePage.closeAllEditors(false);
                return true;
            }
            Iterator iter = errors.iterator();
            while (true) {
                if (!iter.hasNext()) {
                    return false;
                }
                Exception e = (Exception)iter.next();
                if (e instanceof IOException) {
                    String message = e.getMessage();
                    if (!message.startsWith("###")) continue;
                    String projectFileName = message.substring(3);
                    String prompt = LibraryUIResources.bind(LibraryUIResources.readOnlyProjectFile_text, projectFileName);
                    String[] buttonLabels = new String[]{LibraryUIResources.retryButton_text, LibraryUIResources.cancelButton_text};
                    MessageDialog msgBox = new MessageDialog(Display.getCurrent().getActiveShell(), LibraryUIResources.openLibraryWizard_title, null, prompt, 4, buttonLabels, 0);
                    if (msgBox.open() != 0) return true;
                    return this.openLibrary(path);
                }
                Throwable ex = e;
                ex = e;
                while (true) {
                    block7: {
                        if (ex != null && !(ex instanceof MessageException)) break block7;
                    }
                    ex = ex.getCause();
                }
                String msg = ex != null && ex.getMessage() != null ? ex.getMessage() : (e.getMessage() != null ? e.getMessage() : e.toString());
                LibraryUIPlugin.getDefault().getMsgDialog().displayError(LibraryUIResources.openLibraryWizard_title, msg, (Throwable)e);
            }
        }
        catch (Exception e) {
            LibraryUIPlugin.getDefault().getLogger().logError((Throwable)e);
        }
        return false;
    }

    public static boolean upgradeLibrary(String libPath, UpgradeCallerInfo callerInfo) {
        Shell shell = Display.getCurrent().getActiveShell();
        if (!CommandLineRunUtil.getInstance().isNeedToRun() && UpgradeCallerInfo.isUpgradeLibrary((UpgradeCallerInfo)callerInfo)) {
            LibraryBackupUtil.promptBackupLibrary(shell, new File(libPath));
        }
        String libXmi = "library.xmi";
        if (callerInfo != null && callerInfo.getIsExportedPluginLib()) {
            libXmi = "export.xmi";
        }
        return LibraryUIManager.upgradeLibrary(new File(libPath, libXmi), callerInfo);
    }

    public static boolean upgradeLibrary(final File libFile, final UpgradeCallerInfo callerInfo) {
        StringBuffer errMsg;
        block5: {
            errMsg = new StringBuffer();
            final boolean[] cancelFlagHolder = new boolean[1];
            WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

                public void execute(IProgressMonitor monitor) {
                    monitor.beginTask(LibraryUIResources.upgradingLibraryTask_name, 10);
                    monitor.worked(1);
                    try {
                        try {
                            MappingUtil.migrate((String)libFile.getAbsolutePath(), (IProgressMonitor)monitor, (UpgradeCallerInfo)callerInfo);
                        }
                        catch (OperationCanceledException operationCanceledException) {
                            cancelFlagHolder[0] = true;
                            monitor.done();
                        }
                        catch (Exception e) {
                            String msg;
                            LibraryUIPlugin.getDefault().getLogger().logError((Throwable)e);
                            if (DEBUG) {
                                e.printStackTrace();
                            }
                            if ((msg = e.getMessage()) == null) {
                                msg = LibraryUIResources.upgradeLibraryError_msg;
                            }
                            errMsg.append(msg);
                            monitor.done();
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            };
            try {
                ProgressMonitorDialog pmDialog = new ProgressMonitorDialog(Display.getCurrent().getActiveShell()){

                    protected Point getInitialSize() {
                        Point calculatedSize = super.getInitialSize();
                        if (calculatedSize.x < 675) {
                            calculatedSize.x = 675;
                        }
                        return calculatedSize;
                    }
                };
                pmDialog.run(true, false, (IRunnableWithProgress)operation);
                if (!cancelFlagHolder[0]) break block5;
                return false;
            }
            catch (Exception e) {
                LibraryUIPlugin.getDefault().getLogger().logError((Throwable)e);
                if (DEBUG) {
                    e.printStackTrace();
                }
                LibraryUIPlugin.getDefault().getMsgDialog().displayError(LibraryUIResources.upgradeLibraryDialog_title, LibraryUIResources.upgradeLibraryError_msg);
                return false;
            }
        }
        if (errMsg.length() > 0) {
            Status status = new Status(4, LibraryUIPlugin.PLUGIN_ID, 0, "", null){

                public IStatus[] getChildren() {
                    Status cs = new Status(4, LibraryUIPlugin.PLUGIN_ID, 0, errMsg.toString(), null);
                    Status[] ret = new Status[]{cs};
                    return ret;
                }

                public boolean isMultiStatus() {
                    return true;
                }
            };
            LibraryUIPlugin.getDefault().getMsgDialog().displayError(LibraryUIResources.upgradeLibraryDialog_title, LibraryUIResources.upgradeLibraryError_msg, (IStatus)status);
            return false;
        }
        return true;
    }

    public static void setCommandLineDefaultLibrary(String libraryPath) {
        if (libraryPath != null && libraryPath.length() > 0) {
            IPath path = Path.fromOSString((String)libraryPath);
            try {
                defaultLibraryURI = path.toFile().toURI();
            }
            catch (Exception e) {
                defaultLibraryURI = null;
                LibraryPlugin.getDefault().getLogger().logError((Throwable)e);
            }
        }
    }

    public static void setCommandLineLibrary(String libraryPath) {
        if (libraryPath != null && libraryPath.length() > 0) {
            IPath path = Path.fromOSString((String)libraryPath);
            try {
                libraryURI = path.toFile().toURI();
            }
            catch (Exception e) {
                libraryURI = null;
                LibraryPlugin.getDefault().getLogger().logError((Throwable)e);
            }
        }
    }

    public void checkConfigurationContribution() {
        block6: {
            IWorkbenchWindow window;
            IWorkbench workbench = LibraryUIPlugin.getDefault().getWorkbench();
            if (workbench != null && (window = workbench.getActiveWorkbenchWindow()) != null && window instanceof ApplicationWindow) {
                CoolBarManager coolBarMgr = ((ApplicationWindow)window).getCoolBarManager();
                try {
                    IWorkbenchPage activePage = window.getActivePage();
                    if (activePage != null) {
                        if (this.foundConfigView(activePage) || this.foundProcessEditor(activePage) || this.foundPerspective(activePage, REPORT_PERS_ID)) {
                            this.showConfigurationContribution((ICoolBarManager)coolBarMgr);
                        } else {
                            this.hideConfigurationContribution((ICoolBarManager)coolBarMgr);
                        }
                    }
                }
                catch (Exception e) {
                    LibraryUIPlugin.getDefault().getLogger().logError((Throwable)e);
                    if (!DEBUG) break block6;
                    e.printStackTrace();
                }
            }
        }
    }

    private boolean foundConfigView(IWorkbenchPage activePage) {
        if (activePage == null) {
            return false;
        }
        return activePage.findView(CONFIG_VIEW_ID) != null;
    }

    private boolean foundProcessEditor(IWorkbenchPage activePage) {
        if (activePage == null) {
            return false;
        }
        IEditorReference[] editorRefs = activePage.findEditors(null, PROCESS_EDITOR_ID, 2);
        return editorRefs != null && editorRefs.length > 0;
    }

    private boolean foundPerspective(IWorkbenchPage activePage, String persId) {
        return activePage.getPerspective().getId().equals(persId);
    }

    private void showConfigurationContribution(ICoolBarManager coolBarMgr) throws Exception {
        IContributionItem configToolBar = coolBarMgr.find(TOOLBAR_CONFIG_CONTRIBUTION_ID);
        if (configToolBar != null && configToolBar instanceof ToolBarContributionItem) {
            IContributionItem[] toolBarItems;
            IToolBarManager toolBarMgr = ((ToolBarContributionItem)configToolBar).getToolBarManager();
            if (toolBarMgr != null && (toolBarItems = toolBarMgr.getItems()) != null && toolBarItems.length > 0) {
                int i = 0;
                while (i < toolBarItems.length) {
                    toolBarItems[i].setVisible(true);
                    ++i;
                }
                configToolBar.setVisible(true);
                this.updateSystemToolBar(coolBarMgr);
                return;
            }
            this.configCombo = new ConfigurationContributionItem(null);
            toolBarMgr.add((IContributionItem)this.configCombo);
            configToolBar.setVisible(true);
            this.updateSystemToolBar(coolBarMgr);
            return;
        }
        ToolBarManager toolBarMgr = new ToolBarManager(0x804000);
        this.configCombo = new ConfigurationContributionItem(null);
        toolBarMgr.add((IContributionItem)this.configCombo);
        ToolBarContributionItem configComboToolBar = new ToolBarContributionItem((IToolBarManager)toolBarMgr, TOOLBAR_CONFIG_CONTRIBUTION_ID);
        coolBarMgr.add((IContributionItem)configComboToolBar);
    }

    private void hideConfigurationContribution(ICoolBarManager coolBarMgr) throws Exception {
        IContributionItem configToolBar = coolBarMgr.find(TOOLBAR_CONFIG_CONTRIBUTION_ID);
        if (configToolBar == null) {
            return;
        }
        if (configToolBar instanceof ToolBarContributionItem) {
            IToolBarManager toolBarMgr = ((ToolBarContributionItem)configToolBar).getToolBarManager();
            IContributionItem[] toolBarItems = toolBarMgr.getItems();
            int i = 0;
            while (i < toolBarItems.length) {
                toolBarItems[i].setVisible(false);
                ++i;
            }
        }
        configToolBar.setVisible(false);
        this.updateSystemToolBar(coolBarMgr);
    }

    private void updateSystemToolBar(ICoolBarManager coolBarMgr) {
        if (coolBarMgr instanceof CoolBarManager) {
            ((CoolBarManager)coolBarMgr).update(true);
        }
    }

    public void addMethodViewPartListener(final String id) {
        block3: {
            IWorkbenchWindow window;
            IWorkbench workbench = LibraryUIPlugin.getDefault().getWorkbench();
            if (workbench != null && (window = workbench.getActiveWorkbenchWindow()) != null && window instanceof ApplicationWindow) {
                try {
                    final IWorkbenchPage activePage = window.getActivePage();
                    activePage.addPartListener(new IPartListener2(){

                        public void partActivated(IWorkbenchPartReference partRef) {
                        }

                        public void partBroughtToTop(IWorkbenchPartReference partRef) {
                        }

                        public void partClosed(IWorkbenchPartReference partRef) {
                        }

                        public void partDeactivated(IWorkbenchPartReference partRef) {
                        }

                        public void partHidden(IWorkbenchPartReference partRef) {
                        }

                        public void partInputChanged(IWorkbenchPartReference partRef) {
                        }

                        public void partOpened(IWorkbenchPartReference partRef) {
                        }

                        public void partVisible(IWorkbenchPartReference partRef) {
                            if (partRef.getId().equals(id)) {
                                activePage.removePartListener((IPartListener2)this);
                                LibraryUIManager.this.startupOpenLibrary();
                            }
                        }
                    });
                }
                catch (Exception e) {
                    LibraryUIPlugin.getDefault().getLogger().logError((Throwable)e);
                    if (!DEBUG) break block3;
                    e.printStackTrace();
                }
            }
        }
    }

    public void startupOpenLibrary() {
        if (this.libraryInitialized) {
            return;
        }
        this.libraryInitialized = true;
        try {
            MethodConfiguration savedConfig;
            String savedMethodLibraryURI = LibraryPreferences.getSavedMethodLibraryURI();
            boolean hasSavedUri = savedMethodLibraryURI != null && savedMethodLibraryURI.length() > 0;
            String lastSavedConfigName = PreferenceUtil.getSavedLastConfig();
            if (!(libraryURI != null && this.openLibrary(libraryURI) || this.openLastOpenedLibrary() || defaultLibraryURI == null || hasSavedUri)) {
                Locale locale = Locale.getDefault();
                String defaultLibraryStr = new File(defaultLibraryURI).getAbsolutePath();
                String localizedLibPath = I18nUtil.getLocalizedFile((String)FileUtil.removeAllSeparator((String)defaultLibraryStr), (Locale)locale);
                if (localizedLibPath != null) {
                    defaultLibraryURI_NL = StrUtil.toURI((String)localizedLibPath);
                }
                if (defaultLibraryURI_NL == null || !this.openDefaultLibrary(defaultLibraryURI_NL)) {
                    this.openDefaultLibrary(defaultLibraryURI);
                }
            }
            if (LibraryService.getInstance().getCurrentMethodLibrary() != null && (savedConfig = LibraryServiceUtil.getMethodConfiguration((MethodLibrary)LibraryService.getInstance().getCurrentMethodLibrary(), (String)lastSavedConfigName)) != null) {
                LibraryService.getInstance().setCurrentMethodConfiguration(savedConfig);
            }
        }
        catch (Exception e) {
            LibraryUIPlugin.getDefault().getLogger().logError((Throwable)e);
        }
    }

    private String handleLibraryOnReadOnlyInstallPath(URI libURI) {
        File libPathFile;
        block7: {
            block6: {
                libPathFile = new File(libURI);
                if (libPathFile.exists()) break block6;
                return null;
            }
            Location installLocation = Platform.getInstallLocation();
            URL installLocationURL = installLocation.getURL();
            URI installLocationURI = new URI(NetUtil.encodeFileURL((String)installLocationURL.toExternalForm()));
            File installLocFile = new File(installLocationURI);
            String canonicalLibPath = NetUtil.decodedFileUrl((String)libPathFile.getCanonicalPath());
            String canonicalInstallPath = NetUtil.decodedFileUrl((String)installLocFile.getCanonicalPath());
            if (canonicalLibPath.startsWith(canonicalInstallPath)) break block7;
            return null;
        }
        try {
            final String defaultCopyPath = new File(new File(LibraryUIPreferences.getDefaultLibraryPath()).getParent(), libPathFile.getName()).getAbsolutePath();
            final StringBuffer newPath = new StringBuffer();
            UserInteractionHelper.getUIHelper().runSafely(new Runnable(){

                public void run() {
                    String title = LibraryUIResources.copyLibraryDialog_title;
                    String message = LibraryUIResources.copyLibraryDialog_text_readOnlyLib;
                    CopyLibraryDialog dlg = new CopyLibraryDialog(Display.getCurrent().getActiveShell(), title, message, defaultCopyPath);
                    if (dlg.open() == 0) {
                        newPath.append(dlg.getPath());
                    }
                }
            }, true);
            if (newPath.length() > 0) {
                LibraryUIManager.copyLibrary(libPathFile, new File(newPath.toString()));
                return newPath.toString();
            }
            return null;
        }
        catch (URISyntaxException uriEx) {
            LibraryUIPlugin.getDefault().getLogger().logError((Throwable)uriEx);
            return null;
        }
        catch (IOException ioEx) {
            LibraryUIPlugin.getDefault().getLogger().logError((Throwable)ioEx);
            return null;
        }
    }

    private static void copyLibrary(final File source, final File dest) {
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    String excludes = ".lock";
                    LayoutResources.copyDir((File)source, (File)dest, (String)"**", (String)excludes);
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                }
            }
        };
        UserInteractionHelper.runWithProgress((Runnable)runnable, (String)LibraryUIResources.copyLibraryTask_name);
    }

    public ConfigurationContributionItem getConfigCombo() {
        return this.configCombo;
    }

    public void openDefaultLibrary() {
        this.openDefaultLibrary(defaultLibraryURI);
    }
}

