/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.ui.LibraryUIPlugin;
import org.eclipse.epf.library.ui.LibraryUIResources;
import org.eclipse.epf.persistence.util.LibrarySchedulingRule;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class LibraryLockingOperationRunner
implements IRunnableContext {
    private IProgressMonitor progressMonitor;

    private void doRun(final IRunnableWithProgress runnable, final boolean workUnknown) throws InvocationTargetException, InterruptedException {
        final InvocationTargetException[] iteHolder = new InvocationTargetException[1];
        try {
            IWorkspaceRunnable workspaceRunnable = new IWorkspaceRunnable(){

                public void run(IProgressMonitor pm) throws CoreException {
                    block7: {
                        try {
                            if (workUnknown) {
                                pm.beginTask("", 2);
                                pm.worked(1);
                                try {
                                    runnable.run(pm);
                                    pm.worked(2);
                                    break block7;
                                }
                                finally {
                                    pm.done();
                                }
                            }
                            runnable.run(pm);
                        }
                        catch (InvocationTargetException e) {
                            iteHolder[0] = e;
                        }
                        catch (InterruptedException e) {
                            throw new OperationCanceledException(e.getMessage());
                        }
                    }
                }
            };
            ResourcesPlugin.getWorkspace().run(workspaceRunnable, (ISchedulingRule)new LibrarySchedulingRule(LibraryService.getInstance().getCurrentMethodLibrary()), 1, this.getProgressMonitor());
        }
        catch (CoreException e) {
            throw new InvocationTargetException(e);
        }
        catch (OperationCanceledException e) {
            throw new InterruptedException(e.getMessage());
        }
        if (iteHolder[0] != null) {
            throw iteHolder[0];
        }
    }

    public void run(boolean fork, boolean cancelable, IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        this.doRun(runnable, false);
    }

    public void run(IRunnableWithProgress runnable) {
        try {
            this.doRun(runnable, true);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause == null) {
                cause = e;
            }
            LibraryUIPlugin.getDefault().getLogger().logError(cause);
            try {
                String msg = cause.getMessage() != null ? cause.getMessage() : cause.toString();
                LibraryUIPlugin.getDefault().getMsgDialog().displayError(LibraryUIResources.errorDialog_title, msg, cause);
            }
            catch (Exception exception) {}
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    public IProgressMonitor getProgressMonitor() {
        if (this.progressMonitor == null) {
            this.progressMonitor = new NullProgressMonitor();
        }
        return this.progressMonitor;
    }

    public void setProgressMonitor(IProgressMonitor progressMonitor) {
        this.progressMonitor = progressMonitor;
    }
}

