/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.ui.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.command.DeleteMethodElementCommand;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.library.edit.process.BreakdownElementWrapperItemProvider;
import org.eclipse.epf.library.edit.process.command.DeleteRoleDescriptor;
import org.eclipse.epf.library.edit.process.command.DeleteTaskDescriptor;
import org.eclipse.epf.library.edit.process.command.DeleteTeamProfile;
import org.eclipse.epf.library.edit.process.command.DeleteUnusedDescriptorsCommand;
import org.eclipse.epf.library.edit.process.command.DeleteWorkProductDescriptor;
import org.eclipse.epf.library.edit.process.command.ProcessElementDeleteCommand;
import org.eclipse.epf.library.edit.process.command.RemoveUnusedDescriptorsCommand;
import org.eclipse.epf.library.ui.LibraryUIResources;
import org.eclipse.epf.library.ui.actions.MethodElementDeleteAction;
import org.eclipse.epf.uma.Descriptor;
import org.eclipse.epf.uma.RoleDescriptor;
import org.eclipse.epf.uma.TaskDescriptor;
import org.eclipse.epf.uma.TeamProfile;
import org.eclipse.epf.uma.WorkProductDescriptor;
import org.eclipse.epf.uma.util.AssociationHelper;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessDeleteAction
extends MethodElementDeleteAction {
    private boolean deletionConfirmed = false;
    private HashSet<Descriptor> removedDescriptors;

    public ProcessDeleteAction() {
    }

    public ProcessDeleteAction(EditingDomain domain) {
        super(domain);
    }

    public ProcessDeleteAction(EditingDomain domain, boolean confirm) {
        super(domain, confirm);
    }

    @Override
    public DeleteMethodElementCommand createMethodElementDeleteCommand() {
        return new ProcessElementDeleteCommand(RemoveCommand.create((EditingDomain)this.domain, (Collection)this.selection), this.selection, this.confirm);
    }

    public void run(IActionManager actionMgr) {
        if (this.confirmDelete()) {
            Iterator itor = this.selection.iterator();
            while (itor.hasNext()) {
                this.removeReferences(actionMgr, itor.next());
            }
            this.domain.getCommandStack().execute(this.command);
        }
    }

    protected void saveCurrentEditor() {
    }

    @Override
    protected String getDeleteConfirmationMessage() {
        return LibraryUIResources.ProcessDeleteAction_deletecofirm_text;
    }

    protected Command createDeleteUnusedDescriptorsCommand(Collection<Descriptor> descriptors, Collection<?> deletedElements) {
        return new DeleteUnusedDescriptorsCommand(descriptors, false, deletedElements){

            protected Command delete(List elements) {
                return ProcessDeleteAction.delete(elements);
            }
        };
    }

    @Override
    public void run() {
        if (this.confirmDelete()) {
            block8: {
                HashSet<Descriptor> descriptors = new HashSet<Descriptor>();
                for (Object element : this.selection) {
                    ProcessDeleteAction.addRelatedDescriptors(descriptors, element);
                }
                Command cmd = this.command;
                cmd.execute();
                if (((DeleteMethodElementCommand)cmd).executed) {
                    this.deletionConfirmed = true;
                    Collection deletedElements = cmd.getResult();
                    Command deleteUnusedDescriptorsCommand = this.createDeleteUnusedDescriptorsCommand(descriptors, deletedElements);
                    try {
                        try {
                            deleteUnusedDescriptorsCommand.execute();
                        }
                        catch (OperationCanceledException operationCanceledException) {
                            deleteUnusedDescriptorsCommand.dispose();
                            break block8;
                        }
                    }
                    catch (Throwable throwable) {
                        deleteUnusedDescriptorsCommand.dispose();
                        throw throwable;
                    }
                    deleteUnusedDescriptorsCommand.dispose();
                }
            }
            this.saveCurrentEditor();
        }
    }

    private static void addRelatedDescriptors(Collection<Descriptor> descriptors, Object element) {
        if (element instanceof TaskDescriptor) {
            TaskDescriptor taskDesc = (TaskDescriptor)element;
            descriptors.addAll(taskDesc.getAdditionallyPerformedBy());
            descriptors.addAll(taskDesc.getAssistedBy());
            descriptors.addAll(taskDesc.getPerformedPrimarilyBy());
            descriptors.addAll(taskDesc.getMandatoryInput());
            descriptors.addAll(taskDesc.getExternalInput());
            descriptors.addAll(taskDesc.getOptionalInput());
            descriptors.addAll(taskDesc.getOutput());
        } else if (element instanceof RoleDescriptor) {
            RoleDescriptor roleDesc = (RoleDescriptor)element;
            descriptors.addAll(AssociationHelper.getAssistedTaskDescriptors((RoleDescriptor)roleDesc));
            descriptors.addAll(AssociationHelper.getAdditionalTaskDescriptors((RoleDescriptor)roleDesc));
            descriptors.addAll(AssociationHelper.getPrimaryTaskDescriptors((RoleDescriptor)roleDesc));
            descriptors.addAll(roleDesc.getResponsibleFor());
        }
    }

    private void removeReferences(IActionManager actionMgr, Object obj) {
        boolean force;
        DeleteTaskDescriptor cmd = null;
        boolean bl = force = !this.confirm;
        if (obj instanceof TaskDescriptor) {
            cmd = new DeleteTaskDescriptor((TaskDescriptor)obj, force);
        } else if (obj instanceof RoleDescriptor) {
            cmd = new DeleteRoleDescriptor((RoleDescriptor)obj, force);
        } else if (obj instanceof WorkProductDescriptor) {
            cmd = new DeleteWorkProductDescriptor((WorkProductDescriptor)obj, force);
        } else if (obj instanceof TeamProfile) {
            cmd = new DeleteTeamProfile((TeamProfile)obj);
        }
        if (cmd != null) {
            if (actionMgr != null) {
                actionMgr.execute((IResourceAwareCommand)cmd);
            } else {
                cmd.execute();
            }
            if (cmd instanceof RemoveUnusedDescriptorsCommand) {
                this.removedDescriptors.addAll(((RemoveUnusedDescriptorsCommand)cmd).getRemovedDescriptors());
            }
        }
    }

    public boolean updateSelection(IStructuredSelection selection) {
        boolean ret = super.updateSelection(ProcessDeleteAction.filterSelection(selection));
        return ret;
    }

    public static IStructuredSelection filterSelection(IStructuredSelection selection) {
        ArrayList list = new ArrayList();
        for (Object element : selection) {
            if (element instanceof BreakdownElementWrapperItemProvider && ((BreakdownElementWrapperItemProvider)element).isReadOnly()) continue;
            list.add(element);
        }
        return new StructuredSelection(list);
    }

    public boolean isDeletionConfirmed() {
        return this.deletionConfirmed;
    }

    protected Command getCommand() {
        return this.command;
    }

    public static Command delete(Collection elements) {
        ProcessDeleteAction deleteAction = new ProcessDeleteAction(null, false){

            public Command createCommand(Collection selection) {
                this.domain = new AdapterFactoryEditingDomain((AdapterFactory)TngAdapterFactory.INSTANCE.getProcessComposedAdapterFactory(), (CommandStack)new BasicCommandStack());
                return super.createCommand(selection);
            }
        };
        if (deleteAction.updateSelection((IStructuredSelection)new StructuredSelection(new ArrayList(elements)))) {
            deleteAction.run();
            if (!deleteAction.isDeletionConfirmed()) {
                throw new OperationCanceledException();
            }
            return deleteAction.getCommand();
        }
        return null;
    }
}

