/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.ui.internal.wizards;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.epf.library.ui.LibraryUIPlugin;
import org.eclipse.epf.library.ui.internal.wizards.OpenLibraryWizardPageContribution;
import org.eclipse.epf.library.ui.wizards.OpenLibraryWizardPage;
import org.osgi.framework.Bundle;

public class OpenLibraryWizardPageFactory {
    public static final String EXTENSION_POINT_NAMESPACE = "org.eclipse.epf.library.ui";
    public static final String EXTENSION_POINT_NAME = "openLibraryWizardPages";
    private static OpenLibraryWizardPageFactory instance = new OpenLibraryWizardPageFactory();
    private Map<String, OpenLibraryWizardPageContribution> wizardPageProviders = new HashMap<String, OpenLibraryWizardPageContribution>();
    private Map<String, OpenLibraryWizardPage> wizardPages = new HashMap<String, OpenLibraryWizardPage>();

    public static OpenLibraryWizardPageFactory getInstance() {
        return instance;
    }

    private OpenLibraryWizardPageFactory() {
        this.init();
    }

    protected void init() {
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint(EXTENSION_POINT_NAMESPACE, EXTENSION_POINT_NAME);
        if (extensionPoint != null) {
            IExtension[] extensions = extensionPoint.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IExtension extension = extensions[i];
                String pluginId = extension.getNamespaceIdentifier();
                Bundle bundle = Platform.getBundle((String)pluginId);
                IConfigurationElement[] configElements = extension.getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    IConfigurationElement configElement = configElements[j];
                    try {
                        String className = configElement.getAttribute("class");
                        String typeId = configElement.getAttribute("type");
                        String title = configElement.getAttribute("title");
                        String description = configElement.getAttribute("description");
                        if (className != null && className.trim().length() > 0 && typeId != null && typeId.trim().length() > 0 && title != null && title.trim().length() > 0 && description != null && description.trim().length() > 0 && !this.wizardPageProviders.containsKey(typeId)) {
                            OpenLibraryWizardPageContribution provider = new OpenLibraryWizardPageContribution(bundle, className, typeId, title, description);
                            this.wizardPageProviders.put(typeId, provider);
                        }
                    }
                    catch (Exception e) {
                        LibraryUIPlugin.getDefault().getLogger().logError((Throwable)e);
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    public OpenLibraryWizardPage createWizardPage(String pageId, String typeId) {
        OpenLibraryWizardPage wizardPage = this.wizardPages.get(typeId);
        if (wizardPage != null) {
            return wizardPage;
        }
        OpenLibraryWizardPageContribution provider = this.wizardPageProviders.get(typeId);
        if (provider != null) {
            Bundle bundle = provider.getBundle();
            String className = provider.getClassName();
            Class[] argClass = new Class[]{String.class};
            Object[] argValue = new Object[]{pageId};
            try {
                Class wizardPageClass = bundle.loadClass(className);
                Constructor constructor = wizardPageClass.getConstructor(argClass);
                wizardPage = (OpenLibraryWizardPage)((Object)constructor.newInstance(argValue));
                wizardPage.setTitle(provider.getTitle());
                wizardPage.setDescription(provider.getDescription());
                this.wizardPages.put(typeId, wizardPage);
            }
            catch (Exception e) {
                LibraryUIPlugin.getDefault().getLogger().logError((Throwable)e);
            }
        }
        return wizardPage;
    }

    public OpenLibraryWizardPage getWizardPage(String typeId) {
        return this.wizardPages.get(typeId);
    }
}

