/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.ui.wizards;

import java.io.File;
import java.util.List;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.library.ui.LibraryUIPlugin;
import org.eclipse.epf.library.ui.LibraryUIResources;
import org.eclipse.epf.library.ui.preferences.LibraryUIPreferences;
import org.eclipse.epf.ui.wizards.BaseWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class OpenLibraryMainPage
extends BaseWizardPage {
    public static final String PAGE_NAME = OpenLibraryMainPage.class.getName();
    protected static final String TYPE_ID = "typeId";
    protected Shell shell;
    protected Composite composite;
    protected Label pathLabel;
    protected Combo libraryPathCombo;
    protected Button browseButton;
    protected String libraryType;

    public OpenLibraryMainPage(String pageName) {
        super(pageName);
        this.setTitle(LibraryUIResources.openLibraryWizard_title);
        this.setDescription(LibraryUIResources.openLibraryMainWizardPage_title);
        this.setImageDescriptor(LibraryUIPlugin.getDefault().getImageDescriptor("full/wizban/Open.gif"));
    }

    public OpenLibraryMainPage() {
        this(PAGE_NAME);
    }

    public void createControl(Composite parent) {
        this.shell = parent.getShell();
        this.composite = OpenLibraryMainPage.createGridLayoutComposite((Composite)parent, (int)3);
        this.pathLabel = OpenLibraryMainPage.createLabel((Composite)this.composite, (String)LibraryUIResources.pathLabel_text);
        this.libraryPathCombo = OpenLibraryMainPage.createCombobox((Composite)this.composite);
        this.browseButton = OpenLibraryMainPage.createButton((Composite)this.composite, (String)LibraryUIResources.browseButton_text);
        this.initControls();
        this.addListeners();
        this.setControl((Control)this.composite);
    }

    protected void initControls() {
        List<String> openLibraryPathsList = LibraryUIPreferences.getOpenLibraryPathsList();
        if (openLibraryPathsList.size() > 0) {
            String[] openLibraryPaths = LibraryUIPreferences.getOpenLibraryPaths();
            this.libraryPathCombo.setItems(openLibraryPaths);
            if (openLibraryPaths.length > 0) {
                this.libraryPathCombo.setText(openLibraryPaths[0]);
            }
        } else {
            String libraryPath = String.valueOf(LibraryUIPreferences.getDefaultLibraryPath()) + FileUtil.FILE_SEP + "Library1";
            openLibraryPathsList.add(0, libraryPath);
            String[] openLibraryPaths = new String[openLibraryPathsList.size()];
            openLibraryPathsList.toArray(openLibraryPaths);
            this.libraryPathCombo.setItems(openLibraryPaths);
            this.libraryPathCombo.setText(openLibraryPaths[0]);
        }
    }

    protected void addListeners() {
        this.libraryPathCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                OpenLibraryMainPage.this.setPageComplete(OpenLibraryMainPage.this.isPageComplete());
                OpenLibraryMainPage.this.getWizard().getContainer().updateButtons();
            }
        });
        this.libraryPathCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                OpenLibraryMainPage.this.setPageComplete(OpenLibraryMainPage.this.isPageComplete());
                OpenLibraryMainPage.this.getWizard().getContainer().updateButtons();
            }
        });
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DirectoryDialog dialog = new DirectoryDialog(OpenLibraryMainPage.this.shell, 0);
                dialog.setFilterPath(OpenLibraryMainPage.this.getLibraryPath());
                String selectedDir = dialog.open();
                if (selectedDir != null) {
                    OpenLibraryMainPage.this.libraryPathCombo.add(selectedDir, 0);
                    OpenLibraryMainPage.this.libraryPathCombo.setText(selectedDir);
                }
            }
        });
    }

    public boolean isPageComplete() {
        return this.getLibraryName().length() > 0;
    }

    public String getLibraryName() {
        String libName;
        String libPath = this.getLibraryPath();
        if (!libPath.equals(libName = new File(libPath).getName())) {
            return libName;
        }
        return "";
    }

    public String getLibraryPath() {
        return this.libraryPathCombo.getText().trim();
    }

    public String getLibraryType() {
        return this.libraryType;
    }
}

