/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tomcat.internal;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Locale;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.HttpResponse;
import org.apache.catalina.Logger;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.ValveContext;
import org.apache.catalina.util.RequestUtil;
import org.apache.catalina.util.StringManager;
import org.apache.catalina.valves.ValveBase;
import org.eclipse.core.runtime.Platform;
import org.eclipse.tomcat.internal.TomcatResources;

public class EclipseErrorReportValve
extends ValveBase {
    private int debug = 0;
    private static final String info = "org.eclipse.tomcat.internal.EclipseErrorReportValve";
    protected static StringManager sm = StringManager.getManager((String)"org.apache.catalina.valves");

    public String getInfo() {
        return info;
    }

    public void invoke(Request request, Response response, ValveContext context) throws IOException, ServletException {
        context.invokeNext(request, response);
        ServletRequest sreq = (ServletRequest)request;
        Throwable throwable = (Throwable)sreq.getAttribute("javax.servlet.error.exception");
        ServletResponse sresp = (ServletResponse)response;
        if (sresp.isCommitted()) {
            return;
        }
        if (throwable != null) {
            response.setError();
            try {
                sresp.reset();
            }
            catch (IllegalStateException illegalStateException) {}
            ServletResponse sresponse = (ServletResponse)response;
            if (sresponse instanceof HttpServletResponse) {
                ((HttpServletResponse)sresponse).sendError(500);
            }
        }
        response.setSuspended(false);
        try {
            this.report(request, response, throwable);
        }
        catch (Throwable throwable2) {}
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("EclipseErrorReportValve[");
        sb.append(this.container.getName());
        sb.append("]");
        return sb.toString();
    }

    protected void report(Request request, Response response, Throwable throwable) throws IOException {
        block22: {
            if (!(response instanceof HttpResponse)) {
                return;
            }
            HttpResponse hresponse = (HttpResponse)response;
            if (!(response instanceof HttpServletResponse)) {
                return;
            }
            HttpServletResponse hres = (HttpServletResponse)response;
            int statusCode = hresponse.getStatus();
            String message = RequestUtil.filter((String)hresponse.getMessage());
            if (message == null) {
                message = "";
            }
            if (statusCode < 400) {
                return;
            }
            Throwable rootCause = null;
            if (throwable != null && throwable instanceof ServletException) {
                rootCause = ((ServletException)throwable).getRootCause();
            }
            String report = null;
            try {
                report = sm.getString("http." + statusCode, (Object)message);
            }
            catch (Throwable throwable2) {}
            if (report == null) {
                return;
            }
            StringBuffer sb = new StringBuffer();
            sb.append("<html><head><title>");
            sb.append(sm.getString("errorReportValve.errorReport"));
            sb.append("</title>");
            if (statusCode == 404) {
                sb.append("</head><body>");
                sb.append(TomcatResources.noDocument);
            } else {
                sb.append("<STYLE><!--");
                sb.append("H1{font-family : sans-serif,Arial,Tahoma;color : white;background-color : black;} ");
                sb.append("H3{font-family : sans-serif,Arial,Tahoma;color : white;background-color : black;} ");
                sb.append("BODY{font-family : sans-serif,Arial,Tahoma;color : black;background-color : white;} ");
                sb.append("B{color : white;background-color : black;} ");
                sb.append("HR{color : black;} ");
                sb.append("--></STYLE> ");
                sb.append("</head><body>");
                sb.append("<h1>");
                sb.append(sm.getString("errorReportValve.statusHeader", (Object)("" + statusCode), (Object)message)).append("</h1>");
                sb.append("<HR size=\"1\" noshade>");
                sb.append("<p><b>type</b> ");
                if (throwable != null) {
                    sb.append(sm.getString("errorReportValve.exceptionReport"));
                } else {
                    sb.append(sm.getString("errorReportValve.statusReport"));
                }
                sb.append("</p>");
                sb.append("<p><b>");
                sb.append(sm.getString("errorReportValve.message"));
                sb.append("</b> <u>");
                sb.append(message).append("</u></p>");
                sb.append("<p><b>");
                sb.append(sm.getString("errorReportValve.description"));
                sb.append("</b> <u>");
                sb.append(report);
                sb.append("</u></p>");
                if (throwable != null) {
                    boolean selfHostingMode = false;
                    String[] args = Platform.getCommandLineArgs();
                    int i = 0;
                    while (i < args.length) {
                        if ("-pdelaunch".equals(args[i])) {
                            selfHostingMode = true;
                            break;
                        }
                        ++i;
                    }
                    if (selfHostingMode) {
                        StringWriter stackTrace = new StringWriter();
                        throwable.printStackTrace(new PrintWriter(stackTrace));
                        sb.append("<p><b>");
                        sb.append(sm.getString("errorReportValve.exception"));
                        sb.append("</b> <pre>");
                        sb.append(RequestUtil.filter((String)stackTrace.toString()));
                        sb.append("</pre></p>");
                        if (rootCause != null) {
                            stackTrace = new StringWriter();
                            rootCause.printStackTrace(new PrintWriter(stackTrace));
                            sb.append("<p><b>");
                            sb.append(sm.getString("errorReportValve.rootCause"));
                            sb.append("</b> <pre>");
                            sb.append(RequestUtil.filter((String)stackTrace.toString()));
                            sb.append("</pre></p>");
                        }
                    }
                }
            }
            sb.append("</body></html>");
            try {
                PrintWriter writer;
                block23: {
                    writer = response.getReporter();
                    if (writer == null) break block22;
                    Locale locale = Locale.getDefault();
                    try {
                        hres.setContentType("text/html");
                        hres.setLocale(locale);
                    }
                    catch (Throwable t) {
                        if (this.debug < 1) break block23;
                        this.log("status.setContentType", t);
                    }
                }
                ((Writer)writer).write(sb.toString());
                ((Writer)writer).flush();
            }
            catch (IOException iOException) {
            }
            catch (IllegalStateException illegalStateException) {}
        }
    }

    protected void log(String message) {
        Logger logger = this.container.getLogger();
        if (logger != null) {
            logger.log(String.valueOf(this.toString()) + ": " + message);
        } else {
            System.out.println(String.valueOf(this.toString()) + ": " + message);
        }
    }

    protected void log(String message, Throwable throwable) {
        Logger logger = this.container.getLogger();
        if (logger != null) {
            logger.log(String.valueOf(this.toString()) + ": " + message, throwable);
        } else {
            System.out.println(String.valueOf(this.toString()) + ": " + message);
            throwable.printStackTrace(System.out);
        }
    }
}

