/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.search.configuration.internal;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.DateField;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.epf.common.html.HTMLParser;
import org.eclipse.epf.search.GenerateSearchIndexException;
import org.eclipse.epf.search.SearchConfigurationException;
import org.eclipse.epf.search.SearchResources;
import org.eclipse.epf.search.SearchServiceException;
import org.eclipse.epf.search.analysis.TextAnalyzer;
import org.eclipse.epf.search.configuration.ConfigurationHitEntry;
import org.eclipse.epf.search.configuration.ConfigurationSearchQuery;

public class ConfigurationSearchService {
    public static final String BRIEF_DESCRIPTION_FIELD = "briefDescription";
    public static final String CONTENT_FIELD = "content";
    public static final String ID_FIELD = "id";
    public static final String MODIFIED_FIELD = "modified";
    public static final String NAME_FIELD = "name";
    public static final String ROLE_FIELD = "role";
    public static final String SUMMARY_FIELD = "summary";
    public static final String TYPE_FIELD = "type";
    public static final String URL_FIELD = "url";
    private HTMLParser parser;
    private String docDir = null;
    private String indexDir = null;

    public ConfigurationSearchService(String docDir) {
        String userHome = System.getProperty("user.home");
        int hashCode = Math.abs(docDir.hashCode());
        String indexPath = String.valueOf(userHome) + File.separator + "rup" + File.separator + hashCode + File.separator + "index";
        this.setDirs(docDir, indexPath);
    }

    public ConfigurationSearchService(String docDir, String indexDir) {
        this.setDirs(docDir, indexDir);
    }

    public void setDirs(String docDir, String indexDir) {
        this.docDir = docDir;
        this.indexDir = indexDir;
    }

    public ConfigurationHitEntry[] search(ConfigurationSearchQuery query) throws SearchServiceException {
        return this.search(query.getQueryString());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ConfigurationHitEntry[] search(String qstr) throws SearchServiceException {
        ConfigurationHitEntry[] configurationHitEntryArray;
        IndexSearcher searcher = null;
        try {
            searcher = new IndexSearcher(this.indexDir);
            Query query = QueryParser.parse((String)qstr, (String)CONTENT_FIELD, (Analyzer)new TextAnalyzer());
            Hits lhits = searcher.search(query);
            ConfigurationHitEntry[] hits = new ConfigurationHitEntry[lhits.length()];
            int i = 0;
            while (true) {
                if (i >= hits.length) {
                    configurationHitEntryArray = hits;
                    if (searcher == null) return configurationHitEntryArray;
                    break;
                }
                Document doc = lhits.doc(i);
                hits[i] = new ConfigurationHitEntry();
                hits[i].setName(doc.get(NAME_FIELD));
                hits[i].setUrl(doc.get(URL_FIELD));
                hits[i].setBriefDesc(doc.get(BRIEF_DESCRIPTION_FIELD));
                hits[i].setId(doc.get(ID_FIELD));
                hits[i].setType(doc.get(TYPE_FIELD));
                ++i;
            }
        }
        catch (Exception e) {
            try {
                throw new SearchConfigurationException(e);
            }
            catch (Throwable throwable) {
                if (searcher == null) throw throwable;
                try {
                    searcher.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        try {
            searcher.close();
            return configurationHitEntryArray;
        }
        catch (IOException iOException) {}
        return configurationHitEntryArray;
    }

    public boolean indexExists() {
        File[] files = new File(this.indexDir).listFiles();
        return files != null && files.length != 0;
    }

    public void index() throws SearchServiceException {
        this.index(null, false);
    }

    public void index(boolean reindex) throws SearchServiceException {
        this.index(null, reindex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void index(IProgressMonitor pm, boolean reindex) throws SearchServiceException {
        Class<ConfigurationSearchService> clazz = ConfigurationSearchService.class;
        synchronized (ConfigurationSearchService.class) {
            if (this.indexDir == null || this.docDir == null) {
                throw new IllegalStateException("Invalid indexDir or docDir");
            }
            if (!reindex && this.indexExists()) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
            if (pm != null) {
                pm.beginTask(SearchResources.indexConfigFilesTask_name, ConfigurationSearchService.getTotalDocsToIndex(this.docDir));
            }
            try {
                try {
                    this.deleteAllIndexDirs();
                    new File(this.indexDir).mkdirs();
                    IndexWriter writer = new IndexWriter(this.indexDir, (Analyzer)new TextAnalyzer(), true);
                    writer.maxFieldLength = 1000000;
                    this.parser = new HTMLParser();
                    this.indexDocs(new File(this.docDir), writer, pm);
                    writer.optimize();
                    writer.close();
                }
                catch (Exception e) {
                    throw new GenerateSearchIndexException(e);
                }
            }
            finally {
                if (pm != null) {
                    pm.done();
                }
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public void deleteAllIndexDirs() {
        File parent = new File(this.indexDir).getParentFile();
        File[] files = parent.listFiles();
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                if (files[i].getName().startsWith("index")) {
                    File[] file = files[i].listFiles();
                    int j = 0;
                    while (j < file.length) {
                        file[j].delete();
                        ++j;
                    }
                    files[i].delete();
                }
                ++i;
            }
        }
    }

    public static int getTotalDocsToIndex(String dir) {
        int total = 0;
        File dirFile = new File(dir);
        File[] files = dirFile.listFiles();
        if (files == null) {
            return total;
        }
        int i = 0;
        while (i < files.length) {
            if (ConfigurationSearchService.isXMIDoc(files[i])) {
                ++total;
            } else if (files[i].isDirectory()) {
                total += ConfigurationSearchService.getTotalDocsToIndex(files[i].getAbsolutePath());
            }
            ++i;
        }
        return total;
    }

    private static boolean isXMIDoc(File file) {
        return file.getPath().endsWith(".xmi");
    }

    private static boolean isHtmlOrTextDoc(File file) {
        String path = file.getPath();
        return path.endsWith(".html") || path.endsWith(".htm") || path.endsWith(".txt");
    }

    private void indexDocs(File file, IndexWriter writer, IProgressMonitor pm) throws Exception {
        if (file.isDirectory()) {
            if (file.getName().equalsIgnoreCase("applet")) {
                return;
            }
            String[] files = file.list();
            int i = 0;
            while (i < files.length) {
                this.indexDocs(new File(file, files[i]), writer, pm);
                ++i;
            }
        } else if (ConfigurationSearchService.isHtmlOrTextDoc(file)) {
            if (pm != null) {
                pm.subTask(file.getName());
                pm.worked(1);
            }
            if (this.shouldBeExcluded(file)) {
                return;
            }
            Document doc = this.getHTMLDocument(file);
            writer.addDocument(doc);
        }
    }

    public boolean shouldBeExcluded(File file) {
        String p = file.getParentFile().getAbsolutePath();
        return this.docDir.startsWith(p);
    }

    public Document getHTMLDocument(File file) throws IOException, InterruptedException {
        Document doc = new Document();
        doc.add(Field.UnIndexed((String)URL_FIELD, (String)file.getPath().replace(File.pathSeparatorChar, '/')));
        doc.add(Field.Keyword((String)MODIFIED_FIELD, (String)DateField.timeToString((long)file.lastModified())));
        try {
            this.parser.parse(file);
        }
        catch (Exception exception) {}
        doc.add(Field.Text((String)CONTENT_FIELD, (String)this.parser.getText()));
        doc.add(Field.UnIndexed((String)SUMMARY_FIELD, (String)this.parser.getSummary()));
        Properties metaTags = this.parser.getMetaTags();
        Enumeration<?> e = metaTags.propertyNames();
        while (e.hasMoreElements()) {
            String tagName = (String)e.nextElement();
            doc.add(Field.Text((String)tagName, (String)metaTags.getProperty(tagName)));
        }
        if (doc.getField(ROLE_FIELD) == null) {
            doc.add(Field.Text((String)ROLE_FIELD, (String)"NORUPROLE"));
        }
        return doc;
    }
}

