/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.search.utils;

import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

public class UNCUtil {
    public static final String UNC_FILE_PREFIX = "file:/";
    public static final String ALTERNATE_UNC_FILE_PREFIX = "file://";
    public static final String NETSCAPE_UNC_FILE_PREFIX = "file:///";
    public static final String UNC_FILE_ONLY = "file:";
    public static final String UNC_SEPARATOR = "/";

    public static String handleNetscapeFilePrefix(String filename) {
        String convertedName = null;
        convertedName = filename.startsWith(NETSCAPE_UNC_FILE_PREFIX) ? ALTERNATE_UNC_FILE_PREFIX + filename.substring(NETSCAPE_UNC_FILE_PREFIX.length(), filename.length()) : filename;
        return convertedName;
    }

    public static URL handleURLForUNC(URL originalUrl) {
        URL newUrl = null;
        try {
            if (originalUrl.toString().startsWith(ALTERNATE_UNC_FILE_PREFIX)) {
                String extractedString = originalUrl.toString().substring(5);
                newUrl = new URL("file", "", "///" + extractedString);
            } else {
                newUrl = originalUrl;
            }
        }
        catch (MalformedURLException malformedURLException) {
            newUrl = originalUrl;
        }
        return newUrl;
    }

    public static String convertFilename(String filename) {
        String convertedName = null;
        String tempName = null;
        if (filename.startsWith(UNC_FILE_PREFIX)) {
            tempName = filename.substring(UNC_FILE_PREFIX.length(), filename.length());
            int index = tempName.indexOf(":");
            if (index == -1) {
                tempName = UNC_SEPARATOR + tempName;
            }
        } else {
            tempName = filename;
        }
        convertedName = tempName.replace(UNC_SEPARATOR.charAt(0), File.separator.charAt(0));
        return convertedName;
    }

    public static String convertFilenameToUNC(String filename) {
        String convertedName = filename.replace(File.separator.charAt(0), UNC_SEPARATOR.charAt(0));
        String finalName = UNCUtil.convertFileSeparator(convertedName);
        return finalName;
    }

    public static String convertToUNC(String url) {
        String convertedUrl = null;
        convertedUrl = url.startsWith(ALTERNATE_UNC_FILE_PREFIX) ? UNC_FILE_PREFIX + url.substring(ALTERNATE_UNC_FILE_PREFIX.length(), url.length()) : url;
        return convertedUrl;
    }

    public static String convertFileSpacing(String filename) {
        int start = 0;
        String newFilename = "";
        while (start < filename.length()) {
            int index = filename.indexOf("%20", start);
            if (index == -1) {
                index = filename.length();
            }
            newFilename = String.valueOf(newFilename) + filename.substring(start, index);
            newFilename = String.valueOf(newFilename) + " ";
            start = index + 3;
        }
        newFilename = newFilename.trim();
        return newFilename;
    }

    public static String convertFileSeparator(String filename) {
        int start = 0;
        String newFilename = "";
        while (start < filename.length()) {
            int index = filename.indexOf("%5C", start);
            if (index == -1) {
                newFilename = filename.trim();
                break;
            }
            newFilename = String.valueOf(newFilename) + filename.substring(start, index);
            newFilename = String.valueOf(newFilename) + UNC_SEPARATOR;
            start = index + 3;
        }
        newFilename = newFilename.trim();
        String windowsFileSeparator = "\\";
        if (!File.separator.equals(windowsFileSeparator) && File.separator.equals(UNC_SEPARATOR)) {
            newFilename = newFilename.replace(windowsFileSeparator.charAt(0), UNC_SEPARATOR.charAt(0));
        }
        return newFilename;
    }

    public static Vector getFileList(String directory, String suffix) {
        if (directory.startsWith("http")) {
            return UNCUtil.getFileListFromRemote(directory, suffix);
        }
        String tempDir = UNCUtil.convertFilename(directory);
        File documentDirectory = new File(UNCUtil.convertFileSpacing(tempDir));
        String[] fileNameList = documentDirectory.list();
        Vector<String> finalList = new Vector<String>();
        int i = 0;
        while (i < fileNameList.length) {
            if (fileNameList[i].endsWith(suffix)) {
                finalList.addElement(fileNameList[i]);
            }
            ++i;
        }
        return finalList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Vector getFileListFromRemote(String directory, String suffix) {
        Vector<String> filenames = new Vector<String>();
        try {
            int i;
            Vector<String> lines;
            URL remoteUrl = new URL(directory);
            InputStream inStream = remoteUrl.openStream();
            StringBuffer result = new StringBuffer();
            while (true) {
                int c;
                if ((c = inStream.read()) == -1) {
                    inStream.close();
                    String directoryResult = result.toString();
                    directoryResult = directoryResult.replaceAll("href", "HREF");
                    directoryResult = directoryResult.replaceAll("</a", "</A");
                    directoryResult = directoryResult.replaceAll("<tt>", "");
                    directoryResult = directoryResult.replaceAll("</tt>", "");
                    directoryResult = directoryResult.replaceAll("<TT>", "");
                    directoryResult = directoryResult.replaceAll("</TT>", "");
                    StringTokenizer lineTokenizer = new StringTokenizer(directoryResult);
                    lines = new Vector<String>();
                    try {
                        while (true) {
                            lineTokenizer.nextToken("REF");
                            lineTokenizer.nextToken("\"");
                            String line = lineTokenizer.nextToken("\"");
                            int index = line.indexOf("</A");
                            if (index != -1 && index != 0) {
                                String filename = line.substring(0, index);
                                lines.addElement(filename);
                                continue;
                            }
                            lines.addElement(line);
                        }
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        i = 0;
                        break;
                    }
                }
                result.append((char)c);
            }
            while (true) {
                if (i >= lines.size()) {
                    return filenames;
                }
                String line = (String)lines.elementAt(i);
                if (line.endsWith(suffix)) {
                    filenames.addElement(line);
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return filenames;
    }
}

