/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.common.ui.util;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.Platform;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.HTMLTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.Bundle;

public class ClipboardUtil {
    private static Clipboard clipboard;
    private static final String SOURCE_URL = "SourceURL:";
    private static Transfer htmlTransfer;

    static {
        htmlTransfer = null;
        if (SWT.getPlatform().equals("win32")) {
            try {
                Bundle bundle = Platform.getBundle((String)"org.eclipse.epf.common.win32.win32.x86");
                Class c = bundle.loadClass("org.eclipse.epf.common.win32.Win32HTMLTransfer");
                if (c != null) {
                    htmlTransfer = (Transfer)c.newInstance();
                }
            }
            catch (Exception exception) {
                htmlTransfer = null;
            }
        }
    }

    public static String getHTMLSourceURL() {
        if (htmlTransfer == null) {
            return null;
        }
        Clipboard clipboard = new Clipboard(Display.getCurrent());
        String sourceURL = null;
        try {
            URL url;
            int index;
            String htmlContent = (String)clipboard.getContents(htmlTransfer);
            if (htmlContent != null && htmlContent.length() > 0 && (index = htmlContent.indexOf(SOURCE_URL)) > 0) {
                sourceURL = htmlContent.substring(index + SOURCE_URL.length());
                sourceURL = sourceURL.substring(0, sourceURL.indexOf(FileUtil.LINE_SEP));
            }
            if (sourceURL != null && sourceURL.indexOf("\\") != -1 && (sourceURL = (url = new URL(sourceURL)).toExternalForm()).startsWith("file://") && !sourceURL.startsWith("file:///")) {
                sourceURL = "file:///" + sourceURL.substring(7);
            }
            String string = sourceURL;
            return string;
        }
        catch (MalformedURLException malformedURLException) {
            String string = sourceURL;
            return string;
        }
        finally {
            clipboard.dispose();
        }
    }

    public static void copyTextHTMLToClipboard(String string) {
        if (clipboard != null) {
            clipboard.dispose();
        }
        clipboard = new Clipboard(null);
        clipboard.setContents(new Object[]{string, string}, new Transfer[]{TextTransfer.getInstance(), HTMLTransfer.getInstance()});
        if (clipboard != null) {
            clipboard.dispose();
        }
    }
}

