/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.export.xml.services;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.sdo.EDataObject;
import org.eclipse.epf.dataexchange.util.ContentProcessor;
import org.eclipse.epf.dataexchange.util.ILogger;
import org.eclipse.epf.dataexchange.util.IResourceHandler;
import org.eclipse.epf.diagram.ui.service.DiagramImageService;
import org.eclipse.epf.export.services.DiagramHandler;
import org.eclipse.epf.export.xml.ExportXMLPlugin;
import org.eclipse.epf.export.xml.ExportXMLResources;
import org.eclipse.epf.export.xml.services.ExportResourceHandler;
import org.eclipse.epf.export.xml.services.ExportXMLData;
import org.eclipse.epf.export.xml.services.ExportXMLLogger;
import org.eclipse.epf.export.xml.services.XMLLibrary;
import org.eclipse.epf.library.IConfigurationManager;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.util.ModelStructure;
import org.eclipse.epf.library.edit.util.Suppression;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.layout.ElementLayoutManager;
import org.eclipse.epf.library.services.SafeUpdateController;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.library.util.MigrationUtil;
import org.eclipse.epf.library.util.ResourceHelper;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.Diagram;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPackage;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.TaskDescriptor;
import org.eclipse.epf.uma.WorkOrder;
import org.eclipse.epf.uma.WorkOrderType;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.epf.xml.uma.ContentCategoryPackage;
import org.eclipse.osgi.util.NLS;

public class ExportXMLService {
    private ExportXMLData data;
    private boolean debug = ExportXMLPlugin.getDefault().isDebugging();
    private XMLLibrary xmlLib;
    private List discardedElements = new ArrayList();
    ExportXMLLogger logger = null;
    private Map umaIdToXmlIdMap = new HashMap();
    private DiagramHandler diagramHandler;
    private Map<String, TaskDescriptor> tdMap;
    private List processedElements = new ArrayList();

    public ExportXMLService(ExportXMLData data) {
        this.data = data;
        this.logger = new ExportXMLLogger(new File(this.data.xmlFile).getParentFile());
    }

    public File getLogPath() {
        return this.logger.getLogPath();
    }

    public void dispose() {
        this.logger.dispose();
    }

    public void doExport(IProgressMonitor monitor) {
        try {
            ExportResourceHandler handler = new ExportResourceHandler(new File(LibraryService.getInstance().getCurrentMethodLibraryLocation()), new File(this.data.getXMLFile()).getParentFile());
            ContentProcessor contentProc = new ContentProcessor((IResourceHandler)handler, (ILogger)this.logger);
            this.diagramHandler = new DiagramHandler(new File(LibraryService.getInstance().getCurrentMethodLibraryLocation()), new File(this.data.getXMLFile()).getParentFile()){

                public void visitElementMap(int passId) {
                    if (passId != 0) {
                        return;
                    }
                    Map map = this.getElementMap();
                    for (DiagramHandler.MapEntryValue value : map.values()) {
                        EDataObject xmlObj;
                        if (value.targetFile == null || value.sourceFile == null || !((xmlObj = ExportXMLService.this.getXmlObject(value.element)) instanceof org.eclipse.epf.xml.uma.Process)) continue;
                        org.eclipse.epf.xml.uma.Process proc = (org.eclipse.epf.xml.uma.Process)xmlObj;
                        String uri = value.sourceFile.getAbsolutePath();
                        String srcRootFolderPath = this.getRoot(value.element).getAbsolutePath();
                        int ix = srcRootFolderPath.length();
                        uri = uri.substring(ix + 1);
                        uri = URI.createFileURI((String)uri).toString();
                        proc.setDiagramURI(uri);
                    }
                }

                public void execute() {
                    super.execute();
                    SafeUpdateController.syncExec((Runnable)new Runnable(){

                        public void run() {
                            this.exportDiagramImageFiles();
                        }
                    });
                }

                private void exportDiagramImageFiles() {
                    LibraryService.getInstance().getCurrentMethodLibraryLocation();
                    DiagramImageService diagramService = new DiagramImageService(null);
                    diagramService.setForXMLExport(true);
                    try {
                        try {
                            Map map = this.getElementMap();
                            for (DiagramHandler.MapEntryValue value : map.values()) {
                                ElementLayoutManager layoutMgr;
                                Process proc = (Process)value.element;
                                MethodConfiguration config = proc.getDefaultContext();
                                if (config == null) continue;
                                diagramService.setConfig(config);
                                IConfigurationManager mgr = LibraryService.getInstance().getConfigurationManager(config);
                                if (mgr == null || (layoutMgr = mgr.getElementLayoutManager()) == null) continue;
                                IFilter filter = layoutMgr.getDiagramAdapterFactory().getFilter();
                                File diagramXmiFile = value.targetFile;
                                if (diagramXmiFile == null || !diagramXmiFile.exists()) continue;
                                diagramService.setPubDir(diagramXmiFile.getParentFile());
                                Map activities = MigrationUtil.getActivities((Process)proc, (boolean)true);
                                for (Activity act : activities.values()) {
                                    String[] types = new String[]{"Activity", "ActivityDetail", "WPDependency"};
                                    int i = 0;
                                    while (i < types.length) {
                                        block11: {
                                            String imagePath = ResourceHelper.getXmlExportedDiagramImageFileName((MethodElement)act, (String)types[i], (String)".jpeg");
                                            try {
                                                diagramService.saveDiagram((Object)act, imagePath, types[i], filter, Suppression.getSuppression((Process)proc));
                                            }
                                            catch (Exception e) {
                                                if (!ExportXMLService.this.debug) break block11;
                                                ExportXMLService.this.logger.logError(NLS.bind((String)ExportXMLResources.exportXMLService_error, (Object)e.getMessage()), e);
                                            }
                                        }
                                        ++i;
                                    }
                                }
                            }
                        }
                        catch (Exception e) {
                            if (ExportXMLService.this.debug) {
                                ExportXMLService.this.logger.logError(NLS.bind((String)ExportXMLResources.exportXMLService_error, (Object)e.getMessage()), e);
                            }
                            diagramService.dispose();
                        }
                    }
                    finally {
                        diagramService.dispose();
                    }
                }
            };
            MethodLibrary src = LibraryService.getInstance().getCurrentMethodLibrary();
            this.xmlLib = new XMLLibrary(contentProc, (ILogger)this.logger, this.data.getXMLFile());
            this.xmlLib.createLibrary(src.getGuid(), src.getName());
            EDataObject target = this.xmlLib.getRoot();
            this.creatEDataObjectTree((MethodElement)src, target);
            this.iteratEDataObject((MethodElement)src);
            this.xmlLib.fixLibraryForExport();
            this.xmlLib.fixTaskDescriptorsForExport(this.tdMap);
            this.diagramHandler.visitElementMap(0);
            if (this.data.exportType == 2) {
                this.xmlLib.storeExtraInfo(src.getMethodPlugins());
            }
            this.xmlLib.save();
            this.diagramHandler.execute();
        }
        catch (Exception e) {
            this.logger.logError(NLS.bind((String)ExportXMLResources.exportXMLService_error, (Object)e.getMessage()), e);
        }
    }

    private boolean isPluginSelected(MethodPlugin plugin) {
        if (this.data.exportType == 1) {
            return true;
        }
        if (this.data.exportType == 2) {
            return this.data.selectedPlugins != null && this.data.selectedPlugins.contains(plugin);
        }
        if (this.data.exportType == 3) {
            return true;
        }
        return true;
    }

    private boolean isConfigExcluded(MethodConfiguration config) {
        if (this.data.exportType == 2) {
            return this.data.associatedConfigs == null || !this.data.associatedConfigs.contains(config.getGuid());
        }
        return false;
    }

    private void creatEDataObjectTree(MethodElement srcObj, EDataObject targetObj) {
        if (srcObj instanceof MethodPlugin) {
            MethodPlugin plugin = (MethodPlugin)srcObj;
            if (!this.isPluginSelected(plugin)) {
                return;
            }
            this.discardedElements.addAll(TngUtil.getAllSystemPackages((MethodPlugin)plugin));
            List topmostUserPackages = this.getTopmostUserPackage(plugin);
            List categoryPkgs = TngUtil.getContentCategoryPackages((MethodPlugin)plugin);
            ContentCategoryPackage xmlPkg = (ContentCategoryPackage)this.xmlLib.getContentCategoryPackage(plugin.getGuid());
            String contentCategoryPackageId = xmlPkg.getId();
            for (MethodPackage pkg : topmostUserPackages) {
                if (categoryPkgs.contains(pkg)) {
                    this.setIdMapping(pkg.getGuid(), contentCategoryPackageId);
                    this.creatEDataObjectTree((MethodElement)pkg, (EDataObject)xmlPkg);
                    continue;
                }
                this.creatEDataObjectTree((MethodElement)pkg, targetObj);
            }
        } else {
            for (Object nextObj : srcObj.eContents()) {
                MethodElement child;
                MethodElement methodElement = child = nextObj instanceof MethodElement ? (MethodElement)nextObj : null;
                if (child == null || child instanceof WorkOrder && srcObj instanceof MethodPackage || child instanceof MethodPlugin && !this.isPluginSelected((MethodPlugin)child) || child instanceof MethodConfiguration && this.isConfigExcluded((MethodConfiguration)child) || this.isDiscarded(child)) continue;
                this.createXmlObject(child, targetObj);
            }
        }
    }

    private void setIdMapping(String umaId, String xmlId) {
        if (!this.umaIdToXmlIdMap.containsKey(umaId)) {
            this.umaIdToXmlIdMap.put(umaId, xmlId);
        }
    }

    private String getXmlId(String umaId) {
        if (this.umaIdToXmlIdMap.containsKey(umaId)) {
            return (String)this.umaIdToXmlIdMap.get(umaId);
        }
        return umaId;
    }

    private boolean isDiscarded(Object o) {
        if (o instanceof Diagram) {
            return true;
        }
        return this.discardedElements.contains(o);
    }

    private EDataObject getXmlObject(MethodElement srcObj) {
        String id = srcObj.getGuid();
        if (this.umaIdToXmlIdMap.containsKey(id)) {
            id = (String)this.umaIdToXmlIdMap.get(id);
        }
        return this.xmlLib.getElement(id);
    }

    private void createXmlObject(MethodElement umaElement, EDataObject targetContainer) {
        EReference feature = umaElement.eContainmentFeature();
        this.createXmlObject(umaElement, targetContainer, feature.getName());
    }

    private void createXmlObject(MethodElement umaElement, EDataObject targetContainer, String containmentFeature) {
        try {
            List steps;
            TaskDescriptor td;
            if (umaElement == null) {
                return;
            }
            String elementType = umaElement.getType().getName();
            EDataObject xmlElement = this.xmlLib.createElement(targetContainer, containmentFeature, umaElement.eClass().getName(), elementType, umaElement.getGuid());
            if (umaElement instanceof TaskDescriptor && (td = (TaskDescriptor)umaElement).getTask() != null && (steps = td.getSelectedSteps()) != null && !steps.isEmpty()) {
                if (this.tdMap == null) {
                    this.tdMap = new HashMap<String, TaskDescriptor>();
                }
                this.tdMap.put(td.getGuid(), td);
            }
            if (xmlElement != null) {
                this.creatEDataObjectTree(umaElement, xmlElement);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void iteratEDataObject(MethodElement srcObj) {
        MethodPlugin plugin;
        this.diagramHandler.registerElement(srcObj, true);
        if (srcObj instanceof MethodPlugin && !this.isPluginSelected(plugin = (MethodPlugin)srcObj)) {
            return;
        }
        if (this.isProcessed(srcObj.getGuid())) {
            return;
        }
        this.setProcessed(srcObj.getGuid());
        EDataObject targetObj = this.getXmlObject(srcObj);
        if (targetObj == null) {
            if (srcObj instanceof MethodPackage) {
                Iterator it = ((MethodPackage)srcObj).getChildPackages().iterator();
                while (it.hasNext()) {
                    this.iteratEDataObject((MethodElement)it.next());
                }
            }
            return;
        }
        EClass eClass = srcObj.eClass();
        EList features = eClass.getEAllStructuralFeatures();
        for (EStructuralFeature feature : features) {
            Object value = srcObj.eGet(feature);
            try {
                if (value instanceof List && !feature.getName().equals("methodElementProperty")) {
                    for (MethodElement src_value : (List)value) {
                        EDataObject workOrder;
                        if (src_value instanceof WorkOrder && (workOrder = this.getXmlObject(src_value)) == null) {
                            this.createXmlObject(src_value, targetObj, feature.getName());
                        }
                        String xmlId = this.getXmlId(src_value.getGuid());
                        this.xmlLib.setReferenceValue(targetObj, feature.getName(), xmlId, src_value.getType());
                        this.iteratEDataObject(src_value);
                    }
                    continue;
                }
                if (value instanceof MethodElement) {
                    MethodElement src_value = (MethodElement)value;
                    if (src_value.eContainer() == null) continue;
                    String xmlId = this.getXmlId(src_value.getGuid());
                    this.xmlLib.setReferenceValue(targetObj, feature.getName(), xmlId, src_value.getType());
                    this.iteratEDataObject(src_value);
                    continue;
                }
                if (this.isDiscarded(srcObj)) continue;
                if (value instanceof WorkOrderType) {
                    value = ((WorkOrderType)value).getName();
                }
                this.xmlLib.setAtributeFeatureValue(targetObj, feature.getName(), value);
            }
            catch (Exception e) {
                String msg = NLS.bind((String)ExportXMLResources.exportXMLService_feature_error, (Object)LibraryUtil.getTypeName((MethodElement)srcObj), (Object)feature.getName());
                this.logger.logError(msg, e);
            }
        }
    }

    private boolean isProcessed(String guid) {
        return this.processedElements.contains(guid);
    }

    private void setProcessed(String guid) {
        if (!this.processedElements.contains(guid)) {
            this.processedElements.add(guid);
        }
    }

    private List getTopmostUserPackage(MethodPlugin plugin) {
        MethodPackage pkg_core_content = UmaUtil.findMethodPackage((MethodPlugin)plugin, (String[])ModelStructure.DEFAULT.coreContentPath);
        MethodPackage pkg_custom_categories = UmaUtil.findMethodPackage((MethodPlugin)plugin, (String[])ModelStructure.DEFAULT.customCategoryPath);
        MethodPackage pkg_disciplines = UmaUtil.findMethodPackage((MethodPlugin)plugin, (String[])ModelStructure.DEFAULT.disciplineDefinitionPath);
        MethodPackage pkg_domains = UmaUtil.findMethodPackage((MethodPlugin)plugin, (String[])ModelStructure.DEFAULT.domainPath);
        MethodPackage pkg_rolesets = UmaUtil.findMethodPackage((MethodPlugin)plugin, (String[])ModelStructure.DEFAULT.roleSetPath);
        MethodPackage pkg_tools = UmaUtil.findMethodPackage((MethodPlugin)plugin, (String[])ModelStructure.DEFAULT.toolPath);
        MethodPackage pkg_wptypes = UmaUtil.findMethodPackage((MethodPlugin)plugin, (String[])ModelStructure.DEFAULT.workProductTypePath);
        MethodPackage pkg_cp = UmaUtil.findMethodPackage((MethodPlugin)plugin, (String[])ModelStructure.DEFAULT.capabilityPatternPath);
        MethodPackage pkg_dp = UmaUtil.findMethodPackage((MethodPlugin)plugin, (String[])ModelStructure.DEFAULT.deliveryProcessPath);
        MethodPackage pkg_proc_contribution = UmaUtil.findMethodPackage((MethodPlugin)plugin, (String[])ModelStructure.DEFAULT.processContributionPath);
        ArrayList<MethodPackage> pkgs = new ArrayList<MethodPackage>();
        pkgs.add(pkg_core_content);
        pkgs.add(pkg_custom_categories);
        pkgs.add(pkg_disciplines);
        pkgs.add(pkg_domains);
        pkgs.add(pkg_rolesets);
        pkgs.add(pkg_tools);
        pkgs.add(pkg_wptypes);
        pkgs.add(pkg_cp);
        pkgs.add(pkg_dp);
        if (pkg_proc_contribution != null) {
            pkgs.add(pkg_proc_contribution);
        }
        return pkgs;
    }

    public ExportXMLLogger getLogger() {
        return this.logger;
    }
}

