/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.export.msp.ui.wizards;

import org.eclipse.epf.export.msp.ui.ExportMSPUIPlugin;
import org.eclipse.epf.export.msp.ui.ExportMSPUIResources;
import org.eclipse.epf.export.msp.ui.preferences.ExportMSPUIPreferences;
import org.eclipse.epf.ui.wizards.BaseWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Shell;

public class SelectExportDirectoryPage
extends BaseWizardPage {
    public static final String PAGE_NAME = SelectExportDirectoryPage.class.getName();
    protected Shell shell;
    protected Composite composite;
    protected Composite templateComposite;
    protected Combo projectNameCombo;
    protected Combo exportDirCombo;
    protected Button browseButton;
    protected ModifyListener modifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            SelectExportDirectoryPage.this.setPageComplete(SelectExportDirectoryPage.this.isPageComplete());
        }
    };

    public SelectExportDirectoryPage(String pageName) {
        super(pageName);
        this.setTitle(ExportMSPUIResources.selectExportDirWizardPage_title);
        this.setDescription(ExportMSPUIResources.selectExportDirWizardPage_text);
        this.setImageDescriptor(ExportMSPUIPlugin.getDefault().getImageDescriptor("full/wizban/exp_ms_prj_wizban.gif"));
    }

    public SelectExportDirectoryPage() {
        this(PAGE_NAME);
    }

    public void createControl(Composite parent) {
        this.shell = parent.getShell();
        this.composite = SelectExportDirectoryPage.createGridLayoutComposite((Composite)parent, (int)1);
        this.templateComposite = SelectExportDirectoryPage.createGridLayoutComposite((Composite)this.composite, (int)3);
        SelectExportDirectoryPage.createLabel((Composite)this.templateComposite, (String)ExportMSPUIResources.projectNameLabel_text);
        this.projectNameCombo = SelectExportDirectoryPage.createCombobox((Composite)this.templateComposite, (int)2);
        SelectExportDirectoryPage.createLabel((Composite)this.templateComposite, (String)ExportMSPUIResources.dirLabel_text);
        this.exportDirCombo = SelectExportDirectoryPage.createCombobox((Composite)this.templateComposite);
        this.browseButton = SelectExportDirectoryPage.createButton((Composite)this.templateComposite, (String)ExportMSPUIResources.browseButton_text);
        this.initControls();
        this.addListeners();
        this.setControl((Control)this.composite);
    }

    protected void initControls() {
        String[] exportDirs;
        String[] templateNames = ExportMSPUIPreferences.getMSProjectNames();
        if (templateNames != null && templateNames.length > 0) {
            this.projectNameCombo.setItems(templateNames);
            this.projectNameCombo.setText(templateNames[0]);
        }
        if ((exportDirs = ExportMSPUIPreferences.getExportDirectories()) != null && exportDirs.length > 0) {
            this.exportDirCombo.setItems(exportDirs);
            this.exportDirCombo.setText(exportDirs[0]);
        }
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                try {
                    DirectoryDialog dialog = new DirectoryDialog(SelectExportDirectoryPage.this.shell, 0);
                    String selectedDir = dialog.open();
                    if (selectedDir != null) {
                        SelectExportDirectoryPage.this.exportDirCombo.add(selectedDir, 0);
                        SelectExportDirectoryPage.this.exportDirCombo.setText(selectedDir);
                    }
                }
                catch (Exception e) {
                    ExportMSPUIPlugin.getDefault().getLogger().logError((Throwable)e);
                }
            }
        });
    }

    protected void addListeners() {
        this.projectNameCombo.addModifyListener(this.modifyListener);
        this.exportDirCombo.addModifyListener(this.modifyListener);
    }

    public boolean isPageComplete() {
        return this.getMSProjectName().length() > 0 && this.getExportDirectory().length() > 0;
    }

    public String getMSProjectName() {
        return this.projectNameCombo.getText().trim();
    }

    public String getExportDirectory() {
        return this.exportDirCombo.getText().trim();
    }

    public void dispose() {
        ExportMSPUIPreferences.addMSProjectName(this.getMSProjectName());
        ExportMSPUIPreferences.addExportDir(this.getExportDirectory());
        this.modifyListener = null;
        super.dispose();
    }
}

