/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.ui.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.epf.diagram.ad.part.ActivityDiagramEditorPlugin;
import org.eclipse.epf.diagram.add.part.ADDiagramEditor;
import org.eclipse.epf.diagram.add.part.ActivityDetailDiagramEditorPlugin;
import org.eclipse.epf.diagram.core.part.AbstractDiagramEditor;
import org.eclipse.epf.diagram.core.part.DiagramEditorInput;
import org.eclipse.epf.diagram.core.part.DiagramEditorInputProxy;
import org.eclipse.epf.diagram.core.part.util.DiagramEditorUtil;
import org.eclipse.epf.diagram.core.services.DiagramHelper;
import org.eclipse.epf.diagram.core.services.DiagramManager;
import org.eclipse.epf.diagram.ui.DiagramUIPlugin;
import org.eclipse.epf.diagram.wpdd.part.WPDDiagramEditorPlugin;
import org.eclipse.epf.library.edit.process.BreakdownElementWrapperItemProvider;
import org.eclipse.epf.library.edit.util.DiagramOptions;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.Suppression;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.Process;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiagramEditorHelper {
    private Map<Process, DiagramManager> processToDiagramManagerMap = new HashMap<Process, DiagramManager>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DiagramManager getDiagramManager(Process proc) {
        DiagramManager mgr = this.processToDiagramManagerMap.get(proc);
        if (mgr != null && mgr.isDisposed()) {
            this.processToDiagramManagerMap.remove(proc);
            mgr = null;
        }
        if (mgr == null) {
            Map<Process, DiagramManager> map = this.processToDiagramManagerMap;
            synchronized (map) {
                mgr = this.processToDiagramManagerMap.get(proc);
                if (mgr == null) {
                    mgr = DiagramManager.getInstance((Process)proc, (Object)this);
                    this.processToDiagramManagerMap.put(proc, mgr);
                }
            }
        }
        return mgr;
    }

    public void openDiagram(IEditorPart part, int diagramType, Object selectedObject, Suppression suppression) {
        try {
            DiagramEditorInput input = new DiagramEditorInput(selectedObject, suppression, diagramType);
            DiagramEditorUtil.openDiagramEditor((IWorkbenchPage)part.getSite().getPage(), (DiagramEditorInput)input, (PreferencesHint)DiagramEditorHelper.getDiagramPreferencesHint(diagramType), (IProgressMonitor)new NullProgressMonitor());
        }
        catch (RuntimeException e) {
            DiagramUIPlugin.getDefault().getLogger().logError((Throwable)e);
        }
    }

    public Diagram getDiagram(Activity activity, int type) {
        Diagram diagram = null;
        DiagramManager dMgr = this.getDiagramManager(TngUtil.getOwningProcess((BreakdownElement)activity));
        if (dMgr != null) {
            try {
                List list = dMgr.getDiagrams(activity, type);
                if (!list.isEmpty()) {
                    diagram = (Diagram)list.get(0);
                }
            }
            catch (Exception e) {
                DiagramUIPlugin.getDefault().getLogger().logError("Core error retrieving a diagram in process editor:", (Throwable)e);
            }
        }
        return diagram;
    }

    public Collection getDiagrams(Activity act) {
        DiagramManager mgr = this.getDiagramManager(TngUtil.getOwningProcess((BreakdownElement)act));
        try {
            ArrayList diagrams = new ArrayList();
            int i = 0;
            while (i < DiagramHelper.DIAGRAM_TYPES.length) {
                List list = mgr.getDiagrams(act, DiagramHelper.DIAGRAM_TYPES[i]);
                if (!list.isEmpty()) {
                    diagrams.addAll(list);
                }
                ++i;
            }
            return diagrams;
        }
        catch (Exception exception) {
            return Collections.EMPTY_LIST;
        }
    }

    public void dispose() {
        for (DiagramManager mgr : this.processToDiagramManagerMap.values()) {
            try {
                mgr.removeConsumer((Object)this);
            }
            catch (Exception exception) {}
        }
    }

    public static int getDiagramType(Diagram diagram) {
        return DiagramHelper.getDiagramType((Diagram)diagram);
    }

    public static String getDiagramTypeString(Diagram diagram) {
        return DiagramHelper.getDiagramTypeString((Diagram)diagram);
    }

    public static PreferencesHint getDiagramPreferencesHint(int diagramType) {
        switch (diagramType) {
            case 0: {
                return ActivityDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT;
            }
            case 2: {
                return ActivityDetailDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT;
            }
            case 1: {
                return WPDDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT;
            }
        }
        return null;
    }

    public static void closeDiagramEditors(Object closeElement, List<IEditorReference> closedEditorRefs) {
        IWorkbenchPage workbenchPage = DiagramUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (workbenchPage == null) {
            return;
        }
        IEditorReference[] editorReferences = workbenchPage.getEditorReferences();
        if (closedEditorRefs == null) {
            closedEditorRefs = new ArrayList<IEditorReference>();
        }
        ArrayList<IEditorReference> closeEditorRefs = new ArrayList<IEditorReference>();
        int i = 0;
        while (i < editorReferences.length) {
            IEditorReference reference = editorReferences[i];
            IEditorPart editor = reference.getEditor(true);
            if (editor != null) {
                IEditorInput input = editor.getEditorInput();
                Object element = null;
                if (input instanceof DiagramEditorInputProxy) {
                    DiagramEditorInput diagramInput = ((DiagramEditorInputProxy)input).getDiagramEditorInput();
                    if (diagramInput.getWrapper() != null) {
                        Object parent;
                        element = diagramInput.getWrapper();
                        if (element instanceof BreakdownElementWrapperItemProvider && (parent = ((BreakdownElementWrapperItemProvider)element).getParent(element)) instanceof BreakdownElementWrapperItemProvider && element.equals(closeElement)) {
                            DiagramEditorHelper.closeDiagramEditors(parent, closedEditorRefs);
                        }
                    } else {
                        element = diagramInput.getMethodElement();
                    }
                }
                if (element != null) {
                    if (element.equals(closeElement)) {
                        closeEditorRefs.add(reference);
                    } else if (closeElement instanceof Activity) {
                        ArrayList collection = new ArrayList();
                        ProcessUtil.getChildElements((Activity)((Activity)closeElement), Activity.class, collection);
                        if (collection.contains(element)) {
                            closeEditorRefs.add(reference);
                        }
                    }
                }
            }
            ++i;
        }
        int size = closeEditorRefs.size();
        IEditorReference[] references = new IEditorReference[size];
        int i2 = 0;
        while (i2 < size) {
            references[i2] = (IEditorReference)closeEditorRefs.get(i2);
            ++i2;
        }
        workbenchPage.closeEditors(references, false);
        references = null;
    }

    public static void refreshParentDiagramEditors(Object refreshElement, List<IEditorReference> openEditorRefs, boolean parentRefresh) {
        openEditorRefs = new ArrayList<IEditorReference>();
        IWorkbenchPage workbenchPage = DiagramUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorReference[] editorReferences = workbenchPage.getEditorReferences();
        int i = 0;
        while (i < editorReferences.length) {
            IEditorReference reference = editorReferences[i];
            IEditorPart editor = reference.getEditor(true);
            if (editor != null) {
                IEditorInput input = editor.getEditorInput();
                BreakdownElementWrapperItemProvider element = null;
                if (input instanceof DiagramEditorInputProxy) {
                    DiagramEditorInput diagramInput = ((DiagramEditorInputProxy)input).getDiagramEditorInput();
                    if (diagramInput.getWrapper() != null) {
                        Object parent;
                        element = diagramInput.getWrapper();
                        if (parentRefresh && element instanceof BreakdownElementWrapperItemProvider && (parent = element.getParent(null)) instanceof BreakdownElementWrapperItemProvider && element.equals(refreshElement)) {
                            DiagramEditorHelper.refreshParentDiagramEditors(parent, openEditorRefs, parentRefresh);
                        }
                    } else {
                        element = diagramInput.getMethodElement();
                    }
                }
                if (element != null) {
                    Collection c;
                    if (element instanceof Activity) {
                        Activity base;
                        if (!parentRefresh && element == refreshElement) {
                            openEditorRefs.add(reference);
                        }
                        if (((Activity)element).getBreakdownElements().contains(refreshElement)) {
                            openEditorRefs.add(reference);
                        } else if (refreshElement instanceof BreakdownElementWrapperItemProvider) {
                            Object localRefreshElement = refreshElement;
                            while (localRefreshElement instanceof BreakdownElementWrapperItemProvider && ((BreakdownElementWrapperItemProvider)localRefreshElement).getOwner() != null) {
                                if (((BreakdownElementWrapperItemProvider)localRefreshElement).getOwner().equals(element)) {
                                    openEditorRefs.add(reference);
                                }
                                localRefreshElement = ((BreakdownElementWrapperItemProvider)localRefreshElement).getOwner();
                            }
                        }
                        if (((Activity)element).getVariabilityBasedOnElement() != null && (base = (Activity)((Activity)element).getVariabilityBasedOnElement()).getBreakdownElements().contains(refreshElement)) {
                            openEditorRefs.add(reference);
                        }
                    } else if (element instanceof BreakdownElementWrapperItemProvider && (c = element.getChildren((Object)element)) != null && c.contains(refreshElement)) {
                        openEditorRefs.add(reference);
                    }
                }
            }
            ++i;
        }
        int size = openEditorRefs.size();
        int i2 = 0;
        while (i2 < size) {
            IEditorReference reference = openEditorRefs.get(i2);
            IEditorPart editor = reference.getEditor(true);
            if (editor instanceof AbstractDiagramEditor) {
                ((AbstractDiagramEditor)editor).refreshDiagram();
                if (editor instanceof ADDiagramEditor) {
                    ((ADDiagramEditor)editor).runResetLayoutAction();
                }
            }
            ++i2;
        }
    }

    public static void setDiagramOptions(Activity activity, int diagramType) {
        switch (diagramType) {
            case 0: {
                DiagramOptions.setPublishAD((Activity)activity, (boolean)false);
                break;
            }
            case 2: {
                DiagramOptions.setPublishADD((Activity)activity, (boolean)false);
                break;
            }
            case 1: {
                DiagramOptions.setPublishWPDD((Activity)activity, (boolean)false);
            }
        }
    }

    public static boolean isPublishDiagram(Activity activity, int diagramType) {
        switch (diagramType) {
            case 0: {
                return DiagramOptions.isPublishAD((Activity)activity);
            }
            case 2: {
                return DiagramOptions.isPublishADD((Activity)activity);
            }
            case 1: {
                return DiagramOptions.isPublishWPDD((Activity)activity);
            }
        }
        return false;
    }
}

