/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.publishing.services;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.library.configuration.ConfigurationHelper;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.publishing.PublishingPlugin;
import org.eclipse.epf.publishing.services.PublishHTMLOptions;
import org.eclipse.epf.publishing.services.PublishingContentValidator;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.ContentCategory;
import org.eclipse.epf.uma.Descriptor;
import org.eclipse.epf.uma.Guidance;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Practice;
import org.eclipse.epf.uma.Roadmap;
import org.eclipse.epf.uma.SupportingMaterial;
import org.eclipse.epf.uma.TermDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessPublishingContentValidator
extends PublishingContentValidator {
    protected static final String CLOSURE_LOG_FILENAME = "processClosure.html";
    Collection closureElements = null;
    private boolean isFinalClosure = false;
    private boolean debug = PublishingPlugin.getDefault().isDebugging();
    protected PrintStream closureLog = this.getStream("processClosure.html");

    public ProcessPublishingContentValidator(String pubDir, PublishHTMLOptions options) {
        super(pubDir, options);
        this.beginClosureLog();
    }

    @Override
    public void addClosureElements(List items) {
        if (this.closureElements == null) {
            this.closureElements = new HashSet();
        }
        this.closureElements.addAll(items);
    }

    @Override
    public void makeElementClosure(MethodConfiguration config) {
        if (config != null && this.closureElements != null) {
            ArrayList referencingElems = new ArrayList();
            referencingElems.addAll(this.closureElements);
            try {
                this.addReferencesToClosure(referencingElems, config, new HashSet());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.isFinalClosure = true;
        this.endClosureLog();
        if (this.debug) {
            System.out.println("====================== Closure elements =======================");
            Iterator it = this.closureElements.iterator();
            while (it.hasNext()) {
                System.out.println(LibraryUtil.getTypeName((MethodElement)((MethodElement)it.next())));
            }
            System.out.println("====================== Closure elements end =======================");
        }
    }

    private void addReferencesToClosure(Collection referencingElems, MethodConfiguration config, Set processed) {
        HashSet<MethodElement> referencedSet = new HashSet<MethodElement>();
        for (Object obj : referencingElems) {
            this.addReferencesToClosure(config, processed, referencedSet, obj);
        }
        if (!referencedSet.isEmpty()) {
            this.addReferencesToClosure(referencedSet, config, processed);
        }
    }

    private void addReferencesToClosure(MethodConfiguration config, Set processed, Set<MethodElement> referencedSet, Object obj) {
        if (processed.contains(obj)) {
            return;
        }
        if (obj instanceof MethodElement) {
            this.addReferencesToClosure_(config, processed, referencedSet, (MethodElement)obj);
        }
        processed.add(obj);
    }

    private void addReferencesToClosure_(MethodConfiguration config, Set processed, Set<MethodElement> referencedSet, MethodElement element) {
        List properties = LibraryUtil.getStructuralFeatures((MethodElement)element);
        for (EStructuralFeature f : properties) {
            List values;
            EReference feature;
            if (!(f instanceof EReference) || (feature = (EReference)f).isContainer() || feature.isContainment() || (values = this.getValues(element, feature)) == null) continue;
            for (Object value : values) {
                MethodElement referenced;
                if (!(value instanceof MethodElement) || (referenced = (MethodElement)value) instanceof ContentCategory || this.closureElements.contains(referenced) || processed.contains(referenced) || !ConfigurationHelper.inConfig((MethodElement)referenced, (MethodConfiguration)config)) continue;
                this.closureElements.add(referenced);
                referencedSet.add(referenced);
            }
        }
    }

    private List getValues(MethodElement element, EReference feature) {
        Object value = element.eGet((EStructuralFeature)feature);
        if (value == null) {
            return null;
        }
        ArrayList<Object> values = null;
        if (feature.isMany() && value instanceof List) {
            values = (ArrayList<Object>)value;
        } else if (value instanceof MethodElement) {
            values = new ArrayList<Object>();
            values.add(value);
        }
        return values;
    }

    @Override
    public boolean hasClosure() {
        return this.closureElements != null && this.closureElements.size() > 0;
    }

    @Override
    public boolean inClosure(MethodElement e) {
        if (e == null) {
            return false;
        }
        if (!this.hasClosure()) {
            return true;
        }
        if (e instanceof ContentCategory) {
            return true;
        }
        if (ConfigurationHelper.isDescriptionElement((MethodElement)e)) {
            return true;
        }
        if (this.closureElements.contains(e)) {
            return true;
        }
        if (!(e instanceof Guidance)) {
            return false;
        }
        return e instanceof Practice || e instanceof Roadmap || e instanceof SupportingMaterial || e instanceof TermDefinition;
    }

    @Override
    public boolean isDiscarded(MethodElement owner, Object feature, MethodElement e) {
        return this.isDiscarded(owner, feature, e, null);
    }

    public boolean isDiscarded(MethodElement owner, Object feature, MethodElement e, MethodConfiguration config) {
        if (owner == null) {
            owner = this.defaultTarget;
        } else if (this.defaultTarget != null && owner != this.defaultTarget) {
            super.logWarning("Target mismatch" + LibraryUtil.getTypeName((MethodElement)owner) + "<--->" + LibraryUtil.getTypeName((MethodElement)this.defaultTarget));
        }
        if (super.isDiscarded(owner, feature, e, config)) {
            return true;
        }
        boolean inCls = this.inClosure(e);
        if (!inCls && !this.isFinalClosure) {
            boolean bl = inCls = this.inClosure(owner) && e instanceof Guidance;
        }
        return !inCls;
    }

    @Override
    public void dispose() {
        if (this.closureElements != null) {
            this.closureElements.clear();
        }
        if (this.closureLog != null) {
            this.closureLog.close();
            this.closureLog = null;
        }
        super.dispose();
    }

    private void beginClosureLog() {
        this.closureLog.println("<table>");
        this.addLogEntry("<b>Element</b>", "<b>Referenced By</b>");
    }

    private void endClosureLog() {
        this.closureLog.println("</table>");
    }

    private void addLogEntry(String str1, String str2) {
        StringBuffer b = new StringBuffer();
        b.append("<tr><td>").append(str1).append("</td><td>").append(str2).append("</td></tr>");
        this.closureLog.println(b);
    }

    @Override
    public void logReference(MethodElement owner, MethodElement e) {
        super.logReference(owner, e);
        if (e instanceof Descriptor) {
            return;
        }
        if (!this.isFinalClosure && this.closureLog != null) {
            StringBuffer b = new StringBuffer();
            if (owner instanceof BreakdownElement) {
                b.append(this.getBreakdownElementLabel((BreakdownElement)owner));
            } else if (owner != null) {
                b.append(LibraryUtil.getTypeName((MethodElement)owner));
            }
            this.addLogEntry(LibraryUtil.getTypeName((MethodElement)e), b.toString());
        }
    }

    private StringBuffer getBreakdownElementLabel(BreakdownElement e) {
        StringBuffer b = new StringBuffer();
        b.append(LibraryUtil.getTypeName((MethodElement)e));
        while ((e = e.getSuperActivities()) != null) {
            b.insert(0, String.valueOf(LibraryUtil.getTypeName((MethodElement)e)) + "/");
        }
        return b;
    }
}

