/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.publishing.services;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.imageio.ImageIO;
import org.eclipse.epf.publishing.services.PublishOptions;

public class PublishHTMLOptions
extends PublishOptions {
    protected String title;
    protected String aboutHTML;
    protected String feedbackURL;
    protected boolean publishGlossary;
    protected boolean publishIndex;
    protected String bannerImage;
    protected int bannerImageHeight = 67;
    protected boolean checkExternalLinks;
    protected boolean convertBrokenLinks;
    protected boolean publishJavaScriptTree = true;
    protected boolean publishDynamicWebApp;
    protected String dynamicWebAppName;
    protected boolean includeServletSearch;
    protected String defaultActivityTab = "WBS";

    public PublishHTMLOptions() {
    }

    public PublishHTMLOptions(PublishOptions options) {
        this.publishDir = options.getPublishDir();
        this.processes = options.getProcesses();
        this.publishConfiguration = options.isPublishConfiguration();
        this.publishProcess = options.isPublishProcess();
        this.publishUnopenADD = options.isPublishUnopenADD();
        this.publishBaseAD = options.isPublishBaseAD();
        this.publishLightWeightTree = options.isPublishLightWeightTree();
        this.showRelatedLinks = options.isShowRelatedLinks();
        this.showMethodContentInDescriptors = options.isShowMethodContentInDescriptors();
        this.showRelatedDescriptors = options.isShowRelatedDescriptors();
        this.showRelatedDescriptorsOption = options.isShowRelatedDescriptorsOption();
        this.showDescriptorsInNavigationTree = options.isShowDescriptorsInNavigationTree();
        this.publishEmptyCategories = options.isPublishEmptyCategories();
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getAboutHTML() {
        return this.aboutHTML;
    }

    public void setAboutHTML(String aboutHTML) {
        this.aboutHTML = aboutHTML;
    }

    public String getFeedbackURL() {
        return this.feedbackURL;
    }

    public void setFeedbackURL(String feedbackURL) {
        this.feedbackURL = feedbackURL;
    }

    public boolean isPublishGlossary() {
        return this.publishGlossary;
    }

    public void setPublishGlossary(boolean publishGlossary) {
        this.publishGlossary = publishGlossary;
    }

    public boolean isPublishIndex() {
        return this.publishIndex;
    }

    public void setPublishIndex(boolean publishIndex) {
        this.publishIndex = publishIndex;
    }

    public String getBannerImage() {
        return this.bannerImage;
    }

    public void setBannerImage(String bannerImage) {
        this.bannerImage = bannerImage;
        BufferedImage image = null;
        File f = new File(this.bannerImage);
        if (f.exists()) {
            try {
                int height;
                image = ImageIO.read(f);
                if (image != null && (height = ((Image)image).getHeight(null)) > 0) {
                    this.bannerImageHeight = height;
                }
            }
            catch (Exception exception) {}
        }
    }

    public int getBannerImageHeight() {
        return this.bannerImageHeight;
    }

    public void setBannerImageHeight(int bannerImageheight) {
        this.bannerImageHeight = bannerImageheight;
    }

    public boolean isCheckExternalLinks() {
        return this.checkExternalLinks;
    }

    public void setCheckExternalLinks(boolean checkExternalLinks) {
        this.checkExternalLinks = checkExternalLinks;
    }

    public boolean isConvertBrokenLinks() {
        return this.convertBrokenLinks;
    }

    public void setConvertBrokenLinks(boolean convertBrokenLinks) {
        this.convertBrokenLinks = convertBrokenLinks;
    }

    public boolean isPublishJavaScriptTree() {
        return this.publishJavaScriptTree;
    }

    public void setPublishJavaScriptTree(boolean publishJavaScriptTree) {
        this.publishJavaScriptTree = publishJavaScriptTree;
    }

    public boolean isPublishDynamicWebApp() {
        return this.publishDynamicWebApp && this.dynamicWebAppName != null && this.dynamicWebAppName.length() > 0;
    }

    public void setPublishDynamicWebApp(boolean publishDynamicWebApp) {
        this.publishDynamicWebApp = publishDynamicWebApp;
    }

    public String getDynamicWebAppName() {
        return this.dynamicWebAppName;
    }

    public void setDynamicWebAppName(String dynamicWebAppName) {
        this.dynamicWebAppName = dynamicWebAppName;
    }

    public boolean isIncludeServletSearch() {
        return this.includeServletSearch && this.isPublishDynamicWebApp();
    }

    public void setIncludeServletSearch(boolean includeServletSearch) {
        this.includeServletSearch = includeServletSearch;
    }

    public String getDefaultActivityTab() {
        return this.defaultActivityTab;
    }

    public void setDefaultActivityTab(String tabName) {
        this.defaultActivityTab = tabName;
    }

    public void validate() {
        super.validate();
    }
}

