/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.publishing.services.index;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.epf.publishing.services.index.Def;

final class JarResources {
    boolean debugOn = false;
    private Hashtable htJarContents = new Hashtable();
    private String jarFileName;

    JarResources(String jarFileName) {
        this.jarFileName = jarFileName;
        this.init();
    }

    byte[] getResource(String name) {
        return (byte[])this.htJarContents.get(name);
    }

    byte[] getResource() {
        Enumeration keys = this.htJarContents.keys();
        return (byte[])this.htJarContents.get(keys.nextElement());
    }

    private void init() {
        try {
            DataInputStream in = null;
            in = this.jarFileName.startsWith(Def.Http) || this.jarFileName.startsWith(Def.Https) || this.jarFileName.startsWith(Def.File) ? new DataInputStream(new URL(this.jarFileName).openStream()) : new DataInputStream(new FileInputStream(this.jarFileName));
            BufferedInputStream bis = new BufferedInputStream(in);
            ZipInputStream zis = new ZipInputStream(bis);
            ZipEntry ze = null;
            while ((ze = zis.getNextEntry()) != null) {
                int size;
                if (ze.isDirectory()) continue;
                if (this.debugOn) {
                    System.out.println("ze.getName()=" + ze.getName() + "," + "getSize()=" + ze.getSize());
                }
                if ((size = (int)ze.getSize()) == -1) {
                    System.out.println("ERROR: Returned size of zip file is -1. Filename: " + ze.getName());
                }
                byte[] b = new byte[size];
                int rb = 0;
                int chunk = 0;
                while (size - rb > 0) {
                    chunk = zis.read(b, rb, size - rb);
                    if (chunk == -1) break;
                    rb += chunk;
                }
                this.htJarContents.put(ze.getName(), b);
                if (!this.debugOn) continue;
                System.out.println(String.valueOf(ze.getName()) + "  rb=" + rb + ",size=" + size + ",csize=" + ze.getCompressedSize());
            }
        }
        catch (NullPointerException nullPointerException) {
            System.out.println("done.");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String dumpZipEntry(ZipEntry ze) {
        StringBuffer sb = new StringBuffer();
        if (ze.isDirectory()) {
            sb.append("d ");
        } else {
            sb.append("f ");
        }
        if (ze.getMethod() == 0) {
            sb.append("stored   ");
        } else {
            sb.append("defalted ");
        }
        sb.append(ze.getName());
        sb.append("\t");
        sb.append("" + ze.getSize());
        if (ze.getMethod() == 8) {
            sb.append("/" + ze.getCompressedSize());
        }
        return sb.toString();
    }
}

