/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.validation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.emf.edit.provider.AdapterFactoryTreeIterator;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.validation.model.Category;
import org.eclipse.emf.validation.model.EvaluationMode;
import org.eclipse.emf.validation.model.IConstraintStatus;
import org.eclipse.emf.validation.service.IBatchValidator;
import org.eclipse.emf.validation.service.IConstraintDescriptor;
import org.eclipse.emf.validation.service.IConstraintFilter;
import org.eclipse.emf.validation.service.ModelValidationService;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.edit.IAdapterFactoryProvider;
import org.eclipse.epf.library.edit.process.DescribableElementWrapperItemProvider;
import org.eclipse.epf.library.edit.process.IBSItemProvider;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.edit.validation.DependencyChecker;
import org.eclipse.epf.library.edit.validation.DependencyValidationMgr;
import org.eclipse.epf.library.edit.validation.IValidator;
import org.eclipse.epf.library.edit.validation.IValidatorFactory;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.NamedElement;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.RoleDescriptor;
import org.eclipse.epf.uma.TeamProfile;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.WorkProductDescriptor;
import org.eclipse.epf.validation.Activator;
import org.eclipse.epf.validation.ValidationResources;
import org.eclipse.epf.validation.constraints.LibraryTraversalStrategy;
import org.eclipse.epf.validation.util.ValidationStatus;

public class LibraryEValidator
extends EObjectValidator {
    private static final boolean DEBUG = Activator.getDefault().isDebugging();
    private static final Map featureToPropertyMap = LibraryEValidator.createFeatureToAttributeMap();
    public static final String CTX_ADAPTER_FACTORY_PROVIDER = "CTX_ADAPTER_FACTORY_PROVIDER";
    public static final String CTX_DEPENDENCY_VALIDATION_MGR = "CTX_DEPENDENCY_VALIDATION_MGR";
    public static final String CTX_CONSTRAINT_FILTER = "CTX_CONSTRAINT_FILTER";
    public static final String CONSTRAINT_CATEGORY = "org.eclipse.epf.validation.library.category";
    private final IBatchValidator batchValidator = (IBatchValidator)ModelValidationService.getInstance().newValidator(EvaluationMode.BATCH);

    private static Map createFeatureToAttributeMap() {
        HashMap<EAttribute, String> map = new HashMap<EAttribute, String>();
        map.put(UmaPackage.Literals.NAMED_ELEMENT__NAME, "name");
        map.put(UmaPackage.Literals.METHOD_ELEMENT__PRESENTATION_NAME, "presentation_name");
        return map;
    }

    public LibraryEValidator() {
        this.batchValidator.setIncludeLiveConstraints(true);
        this.batchValidator.setReportSuccesses(false);
        this.batchValidator.addConstraintFilter(new IConstraintFilter(){

            public boolean accept(IConstraintDescriptor constraint, EObject target) {
                Set categories = constraint.getCategories();
                if (categories != null && !categories.isEmpty()) {
                    for (Category category : categories) {
                        if (!LibraryEValidator.CONSTRAINT_CATEGORY.equals(category.getId())) continue;
                        return true;
                    }
                }
                return false;
            }
        });
    }

    public boolean validate(EObject eObject, DiagnosticChain diagnostics, Map context) {
        return this.validate(eObject.eClass(), eObject, diagnostics, context);
    }

    public boolean validate(EClass eClass, EObject eObject, DiagnosticChain diagnostics, Map context) {
        Process proc;
        IStatus status = Status.OK_STATUS;
        boolean circularCheckOk = true;
        DependencyValidationMgr mgr = (DependencyValidationMgr)context.get(CTX_DEPENDENCY_VALIDATION_MGR);
        if (DependencyChecker.newCheck && mgr != null && (eObject instanceof VariabilityElement || eObject instanceof MethodPlugin) && !(status = mgr.checkCircularDependnecy((MethodElement)eObject)).isOK()) {
            circularCheckOk = false;
            String msg = status.getMessage();
            if (StrUtil.isBlank((String)msg)) {
                msg = ValidationResources.circularDependency_error;
            }
            this.appendDiagnostics(status, diagnostics);
        }
        if (diagnostics != null && !this.hasProcessed(eObject, context)) {
            IConstraintFilter filter;
            if (LibraryEValidator.getTraversalType(context) == 1) {
                this.batchValidator.setTraversalStrategy(LibraryTraversalStrategy.deepTraversalStrategy);
            }
            if ((filter = (IConstraintFilter)context.get(CTX_CONSTRAINT_FILTER)) != null) {
                this.batchValidator.addConstraintFilter(filter);
            }
            try {
                status = this.batchValidator.validate(eObject, (IProgressMonitor)new NullProgressMonitor());
            }
            finally {
                if (filter != null) {
                    this.batchValidator.removeConstraintFilter(filter);
                }
            }
            this.processed(eObject, context, status);
            this.appendDiagnostics(status, diagnostics);
        }
        if (eObject instanceof ProcessComponent && (proc = ((ProcessComponent)eObject).getProcess()) != null) {
            this.validateProcess(proc, diagnostics, context);
        }
        return circularCheckOk && status.isOK();
    }

    public void validateProcess(Process proc, DiagnosticChain diagnostics, Map context) {
        Object o = context.get(CTX_ADAPTER_FACTORY_PROVIDER);
        if (!(o instanceof IAdapterFactoryProvider)) {
            return;
        }
        IAdapterFactoryProvider provider = (IAdapterFactoryProvider)o;
        class FilteredAdapterFactoryTreeIterator
        extends AdapterFactoryTreeIterator {
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ DiagnosticChain val$diagnostics;

            public FilteredAdapterFactoryTreeIterator(AdapterFactory adapterFactory, Object object, DiagnosticChain diagnosticChain) {
                this.val$diagnostics = diagnosticChain;
                super(adapterFactory, object);
            }

            protected boolean accept(Object child) {
                return child instanceof NamedElement;
            }

            protected Iterator getChildren(Object o) {
                ArrayList children = new ArrayList();
                Iterator iter = super.getChildren(o);
                while (iter.hasNext()) {
                    Object child = iter.next();
                    if (child instanceof MethodElement || child instanceof DescribableElementWrapperItemProvider && !((DescribableElementWrapperItemProvider)child).isReadOnly()) {
                        children.add(child);
                        child = TngUtil.unwrap(child);
                    }
                    if (!this.accept(child)) continue;
                    try {
                        ArrayList<EAttribute> features = new ArrayList<EAttribute>();
                        features.add(UmaPackage.Literals.NAMED_ELEMENT__NAME);
                        if (child instanceof DescribableElement) {
                            features.add(UmaPackage.Literals.METHOD_ELEMENT__PRESENTATION_NAME);
                        }
                        NamedElement e = (NamedElement)child;
                        boolean cfr_ignored_0 = e instanceof BreakdownElement;
                        if (DEBUG) {
                            System.out.println("FilteredAdapterFactoryTreeIterator.getChildren(): validating '" + e.getName() + "'");
                        }
                        for (EStructuralFeature eStructuralFeature : features) {
                            IValidator validator = IValidatorFactory.INSTANCE.createValidator(o, null, (EObject)child, eStructuralFeature, this.adapterFactory);
                            Object itemProvider = this.adapterFactory.adapt(child, ITreeItemContentProvider.class);
                            String prop = (String)featureToPropertyMap.get(eStructuralFeature);
                            String name = itemProvider instanceof IBSItemProvider && prop != null ? ((IBSItemProvider)itemProvider).getAttribute(child, prop) : (String)e.eGet(eStructuralFeature);
                            String msg = validator.isValid(name);
                            if (msg == null) continue;
                            LibraryEValidator.this.appendDiagnostics((IStatus)new ValidationStatus(4, 0, msg, e, eStructuralFeature), this.val$diagnostics);
                        }
                    }
                    catch (Exception exception) {}
                }
                return children.iterator();
            }
        }
        FilteredAdapterFactoryTreeIterator iterator = new FilteredAdapterFactoryTreeIterator(provider.getWBSAdapterFactory(), proc, diagnostics);
        while (iterator.hasNext()) {
            iterator.next();
        }
        iterator = new FilteredAdapterFactoryTreeIterator(provider.getTBSAdapterFactory(), proc, diagnostics){
            private static final long serialVersionUID = 1L;
            {
                super($anonymous0, $anonymous1, diagnosticChain);
            }

            protected boolean accept(Object child) {
                return child instanceof RoleDescriptor || child instanceof TeamProfile;
            }
        };
        while (iterator.hasNext()) {
            iterator.next();
        }
        iterator = new FilteredAdapterFactoryTreeIterator(provider.getWPBSAdapterFactory(), proc, diagnostics){
            private static final long serialVersionUID = 1L;
            {
                super($anonymous0, $anonymous1, diagnosticChain);
            }

            protected boolean accept(Object child) {
                return child instanceof WorkProductDescriptor;
            }
        };
        while (iterator.hasNext()) {
            iterator.next();
        }
    }

    private static int getTraversalType(Map context) {
        Object type = context.get("TRAVERSAL_TYPE");
        return type instanceof Number && ((Number)type).intValue() == 1 ? 1 : 0;
    }

    public boolean validate(EDataType eDataType, Object value, DiagnosticChain diagnostics, Map context) {
        return super.validate(eDataType, value, diagnostics, context);
    }

    private void processed(EObject eObject, Map context, IStatus status) {
        if (context != null) {
            context.put(eObject, status);
        }
    }

    private boolean hasProcessed(EObject eObject, Map context) {
        boolean result = false;
        if (context != null) {
            while (eObject != null) {
                if (context.containsKey(eObject)) {
                    result = true;
                    eObject = null;
                    continue;
                }
                eObject = eObject.eContainer();
            }
        }
        return result;
    }

    private void appendDiagnostics(IStatus status, DiagnosticChain diagnostics) {
        if (status.isMultiStatus()) {
            IStatus[] children = status.getChildren();
            int i = 0;
            while (i < children.length) {
                this.appendDiagnostics(children[i], diagnostics);
                ++i;
            }
        } else if (status instanceof IConstraintStatus) {
            diagnostics.add((Diagnostic)new BasicDiagnostic(status.getSeverity(), status.getPlugin(), status.getCode(), status.getMessage(), ((IConstraintStatus)status).getResultLocus().toArray()));
        } else if (status instanceof org.eclipse.epf.library.edit.validation.ValidationStatus) {
            diagnostics.add((Diagnostic)new BasicDiagnostic(status.getSeverity(), status.getPlugin(), status.getCode(), status.getMessage(), new Object[]{((org.eclipse.epf.library.edit.validation.ValidationStatus)status).getCheckedObject()}));
        } else {
            diagnostics.add((Diagnostic)new BasicDiagnostic(status.getSeverity(), status.getPlugin(), status.getCode(), status.getMessage(), null));
        }
    }
}

