/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.persistence.internal;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.epf.library.persistence.ILibraryResourceSet;
import org.eclipse.epf.persistence.FileManager;
import org.eclipse.epf.services.IAccessController;

public class AccessController
implements IAccessController {
    public IStatus checkModify(Collection eObjects, Object context) {
        if (eObjects.isEmpty()) {
            return Status.OK_STATUS;
        }
        ILibraryResourceSet resourceSet = null;
        for (EObject o : eObjects) {
            Resource resource = o.eResource();
            if (resource != null && resource.getResourceSet() instanceof ILibraryResourceSet && (resourceSet = (ILibraryResourceSet)resource.getResourceSet()) != null) break;
        }
        if (resourceSet != null) {
            return resourceSet.checkModify(eObjects, context);
        }
        return Status.OK_STATUS;
    }

    public IStatus checkModify(Resource[] resources, Object context) {
        if (resources.length == 0) {
            return Status.OK_STATUS;
        }
        ArrayList<String> paths = new ArrayList<String>();
        int i = 0;
        while (i < resources.length) {
            String path;
            Resource resource = resources[i];
            if (resource != null && (path = FileManager.toFileString(resource.getURI())) != null) {
                paths.add(path);
            }
            ++i;
        }
        if (!paths.isEmpty()) {
            String[] arr = new String[paths.size()];
            paths.toArray(arr);
            return FileManager.getInstance().checkModify(arr, context);
        }
        return Status.OK_STATUS;
    }
}

