/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.persistence;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.Calendar;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.NotificationImpl;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.XMLInfoImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLMapImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.library.persistence.ILibraryResourceSet;
import org.eclipse.epf.library.persistence.LibraryResourceException;
import org.eclipse.epf.persistence.FileManager;
import org.eclipse.epf.persistence.FilePathProvider;
import org.eclipse.epf.persistence.IURIProvider;
import org.eclipse.epf.persistence.MethodLibraryPersister;
import org.eclipse.epf.persistence.MultiFileIOException;
import org.eclipse.epf.persistence.MultiFileSaveUtil;
import org.eclipse.epf.persistence.MultiFileURIConverter;
import org.eclipse.epf.persistence.MultiFileXMIResourceImpl;
import org.eclipse.epf.persistence.MultiFileXMISaveImpl;
import org.eclipse.epf.persistence.PersistencePlugin;
import org.eclipse.epf.persistence.TxRecord;
import org.eclipse.epf.persistence.UnnormalizedURIException;
import org.eclipse.epf.persistence.refresh.IRefreshEvent;
import org.eclipse.epf.persistence.refresh.IRefreshListener;
import org.eclipse.epf.persistence.refresh.RefreshJob;
import org.eclipse.epf.persistence.refresh.internal.RefreshEvent;
import org.eclipse.epf.persistence.util.PersistenceResources;
import org.eclipse.epf.persistence.util.PersistenceUtil;
import org.eclipse.epf.persistence.util.UnresolvedProxyMarkerManager;
import org.eclipse.epf.resourcemanager.ResourceDescriptor;
import org.eclipse.epf.resourcemanager.ResourceManager;
import org.eclipse.epf.services.ILibraryPersister;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.Descriptor;
import org.eclipse.epf.uma.Diagram;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.ProcessElement;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.RoleDescriptor;
import org.eclipse.epf.uma.SemanticModelBridge;
import org.eclipse.epf.uma.TeamProfile;
import org.eclipse.epf.uma.UMASemanticModelBridge;
import org.eclipse.epf.uma.UmaFactory;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.WorkOrder;
import org.eclipse.epf.uma.WorkProductDescriptor;
import org.eclipse.epf.uma.ecore.IProxyResolutionListener;
import org.eclipse.epf.uma.ecore.IUmaResourceSet;
import org.eclipse.epf.uma.ecore.ResolveException;
import org.eclipse.epf.uma.ecore.impl.MultiResourceEObject;
import org.eclipse.epf.uma.ecore.util.OppositeFeature;
import org.eclipse.epf.uma.util.AssociationHelper;
import org.eclipse.epf.uma.util.ContentDescriptionFactory;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiFileResourceSetImpl
extends ResourceSetImpl
implements IProxyResolutionListener,
IUmaResourceSet,
ILibraryResourceSet {
    private static final String[] DEFAULT_DELIVERY_PROCESS_PATH = new String[]{"DeliveryProcesses"};
    private static final String[] DEFAULT_CAPABILITY_PATTERN_PATH = new String[]{"Content", "CapabilityPatterns"};
    private static final String[] DEFAULT_PROCESS_CONTRIBUTION_PATH = new String[]{"ProcessContributions"};
    public static final String[][] PROCESS_PACKAGE_PATHS = new String[][]{DEFAULT_DELIVERY_PROCESS_PATH, DEFAULT_CAPABILITY_PATTERN_PATH, DEFAULT_PROCESS_CONTRIBUTION_PATH};
    public static boolean REPORT_ERROR = true;
    static final Map<Object, Object> DEFAULT_SAVE_OPTIONS = new HashMap<Object, Object>();
    static final Set DEFAULT_SAVE_SEPARATELY_CLASS_SET = new HashSet();
    public static final String RESMGR_XMI = "resmgr.xmi";
    private HashMap<Object, Object> defaultSaveOptions;
    private HashMap<String, EObject> guidToMethodElementMap;
    private boolean loading;
    private boolean loadingResourceManagerTree;
    private Map URIToTempURIMap;
    private UnresolvedProxyMarkerManager markerMananger = new UnresolvedProxyMarkerManager((ResourceSet)this);
    private UniqueEList<IRefreshListener> refreshListeners;
    protected IURIProvider uriProvider;
    private Path configFolderPath;
    private Path libFolderPath;

    static {
        DEFAULT_SAVE_SEPARATELY_CLASS_SET.add(UmaPackage.eINSTANCE.getMethodPlugin());
        DEFAULT_SAVE_SEPARATELY_CLASS_SET.add(UmaPackage.eINSTANCE.getProcessComponent());
        DEFAULT_SAVE_SEPARATELY_CLASS_SET.add(UmaPackage.eINSTANCE.getContentDescription());
        DEFAULT_SAVE_SEPARATELY_CLASS_SET.add(UmaPackage.eINSTANCE.getMethodConfiguration());
        XMLResource.XMLMap xmlMap = MultiFileResourceSetImpl.createSaveXMLMap();
        HashSet<EClass> saveTogether = new HashSet<EClass>();
        saveTogether.add(UmaPackage.eINSTANCE.getBreakdownElementDescription());
        DEFAULT_SAVE_OPTIONS.put("SAVE_SEPARATELY_CLASS_SET", DEFAULT_SAVE_SEPARATELY_CLASS_SET);
        DEFAULT_SAVE_OPTIONS.put("SAVE_ALL", "false");
        DEFAULT_SAVE_OPTIONS.put("SAVE_TOGETHER_CLASS_SET", saveTogether);
        DEFAULT_SAVE_OPTIONS.put("REFRESH_NEW_RESOURCE", "true");
        DEFAULT_SAVE_OPTIONS.put("CHECK_MODIFY", "true");
        DEFAULT_SAVE_OPTIONS.put("ENCODING", "UTF-8");
        DEFAULT_SAVE_OPTIONS.put("PROCESS_DANGLING_HREF", "DISCARD");
        DEFAULT_SAVE_OPTIONS.put("XML_MAP", xmlMap);
        DEFAULT_SAVE_OPTIONS.put("CONFIGURATION_CACHE", Boolean.TRUE);
        AssociationHelper.init();
    }

    private static XMLResource.XMLMap createLoadXMLMap() {
        XMLMapImpl xmlMap = new XMLMapImpl();
        HashSet<EAttribute> excludedAttributes = new HashSet<EAttribute>();
        excludedAttributes.add(UmaPackage.eINSTANCE.getMethodElement_Guid());
        excludedAttributes.add(UmaPackage.eINSTANCE.getNamedElement_Name());
        for (EClassifier eClassifier : UmaPackage.eINSTANCE.getEClassifiers()) {
            if (!(eClassifier instanceof EClass)) continue;
            EClass eClass = (EClass)eClassifier;
            for (EAttribute attrib : eClass.getEAttributes()) {
                if (excludedAttributes.contains(attrib)) continue;
                XMLInfoImpl xmlInfo = new XMLInfoImpl();
                xmlInfo.setName(attrib.getName());
                xmlInfo.setXMLRepresentation(0);
                xmlMap.add((ENamedElement)attrib, (XMLResource.XMLInfo)xmlInfo);
            }
        }
        return xmlMap;
    }

    private static boolean saveAttributeAsElement(EClass eClass, Collection selectedEClasses) {
        for (EClass base : selectedEClasses) {
            if (!base.isSuperTypeOf(eClass)) continue;
            return true;
        }
        return false;
    }

    private static XMLResource.XMLMap createSaveXMLMap() {
        XMLMapImpl xmlMap = new XMLMapImpl();
        HashSet<EAttribute> excludedAttributes = new HashSet<EAttribute>();
        excludedAttributes.add(UmaPackage.eINSTANCE.getMethodElement_Guid());
        excludedAttributes.add(UmaPackage.eINSTANCE.getNamedElement_Name());
        HashSet<EClass> selectedEClasses = new HashSet<EClass>();
        selectedEClasses.add(UmaPackage.eINSTANCE.getContentDescription());
        selectedEClasses.add(UmaPackage.eINSTANCE.getSection());
        for (EClassifier eClassifier : UmaPackage.eINSTANCE.getEClassifiers()) {
            EClass eClass;
            if (!(eClassifier instanceof EClass) || !MultiFileResourceSetImpl.saveAttributeAsElement(eClass = (EClass)eClassifier, selectedEClasses)) continue;
            for (EAttribute attrib : eClass.getEAttributes()) {
                if (excludedAttributes.contains(attrib)) continue;
                XMLInfoImpl xmlInfo = new XMLInfoImpl();
                xmlInfo.setName(attrib.getName());
                xmlInfo.setXMLRepresentation(0);
                xmlMap.add((ENamedElement)attrib, (XMLResource.XMLInfo)xmlInfo);
            }
        }
        return xmlMap;
    }

    public MultiFileResourceSetImpl() {
    }

    public MultiFileResourceSetImpl(boolean reportError) {
        this();
        this.markerMananger.setEnabled(reportError);
    }

    public UnresolvedProxyMarkerManager getUnresolvedProxyMarkerManager() {
        return this.markerMananger;
    }

    public IURIProvider getURIProvider() {
        if (this.uriProvider == null) {
            this.uriProvider = new FilePathProvider();
        }
        return this.uriProvider;
    }

    private void handleResourceChange(IResource wsRes) {
        System.out.println("MultiFileResourceSetImpl.handleResourceChange(): " + wsRes.toString());
        MultiFileXMIResourceImpl resource = (MultiFileXMIResourceImpl)this.getResource(URI.createFileURI((String)wsRes.getLocation().toString()), false);
        if (resource != null) {
            try {
                ArrayList proxies = new ArrayList();
                resource.reload(proxies);
                NotificationImpl msg = new NotificationImpl(11, false, true);
                for (EObject o : proxies) {
                    o.eNotify((Notification)msg);
                }
            }
            catch (IOException e) {
                CommonPlugin.INSTANCE.log((Object)e);
            }
        }
    }

    public Map<Object, Object> getLoadOptions() {
        Map options = super.getLoadOptions();
        options.put("ENCODING", "UTF-8");
        options.put("XML_MAP", MultiFileResourceSetImpl.createLoadXMLMap());
        return options;
    }

    public Map<Object, Object> getDefaultSaveOptions() {
        if (this.defaultSaveOptions == null) {
            this.defaultSaveOptions = new HashMap();
            this.defaultSaveOptions.putAll(DEFAULT_SAVE_OPTIONS);
        }
        return this.defaultSaveOptions;
    }

    private Resource getMethodLibraryResource() {
        if (this.getResources().isEmpty()) {
            return null;
        }
        return (Resource)this.getResources().get(0);
    }

    public MethodLibrary getMethodLibrary() {
        Resource resource = this.getMethodLibraryResource();
        return resource == null ? null : (MethodLibrary)PersistenceUtil.getMethodElement(resource);
    }

    protected ResourceManager getRootResourceManager() {
        Resource resource = this.getMethodLibraryResource();
        return resource == null ? null : MultiFileSaveUtil.getResourceManager(resource);
    }

    public URIConverter getURIConverter() {
        if (this.uriConverter == null) {
            this.uriConverter = new MultiFileURIConverter(this);
        }
        return this.uriConverter;
    }

    public Resource getResource(URI uri) {
        Resource res;
        block7: {
            if (this.getURIConverter().normalize(uri) == null) {
                return null;
            }
            res = null;
            try {
                res = super.getResource(uri, false);
                if (res != null) break block7;
                Map map = this.getURIResourceMap();
                res = this.createResource(uri);
                try {
                    this.demandLoadHelper(res);
                }
                catch (RuntimeException e) {
                    this.getResources().remove((Object)res);
                    throw e;
                }
                if (map != null) {
                    map.put(uri, res);
                }
            }
            catch (WrappedException e) {
                if (e.exception() instanceof FileNotFoundException) {
                    return null;
                }
                throw e;
            }
        }
        return res;
    }

    protected void demandLoad(Resource resource) throws IOException {
        super.demandLoad(resource);
        boolean ret = FileManager.getInstance().refresh(resource);
        if (MultiFileSaveUtil.DEBUG && !ret) {
            System.err.println("MultiFileResourceSetImpl.demandLoad(): could not refresh resource " + resource);
        }
    }

    public void resolveContainer(Resource res) {
        MethodLibrary lib = this.getMethodLibrary();
        if (this.loading && lib == null) {
            return;
        }
        for (Object element : res.getContents()) {
            Object proxy;
            Resource containerResource;
            ResourceDescriptor resDesc;
            MethodElement e;
            if (!(element instanceof MethodElement) || (e = (MethodElement)element) == lib || e.eContainer() != null || (resDesc = MultiFileSaveUtil.getResourceDescriptor(res)) == null || !((containerResource = resDesc.eResource()) instanceof XMLResourceImpl) || !((proxy = ((XMLResourceImpl)containerResource).getIDToEObjectMap().get(e.getGuid())) instanceof EObject)) continue;
            EObject proxyEObject = (EObject)proxy;
            EReference ref = proxyEObject.eContainmentFeature();
            EObject container = proxyEObject.eContainer();
            if (container == null) continue;
            if (ref.isMany()) {
                List values = (List)container.eGet((EStructuralFeature)ref);
                Iterator iter = values.iterator();
                while (iter.hasNext()) {
                    iter.next();
                }
            } else {
                container.eGet((EStructuralFeature)ref);
            }
            this.resolveContainer(containerResource);
        }
    }

    public Resource getResource(URI uri, boolean loadOnDemand) {
        if (this.getURIConverter().normalize(uri) == null) {
            return null;
        }
        Resource res = null;
        try {
            res = super.getResource(uri, loadOnDemand);
        }
        catch (RuntimeException e) {
            String msg = null;
            msg = e.getMessage() != null ? NLS.bind((String)PersistenceResources.loadResourceErrorWithReason_msg, (Object[])new Object[]{uri, e.getMessage()}) : NLS.bind((String)PersistenceResources.loadResourceError_msg, (Object)uri);
            this.handleException(msg);
            throw e;
        }
        return res;
    }

    @Override
    public void addRefreshListener(IRefreshListener listener) {
        if (this.refreshListeners == null) {
            this.refreshListeners = new UniqueEList();
        }
        this.refreshListeners.add((Object)listener);
    }

    @Override
    public void removeRefreshListenter(IRefreshListener listener) {
        if (this.refreshListeners != null) {
            this.refreshListeners.remove((Object)listener);
        }
    }

    public void notifyRefreshListeners(IRefreshEvent event) {
        if (this.refreshListeners != null && !this.refreshListeners.isEmpty()) {
            for (IRefreshListener listener : this.refreshListeners) {
                try {
                    listener.notifyRefreshed(event);
                }
                catch (Exception e) {
                    PersistencePlugin.getDefault().getLogger().logError((Throwable)e);
                }
            }
        }
    }

    public synchronized Collection reloadResources(Collection resources) {
        for (MultiFileXMIResourceImpl resource : resources) {
            ResourceDescriptor resDesc;
            if (MultiFileSaveUtil.DEBUG) {
                System.out.println("MultiFileResourceSetImpl.reloadResources(): resource=" + resource + ", element=" + PersistenceUtil.getMethodElement(resource));
            }
            if ((resDesc = MultiFileSaveUtil.getResourceDescriptor(resource)) == null) continue;
            resource.setResourceDescriptor(resDesc);
        }
        ArrayList<Resource> reloadedResources = new ArrayList<Resource>();
        HashSet<EObject> proxies = new HashSet<EObject>();
        ArrayList resourceList = new ArrayList(resources);
        Resource libResource = this.getMethodLibraryResource();
        boolean reloadAllConfigs = false;
        if (resourceList.remove(libResource)) {
            MultiFileXMIResourceImpl resource = (MultiFileXMIResourceImpl)libResource;
            this.markerMananger.clearMarkers(resource);
            try {
                if (resource.reload(proxies)) {
                    reloadedResources.add(resource);
                    MultiFileURIConverter uriConverter = (MultiFileURIConverter)this.getURIConverter();
                    uriConverter.resMgr = null;
                    reloadAllConfigs = true;
                }
            }
            catch (IOException e) {
                CommonPlugin.INSTANCE.log((Object)e);
            }
        }
        for (MultiFileXMIResourceImpl resource : resourceList) {
            this.markerMananger.clearMarkers(resource);
            try {
                if (!resource.reload(proxies)) continue;
                reloadedResources.add(resource);
            }
            catch (IOException e) {
                CommonPlugin.INSTANCE.log((Object)e);
            }
        }
        if (!reloadedResources.isEmpty()) {
            this.initialize(reloadAllConfigs);
            if (this.refreshListeners != null) {
                RefreshEvent event = new RefreshEvent(reloadedResources, proxies);
                for (IRefreshListener listener : new ArrayList<IRefreshListener>((Collection<IRefreshListener>)this.refreshListeners)) {
                    listener.notifyRefreshed(event);
                }
            }
        }
        return reloadedResources;
    }

    public void initialize(boolean loadConfigurations) {
        this.loadResourceManagerTree();
        this.setContainersOfLoadedElements();
        if (loadConfigurations) {
            this.loadConfigurations();
        }
        this.loadOppositeFeatures();
        MultiFileURIConverter uriConverter = (MultiFileURIConverter)this.getURIConverter();
        uriConverter.resMgr = null;
    }

    private void setContainersOfLoadedElements() {
        ResourceManager resMgr = this.getRootResourceManager();
        AbstractTreeIterator iterator = new AbstractTreeIterator(resMgr, false){
            private static final long serialVersionUID = 2172691017987702506L;

            protected Iterator getChildren(Object object) {
                ResourceManager resMgr = (ResourceManager)object;
                HashSet<String> GUIDs = new HashSet<String>();
                ArrayList<ResourceManager> subMgrs = new ArrayList<ResourceManager>(resMgr.getSubManagers());
                Iterator iter = subMgrs.iterator();
                while (iter.hasNext()) {
                    InternalEObject subMgr = (InternalEObject)iter.next();
                    if (subMgr == null || subMgr.eIsProxy()) continue;
                    MethodElement e = PersistenceUtil.getMethodElement(subMgr.eResource());
                    GUIDs.add(e.getGuid());
                }
                Resource resource = resMgr.eResource();
                if (resource != null) {
                    MethodElement parent = PersistenceUtil.getMethodElement(resource);
                    MultiFileSaveUtil.resolveProxies(GUIDs, (EObject)parent);
                }
                return resMgr.getSubManagers().iterator();
            }
        };
        while (iterator.hasNext()) {
            iterator.next();
        }
    }

    public boolean isLibraryResource(IResource wsResource) {
        return this.libFolderPath != null && this.libFolderPath.isPrefixOf(wsResource.getLocation());
    }

    public boolean isNewResourceToLoad(IResource wsResource) {
        IPath loc = wsResource.getLocation();
        return loc != null && this.configFolderPath != null && ".xmi".equalsIgnoreCase("." + loc.getFileExtension()) && this.configFolderPath.isPrefixOf(loc) && !FileManager.getInstance().isTeamPrivate(loc.toString());
    }

    public void loadNewResources(Collection<IResource> wsResources) {
        ArrayList<String> newConfigFiles = new ArrayList<String>();
        for (IResource wsResource : wsResources) {
            IResource wsRes;
            IPath loc;
            if (!(wsResource instanceof IResource) || (loc = (wsRes = wsResource).getLocation()) == null || this.configFolderPath == null || !".xmi".equalsIgnoreCase("." + loc.getFileExtension()) || !this.configFolderPath.isPrefixOf(loc)) continue;
            String configFile = loc.toString();
            if (FileManager.getInstance().isTeamPrivate(configFile)) continue;
            newConfigFiles.add(configFile);
        }
        for (String configFile : newConfigFiles) {
            this.loadConfiguration(new File(configFile));
        }
    }

    protected Collection<Resource> loadConfigurations() {
        MethodLibrary lib = this.getMethodLibrary();
        File configDir = new File(new File(lib.eResource().getURI().toFileString()).getParent(), "configurations");
        return this.loadConfigurations(configDir);
    }

    protected Collection<Resource> loadConfigurations(File configDir) {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        Iterator dirIter = MultiFileSaveUtil.listConfigFiles(configDir);
        HashSet<File> configFiles = new HashSet<File>();
        while (dirIter.hasNext()) {
            File configFile = (File)dirIter.next();
            if (!configFile.isFile()) continue;
            configFiles.add(configFile);
        }
        MethodLibrary lib = this.getMethodLibrary();
        for (MethodConfiguration config : lib.getPredefinedConfigurations()) {
            File file = new File(config.eResource().getURI().toFileString());
            if (!configFiles.contains(file)) continue;
            configFiles.remove(file);
        }
        for (File file : configFiles) {
            Resource resource = this.loadConfiguration(file);
            if (resource == null) continue;
            resources.add(resource);
        }
        return resources;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Resource loadConfiguration(File configFile) {
        try {
            MethodLibrary lib = this.getMethodLibrary();
            URI uri = URI.createFileURI((String)configFile.getCanonicalPath());
            Resource resource = super.getResource(uri, true);
            if (resource == null) return null;
            MethodElement e = PersistenceUtil.getMethodElement(resource);
            if (e instanceof MethodConfiguration) {
                if (!PersistenceUtil.hasDuplicateGUID(e, lib.getPredefinedConfigurations())) {
                    lib.getPredefinedConfigurations().add((MethodConfiguration)e);
                    return resource;
                }
                PersistencePlugin.getDefault().getLogger().logError(NLS.bind((String)PersistenceResources.loadConfiguration_couldNotLoad_logMsg, (Object)configFile));
            } else {
                PersistencePlugin.getDefault().getLogger().logError(NLS.bind((String)PersistenceResources.loadConfiguration_notConfigFile_logMsg, (Object)configFile));
            }
            resource.unload();
            this.getResources().remove((Object)resource);
            return null;
        }
        catch (Exception e) {
            PersistencePlugin.getDefault().getLogger().logError((Throwable)e);
        }
        return null;
    }

    protected void handleException(Object err) {
        if (err instanceof Throwable) {
            PersistencePlugin.getDefault().getLogger().logError((Throwable)((Exception)err));
        } else {
            PersistencePlugin.getDefault().getLogger().logError(err.toString());
        }
        if (MultiFileSaveUtil.DEBUG) {
            if (err instanceof Throwable) {
                ((Exception)err).printStackTrace();
            } else {
                System.err.println(err.toString());
            }
        }
    }

    public void reset() {
        if (this.uriConverter instanceof MultiFileURIConverter) {
            ((MultiFileURIConverter)this.uriConverter).dispose();
        }
        this.uriConverter = null;
        boolean notify = this.eDeliver();
        boolean reportError = REPORT_ERROR;
        boolean refresh = RefreshJob.getInstance().isEnabled();
        boolean oldMarkerManagerEnabled = this.markerMananger.isEnabled();
        try {
            if (RefreshJob.getInstance().getResourceSet() == this) {
                RefreshJob.getInstance().setEnabled(false);
                RefreshJob.getInstance().reset();
            }
            this.eSetDeliver(false);
            REPORT_ERROR = false;
            this.markerMananger.setEnabled(false);
            this.markerMananger.clearAll();
            for (Resource resource : new ArrayList(this.getResources())) {
                try {
                    resource.unload();
                }
                catch (Exception exception) {}
            }
            this.clearErrors();
        }
        finally {
            this.eSetDeliver(notify);
            REPORT_ERROR = reportError;
            this.markerMananger.setEnabled(oldMarkerManagerEnabled);
            if (RefreshJob.getInstance().getResourceSet() == this) {
                RefreshJob.getInstance().setEnabled(refresh);
            }
        }
        if (this.guidToMethodElementMap != null) {
            this.guidToMethodElementMap.clear();
        }
        this.getResources().clear();
        if (this.URIToTempURIMap != null) {
            this.URIToTempURIMap.clear();
        }
        MultiFileXMIResourceImpl.clearDetachedEObjectToIDMap();
    }

    private void clearErrors() {
        this.markerMananger.clearAll();
    }

    public MethodLibrary loadLibrary(String path) throws Exception {
        long begin = System.currentTimeMillis();
        this.reset();
        long afterReset = System.currentTimeMillis();
        if (MultiFileSaveUtil.DEBUG) {
            System.out.println("Reset time: " + (afterReset - begin));
        }
        MethodLibrary lib = this.loadLibraryWithoutReset(path);
        if (MultiFileSaveUtil.DEBUG) {
            System.out.println("Load time: " + (System.currentTimeMillis() - begin));
        }
        if (MultiFileSaveUtil.DEBUG) {
            System.err.println("Modified resources after loading:");
            for (Resource resource : this.getResources()) {
                if (!resource.isModified()) continue;
                System.err.println("  " + resource.getURI());
            }
        }
        return lib;
    }

    protected Resource loadLibraryResource(String path) {
        URI uri = URI.createFileURI((String)path);
        Resource res = super.getResource(uri, true);
        if (!res.getErrors().isEmpty()) {
            StringBuffer strBuf = new StringBuffer();
            strBuf.append(PersistenceResources.loadLibraryError_msg);
            for (Resource.Diagnostic error : res.getErrors()) {
                strBuf.append(NLS.bind((String)PersistenceResources.loadLibraryError_details, (Object[])new Object[]{String.valueOf(error.getLine()), String.valueOf(error.getColumn()), error.getMessage()}));
            }
            String msg = strBuf.toString();
            CommonPlugin.INSTANCE.log((Object)msg);
            if (MultiFileSaveUtil.DEBUG) {
                System.err.println(msg);
            }
        }
        return res;
    }

    public MethodLibrary loadLibraryWithoutReset(String path) throws Exception {
        this.loading = true;
        boolean b = RefreshJob.getInstance().isEnabled();
        if (RefreshJob.getInstance().getResourceSet() == this) {
            RefreshJob.getInstance().setEnabled(false);
            RefreshJob.getInstance().reset();
        }
        boolean autoScheduled = this.markerMananger.isAutoScheduled();
        this.markerMananger.setAutoScheduled(false);
        try {
            File libFile = new File(path);
            this.configFolderPath = new Path(new File(libFile.getParentFile(), "configurations").getCanonicalPath());
            this.libFolderPath = new Path(libFile.getParentFile().getCanonicalPath());
            Resource res = this.loadLibraryResource(libFile.getCanonicalPath());
            try {
                this.initialize(true);
                if (res != null) {
                    res.setModified(false);
                }
                MethodLibrary methodLibrary = this.getMethodLibrary();
                return methodLibrary;
            }
            catch (Exception e) {
                PersistencePlugin.getDefault().getLogger().logError((Throwable)e);
                throw new Exception(NLS.bind((String)PersistenceResources.invalidLibraryFileError_msg, (Object)path));
            }
        }
        finally {
            if (RefreshJob.getInstance().getResourceSet() == this) {
                RefreshJob.getInstance().setEnabled(b);
            }
            this.markerMananger.setAutoScheduled(autoScheduled);
            this.markerMananger.start();
            this.loading = false;
        }
    }

    private void loadOppositeFeatures() {
        ArrayList<OppositeFeature> oppositeFeatures = new ArrayList<OppositeFeature>();
        for (OppositeFeature oppositeFeature : AssociationHelper.getPredefinedOppositeFeatures()) {
            if (!oppositeFeature.resolveOwner()) continue;
            oppositeFeatures.add(oppositeFeature);
        }
        this.loadOppositeFeatures(oppositeFeatures);
    }

    private void loadResourceManagerTree() {
        long begin = 0L;
        if (MultiFileSaveUtil.DEBUG) {
            begin = System.currentTimeMillis();
        }
        boolean oldMarkerManagerEnabled = this.markerMananger.isEnabled();
        this.markerMananger.setEnabled(false);
        MultiFileURIConverter uriConverter = (MultiFileURIConverter)this.getURIConverter();
        try {
            uriConverter.setResolveProxy(false);
            ResourceManager resMgr = this.getRootResourceManager();
            AbstractTreeIterator<Object> iterator = new AbstractTreeIterator<Object>((Object)resMgr, false){
                private static final long serialVersionUID = 2172691017987702506L;

                protected Iterator<?> getChildren(Object object) {
                    ResourceManager resMgr = (ResourceManager)object;
                    return resMgr.getSubManagers().iterator();
                }
            };
            this.loadingResourceManagerTree = true;
            while (iterator.hasNext()) {
                iterator.next();
            }
        }
        finally {
            this.markerMananger.setEnabled(oldMarkerManagerEnabled);
            uriConverter.setResolveProxy(true);
            this.loadingResourceManagerTree = false;
            try {
                for (InternalEObject internalEObject : new ArrayList<EObject>(this.getGuidToMethodElementMap().values())) {
                    if (!internalEObject.eIsProxy() || internalEObject.eContainer() == null) continue;
                    URI uri = internalEObject.eProxyURI();
                    URI normalizedURI = this.getURIConverter().normalize(uri);
                    if (normalizedURI != null) continue;
                    ((InternalEObject)internalEObject.eContainer()).eResolveProxy(internalEObject);
                }
            }
            catch (Exception e) {
                PersistencePlugin.getDefault().getLogger().logError((Throwable)e);
            }
        }
        if (MultiFileSaveUtil.DEBUG) {
            System.out.println("MultiFileResourceSetImpl.loadResourceManagerTree(): " + (System.currentTimeMillis() - begin));
        }
    }

    protected ResourceManager getResourceManager() {
        return ((MultiFileURIConverter)this.getURIConverter()).getResourceManager();
    }

    protected EObject findEObjectInUnloadedResources(String id) {
        return this.findEObjectInUnloadedResources(this.getResourceManager(), id);
    }

    private EObject findEObjectInUnloadedResources(ResourceManager resMgr, String id) {
        for (ResourceDescriptor desc : resMgr.getResourceDescriptors()) {
            EObject eObject;
            Resource resource = super.getResource(desc.getResolvedURI(), false);
            if (resource != null && resource.isLoaded()) continue;
            try {
                resource = super.getResource(desc.getResolvedURI(), true);
            }
            catch (Exception exception) {}
            if (resource == null || (eObject = resource.getEObject(id)) == null) continue;
            return eObject;
        }
        Iterator<Object> iter = resMgr.getSubManagers().iterator();
        while (iter.hasNext()) {
            EObject eObject = this.findEObjectInUnloadedResources((ResourceManager)iter.next(), id);
            if (eObject == null) continue;
            return eObject;
        }
        return null;
    }

    @Override
    public EObject getEObject(String id) {
        EObject eObject = this.getGuidToMethodElementMap().get(id);
        if (eObject != null) {
            return eObject;
        }
        URI uri = MultiFileURIConverter.createURI(id).appendFragment(id);
        URI normalized = this.getURIConverter().normalize(uri);
        if (normalized == null) {
            eObject = this.findEObjectInUnloadedResources(id);
            if (eObject == null && REPORT_ERROR) {
                this.handleException(NLS.bind((String)PersistenceResources.objNotFoundError_msg, (Object)id));
            }
            return eObject;
        }
        try {
            return this.getEObject(uri, true);
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    public EObject getEObject(URI uri, boolean loadOnDemand) {
        return this.getEObject(null, uri, loadOnDemand);
    }

    public Resource createResource(URI uri) {
        Resource result = this.doCreateResource(uri);
        result.setTrackingModification(true);
        this.getResources().add((Object)result);
        return result;
    }

    protected Resource doCreateResource(URI uri) {
        return new MultiFileXMIResourceImpl(uri);
    }

    private static boolean backupRequired(Map options) {
        Boolean backup = (Boolean)options.get("BACK_UP_BEFORE_SAVE");
        return backup != null && backup != false;
    }

    private void backup(Resource res) {
        try {
            if (res.getContents().isEmpty()) {
                return;
            }
            Object object = res.getContents().get(0);
            if (!(object instanceof MethodLibrary || object instanceof ResourceManager || object instanceof MethodPlugin)) {
                return;
            }
            MethodLibrary library = this.getMethodLibrary();
            String backupDir = String.valueOf(new File(library.eResource().getURI().toFileString()).getParent()) + File.separator + ".bak";
            SimpleDateFormat dateFormatter = new SimpleDateFormat("yyMMddHHmmss.S");
            if (res == library.eResource()) {
                DateFormat.getInstance().format(Calendar.getInstance().getTime());
                File backupFile = new File(backupDir, "library.xmi_" + dateFormatter.format(Calendar.getInstance().getTime()));
                if (!backupFile.getParentFile().exists()) {
                    backupFile.getParentFile().mkdirs();
                }
                FileUtil.moveFile((File)new File(res.getURI().toFileString()), (File)backupFile);
            } else {
                String relativePath = res.getURI().deresolve(library.eResource().getURI()).toFileString();
                File backupFile = new File(backupDir, String.valueOf(relativePath) + '_' + dateFormatter.format(Calendar.getInstance().getTime()));
                if (!backupFile.getParentFile().exists()) {
                    backupFile.getParentFile().mkdirs();
                }
                FileUtil.moveFile((File)new File(res.getURI().toFileString()), (File)backupFile);
            }
        }
        catch (Exception e) {
            this.handleException(e);
            this.handleException(NLS.bind((String)PersistenceResources.backupError_msg, (Object)res));
        }
    }

    void removeURIMappings(EObject eObj, Set modifiedResources) {
        ResourceDescriptor desc;
        ResourceManager resMgr = MultiFileSaveUtil.getResourceManager(eObj.eResource());
        if (resMgr != null && resMgr.eContainer() != null) {
            EcoreUtil.remove((EObject)resMgr);
        }
        if ((resMgr = this.getRootResourceManager()) != null && (desc = MultiFileSaveUtil.findResourceDescriptor(resMgr, MultiFileSaveUtil.getGuid(eObj), null, true)) != null) {
            if (modifiedResources != null && desc.eResource() != null) {
                modifiedResources.add(desc.eResource());
            }
            EcoreUtil.remove((EObject)desc);
        }
    }

    protected void cleanUp(Resource removedResource) throws IOException {
        this.cleanUp(removedResource, null);
    }

    void cleanUp(Resource removedResource, Set modifiedResources) throws IOException {
        try {
            if (removedResource.getContents().isEmpty()) {
                removedResource.unload();
                try {
                    removedResource.load(null);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    this.getResources().remove((Object)removedResource);
                    URI oldURI = ((MultiFileXMIResourceImpl)removedResource).getOldURI();
                    if (oldURI != null) {
                        this.getURIToTempURIMap().remove(oldURI);
                    }
                    return;
                }
            }
            MethodElement obj = PersistenceUtil.getMethodElement(removedResource);
            this.removeURIMappings((EObject)obj, modifiedResources);
            removedResource.unload();
        }
        finally {
            this.getResources().remove((Object)removedResource);
            URI oldURI = ((MultiFileXMIResourceImpl)removedResource).getOldURI();
            if (oldURI != null) {
                this.getURIToTempURIMap().remove(oldURI);
            }
        }
    }

    private void cleanUp(ProcessPackage procPkg) {
        this.removeContentDescriptions(procPkg);
        EcoreUtil.remove((EObject)procPkg);
    }

    private void removeContentDescriptions(ProcessPackage procPkg) {
        for (ProcessElement element : procPkg.getProcessElements()) {
            if (!ContentDescriptionFactory.hasPresentation((MethodElement)element) || element.getPresentation().eResource() == null) continue;
            this.removePresentation(element);
        }
        for (Object pkg : procPkg.getChildPackages()) {
            if (!(pkg instanceof ProcessPackage)) continue;
            this.removeContentDescriptions((ProcessPackage)pkg);
        }
    }

    private void removePresentation(ProcessElement element) {
        Resource resource = element.getPresentation().eResource();
        resource.getContents().remove((Object)element.getPresentation());
    }

    private boolean save(Collection resources, Map options, boolean prepareSave) throws Exception {
        if (options == null) {
            options = this.getDefaultSaveOptions();
        }
        HashSet modifiedResources = new HashSet();
        options.put("MODIFIED_RESOURCE_SET", modifiedResources);
        try {
            for (Resource res : resources) {
                this.save(res, options, prepareSave);
            }
            this.saveModifiedResources(options);
            return true;
        }
        finally {
            options.remove("MODIFIED_RESOURCE_SET");
        }
    }

    boolean save(Resource res, Map options, boolean prepareSave) throws Exception {
        Set modifiedResources = (Set)options.get("MODIFIED_RESOURCE_SET");
        TxRecord txRecord = (TxRecord)options.get("TX_RECORD");
        List resourcesToCommit = txRecord != null ? txRecord.getResourcesToCommit() : null;
        try {
            MethodElement eObj = PersistenceUtil.getMethodElement(res);
            if (eObj != null) {
                if (prepareSave) {
                    if (eObj instanceof ProcessComponent) {
                        ProcessComponent procComp = (ProcessComponent)eObj;
                        Resource content = procComp.getProcess() != null && ContentDescriptionFactory.hasPresentation((MethodElement)procComp.getProcess()) ? procComp.getProcess().getPresentation().eResource() : null;
                        boolean alreadyModified = content != null && content.isModified();
                        this.prepareSave(procComp);
                        if (content != null && content.isModified() && !alreadyModified) {
                            modifiedResources.add(content);
                        }
                    } else if (eObj instanceof MethodPlugin) {
                        MultiFileSaveUtil.addResourceManager(res);
                    }
                }
                if (res.isModified()) {
                    boolean backupRequired = MultiFileResourceSetImpl.backupRequired(options);
                    if (backupRequired) {
                        this.backup(res);
                    }
                    if (resourcesToCommit != null) {
                        ((MultiFileXMIResourceImpl)res).setTempURI(txRecord.getTxID());
                        resourcesToCommit.add(res);
                    }
                    MultiFileSaveUtil.save(res, options);
                    return true;
                }
            }
        }
        catch (Exception exception) {
            this.handleException(exception);
            throw exception;
        }
        return false;
    }

    public boolean save(Resource res, Map options) throws Exception {
        if (res == null || res.getContents().isEmpty()) {
            return false;
        }
        if (options == null) {
            options = this.getDefaultSaveOptions();
        }
        HashSet modifiedResources = new HashSet();
        options.put("MODIFIED_RESOURCE_SET", modifiedResources);
        boolean notFailSafe = options.get("TX_RECORD") == null;
        try {
            Collection collection;
            boolean ret;
            ArrayList<Resource> savedResources = null;
            if (notFailSafe) {
                savedResources = new ArrayList<Resource>();
            }
            if ((ret = this.save(res, options, true)) && notFailSafe) {
                savedResources.add(res);
            }
            if (!(collection = this.saveModifiedResources(options)).isEmpty()) {
                ret = true;
                if (notFailSafe) {
                    savedResources.addAll(collection);
                }
            }
            if (notFailSafe && ret) {
                for (Object e : savedResources) {
                    if (!(e instanceof MultiFileXMIResourceImpl)) continue;
                    ((MultiFileXMIResourceImpl)e).updateTimeStamps();
                }
            }
            boolean bl = ret;
            return bl;
        }
        finally {
            options.remove("MODIFIED_RESOURCE_SET");
        }
    }

    public void save(Map options) throws LibraryResourceException {
        try {
            this.save(options, false, true);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new LibraryResourceException(e);
        }
    }

    Collection saveModifiedResources(Map options) throws LibraryResourceException {
        List resourcesToCommit;
        Set modifiedResources = (Set)options.get("MODIFIED_RESOURCE_SET");
        TxRecord txRecord = (TxRecord)options.get("TX_RECORD");
        List list = resourcesToCommit = txRecord != null ? txRecord.getResourcesToCommit() : null;
        if (modifiedResources == null) {
            return Collections.EMPTY_LIST;
        }
        boolean backupRequired = MultiFileResourceSetImpl.backupRequired(options);
        boolean checkModify = MultiFileXMISaveImpl.checkModifyRequired(options);
        ArrayList<Resource> savedResources = new ArrayList<Resource>();
        while (!modifiedResources.isEmpty()) {
            ArrayList<Resource> resourcesToSave = new ArrayList<Resource>(modifiedResources);
            modifiedResources.clear();
            if (checkModify) {
                this.checkModify(resourcesToSave);
                if (resourcesToCommit != null) {
                    MultiFileSaveUtil.checkOutOfSynch(resourcesToSave, options);
                }
            }
            for (Resource resource : resourcesToSave) {
                if (backupRequired) {
                    this.backup(resource);
                }
                if (resourcesToCommit != null) {
                    ((MultiFileXMIResourceImpl)resource).setTempURI(txRecord.getTxID());
                    resourcesToCommit.add(resource);
                }
                if (!MultiFileSaveUtil.save(resource, options)) continue;
                savedResources.add(resource);
            }
        }
        return savedResources;
    }

    public void save(Map options, boolean saveAll) throws Exception {
        this.save(options, saveAll, false);
    }

    protected void save(Map options, boolean saveAll, boolean failSafe) throws Exception {
        block19: {
            if (options == null) {
                options = new HashMap<Object, Object>(this.getDefaultSaveOptions());
            }
            MethodLibrary library = this.getMethodLibrary();
            MultiFileSaveUtil.setGuid((MethodElement)library);
            this.prepareSave(library);
            this.cleanUp();
            MultiFileURIConverter umaUriConverter = (MultiFileURIConverter)this.getURIConverter();
            umaUriConverter.setLibraryURIs(library);
            HashSet modifiedResources = new HashSet();
            options.put("MODIFIED_RESOURCE_SET", modifiedResources);
            MethodLibraryPersister.FailSafePersister persister = null;
            if (failSafe) {
                persister = MethodLibraryPersister.INSTANCE.getFailSafePersister(options);
                options = persister.getSaveOptions();
            }
            try {
                try {
                    EList list = this.getResources();
                    int size = list.size();
                    MultiFileResourceSetImpl.backupRequired(options);
                    ArrayList<Resource> saveResources = new ArrayList<Resource>();
                    ArrayList<Resource> moveResources = new ArrayList<Resource>();
                    int i = 0;
                    while (i < size) {
                        MethodElement eObj;
                        Resource res = (Resource)list.get(i);
                        if (res.isModified() && MultiFileSaveUtil.adjustLocationRequired((MultiFileXMIResourceImpl)res)) {
                            moveResources.add(res);
                        }
                        if ((eObj = PersistenceUtil.getMethodElement(res)) != null && eObj instanceof MethodElement && (saveAll || res.isModified())) {
                            saveResources.add(res);
                        }
                        ++i;
                    }
                    if (saveResources.isEmpty()) break block19;
                    Resource libResource = this.getMethodLibraryResource();
                    if (!saveResources.contains(libResource) && PersistenceUtil.checkToolVersion(libResource) != 0) {
                        saveResources.add(libResource);
                    }
                    if (MultiFileXMISaveImpl.checkModifyRequired(options)) {
                        this.checkModify(saveResources);
                    }
                    if (failSafe) {
                        try {
                            this.save(saveResources, options, false);
                            persister.commit();
                            persister.adjustLocation(moveResources);
                            break block19;
                        }
                        catch (Exception e) {
                            persister.rollback();
                            throw e;
                        }
                    }
                    for (Resource resource : saveResources) {
                        if (!MultiFileSaveUtil.save(resource, options) || !(resource instanceof MultiFileXMIResourceImpl)) continue;
                        ((MultiFileXMIResourceImpl)resource).updateTimeStamps();
                    }
                    for (Resource resource : moveResources) {
                        MultiFileSaveUtil.adjustLocation(resource, modifiedResources);
                    }
                    Collection saved = this.saveModifiedResources(options);
                    if (saved != null) {
                        for (Resource resource : saved) {
                            if (!(resource instanceof MultiFileXMIResourceImpl)) continue;
                            ((MultiFileXMIResourceImpl)resource).updateTimeStamps();
                        }
                    }
                }
                catch (Exception exception) {
                    this.handleException(exception);
                    throw exception;
                }
            }
            finally {
                options.remove("MODIFIED_RESOURCE_SET");
            }
        }
    }

    public void saveAs(String newLocation, boolean regenerateGUID, IProgressMonitor monitor) throws Exception {
        MethodLibrary lib = this.getMethodLibrary();
        if (lib == null) {
            return;
        }
        if (monitor != null) {
            monitor.setTaskName(PersistenceResources.loadResourcesTask_name);
        }
        TreeIterator iter = lib.eAllContents();
        while (iter.hasNext()) {
            EObject element = (EObject)iter.next();
            if (regenerateGUID && element instanceof MethodElement) {
                ((MethodElement)element).setGuid(UmaUtil.generateGUID());
            }
            Iterator iterator = element.eCrossReferences().iterator();
            while (iterator.hasNext()) {
                iterator.next();
            }
        }
        URI oldDir = URI.createFileURI((String)(String.valueOf(new File(lib.eResource().getURI().toFileString()).getParent()) + File.separator));
        URI newDir = URI.createFileURI((String)(String.valueOf(newLocation) + File.separator));
        for (Resource resource : this.getResources()) {
            resource.setURI(resource.getURI().replacePrefix(oldDir, newDir));
        }
        ResourceManager resMgr = ((MultiFileURIConverter)this.getURIConverter()).getResourceManager();
        if (resMgr != null) {
            resMgr.getResourceDescriptors().clear();
        }
        if (monitor != null) {
            monitor.setTaskName(PersistenceResources.saveLibraryTask_name);
        }
        this.save(null, true);
    }

    protected boolean unloadWithoutRemove(MultiFileXMIResourceImpl resource) {
        MethodLibrary lib;
        MethodElement e = PersistenceUtil.getMethodElement(resource);
        resource.unloadWithoutRemove();
        if (e instanceof MethodConfiguration && (lib = this.getMethodLibrary()) != null) {
            lib.getPredefinedConfigurations().remove(e);
        }
        return true;
    }

    private void cleanUp() throws IOException {
        MethodLibrary library = this.getMethodLibrary();
        ArrayList<Resource> removedResources = new ArrayList<Resource>();
        EList list = this.getResources();
        int size = list.size();
        int i = 0;
        while (i < size) {
            Resource res = (Resource)list.get(i);
            boolean remove = false;
            if (res.getContents().isEmpty()) {
                System.out.println("MultiFileResourceSetImpl.cleanUp(): empty resource: " + res);
                remove = true;
            } else {
                MethodElement eObj = PersistenceUtil.getMethodElement(res);
                if (eObj == null || eObj != library && eObj.eContainer() == null) {
                    if (eObj == null) {
                        System.out.println("MultiFileResourceSetImpl.cleanUp(): resource without any MethodElement: " + res);
                        remove = true;
                    } else if (eObj != library && eObj.eContainer() == null) {
                        System.out.println("MultiFileResourceSetImpl.cleanUp(): resource without a container: " + res);
                    }
                }
            }
            if (remove) {
                removedResources.add(res);
            }
            ++i;
        }
        System.out.println("MultiFileResourceSetImpl.cleanUp(): removed resources: " + removedResources);
        for (Resource res : removedResources) {
            try {
                this.cleanUp(res);
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
    }

    private void prepareSave(MethodLibrary library) {
        MultiFileXMIResourceImpl resource = (MultiFileXMIResourceImpl)library.eResource();
        ResourceManager libResMgr = MultiFileSaveUtil.addResourceManager(resource);
        if (libResMgr != null) {
            MultiFileSaveUtil.registerWithResourceManager(libResMgr, library, resource.getFinalURI());
        }
        List models = library.getMethodPlugins();
        int size = models.size();
        int i = 0;
        while (i < size) {
            this.prepareSave((MethodPlugin)models.get(i));
            ++i;
        }
        i = 0;
        while (i < size) {
            MultiFileResourceSetImpl.cleanUp((MethodPlugin)models.get(i));
            ++i;
        }
    }

    private static void cleanUp(MethodPlugin plugin) {
        int i = 0;
        while (i < PROCESS_PACKAGE_PATHS.length) {
            ProcessPackage pkg = (ProcessPackage)UmaUtil.findMethodPackage((MethodPlugin)plugin, (String[])PROCESS_PACKAGE_PATHS[i]);
            if (pkg != null) {
                MultiFileResourceSetImpl.cleanUpProcesses(pkg);
            }
            ++i;
        }
    }

    private void prepareSave(MethodPlugin model) {
        int i = 0;
        while (i < PROCESS_PACKAGE_PATHS.length) {
            ProcessPackage pkg = (ProcessPackage)UmaUtil.findMethodPackage((MethodPlugin)model, (String[])PROCESS_PACKAGE_PATHS[i]);
            if (pkg != null) {
                this.prepareSave(pkg);
            }
            ++i;
        }
    }

    private static void cleanUpProcesses(ProcessPackage pkg) {
        List list = pkg.getChildPackages();
        int size = list.size();
        int i = 0;
        while (i < size) {
            Object obj = list.get(i);
            if (obj instanceof ProcessComponent) {
                ProcessComponent procComp = (ProcessComponent)obj;
                ArrayList packages = new ArrayList();
                for (Object element : procComp.getChildPackages()) {
                    if (!(element instanceof ProcessPackage)) continue;
                    MultiFileResourceSetImpl.getRemovedPackages((ProcessPackage)element, packages);
                }
                Iterator iterator = packages.iterator();
                while (iterator.hasNext()) {
                    EcoreUtil.remove((EObject)((EObject)iterator.next()));
                }
            }
            ++i;
        }
    }

    private static void getRemovedPackages(ProcessPackage pkg, List removedPackages) {
        Activity act = MultiFileResourceSetImpl.getActivity(pkg);
        if (act == null || MultiFileResourceSetImpl.getParent((BreakdownElement)act) == null) {
            removedPackages.add(pkg);
        } else {
            for (Object element : pkg.getChildPackages()) {
                if (!(element instanceof ProcessPackage)) continue;
                MultiFileResourceSetImpl.getRemovedPackages((ProcessPackage)element, removedPackages);
            }
        }
    }

    private static Activity getActivity(ProcessPackage pkg) {
        Activity act = null;
        for (Object element : pkg.getProcessElements()) {
            if (!(element instanceof Activity)) continue;
            act = (Activity)element;
            break;
        }
        return act;
    }

    private static Object getParent(BreakdownElement e) {
        return UmaUtil.getParentActivity((BreakdownElement)e);
    }

    private void prepareSave(ProcessPackage pkg) {
        List list = pkg.getChildPackages();
        int size = list.size();
        int i = 0;
        while (i < size) {
            Object obj = list.get(i);
            if (obj instanceof ProcessComponent) {
                this.prepareSave((ProcessComponent)obj);
            }
            ++i;
        }
    }

    private void prepareSave(ProcessComponent procComp) {
        Process proc = procComp.getProcess();
        if (proc != null) {
            MultiFileResourceSetImpl.prepareSave((Activity)proc);
            MultiFileResourceSetImpl.cleanUpDanglingDescriptors((ProcessPackage)procComp);
            ArrayList danglingPkgs = new ArrayList();
            for (Object element : new ArrayList(procComp.getChildPackages())) {
                if (!(element instanceof ProcessPackage)) continue;
                ProcessPackage pkg = (ProcessPackage)element;
                this.reorganize(pkg, danglingPkgs);
            }
            Iterator iter = danglingPkgs.iterator();
            while (iter.hasNext()) {
                this.cleanUp((ProcessPackage)iter.next());
            }
        }
    }

    private static void prepareSave(Activity activity) {
        ProcessPackage parentPkg = (ProcessPackage)activity.eContainer();
        List elements = activity.getBreakdownElements();
        for (EObject element : elements) {
            if (element instanceof Activity || element.eContainer() != null) continue;
            parentPkg.getProcessElements().add((ProcessElement)element);
        }
        for (WorkOrder workOrder : activity.getLinkToPredecessor()) {
            if (workOrder.eContainer() == null) {
                if (workOrder.getPred() == null || MultiFileResourceSetImpl.getParent((BreakdownElement)workOrder.getPred()) == null) continue;
                parentPkg.getProcessElements().add(workOrder);
                continue;
            }
            if (workOrder.getPred() != null && MultiFileResourceSetImpl.getParent((BreakdownElement)workOrder.getPred()) != null) continue;
            if (MultiFileSaveUtil.DEBUG) {
                System.err.println("Invalid WorkOrder: " + workOrder);
            }
            parentPkg.getProcessElements().remove(workOrder);
        }
        Iterator iter = parentPkg.getDiagrams().iterator();
        while (iter.hasNext()) {
            MethodElement element;
            Diagram diagram = (Diagram)iter.next();
            SemanticModelBridge bridge = diagram.getSemanticModel();
            if (!(bridge instanceof UMASemanticModelBridge) || !((element = ((UMASemanticModelBridge)bridge).getElement()) instanceof Activity) || element instanceof Process || MultiFileResourceSetImpl.getParent((BreakdownElement)((Activity)element)) != null) continue;
            iter.remove();
        }
        int size = elements.size();
        int i = 0;
        while (i < size) {
            Object e = elements.get(i);
            if (e instanceof Activity) {
                Activity act = (Activity)e;
                if (act.eContainer() == null) {
                    ProcessPackage pkg = UmaFactory.eINSTANCE.createProcessPackage();
                    pkg.setName(act.getName());
                    pkg.getProcessElements().add(act);
                    ArrayList descriptors = new ArrayList();
                    int j = 0;
                    while (j < act.getBreakdownElements().size()) {
                        Object obj = act.getBreakdownElements().get(j);
                        if (obj instanceof Descriptor) {
                            descriptors.add(obj);
                        }
                        ++j;
                    }
                    pkg.getProcessElements().addAll(descriptors);
                    parentPkg.getChildPackages().add(pkg);
                }
                MultiFileResourceSetImpl.prepareSave(act);
            }
            ++i;
        }
    }

    private static void cleanUpDanglingDescriptors(ProcessPackage pkg) {
        Iterator iter = pkg.getProcessElements().iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (!(element instanceof BreakdownElement) || ((BreakdownElement)element).getSuperActivities() != null) continue;
            boolean remove = false;
            if (element instanceof RoleDescriptor) {
                if (AssociationHelper.getTeamProfiles((RoleDescriptor)((RoleDescriptor)element)).isEmpty()) {
                    remove = true;
                }
            } else if (element instanceof WorkProductDescriptor) {
                if (AssociationHelper.getDeliverableDescriptors((WorkProductDescriptor)((WorkProductDescriptor)element)).isEmpty()) {
                    remove = true;
                }
            } else if (element instanceof TeamProfile) {
                if (((TeamProfile)element).getSuperTeam() == null) {
                    remove = true;
                }
            } else {
                remove = true;
            }
            if (!remove) continue;
            iter.remove();
        }
    }

    private void reorganize(ProcessPackage pkg, List danglingPkgs) {
        EObject parentAct;
        Activity act = MultiFileResourceSetImpl.getActivity(pkg);
        if (act == null) {
            return;
        }
        if (!pkg.getName().equals(act.getName())) {
            pkg.setName(act.getName());
        }
        if ((parentAct = (EObject)MultiFileResourceSetImpl.getParent((BreakdownElement)act)) == null) {
            danglingPkgs.add(pkg);
        } else if (parentAct != MultiFileResourceSetImpl.getActivity((ProcessPackage)pkg.eContainer())) {
            ProcessPackage parentPkg = (ProcessPackage)parentAct.eContainer();
            parentPkg.getChildPackages().add(pkg);
        }
        if (parentAct != null) {
            MultiFileResourceSetImpl.cleanUpDanglingDescriptors(pkg);
        }
        for (Object element : pkg.getChildPackages()) {
            if (!(element instanceof ProcessPackage)) continue;
            this.reorganize((ProcessPackage)element, danglingPkgs);
        }
    }

    public Map<String, EObject> getGuidToMethodElementMap() {
        if (this.guidToMethodElementMap == null) {
            this.guidToMethodElementMap = new HashMap();
        }
        return this.guidToMethodElementMap;
    }

    public void eNotify(Notification notification) {
        try {
            super.eNotify(notification);
        }
        catch (RuntimeException e) {
            CommonPlugin.INSTANCE.log((Object)("ERROR notifying changes: resourceSet=" + this + ", notification=" + notification));
            CommonPlugin.INSTANCE.log((Object)e);
            e.printStackTrace();
        }
    }

    public void addMarker(Exception e) {
        block2: {
            try {
                this.markerMananger.notifyException(e);
            }
            catch (RuntimeException ex) {
                CommonPlugin.INSTANCE.log((Object)ex);
                if (!MultiFileSaveUtil.DEBUG) break block2;
                ex.printStackTrace();
            }
        }
    }

    public void setLoading(boolean b) {
        this.loading = b;
    }

    public void notifyException(Exception e) {
        if (this.loadingResourceManagerTree && e instanceof ResolveException && ((ResolveException)e).exception() instanceof MultiFileIOException) {
            return;
        }
        try {
            this.addMarker(e);
        }
        catch (Exception exception) {}
    }

    public void proxyResolved(Object proxy, Object resolved) {
        String guid;
        if (resolved instanceof MethodElement && (guid = MultiFileSaveUtil.getGuid(resolved)) != null) {
            this.getGuidToMethodElementMap().put(guid, (EObject)resolved);
        }
        this.markerMananger.proxyResolved(proxy, resolved);
    }

    protected EObject getEObjectByGUID(String guid) {
        return this.getGuidToMethodElementMap().get(guid);
    }

    public EObject getEObject(EObject resolver, URI uri, boolean loadOnDemand) {
        URI normalized = ((MultiFileURIConverter)this.getURIConverter()).normalize(uri, resolver);
        if (normalized == null) {
            String guid = uri.fragment();
            EObject eObject = this.getEObjectByGUID(guid);
            if (eObject != null) {
                return eObject;
            }
            String msg = NLS.bind((String)PersistenceResources.normalizeURIError_msg, (Object)uri);
            throw new UnnormalizedURIException(uri, msg);
        }
        Resource resource = this.getResource(normalized.trimFragment(), loadOnDemand);
        if (resource != null) {
            String fragment = normalized.fragment();
            if (fragment == null || fragment.length() == 0) {
                return PersistenceUtil.getMethodElement(resource);
            }
            EObject eObject = resource.getEObject(fragment);
            if (eObject == null && !fragment.equals(uri.authority())) {
                return this.getEObjectByGUID(fragment);
            }
            return eObject;
        }
        return null;
    }

    public void loadOppositeFeatures(List oppositeFeatures) {
        int max = oppositeFeatures.size() - 1;
        if (max < 0) {
            return;
        }
        ArrayList<EObject> elements = new ArrayList<EObject>(this.getGuidToMethodElementMap().values());
        HashSet<EObject> loadedElements = new HashSet<EObject>();
        while (!elements.isEmpty()) {
            for (EObject obj : elements) {
                if (!(obj instanceof MethodElement)) continue;
                MethodElement element = (MethodElement)obj;
                int i = max;
                while (i > -1) {
                    EStructuralFeature eFeature = ((OppositeFeature)oppositeFeatures.get(i)).getTargetFeature();
                    if (eFeature.getContainerClass().isInstance(element)) {
                        if (eFeature.isMany()) {
                            InternalEList list = (InternalEList)element.eGet(eFeature);
                            if (!list.isEmpty()) {
                                Iterator iterator = list.iterator();
                                while (iterator.hasNext()) {
                                    iterator.next();
                                }
                            }
                        } else {
                            element.eGet(eFeature);
                        }
                    }
                    --i;
                }
            }
            loadedElements.addAll(elements);
            elements = new ArrayList<EObject>(this.getGuidToMethodElementMap().values());
            elements.removeAll(loadedElements);
        }
    }

    public void loadOppositeFeatures(List oppositeFeatures, Set deletedGUIDs) {
        int max = oppositeFeatures.size() - 1;
        if (max < 0) {
            return;
        }
        ArrayList<EObject> elements = new ArrayList<EObject>(this.getGuidToMethodElementMap().values());
        HashSet<EObject> loadedElements = new HashSet<EObject>();
        while (!elements.isEmpty()) {
            for (EObject obj : elements) {
                if (!(obj instanceof MethodElement)) continue;
                MethodElement element = (MethodElement)obj;
                MultiResourceEObject mrEObject = (MultiResourceEObject)element;
                int i = max;
                while (i > -1) {
                    OppositeFeature oppositeFeature = (OppositeFeature)oppositeFeatures.get(i);
                    EStructuralFeature eFeature = oppositeFeature.getTargetFeature();
                    if (eFeature.getContainerClass().isInstance(element)) {
                        if (eFeature.isMany()) {
                            InternalEList list = (InternalEList)element.eGet(eFeature);
                            if (!list.isEmpty()) {
                                boolean resolve = false;
                                Iterator iterator = list.basicIterator();
                                while (iterator.hasNext()) {
                                    String guid;
                                    Object e = (InternalEObject)iterator.next();
                                    if (!e.eIsProxy() || !deletedGUIDs.contains(guid = e.eProxyURI().fragment())) continue;
                                    resolve = true;
                                    break;
                                }
                                if (resolve) {
                                    HashSet deletedElements = new HashSet();
                                    for (Object o : list) {
                                        if (!(o instanceof MethodElement) || !deletedGUIDs.contains(((MethodElement)o).getGuid())) continue;
                                        deletedElements.add(o);
                                    }
                                    for (Object e : deletedElements) {
                                        if (oppositeFeature.isMany()) {
                                            mrEObject.oppositeAdd(oppositeFeature, e);
                                            continue;
                                        }
                                        mrEObject.getOppositeFeatureMap().put(oppositeFeature, e);
                                    }
                                }
                            }
                        } else {
                            String guid;
                            InternalEObject e;
                            Object value = element.eGet(eFeature, false);
                            if (value instanceof InternalEObject && (e = (InternalEObject)value).eIsProxy() && deletedGUIDs.contains(guid = e.eProxyURI().fragment())) {
                                Object o = element.eGet(eFeature);
                                if (oppositeFeature.isMany()) {
                                    mrEObject.oppositeAdd(oppositeFeature, o);
                                } else {
                                    mrEObject.getOppositeFeatureMap().put(oppositeFeature, o);
                                }
                            }
                        }
                    }
                    --i;
                }
            }
            loadedElements.addAll(elements);
            elements = new ArrayList<EObject>(this.getGuidToMethodElementMap().values());
            elements.removeAll(loadedElements);
        }
    }

    @Override
    public boolean hasUnresolvedProxy() {
        return this.markerMananger.hasUnresolvedProxy();
    }

    protected Map getURIToTempURIMap() {
        if (this.URIToTempURIMap == null) {
            this.URIToTempURIMap = new HashMap();
        }
        return this.URIToTempURIMap;
    }

    public UnresolvedProxyMarkerManager getMarkerMananger() {
        return this.markerMananger;
    }

    private void checkModify(Collection<Resource> resources) throws LibraryResourceException {
        if (!resources.isEmpty()) {
            Resource[] resourceArray = new Resource[resources.size()];
            resources.toArray(resourceArray);
            this.checkModify(resourceArray, PersistencePlugin.getDefault().getContext());
        }
    }

    @Override
    public void checkModify(Resource[] resources, Object context) throws LibraryResourceException {
        MultiFileSaveUtil.doCheckModify((Collection<Resource>)Arrays.asList(resources));
    }

    @Override
    public IStatus checkModify(Collection<EObject> eObjects, Object context) {
        HashSet<String> pathSet = new HashSet<String>();
        for (EObject o : eObjects) {
            MultiFileXMIResourceImpl mfResource;
            Resource resource = o.eResource();
            if (resource == null || resource.getResourceSet() != this || (mfResource = (MultiFileXMIResourceImpl)resource).hasTempURI()) continue;
            String path = mfResource.getURI().toFileString();
            pathSet.add(path);
        }
        if (pathSet.isEmpty()) {
            return Status.OK_STATUS;
        }
        String[] paths = new String[pathSet.size()];
        pathSet.toArray(paths);
        return FileManager.getInstance().checkModify(paths, context);
    }

    @Override
    public ILibraryPersister getPersister() {
        return MethodLibraryPersister.INSTANCE;
    }

    public boolean unload(Resource resource, Map options) {
        if (resource instanceof MultiFileXMIResourceImpl) {
            return this.unloadWithoutRemove((MultiFileXMIResourceImpl)resource);
        }
        return false;
    }

    @Override
    public void unload() {
        this.reset();
    }

    @Override
    public MethodLibrary getFirstMethodLibrary() {
        return this.getMethodLibrary();
    }

    public List getMethodLibraries() {
        MethodLibrary lib = this.getMethodLibrary();
        if (lib == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.singletonList(lib);
    }

    @Override
    public void loadMethodLibraries(URI uri, Map<?, ?> parameters) throws LibraryResourceException {
        try {
            this.loadLibrary(uri.toFileString());
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new LibraryResourceException(e);
        }
    }

    @Override
    public String getPersistenceType() {
        return "xmi";
    }

    @Override
    public boolean unload(EObject object) {
        Resource resource = object.eResource();
        if (resource instanceof MultiFileXMIResourceImpl) {
            ((MultiFileXMIResourceImpl)resource).unloaded((InternalEObject)object);
            return true;
        }
        return false;
    }

    public Collection reloadObjects(Collection objects) {
        return null;
    }

    public Resource getResource(IResource wsRes) {
        IPath path = wsRes.getLocation();
        return path != null ? PersistenceUtil.getResource(path, (ResourceSet)this) : null;
    }

    @Override
    public Collection<Resource> loadNewResources() {
        return this.loadConfigurations();
    }

    public void handleLibraryMoved(String newFolder) {
        PersistenceUtil.replaceURIPrefix(new ArrayList<Resource>((Collection<Resource>)this.getResources()), this.libFolderPath.toOSString(), newFolder);
        this.clearCachedResolvedURIs();
    }

    protected void clearCachedResolvedURIs() {
        ResourceManager resMgr = this.getRootResourceManager();
        AbstractTreeIterator iterator = new AbstractTreeIterator(resMgr, true){
            private static final long serialVersionUID = 1L;

            protected Iterator getChildren(Object object) {
                ResourceManager resMgr = (ResourceManager)object;
                return resMgr.getSubManagers().iterator();
            }
        };
        while (iterator.hasNext()) {
            ResourceManager mgr = (ResourceManager)iterator.next();
            for (ResourceDescriptor resDesc : mgr.getResourceDescriptors()) {
                resDesc.clearResolvedURI();
            }
        }
    }
}

