/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.persistence;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.impl.URIConverterImpl;
import org.eclipse.epf.persistence.MultiFileResourceSetImpl;
import org.eclipse.epf.persistence.MultiFileSaveUtil;
import org.eclipse.epf.persistence.MultiFileXMIResourceImpl;
import org.eclipse.epf.resourcemanager.ResourceDescriptor;
import org.eclipse.epf.resourcemanager.ResourceManager;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;

public class MultiFileURIConverter
extends URIConverterImpl {
    public static final String SCHEME = "uma";
    private static final HashSet lockedGUIDs = new HashSet();
    protected ResourceManager resMgr;
    private URI libraryURI;
    private URI libraryUmaURI;
    private MultiFileResourceSetImpl resourceSet;
    private boolean resolveProxy;

    public MultiFileURIConverter(MultiFileResourceSetImpl resourceSet) {
        this.resourceSet = resourceSet;
    }

    void setResolveProxy(boolean resolveProxy) {
        this.resolveProxy = resolveProxy;
    }

    void setLibraryURIs(MethodLibrary library) {
        this.libraryURI = library.eResource().getURI();
        this.libraryUmaURI = URI.createURI((String)new StringBuffer(SCHEME).append("://").append(library.getGuid()).toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void lockGUID(String guid) {
        HashSet hashSet = lockedGUIDs;
        synchronized (hashSet) {
            lockedGUIDs.add(guid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isLockedGUID(String guid) {
        HashSet hashSet = lockedGUIDs;
        synchronized (hashSet) {
            return lockedGUIDs.contains(guid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean unlockGUID(String guid) {
        HashSet hashSet = lockedGUIDs;
        synchronized (hashSet) {
            return lockedGUIDs.remove(guid);
        }
    }

    public URI normalize(URI uri) {
        return this.normalize(uri, null);
    }

    public URI normalize(URI uri, EObject resolver) {
        if (SCHEME.equalsIgnoreCase(uri.scheme())) {
            String guid = uri.authority();
            if (MultiFileURIConverter.isLockedGUID(guid)) {
                return null;
            }
            try {
                ResourceManager resMgr;
                MultiFileURIConverter.lockGUID(guid);
                ResourceDescriptor desc = null;
                HashSet excludedResManagers = null;
                if (resolver != null && resolver.eResource() != null && (resMgr = MultiFileSaveUtil.getResourceManager(resolver.eResource())) != null && (desc = MultiFileSaveUtil.findResourceDescriptor(resMgr, guid, null, this.resolveProxy)) == null) {
                    excludedResManagers = new HashSet();
                    AbstractTreeIterator iter = new AbstractTreeIterator(resMgr){

                        protected Iterator getChildren(Object object) {
                            return ((ResourceManager)object).getSubManagers().iterator();
                        }
                    };
                    while (iter.hasNext()) {
                        excludedResManagers.add(iter.next());
                    }
                }
                if (desc == null && this.getResourceManager() != null) {
                    desc = MultiFileSaveUtil.findResourceDescriptor(this.getResourceManager(), guid, excludedResManagers, this.resolveProxy);
                }
                if (desc != null) {
                    URI normalized = desc.getResolvedURI();
                    URI tempURI = (URI)this.resourceSet.getURIToTempURIMap().get(normalized);
                    if (tempURI != null) {
                        normalized = tempURI;
                    }
                    if (uri.hasFragment()) {
                        normalized = normalized.appendFragment(uri.fragment());
                    }
                    URI uRI = normalized;
                    return uRI;
                }
                return null;
            }
            finally {
                MultiFileURIConverter.unlockGUID(guid);
            }
        }
        return super.normalize(uri);
    }

    public InputStream createInputStream(URI uri) throws IOException {
        if (uri == null) {
            return null;
        }
        return super.createInputStream(uri);
    }

    public static URI createURI(String guid) {
        return URI.createURI((String)new StringBuffer(SCHEME).append("://").append(guid).toString());
    }

    public static URI createURI(MethodElement e) {
        return URI.createURI((String)MultiFileURIConverter.createUriString(e));
    }

    public static String createUriString(Object e) {
        InternalEObject o = (InternalEObject)e;
        URI objectURI = o.eProxyURI();
        if (objectURI != null && SCHEME.equals(objectURI.scheme())) {
            return objectURI.toString();
        }
        String guid = MultiFileSaveUtil.getGuid(e);
        if (guid == null) {
            return null;
        }
        return new StringBuffer(SCHEME).append("://").append(guid).toString();
    }

    public ResourceManager getResourceManager() {
        if (this.resMgr == null) {
            this.resMgr = this.resourceSet.getRootResourceManager();
        }
        return this.resMgr;
    }

    public ResourceDescriptor findResourceDescriptor(String guid) {
        return MultiFileSaveUtil.findResourceDescriptor(this.getResourceManager(), guid, null, this.resolveProxy);
    }

    public void dispose() {
        if (this.resMgr != null) {
            this.resMgr.dispose();
            this.resMgr = null;
        }
    }

    public void setURIMapping(EObject e, URI uri, Set modifiedResources) {
        this.setURIMapping(e, uri, modifiedResources, true);
    }

    public void setURIMapping(EObject e, URI uri, Set modifiedResources, boolean afterMove) {
        String guid = MultiFileSaveUtil.getGuid(e);
        ResourceManager resMgr = MultiFileSaveUtil.getResourceManagerFor(e, modifiedResources);
        ResourceDescriptor resDesc = resMgr.getResourceDescriptor(guid);
        if (resDesc != null) {
            if (afterMove) {
                resDesc.setResolvedURI(uri);
            } else {
                resDesc.getResolvedURI();
                resDesc.setUri(uri.deresolve(MultiFileSaveUtil.getFinalURI(resDesc.eResource())).toString());
            }
            if (modifiedResources != null) {
                modifiedResources.add(resDesc.eResource());
            }
        } else {
            MultiFileResourceSetImpl resourceSet = (MultiFileResourceSetImpl)e.eResource().getResourceSet();
            ResourceManager libResMgr = resourceSet.getRootResourceManager();
            resDesc = MultiFileSaveUtil.findResourceDescriptor(libResMgr, guid, Collections.singletonList(resMgr), this.resolveProxy);
            if (resDesc != null) {
                ResourceManager currentResMgr = (ResourceManager)resDesc.eContainer();
                ResourceManager subMgr = null;
                for (ResourceManager mgr : currentResMgr.getSubManagers()) {
                    URI mgrURI = ((MultiFileXMIResourceImpl)mgr.eResource()).getFinalURI();
                    if (!mgrURI.equals((Object)uri)) continue;
                    subMgr = mgr;
                    break;
                }
                resMgr.getResourceDescriptors().add(resDesc);
                if (modifiedResources != null) {
                    modifiedResources.add(currentResMgr.eResource());
                    modifiedResources.add(resMgr.eResource());
                }
                if (subMgr != null) {
                    resMgr.getSubManagers().add(subMgr);
                }
                if (afterMove) {
                    resDesc.setResolvedURI(uri);
                } else {
                    resDesc.getResolvedURI();
                    resDesc.setUri(uri.deresolve(resDesc.eResource().getURI()).toString());
                }
                if (modifiedResources != null) {
                    modifiedResources.add(resDesc.eResource());
                }
            } else {
                MultiFileSaveUtil.registerWithResourceManager(resMgr, e, uri);
                if (modifiedResources != null) {
                    modifiedResources.add(resMgr.eResource());
                }
            }
        }
    }

    public static void main(String[] args) {
        URI uri = URI.createURI((String)"uma://_LPzdAGZ7EdmAm_xSX2EdUA#//@breakdownElements.0");
        System.out.println(uri);
        System.out.println("deresolved URI: " + uri.deresolve(URI.createURI((String)"uma://_LPzdAGZ7EdmAm_xSX2EdUA")));
    }
}

