/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.export.services;

import java.io.File;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.epf.export.services.LibraryDocument;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.edit.util.MethodElementUtil;
import org.eclipse.epf.uma.MethodPlugin;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseExportService {
    protected static final String exportFile = "export.xmi";
    protected static final String libraryFile = "library.xmi";
    protected List selectedIds = new ArrayList();
    protected List selectedPluginNames = new ArrayList();

    protected boolean isIdSelected(String uri) {
        for (String id : this.selectedIds) {
            if (uri.indexOf(id) < 0) continue;
            return true;
        }
        return false;
    }

    protected boolean isSelectedPluginResource(String uri) {
        for (String plugin_name : this.selectedPluginNames) {
            if (!uri.startsWith(String.valueOf(plugin_name) + "/")) continue;
            return true;
        }
        return false;
    }

    protected boolean isResourceSelected(String uri) {
        if (this.isIdSelected(uri)) {
            return true;
        }
        return this.isSelectedPluginResource(uri);
    }

    protected LibraryDocument processLibraryFile(File source, File target) {
        try {
            Element node;
            String uri;
            Element node2;
            LibraryDocument document = new LibraryDocument(source);
            NodeList nodes = document.getPlugins();
            int i = 0;
            while (i < nodes.getLength()) {
                node2 = (Element)nodes.item(i);
                uri = node2.getAttribute("href");
                if (!this.isIdSelected(uri)) {
                    document.removePlugin(node2);
                    continue;
                }
                ++i;
            }
            nodes = document.getConfigurations();
            i = 0;
            while (i < nodes.getLength()) {
                node2 = (Element)nodes.item(i);
                uri = node2.getAttribute("href");
                if (!this.isIdSelected(uri)) {
                    document.removeConfiguration(node2);
                    continue;
                }
                ++i;
            }
            List plugins = LibraryService.getInstance().getCurrentMethodLibrary().getMethodPlugins();
            Map pluginMap = MethodElementUtil.buildMap((Collection)plugins);
            nodes = document.getResourceDescriptors();
            i = 0;
            while (i < nodes.getLength()) {
                node = (Element)nodes.item(i);
                String id = node.getAttribute("id");
                String uri2 = this.getPluginResMgrUri(id, node, pluginMap);
                if (!this.isIdSelected(id) && !this.isResourceSelected(URLDecoder.decode(uri2, "UTF-8"))) {
                    document.removeResourceDescriptor(node);
                    continue;
                }
                ++i;
            }
            nodes = document.getResourceSubManagers();
            i = 0;
            while (i < nodes.getLength()) {
                node = (Element)nodes.item(i);
                String uri3 = node.getAttribute("href");
                if (!this.isResourceSelected(uri3)) {
                    document.removeResourceDescriptor(node);
                    continue;
                }
                ++i;
            }
            List pluginList = LibraryService.getInstance().getCurrentMethodLibrary().getMethodPlugins();
            document.storeExtraInfo(pluginList);
            document.saveAs(target.getAbsolutePath());
            return document;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private String getPluginResMgrUri(String id, Element node, Map<String, MethodPlugin> pluginMap) {
        String newUri;
        String uri = node.getAttribute("uri");
        MethodPlugin plugin = pluginMap.get(id);
        if (plugin != null && !(newUri = String.valueOf(plugin.getName()) + "/plugin.xmi").equals(uri)) {
            node.setAttribute("uri", newUri);
            return newUri;
        }
        return uri;
    }
}

