/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.importing.services;

import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.epf.common.service.utils.CommandLineRunner;
import org.eclipse.epf.common.utils.XMLUtil;
import org.eclipse.epf.importing.services.PluginImportData;
import org.eclipse.epf.importing.services.PluginImportingService;
import org.eclipse.epf.library.xmi.XMILibraryUtil;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CommandLinePluginImporter
extends CommandLineRunner {
    private static String ImportPluginsTag = "ImportPlugins";
    private static String SelectedPluginTag = "SelectedPlugin";
    private static String BaseLibraryFolderUriAtt = "baseLibraryFolderUri";
    private static String ImportLibraryFolderUriAtt = "importLibraryFolderUri";
    private static String NameAtt = "name";
    private String baseLibPath;
    private String importLibPath;
    private Set<String> selectedPlugins;

    public boolean execute(String[] args) {
        if (!super.execute(args)) {
            return false;
        }
        try {
            this.loadInputFile();
            WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

                public void execute(IProgressMonitor monitor) {
                    try {
                        try {
                            monitor.setTaskName("Openning base library and preparing import ...");
                            XMILibraryUtil.openMethodLibrary((String)CommandLinePluginImporter.this.baseLibPath);
                            File importLibFolder = new File(CommandLinePluginImporter.this.importLibPath);
                            PluginImportData data = new PluginImportData();
                            data.llData.setLibName(importLibFolder.getName());
                            data.llData.setParentFolder(importLibFolder.getAbsolutePath());
                            PluginImportingService service = new PluginImportingService(data);
                            service.validate(null);
                            List<PluginImportData.PluginInfo> importPlugins = data.getPlugins();
                            int i = 0;
                            while (i < importPlugins.size()) {
                                PluginImportData.PluginInfo info = importPlugins.get(i);
                                info.selected = CommandLinePluginImporter.this.selectedPlugins.isEmpty() || CommandLinePluginImporter.this.selectedPlugins.contains(info.name);
                                ++i;
                            }
                            service.performImport(monitor);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            monitor.done();
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            };
            ProgressMonitorDialog pmDialog = new ProgressMonitorDialog(Display.getCurrent().getActiveShell());
            pmDialog.run(true, false, (IRunnableWithProgress)operation);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private void loadInputFile() throws Exception {
        Document document = XMLUtil.loadXml((File)this.getInputFile());
        Element root = document.getDocumentElement();
        if (!root.getTagName().equals(ImportPluginsTag)) {
            String msg = "The root element must be:  " + ImportPluginsTag;
            throw new RuntimeException(msg);
        }
        this.baseLibPath = root.getAttribute(BaseLibraryFolderUriAtt);
        this.importLibPath = root.getAttribute(ImportLibraryFolderUriAtt);
        this.selectedPlugins = new HashSet<String>();
        NodeList nodes = root.getChildNodes();
        int sz = nodes == null ? 0 : nodes.getLength();
        int i = 0;
        while (i < sz) {
            Element element;
            Node node = nodes.item(i);
            if (node instanceof Element && (element = (Element)node).getTagName().equals(SelectedPluginTag)) {
                String name = element.getAttribute(NameAtt);
                this.selectedPlugins.add(name);
            }
            ++i;
        }
    }
}

