/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.importing.wizards;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.epf.export.wizards.DestinationCommonPage;
import org.eclipse.epf.importing.ImportPlugin;
import org.eclipse.epf.importing.ImportResources;
import org.eclipse.epf.importing.services.ConfigurationImportData;
import org.eclipse.epf.importing.services.ConfigurationImportService;
import org.eclipse.epf.importing.wizards.ImportConfigurationWizard;
import org.eclipse.epf.importing.wizards.ImportUIPreferences;
import org.eclipse.epf.importing.wizards.PluginModifyInfo;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.ui.LibraryUIResources;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.ui.wizards.BaseWizardPage;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;

public class SelectImportConfigurationSource
extends DestinationCommonPage {
    public static final String PAGE_NAME = SelectImportConfigurationSource.class.getName();
    private static final Status okStatus = new Status(0, ImportResources.SelectImportConfigurationSource_not_used, 0, "", null);
    private ConfigurationImportData data;
    private ConfigurationImportService service;
    private Status status = okStatus;

    public SelectImportConfigurationSource(ConfigurationImportData data, ConfigurationImportService service) {
        super(PAGE_NAME, data.llData);
        this.setTitle(ImportResources.selectConfigDirWizardPage_title);
        this.setDescription(ImportResources.selectConfigDirWizardPage_text);
        this.setImageDescriptor(ImportPlugin.getDefault().getImageDescriptor("full/wizban/imp_lib_conf_wizban.gif"));
        this.service = service;
        this.data = data;
    }

    protected void initControls() {
        String[] exportDirs = ImportUIPreferences.getImportConfigDirs();
        if (exportDirs != null && exportDirs.length > 0) {
            this.exportPathCombo.setItems(exportDirs);
            this.exportPathCombo.setText(exportDirs[0]);
        }
        super.initControls();
    }

    public boolean isPageComplete() {
        if (LibraryService.getInstance().getCurrentMethodLibrary() == null) {
            this.setErrorMessage(LibraryUIResources.noOpenLibraryWarning_msg);
            return false;
        }
        boolean returnValue = false;
        this.status = okStatus;
        if (this.exportPathCombo.getText().length() > 0) {
            this.saveToDataModel();
            File libDir = new File(this.exportPathCombo.getText());
            if (!libDir.exists()) {
                this.status = new Status(4, ImportResources.SelectImportConfigurationSource_not_used, 0, ImportResources.SelectImportConfigurationSource_no_path, null);
            } else {
                returnValue = true;
            }
        }
        this.applyToStatusLine();
        return returnValue;
    }

    public IWizardPage getNextPage() {
        this.saveToDataModel();
        IRunnableWithProgress operation = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask(ImportResources.SelectImportConfigurationSource_MSG1, -1);
                SelectImportConfigurationSource.this.service.analyze(monitor);
                monitor.done();
            }
        };
        try {
            this.getWizard().getContainer().run(true, false, operation);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        String error = this.data.getErrorInfo().getError();
        if (error != null && error.length() > 0) {
            this.status = new Status(4, ImportResources.SelectImportConfigurationSource_not_used, 0, error, null);
            this.applyToStatusLine();
            return this;
        }
        BaseWizardPage page = null;
        if (this.data.specs != null) {
            page = ((ImportConfigurationWizard)this.getWizard()).specsPage;
        } else {
            PluginModifyInfo modifyInfo = this.checkModify();
            if (modifyInfo.readonlyPlugins.size() > 0) {
                error = modifyInfo.getReadonlyMessage().toString();
                ImportPlugin.getDefault().getMsgDialog().displayError(ImportResources.ImportConfigurationWizard_error, error);
                this.status = new Status(4, ImportResources.SelectImportConfigurationSource_not_used, 0, ImportResources.SelectImportConfigurationSource_error_not_updatable, null);
                this.applyToStatusLine();
                return this;
            }
            if (modifyInfo.lockedPlugins.size() > 0) {
                String WIZARD_TITLE = ImportResources.importConfigWizard_title;
                String message = String.valueOf(modifyInfo.getLockedMessage().toString()) + ImportResources.ImportPluginWizard_confirm_continue;
                boolean yes = ImportPlugin.getDefault().getMsgDialog().displayConfirmation(WIZARD_TITLE, message);
                if (!yes) {
                    this.status = new Status(4, ImportResources.SelectImportConfigurationSource_not_used, 0, ImportResources.SelectImportConfigurationSource_error_not_updatable, null);
                    this.applyToStatusLine();
                    return this;
                }
            }
            page = ((ImportConfigurationWizard)this.getWizard()).configPage;
        }
        page.onEnterPage(null);
        return page;
    }

    public PluginModifyInfo checkModify() {
        return SelectImportConfigurationSource.checkModify(LibraryUtil.getMethodPluginGuids((MethodLibrary)this.service.getImportingLibrary()), this.getShell(), true);
    }

    public static PluginModifyInfo checkModify(List guids, Shell shell, boolean checkEdit) {
        PluginModifyInfo modifyInfo = new PluginModifyInfo();
        List plugins = LibraryService.getInstance().getCurrentMethodLibrary().getMethodPlugins();
        for (MethodPlugin plugin : plugins) {
            IStatus status;
            if (!guids.contains(plugin.getGuid())) continue;
            if (!plugin.getUserChangeable().booleanValue()) {
                modifyInfo.lockedPlugins.add(plugin);
                continue;
            }
            if (!checkEdit || (status = TngUtil.checkEdit((EObject)plugin, (Object)shell)).isOK()) continue;
            modifyInfo.readonlyPlugins.add(plugin);
        }
        return modifyInfo;
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }

    private void applyToStatusLine() {
        if (this.status != okStatus) {
            this.setErrorMessage(this.status.getMessage());
        } else {
            this.setErrorMessage(null);
        }
    }
}

