/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library;

import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.epf.common.AbstractActivator;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.layout.LayoutResources;
import org.osgi.framework.BundleContext;

public class LibraryPlugin
extends AbstractActivator {
    private static final String LAYOUT_PATH = "layout/";
    public static final String LAYOUT_XSL_PATH = "layout/xsl/";
    private static final String LAYOUT_CSS_PATH = "layout/css/";
    public static final String LAYOUT_SCRIPTS_FOLDER = "scripts";
    public static final String LAYOUT_SCRIPTS_PATH = "layout/scripts/";
    private static LibraryPlugin plugin;
    private String layoutPath;
    private String layoutXslPath;
    private String layoutCssPath;

    public LibraryPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        try {
            URL url = new URL(super.getInstallURL(), LAYOUT_PATH);
            this.layoutPath = FileLocator.resolve((URL)url).getPath();
            url = new URL(super.getInstallURL(), LAYOUT_XSL_PATH);
            this.layoutXslPath = FileLocator.resolve((URL)url).getPath();
            url = new URL(super.getInstallURL(), LAYOUT_CSS_PATH);
            this.layoutCssPath = FileLocator.resolve((URL)url).getPath();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        LibraryService.getInstance().getLibraryProblemMonitor();
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
        LayoutResources.clear();
    }

    public static LibraryPlugin getDefault() {
        return plugin;
    }

    public String getLayoutPath() {
        return this.layoutPath;
    }

    public String getLayoutXslPath() {
        return this.layoutXslPath;
    }

    public String getLayoutCssPath() {
        return this.layoutCssPath;
    }
}

