/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.layout;

import java.util.ArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.layout.util.XmlElement;
import org.eclipse.epf.library.util.IElementPropertyProvider;
import org.eclipse.epf.uma.MethodElement;

public class ElementPropertyProviderManager {
    public static final String EXTENSION_POINT_NAMESPACE = "org.eclipse.epf.library";
    public static final String EXTENSION_POINT_NAME = "elementPropertyProviders";
    public static final String CLASS_ATTRIB_NAME = "class";
    private static ElementPropertyProviderManager myself;
    private ArrayList<IElementPropertyProvider> providers;

    private ElementPropertyProviderManager() {
    }

    public static ElementPropertyProviderManager getInstance() {
        if (myself == null) {
            myself = new ElementPropertyProviderManager();
        }
        return myself;
    }

    public void loadAdditionalElementProperties(MethodElement element, XmlElement document) {
        if (this.providers == null) {
            this.loadProviders();
        }
        int idx = 0;
        while (idx < this.providers.size()) {
            IElementPropertyProvider provider = this.providers.get(idx);
            String childName = provider.getChildElementName(element);
            if (childName != null && childName.length() > 0) {
                XmlElement childElement = document.newChild(childName);
                provider.publishMethodElementProperties(element, childElement);
            }
            ++idx;
        }
    }

    private void loadProviders() {
        this.providers = new ArrayList();
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint(EXTENSION_POINT_NAMESPACE, EXTENSION_POINT_NAME);
        if (extensionPoint != null) {
            IExtension[] extensions = extensionPoint.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IExtension extension = extensions[i];
                IConfigurationElement[] configElements = extension.getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    IConfigurationElement configElement = configElements[j];
                    try {
                        this.providers.add((IElementPropertyProvider)configElement.createExecutableExtension(CLASS_ATTRIB_NAME));
                    }
                    catch (Exception e) {
                        LibraryPlugin.getDefault().getLogger().logError((Throwable)e);
                    }
                    ++j;
                }
                ++i;
            }
        }
    }
}

